// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestExtractCustomNormalization(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.CustomNormalizationOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.CustomNormalization(map[string]map[string]string{}),
		},
		{
			opts:     []interface{}{opt.CustomNormalization(map[string]map[string]string{})},
			expected: opt.CustomNormalization(map[string]map[string]string{}),
		},
		{
			opts:     []interface{}{opt.CustomNormalization(map[string]map[string]string{"outer1": map[string]string{"k1": "v1", "k2": "v2"}, "outer2": map[string]string{"k3": "v3"}})},
			expected: opt.CustomNormalization(map[string]map[string]string{"outer1": map[string]string{"k1": "v1", "k2": "v2"}, "outer2": map[string]string{"k3": "v3"}}),
		},
	} {
		var (
			in  = ExtractCustomNormalization(c.opts...)
			out opt.CustomNormalizationOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.Equal(t, *c.expected, out)
	}
}
