/*
Edge Application API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package edgeapplications

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
)


// EdgeApplicationsOriginsAPIService EdgeApplicationsOriginsAPI service
type EdgeApplicationsOriginsAPIService service

type ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest struct {
	ctx context.Context
	ApiService *EdgeApplicationsOriginsAPIService
	edgeApplicationId int64
	page *int64
	pageSize *int64
	filter *string
	orderBy *string
	sort *string
	accept *string
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest) Page(page int64) ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest {
	r.page = &page
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest) PageSize(pageSize int64) ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest {
	r.pageSize = &pageSize
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest) Filter(filter string) ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest {
	r.filter = &filter
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest) OrderBy(orderBy string) ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest {
	r.orderBy = &orderBy
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest) Sort(sort string) ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest {
	r.sort = &sort
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest) Accept(accept string) ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest {
	r.accept = &accept
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest) Execute() (*OriginsResponse, *http.Response, error) {
	return r.ApiService.EdgeApplicationsEdgeApplicationIdOriginsGetExecute(r)
}

/*
EdgeApplicationsEdgeApplicationIdOriginsGet /edge_applications/{edge_application_id}/origins

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeApplicationId
 @return ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest
*/
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsGet(ctx context.Context, edgeApplicationId int64) ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest {
	return ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest{
		ApiService: a,
		ctx: ctx,
		edgeApplicationId: edgeApplicationId,
	}
}

// Execute executes the request
//  @return OriginsResponse
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsGetExecute(r ApiEdgeApplicationsEdgeApplicationIdOriginsGetRequest) (*OriginsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *OriginsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "EdgeApplicationsOriginsAPIService.EdgeApplicationsEdgeApplicationIdOriginsGet")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_applications/{edge_application_id}/origins"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_application_id"+"}", url.PathEscape(parameterValueToString(r.edgeApplicationId, "edgeApplicationId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.page != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "page", r.page, "form", "")
	}
	if r.pageSize != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "page_size", r.pageSize, "form", "")
	}
	if r.filter != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "filter", r.filter, "form", "")
	}
	if r.orderBy != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "order_by", r.orderBy, "form", "")
	}
	if r.sort != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "sort", r.sort, "form", "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.accept != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Accept", r.accept, "simple", "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyDeleteRequest struct {
	ctx context.Context
	ApiService *EdgeApplicationsOriginsAPIService
	edgeApplicationId int64
	originKey string
	accept *string
}

// The id of the Origin that you plan to delete.
func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyDeleteRequest) Accept(accept string) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyDeleteRequest {
	r.accept = &accept
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.EdgeApplicationsEdgeApplicationIdOriginsOriginKeyDeleteExecute(r)
}

/*
EdgeApplicationsEdgeApplicationIdOriginsOriginKeyDelete /edge_applications/{edge_application_id}/origins/{origin_id}

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeApplicationId
 @param originKey
 @return ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyDeleteRequest
*/
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsOriginKeyDelete(ctx context.Context, edgeApplicationId int64, originKey string) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyDeleteRequest {
	return ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyDeleteRequest{
		ApiService: a,
		ctx: ctx,
		edgeApplicationId: edgeApplicationId,
		originKey: originKey,
	}
}

// Execute executes the request
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsOriginKeyDeleteExecute(r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "EdgeApplicationsOriginsAPIService.EdgeApplicationsEdgeApplicationIdOriginsOriginKeyDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_applications/{edge_application_id}/origins/{origin_key}"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_application_id"+"}", url.PathEscape(parameterValueToString(r.edgeApplicationId, "edgeApplicationId")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"origin_key"+"}", url.PathEscape(parameterValueToString(r.originKey, "originKey")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.accept != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Accept", r.accept, "simple", "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyGetRequest struct {
	ctx context.Context
	ApiService *EdgeApplicationsOriginsAPIService
	edgeApplicationId int64
	originKey string
	accept *string
}

// The id of the Origin that you plan to query.
func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyGetRequest) Accept(accept string) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyGetRequest {
	r.accept = &accept
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyGetRequest) Execute() (*OriginsIdResponse, *http.Response, error) {
	return r.ApiService.EdgeApplicationsEdgeApplicationIdOriginsOriginKeyGetExecute(r)
}

/*
EdgeApplicationsEdgeApplicationIdOriginsOriginKeyGet /edge_applications/{edge_application_id}/origins/{origin_key}

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeApplicationId
 @param originKey
 @return ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyGetRequest
*/
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsOriginKeyGet(ctx context.Context, edgeApplicationId int64, originKey string) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyGetRequest {
	return ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyGetRequest{
		ApiService: a,
		ctx: ctx,
		edgeApplicationId: edgeApplicationId,
		originKey: originKey,
	}
}

// Execute executes the request
//  @return OriginsIdResponse
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsOriginKeyGetExecute(r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyGetRequest) (*OriginsIdResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *OriginsIdResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "EdgeApplicationsOriginsAPIService.EdgeApplicationsEdgeApplicationIdOriginsOriginKeyGet")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_applications/{edge_application_id}/origins/{origin_key}"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_application_id"+"}", url.PathEscape(parameterValueToString(r.edgeApplicationId, "edgeApplicationId")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"origin_key"+"}", url.PathEscape(parameterValueToString(r.originKey, "originKey")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.accept != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Accept", r.accept, "simple", "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest struct {
	ctx context.Context
	ApiService *EdgeApplicationsOriginsAPIService
	edgeApplicationId int64
	originKey string
	accept *string
	contentType *string
	patchOriginsRequest *PatchOriginsRequest
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest) Accept(accept string) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest {
	r.accept = &accept
	return r
}

// The type of coding used in the Body (application/json). &lt;br&gt;  Example: Content-Type: application/json
func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest) ContentType(contentType string) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest {
	r.contentType = &contentType
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest) PatchOriginsRequest(patchOriginsRequest PatchOriginsRequest) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest {
	r.patchOriginsRequest = &patchOriginsRequest
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest) Execute() (*OriginsIdResponse, *http.Response, error) {
	return r.ApiService.EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchExecute(r)
}

/*
EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatch /edge_applications/:edge_application_id:/origins/:origin_id:

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeApplicationId
 @param originKey
 @return ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest
*/
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatch(ctx context.Context, edgeApplicationId int64, originKey string) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest {
	return ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest{
		ApiService: a,
		ctx: ctx,
		edgeApplicationId: edgeApplicationId,
		originKey: originKey,
	}
}

// Execute executes the request
//  @return OriginsIdResponse
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchExecute(r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatchRequest) (*OriginsIdResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *OriginsIdResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "EdgeApplicationsOriginsAPIService.EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatch")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_applications/{edge_application_id}/origins/{origin_key}"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_application_id"+"}", url.PathEscape(parameterValueToString(r.edgeApplicationId, "edgeApplicationId")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"origin_key"+"}", url.PathEscape(parameterValueToString(r.originKey, "originKey")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json; version=3"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.accept != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Accept", r.accept, "simple", "")
	}
	if r.contentType != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Content-Type", r.contentType, "simple", "")
	}
	// body params
	localVarPostBody = r.patchOriginsRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest struct {
	ctx context.Context
	ApiService *EdgeApplicationsOriginsAPIService
	edgeApplicationId int64
	originKey string
	accept *string
	contentType *string
	updateOriginsRequest *UpdateOriginsRequest
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest) Accept(accept string) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest {
	r.accept = &accept
	return r
}

// The type of coding used in the Body (application/json). &lt;br&gt;  Example: Content-Type: application/json
func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest) ContentType(contentType string) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest {
	r.contentType = &contentType
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest) UpdateOriginsRequest(updateOriginsRequest UpdateOriginsRequest) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest {
	r.updateOriginsRequest = &updateOriginsRequest
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest) Execute() (*OriginsIdResponse, *http.Response, error) {
	return r.ApiService.EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutExecute(r)
}

/*
EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPut /edge_applications/{edge_application_id}/origins/{origin_id}

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeApplicationId
 @param originKey
 @return ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest
*/
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPut(ctx context.Context, edgeApplicationId int64, originKey string) ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest {
	return ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest{
		ApiService: a,
		ctx: ctx,
		edgeApplicationId: edgeApplicationId,
		originKey: originKey,
	}
}

// Execute executes the request
//  @return OriginsIdResponse
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutExecute(r ApiEdgeApplicationsEdgeApplicationIdOriginsOriginKeyPutRequest) (*OriginsIdResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *OriginsIdResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "EdgeApplicationsOriginsAPIService.EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPut")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_applications/{edge_application_id}/origins/{origin_key}"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_application_id"+"}", url.PathEscape(parameterValueToString(r.edgeApplicationId, "edgeApplicationId")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"origin_key"+"}", url.PathEscape(parameterValueToString(r.originKey, "originKey")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json; version=3"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.accept != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Accept", r.accept, "simple", "")
	}
	if r.contentType != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Content-Type", r.contentType, "simple", "")
	}
	// body params
	localVarPostBody = r.updateOriginsRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest struct {
	ctx context.Context
	ApiService *EdgeApplicationsOriginsAPIService
	edgeApplicationId int64
	accept *string
	contentType *string
	createOriginsRequest *CreateOriginsRequest
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest) Accept(accept string) ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest {
	r.accept = &accept
	return r
}

// The type of coding used in the Body (application/json). &lt;br&gt;  Example: Content-Type: application/json
func (r ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest) ContentType(contentType string) ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest {
	r.contentType = &contentType
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest) CreateOriginsRequest(createOriginsRequest CreateOriginsRequest) ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest {
	r.createOriginsRequest = &createOriginsRequest
	return r
}

func (r ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest) Execute() (*OriginsIdResponse, *http.Response, error) {
	return r.ApiService.EdgeApplicationsEdgeApplicationIdOriginsPostExecute(r)
}

/*
EdgeApplicationsEdgeApplicationIdOriginsPost /edge_applications/{edge_application_id}/origins

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeApplicationId
 @return ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest
*/
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsPost(ctx context.Context, edgeApplicationId int64) ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest {
	return ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest{
		ApiService: a,
		ctx: ctx,
		edgeApplicationId: edgeApplicationId,
	}
}

// Execute executes the request
//  @return OriginsIdResponse
func (a *EdgeApplicationsOriginsAPIService) EdgeApplicationsEdgeApplicationIdOriginsPostExecute(r ApiEdgeApplicationsEdgeApplicationIdOriginsPostRequest) (*OriginsIdResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *OriginsIdResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "EdgeApplicationsOriginsAPIService.EdgeApplicationsEdgeApplicationIdOriginsPost")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_applications/{edge_application_id}/origins"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_application_id"+"}", url.PathEscape(parameterValueToString(r.edgeApplicationId, "edgeApplicationId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json; version=3"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.accept != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Accept", r.accept, "simple", "")
	}
	if r.contentType != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Content-Type", r.contentType, "simple", "")
	}
	// body params
	localVarPostBody = r.createOriginsRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
