/*
Edge Firewall API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package edgefirewall

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
)


// DefaultAPIService DefaultAPI service
type DefaultAPIService service

type ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	edgeFirewallId int64
	page *int64
	pageSize *int64
	sort *string
	orderBy *string
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest) Page(page int64) ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest {
	r.page = &page
	return r
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest) PageSize(pageSize int64) ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest {
	r.pageSize = &pageSize
	return r
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest) Sort(sort string) ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest {
	r.sort = &sort
	return r
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest) OrderBy(orderBy string) ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest {
	r.orderBy = &orderBy
	return r
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest) Execute() (*RuleSetResponseAll, *http.Response, error) {
	return r.ApiService.EdgeFirewallEdgeFirewallIdRulesEngineGetExecute(r)
}

/*
EdgeFirewallEdgeFirewallIdRulesEngineGet List all rule sets.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeFirewallId
 @return ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest
*/
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEngineGet(ctx context.Context, edgeFirewallId int64) ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest {
	return ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest{
		ApiService: a,
		ctx: ctx,
		edgeFirewallId: edgeFirewallId,
	}
}

// Execute executes the request
//  @return RuleSetResponseAll
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEngineGetExecute(r ApiEdgeFirewallEdgeFirewallIdRulesEngineGetRequest) (*RuleSetResponseAll, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RuleSetResponseAll
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallEdgeFirewallIdRulesEngineGet")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall/{edge_firewall_id}/rules_engine"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_firewall_id"+"}", url.PathEscape(parameterValueToString(r.edgeFirewallId, "edgeFirewallId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.edgeFirewallId < 1 {
		return localVarReturnValue, nil, reportError("edgeFirewallId must be greater than 1")
	}

	if r.page != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "page", r.page, "")
	}
	if r.pageSize != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "page_size", r.pageSize, "")
	}
	if r.sort != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "sort", r.sort, "")
	}
	if r.orderBy != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "order_by", r.orderBy, "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeFirewallEdgeFirewallIdRulesEnginePostRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	edgeFirewallId int64
	createRuleSetRequest *CreateRuleSetRequest
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEnginePostRequest) CreateRuleSetRequest(createRuleSetRequest CreateRuleSetRequest) ApiEdgeFirewallEdgeFirewallIdRulesEnginePostRequest {
	r.createRuleSetRequest = &createRuleSetRequest
	return r
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEnginePostRequest) Execute() (*RuleSetResponse, *http.Response, error) {
	return r.ApiService.EdgeFirewallEdgeFirewallIdRulesEnginePostExecute(r)
}

/*
EdgeFirewallEdgeFirewallIdRulesEnginePost Create rule set.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeFirewallId
 @return ApiEdgeFirewallEdgeFirewallIdRulesEnginePostRequest
*/
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEnginePost(ctx context.Context, edgeFirewallId int64) ApiEdgeFirewallEdgeFirewallIdRulesEnginePostRequest {
	return ApiEdgeFirewallEdgeFirewallIdRulesEnginePostRequest{
		ApiService: a,
		ctx: ctx,
		edgeFirewallId: edgeFirewallId,
	}
}

// Execute executes the request
//  @return RuleSetResponse
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEnginePostExecute(r ApiEdgeFirewallEdgeFirewallIdRulesEnginePostRequest) (*RuleSetResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RuleSetResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallEdgeFirewallIdRulesEnginePost")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall/{edge_firewall_id}/rules_engine"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_firewall_id"+"}", url.PathEscape(parameterValueToString(r.edgeFirewallId, "edgeFirewallId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.edgeFirewallId < 1 {
		return localVarReturnValue, nil, reportError("edgeFirewallId must be greater than 1")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json; version=3"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.createRuleSetRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDeleteRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	edgeFirewallId int64
	ruleSetId int64
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDeleteExecute(r)
}

/*
EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDelete Delete rule set.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeFirewallId
 @param ruleSetId
 @return ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDeleteRequest
*/
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDelete(ctx context.Context, edgeFirewallId int64, ruleSetId int64) ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDeleteRequest {
	return ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDeleteRequest{
		ApiService: a,
		ctx: ctx,
		edgeFirewallId: edgeFirewallId,
		ruleSetId: ruleSetId,
	}
}

// Execute executes the request
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDeleteExecute(r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall/{edge_firewall_id}/rules_engine/{rule_set_id}"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_firewall_id"+"}", url.PathEscape(parameterValueToString(r.edgeFirewallId, "edgeFirewallId")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"rule_set_id"+"}", url.PathEscape(parameterValueToString(r.ruleSetId, "ruleSetId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.edgeFirewallId < 1 {
		return nil, reportError("edgeFirewallId must be greater than 1")
	}
	if r.ruleSetId < 1 {
		return nil, reportError("ruleSetId must be greater than 1")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	edgeFirewallId int64
	ruleSetId int64
	orderBy *string
	sort *string
	page *int64
	pageSize *int64
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest) OrderBy(orderBy string) ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest {
	r.orderBy = &orderBy
	return r
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest) Sort(sort string) ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest {
	r.sort = &sort
	return r
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest) Page(page int64) ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest {
	r.page = &page
	return r
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest) PageSize(pageSize int64) ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest {
	r.pageSize = &pageSize
	return r
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest) Execute() (*RuleSetResult, *http.Response, error) {
	return r.ApiService.EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetExecute(r)
}

/*
EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGet Retrieve rule set by ID.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeFirewallId
 @param ruleSetId
 @return ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest
*/
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGet(ctx context.Context, edgeFirewallId int64, ruleSetId int64) ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest {
	return ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest{
		ApiService: a,
		ctx: ctx,
		edgeFirewallId: edgeFirewallId,
		ruleSetId: ruleSetId,
	}
}

// Execute executes the request
//  @return RuleSetResult
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetExecute(r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGetRequest) (*RuleSetResult, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RuleSetResult
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGet")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall/{edge_firewall_id}/rules_engine/{rule_set_id}"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_firewall_id"+"}", url.PathEscape(parameterValueToString(r.edgeFirewallId, "edgeFirewallId")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"rule_set_id"+"}", url.PathEscape(parameterValueToString(r.ruleSetId, "ruleSetId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.edgeFirewallId < 1 {
		return localVarReturnValue, nil, reportError("edgeFirewallId must be greater than 1")
	}
	if r.ruleSetId < 1 {
		return localVarReturnValue, nil, reportError("ruleSetId must be greater than 1")
	}

	if r.orderBy != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "order_by", r.orderBy, "")
	}
	if r.sort != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "sort", r.sort, "")
	}
	if r.page != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "page", r.page, "")
	} else {
		var defaultValue int64 = 1
		r.page = &defaultValue
	}
	if r.pageSize != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "page_size", r.pageSize, "")
	} else {
		var defaultValue int64 = 10
		r.pageSize = &defaultValue
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatchRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	edgeFirewallId int64
	ruleSetId int64
	createRuleSetRequest *CreateRuleSetRequest
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatchRequest) CreateRuleSetRequest(createRuleSetRequest CreateRuleSetRequest) ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatchRequest {
	r.createRuleSetRequest = &createRuleSetRequest
	return r
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatchRequest) Execute() (*RuleSetResult, *http.Response, error) {
	return r.ApiService.EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatchExecute(r)
}

/*
EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatch Edit rule set.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeFirewallId
 @param ruleSetId
 @return ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatchRequest
*/
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatch(ctx context.Context, edgeFirewallId int64, ruleSetId int64) ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatchRequest {
	return ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatchRequest{
		ApiService: a,
		ctx: ctx,
		edgeFirewallId: edgeFirewallId,
		ruleSetId: ruleSetId,
	}
}

// Execute executes the request
//  @return RuleSetResult
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatchExecute(r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatchRequest) (*RuleSetResult, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RuleSetResult
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatch")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall/{edge_firewall_id}/rules_engine/{rule_set_id}"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_firewall_id"+"}", url.PathEscape(parameterValueToString(r.edgeFirewallId, "edgeFirewallId")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"rule_set_id"+"}", url.PathEscape(parameterValueToString(r.ruleSetId, "ruleSetId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.edgeFirewallId < 1 {
		return localVarReturnValue, nil, reportError("edgeFirewallId must be greater than 1")
	}
	if r.ruleSetId < 1 {
		return localVarReturnValue, nil, reportError("ruleSetId must be greater than 1")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json; version=3"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.createRuleSetRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPutRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	edgeFirewallId int64
	ruleSetId int64
	createRuleSetRequest *CreateRuleSetRequest
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPutRequest) CreateRuleSetRequest(createRuleSetRequest CreateRuleSetRequest) ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPutRequest {
	r.createRuleSetRequest = &createRuleSetRequest
	return r
}

func (r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPutRequest) Execute() (*RuleSetResult, *http.Response, error) {
	return r.ApiService.EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPutExecute(r)
}

/*
EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPut Overwrite rule set

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param edgeFirewallId
 @param ruleSetId
 @return ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPutRequest
*/
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPut(ctx context.Context, edgeFirewallId int64, ruleSetId int64) ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPutRequest {
	return ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPutRequest{
		ApiService: a,
		ctx: ctx,
		edgeFirewallId: edgeFirewallId,
		ruleSetId: ruleSetId,
	}
}

// Execute executes the request
//  @return RuleSetResult
func (a *DefaultAPIService) EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPutExecute(r ApiEdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPutRequest) (*RuleSetResult, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RuleSetResult
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPut")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall/{edge_firewall_id}/rules_engine/{rule_set_id}"
	localVarPath = strings.Replace(localVarPath, "{"+"edge_firewall_id"+"}", url.PathEscape(parameterValueToString(r.edgeFirewallId, "edgeFirewallId")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"rule_set_id"+"}", url.PathEscape(parameterValueToString(r.ruleSetId, "ruleSetId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.edgeFirewallId < 1 {
		return localVarReturnValue, nil, reportError("edgeFirewallId must be greater than 1")
	}
	if r.ruleSetId < 1 {
		return localVarReturnValue, nil, reportError("ruleSetId must be greater than 1")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json; version=3"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.createRuleSetRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeFirewallGetRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	page *int64
	pageSize *int64
	sort *string
	orderBy *string
}

func (r ApiEdgeFirewallGetRequest) Page(page int64) ApiEdgeFirewallGetRequest {
	r.page = &page
	return r
}

func (r ApiEdgeFirewallGetRequest) PageSize(pageSize int64) ApiEdgeFirewallGetRequest {
	r.pageSize = &pageSize
	return r
}

func (r ApiEdgeFirewallGetRequest) Sort(sort string) ApiEdgeFirewallGetRequest {
	r.sort = &sort
	return r
}

func (r ApiEdgeFirewallGetRequest) OrderBy(orderBy string) ApiEdgeFirewallGetRequest {
	r.orderBy = &orderBy
	return r
}

func (r ApiEdgeFirewallGetRequest) Execute() (*ListEdgeFirewallResponse, *http.Response, error) {
	return r.ApiService.EdgeFirewallGetExecute(r)
}

/*
EdgeFirewallGet List all user edge firewall

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiEdgeFirewallGetRequest
*/
func (a *DefaultAPIService) EdgeFirewallGet(ctx context.Context) ApiEdgeFirewallGetRequest {
	return ApiEdgeFirewallGetRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return ListEdgeFirewallResponse
func (a *DefaultAPIService) EdgeFirewallGetExecute(r ApiEdgeFirewallGetRequest) (*ListEdgeFirewallResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ListEdgeFirewallResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallGet")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.page != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "page", r.page, "")
	}
	if r.pageSize != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "page_size", r.pageSize, "")
	}
	if r.sort != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "sort", r.sort, "")
	}
	if r.orderBy != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "order_by", r.orderBy, "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeFirewallPostRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	createEdgeFirewallRequest *CreateEdgeFirewallRequest
}

func (r ApiEdgeFirewallPostRequest) CreateEdgeFirewallRequest(createEdgeFirewallRequest CreateEdgeFirewallRequest) ApiEdgeFirewallPostRequest {
	r.createEdgeFirewallRequest = &createEdgeFirewallRequest
	return r
}

func (r ApiEdgeFirewallPostRequest) Execute() (*EdgeFirewallResponse, *http.Response, error) {
	return r.ApiService.EdgeFirewallPostExecute(r)
}

/*
EdgeFirewallPost Create a edge firewall

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiEdgeFirewallPostRequest
*/
func (a *DefaultAPIService) EdgeFirewallPost(ctx context.Context) ApiEdgeFirewallPostRequest {
	return ApiEdgeFirewallPostRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return EdgeFirewallResponse
func (a *DefaultAPIService) EdgeFirewallPostExecute(r ApiEdgeFirewallPostRequest) (*EdgeFirewallResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *EdgeFirewallResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallPost")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.createEdgeFirewallRequest == nil {
		return localVarReturnValue, nil, reportError("createEdgeFirewallRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.createEdgeFirewallRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeFirewallUuidDeleteRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	uuid string
}

func (r ApiEdgeFirewallUuidDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.EdgeFirewallUuidDeleteExecute(r)
}

/*
EdgeFirewallUuidDelete Delete an edge firewall by uuid

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uuid
 @return ApiEdgeFirewallUuidDeleteRequest
*/
func (a *DefaultAPIService) EdgeFirewallUuidDelete(ctx context.Context, uuid string) ApiEdgeFirewallUuidDeleteRequest {
	return ApiEdgeFirewallUuidDeleteRequest{
		ApiService: a,
		ctx: ctx,
		uuid: uuid,
	}
}

// Execute executes the request
func (a *DefaultAPIService) EdgeFirewallUuidDeleteExecute(r ApiEdgeFirewallUuidDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallUuidDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall/{uuid}"
	localVarPath = strings.Replace(localVarPath, "{"+"uuid"+"}", url.PathEscape(parameterValueToString(r.uuid, "uuid")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiEdgeFirewallUuidGetRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	uuid string
}

func (r ApiEdgeFirewallUuidGetRequest) Execute() (*EdgeFirewallResponse, *http.Response, error) {
	return r.ApiService.EdgeFirewallUuidGetExecute(r)
}

/*
EdgeFirewallUuidGet Retrieve an edge firewall set by uuid

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uuid
 @return ApiEdgeFirewallUuidGetRequest
*/
func (a *DefaultAPIService) EdgeFirewallUuidGet(ctx context.Context, uuid string) ApiEdgeFirewallUuidGetRequest {
	return ApiEdgeFirewallUuidGetRequest{
		ApiService: a,
		ctx: ctx,
		uuid: uuid,
	}
}

// Execute executes the request
//  @return EdgeFirewallResponse
func (a *DefaultAPIService) EdgeFirewallUuidGetExecute(r ApiEdgeFirewallUuidGetRequest) (*EdgeFirewallResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *EdgeFirewallResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallUuidGet")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall/{uuid}"
	localVarPath = strings.Replace(localVarPath, "{"+"uuid"+"}", url.PathEscape(parameterValueToString(r.uuid, "uuid")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeFirewallUuidPatchRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	uuid string
	updateEdgeFirewallRequest *UpdateEdgeFirewallRequest
}

func (r ApiEdgeFirewallUuidPatchRequest) UpdateEdgeFirewallRequest(updateEdgeFirewallRequest UpdateEdgeFirewallRequest) ApiEdgeFirewallUuidPatchRequest {
	r.updateEdgeFirewallRequest = &updateEdgeFirewallRequest
	return r
}

func (r ApiEdgeFirewallUuidPatchRequest) Execute() (*EdgeFirewallResponse, *http.Response, error) {
	return r.ApiService.EdgeFirewallUuidPatchExecute(r)
}

/*
EdgeFirewallUuidPatch Update some edge firewall attributes, like \"active\"

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uuid
 @return ApiEdgeFirewallUuidPatchRequest
*/
func (a *DefaultAPIService) EdgeFirewallUuidPatch(ctx context.Context, uuid string) ApiEdgeFirewallUuidPatchRequest {
	return ApiEdgeFirewallUuidPatchRequest{
		ApiService: a,
		ctx: ctx,
		uuid: uuid,
	}
}

// Execute executes the request
//  @return EdgeFirewallResponse
func (a *DefaultAPIService) EdgeFirewallUuidPatchExecute(r ApiEdgeFirewallUuidPatchRequest) (*EdgeFirewallResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *EdgeFirewallResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallUuidPatch")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall/{uuid}"
	localVarPath = strings.Replace(localVarPath, "{"+"uuid"+"}", url.PathEscape(parameterValueToString(r.uuid, "uuid")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.updateEdgeFirewallRequest == nil {
		return localVarReturnValue, nil, reportError("updateEdgeFirewallRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.updateEdgeFirewallRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEdgeFirewallUuidPutRequest struct {
	ctx context.Context
	ApiService *DefaultAPIService
	uuid string
	updateEdgeFirewallRequest *UpdateEdgeFirewallRequest
}

func (r ApiEdgeFirewallUuidPutRequest) UpdateEdgeFirewallRequest(updateEdgeFirewallRequest UpdateEdgeFirewallRequest) ApiEdgeFirewallUuidPutRequest {
	r.updateEdgeFirewallRequest = &updateEdgeFirewallRequest
	return r
}

func (r ApiEdgeFirewallUuidPutRequest) Execute() (*EdgeFirewallResponse, *http.Response, error) {
	return r.ApiService.EdgeFirewallUuidPutExecute(r)
}

/*
EdgeFirewallUuidPut Overwrite some edge firewall attributes, like \"active\"

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uuid
 @return ApiEdgeFirewallUuidPutRequest
*/
func (a *DefaultAPIService) EdgeFirewallUuidPut(ctx context.Context, uuid string) ApiEdgeFirewallUuidPutRequest {
	return ApiEdgeFirewallUuidPutRequest{
		ApiService: a,
		ctx: ctx,
		uuid: uuid,
	}
}

// Execute executes the request
//  @return EdgeFirewallResponse
func (a *DefaultAPIService) EdgeFirewallUuidPutExecute(r ApiEdgeFirewallUuidPutRequest) (*EdgeFirewallResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *EdgeFirewallResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DefaultAPIService.EdgeFirewallUuidPut")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/edge_firewall/{uuid}"
	localVarPath = strings.Replace(localVarPath, "{"+"uuid"+"}", url.PathEscape(parameterValueToString(r.uuid, "uuid")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.updateEdgeFirewallRequest == nil {
		return localVarReturnValue, nil, reportError("updateEdgeFirewallRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.updateEdgeFirewallRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
