/*
Object Storage

REST API OpenAPI documentation for the Object Storage

API version: 1.0.0 (v1)
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package storage

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the Bucket type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &Bucket{}

// Bucket struct for Bucket
type Bucket struct {
	Name string `json:"name"`
	EdgeAccess EdgeAccessEnum `json:"edge_access"`
}

type _Bucket Bucket

// NewBucket instantiates a new Bucket object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBucket(name string, edgeAccess EdgeAccessEnum) *Bucket {
	this := Bucket{}
	this.Name = name
	this.EdgeAccess = edgeAccess
	return &this
}

// NewBucketWithDefaults instantiates a new Bucket object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBucketWithDefaults() *Bucket {
	this := Bucket{}
	return &this
}

// GetName returns the Name field value
func (o *Bucket) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *Bucket) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *Bucket) SetName(v string) {
	o.Name = v
}

// GetEdgeAccess returns the EdgeAccess field value
func (o *Bucket) GetEdgeAccess() EdgeAccessEnum {
	if o == nil {
		var ret EdgeAccessEnum
		return ret
	}

	return o.EdgeAccess
}

// GetEdgeAccessOk returns a tuple with the EdgeAccess field value
// and a boolean to check if the value has been set.
func (o *Bucket) GetEdgeAccessOk() (*EdgeAccessEnum, bool) {
	if o == nil {
		return nil, false
	}
	return &o.EdgeAccess, true
}

// SetEdgeAccess sets field value
func (o *Bucket) SetEdgeAccess(v EdgeAccessEnum) {
	o.EdgeAccess = v
}

func (o Bucket) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o Bucket) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["name"] = o.Name
	toSerialize["edge_access"] = o.EdgeAccess
	return toSerialize, nil
}

func (o *Bucket) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"name",
		"edge_access",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varBucket := _Bucket{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varBucket)

	if err != nil {
		return err
	}

	*o = Bucket(varBucket)

	return err
}

type NullableBucket struct {
	value *Bucket
	isSet bool
}

func (v NullableBucket) Get() *Bucket {
	return v.value
}

func (v *NullableBucket) Set(val *Bucket) {
	v.value = val
	v.isSet = true
}

func (v NullableBucket) IsSet() bool {
	return v.isSet
}

func (v *NullableBucket) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBucket(val *Bucket) *NullableBucket {
	return &NullableBucket{value: val, isSet: true}
}

func (v NullableBucket) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBucket) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


