/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.BellmanFordPathElement;

@Deprecated
class BellmanFordIterator<V, E>
implements Iterator<List<V>> {
    protected static final String NEGATIVE_UNDIRECTED_EDGE = "Negativeedge-weights are not allowed in an unidrected graph!";
    protected Graph<V, E> graph;
    protected V startVertex;
    private List<V> prevImprovedVertices = new ArrayList<V>();
    private Map<V, BellmanFordPathElement<V, E>> prevVertexData;
    private boolean startVertexEncountered = false;
    private Map<V, BellmanFordPathElement<V, E>> vertexData;
    private double epsilon;

    protected BellmanFordIterator(Graph<V, E> graph, V startVertex, double epsilon) {
        this.assertBellmanFordIterator(graph, startVertex);
        this.graph = graph;
        this.startVertex = startVertex;
        this.epsilon = epsilon;
    }

    public BellmanFordPathElement<V, E> getPathElement(V endVertex) {
        return this.getSeenData(endVertex);
    }

    @Override
    public boolean hasNext() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        return !this.prevImprovedVertices.isEmpty();
    }

    @Override
    public List<V> next() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            ArrayList<V> improvedVertices = new ArrayList<V>();
            for (int i = this.prevImprovedVertices.size() - 1; i >= 0; --i) {
                V vertex = this.prevImprovedVertices.get(i);
                Iterator<E> iter = this.edgesOfIterator(vertex);
                while (iter.hasNext()) {
                    E edge = iter.next();
                    V oppositeVertex = Graphs.getOppositeVertex(this.graph, edge, vertex);
                    if (this.getPathElement(oppositeVertex) != null) {
                        boolean relaxed = this.relaxVertexAgain(oppositeVertex, edge);
                        if (!relaxed) continue;
                        improvedVertices.add(oppositeVertex);
                        continue;
                    }
                    this.relaxVertex(oppositeVertex, edge);
                    improvedVertices.add(oppositeVertex);
                }
            }
            this.savePassData(improvedVertices);
            return improvedVertices;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void assertValidEdge(E edge) {
        if (this.graph instanceof UndirectedGraph && this.graph.getEdgeWeight(edge) < 0.0) {
            throw new IllegalArgumentException(NEGATIVE_UNDIRECTED_EDGE);
        }
    }

    protected double calculatePathCost(V vertex, E edge) {
        V oppositeVertex = Graphs.getOppositeVertex(this.graph, edge, vertex);
        BellmanFordPathElement<V, E> oppositePrevData = this.getPrevSeenData(oppositeVertex);
        double pathCost = this.graph.getEdgeWeight(edge);
        if (!oppositePrevData.getVertex().equals(this.startVertex)) {
            pathCost += oppositePrevData.getCost();
        }
        return pathCost;
    }

    protected Iterator<E> edgesOfIterator(V vertex) {
        if (this.graph instanceof DirectedGraph) {
            return ((DirectedGraph)this.graph).outgoingEdgesOf(vertex).iterator();
        }
        return this.graph.edgesOf(vertex).iterator();
    }

    protected BellmanFordPathElement<V, E> getPrevSeenData(V vertex) {
        return this.prevVertexData.get(vertex);
    }

    protected BellmanFordPathElement<V, E> getSeenData(V vertex) {
        return this.vertexData.get(vertex);
    }

    protected boolean isSeenVertex(V vertex) {
        return this.vertexData.containsKey(vertex);
    }

    protected BellmanFordPathElement<V, E> putPrevSeenData(V vertex, BellmanFordPathElement<V, E> data) {
        if (this.prevVertexData == null) {
            this.prevVertexData = new HashMap<V, BellmanFordPathElement<V, E>>();
        }
        return this.prevVertexData.put((BellmanFordPathElement<V, E>)vertex, (BellmanFordPathElement<BellmanFordPathElement<V, E>, E>)data);
    }

    protected BellmanFordPathElement<V, E> putSeenData(V vertex, BellmanFordPathElement<V, E> data) {
        if (this.vertexData == null) {
            this.vertexData = new HashMap<V, BellmanFordPathElement<V, E>>();
        }
        return this.vertexData.put((BellmanFordPathElement<V, E>)vertex, (BellmanFordPathElement<BellmanFordPathElement<V, E>, E>)data);
    }

    private void assertBellmanFordIterator(Graph<V, E> graph, V startVertex) {
        if (!graph.containsVertex(startVertex)) {
            throw new IllegalArgumentException("Graph must contain the start vertex!");
        }
    }

    private BellmanFordPathElement<V, E> createSeenData(V vertex, E edge, double cost) {
        BellmanFordPathElement<V, E> prevPathElement = this.getPrevSeenData(Graphs.getOppositeVertex(this.graph, edge, vertex));
        return new BellmanFordPathElement<V, E>(this.graph, prevPathElement, edge, cost, this.epsilon);
    }

    private void encounterStartVertex() {
        BellmanFordPathElement data = new BellmanFordPathElement(this.startVertex, this.epsilon);
        this.prevImprovedVertices.add(this.startVertex);
        this.putSeenData(this.startVertex, data);
        this.putPrevSeenData(this.startVertex, data);
        this.startVertexEncountered = true;
    }

    private void relaxVertex(V vertex, E edge) {
        this.assertValidEdge(edge);
        double shortestPathCost = this.calculatePathCost(vertex, edge);
        BellmanFordPathElement<V, E> data = this.createSeenData(vertex, edge, shortestPathCost);
        this.putSeenData(vertex, data);
    }

    private boolean relaxVertexAgain(V vertex, E edge) {
        this.assertValidEdge(edge);
        double candidateCost = this.calculatePathCost(vertex, edge);
        BellmanFordPathElement<V, E> oppositePrevData = this.getPrevSeenData(Graphs.getOppositeVertex(this.graph, edge, vertex));
        BellmanFordPathElement<V, E> pathElement = this.getSeenData(vertex);
        return pathElement.improve(oppositePrevData, edge, candidateCost);
    }

    private void savePassData(List<V> improvedVertices) {
        for (V vertex : improvedVertices) {
            BellmanFordPathElement<V, E> orig = this.getSeenData(vertex);
            BellmanFordPathElement<V, E> clonedData = new BellmanFordPathElement<V, E>(orig);
            this.putPrevSeenData(vertex, clonedData);
        }
        this.prevImprovedVertices = improvedVertices;
    }
}

