/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.graph.GraphWalk;
import org.jgrapht.traverse.ClosestFirstIterator;

@Deprecated
public final class DijkstraShortestPath<V, E> {
    private GraphPath<V, E> path;

    public DijkstraShortestPath(Graph<V, E> graph, V startVertex, V endVertex) {
        this(graph, startVertex, endVertex, Double.POSITIVE_INFINITY);
    }

    public DijkstraShortestPath(Graph<V, E> graph, V startVertex, V endVertex, double radius) {
        if (!graph.containsVertex(endVertex)) {
            throw new IllegalArgumentException("graph must contain the end vertex");
        }
        ClosestFirstIterator<V, E> iter = new ClosestFirstIterator<V, E>(graph, startVertex, radius);
        while (iter.hasNext()) {
            Object vertex = iter.next();
            if (!vertex.equals(endVertex)) continue;
            this.createEdgeList(graph, iter, startVertex, endVertex);
            return;
        }
        this.path = null;
    }

    public List<E> getPathEdgeList() {
        if (this.path == null) {
            return null;
        }
        return this.path.getEdgeList();
    }

    public GraphPath<V, E> getPath() {
        return this.path;
    }

    public double getPathLength() {
        if (this.path == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.path.getWeight();
    }

    public static <V, E> List<E> findPathBetween(Graph<V, E> graph, V startVertex, V endVertex) {
        DijkstraShortestPath<V, E> alg = new DijkstraShortestPath<V, E>(graph, startVertex, endVertex);
        return alg.getPathEdgeList();
    }

    private void createEdgeList(Graph<V, E> graph, ClosestFirstIterator<V, E> iter, V startVertex, V endVertex) {
        E edge;
        ArrayList<E> edgeList = new ArrayList<E>();
        ArrayList<V> vertexList = new ArrayList<V>();
        vertexList.add(endVertex);
        V v = endVertex;
        while ((edge = iter.getSpanningTreeEdge(v)) != null) {
            edgeList.add(edge);
            v = Graphs.getOppositeVertex(graph, edge, v);
            vertexList.add(v);
        }
        Collections.reverse(edgeList);
        Collections.reverse(vertexList);
        double pathLength = iter.getShortestPathLength(endVertex);
        this.path = new GraphWalk<V, E>(graph, startVertex, endVertex, vertexList, edgeList, pathLength);
    }
}

