/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.interfaces.MatchingAlgorithm;
import org.jgrapht.graph.Multigraph;

@Deprecated
public class HopcroftKarpBipartiteMatching<V, E>
implements MatchingAlgorithm<V, E> {
    private final UndirectedGraph<V, E> graph;
    private final Set<V> partition1;
    private final Set<V> partition2;
    private Set<E> matching;
    private final Set<V> unmatchedVertices1;
    private final Set<V> unmatchedVertices2;

    public HopcroftKarpBipartiteMatching(UndirectedGraph<V, E> graph, Set<V> partition1, Set<V> partition2) {
        this.graph = graph;
        this.partition1 = partition1;
        this.partition2 = partition2;
        this.matching = new HashSet();
        this.unmatchedVertices1 = new HashSet<V>(partition1);
        this.unmatchedVertices2 = new HashSet<V>(partition2);
        assert (this.checkInputData());
        this.maxMatching();
    }

    private boolean checkInputData() {
        if (this.graph instanceof Multigraph) {
            throw new IllegalArgumentException("Multi graphs are not allowed as input, only simple graphs!");
        }
        HashSet<V> neighborsSet1 = new HashSet<V>();
        for (V v : this.partition1) {
            neighborsSet1.addAll(Graphs.neighborListOf(this.graph, v));
        }
        if (this.interSectionNotEmpty(this.partition1, neighborsSet1)) {
            throw new IllegalArgumentException("There are edges within partition 1, i.e. not a bipartite graph");
        }
        HashSet<V> neighborsSet2 = new HashSet<V>();
        for (V v : this.partition2) {
            neighborsSet2.addAll(Graphs.neighborListOf(this.graph, v));
        }
        if (this.interSectionNotEmpty(this.partition2, neighborsSet2)) {
            throw new IllegalArgumentException("There are edges within partition 2, i.e. not a bipartite graph");
        }
        return true;
    }

    private void greedyMatch() {
        HashSet<V> usedVertices = new HashSet<V>();
        block0: for (V vertex1 : this.partition1) {
            for (V vertex2 : Graphs.neighborListOf(this.graph, vertex1)) {
                if (usedVertices.contains(vertex2)) continue;
                usedVertices.add(vertex2);
                this.unmatchedVertices1.remove(vertex1);
                this.unmatchedVertices2.remove(vertex2);
                this.matching.add(this.graph.getEdge(vertex1, vertex2));
                continue block0;
            }
        }
    }

    private void maxMatching() {
        this.greedyMatch();
        List<LinkedList<V>> augmentingPaths = this.getAugmentingPaths();
        while (!augmentingPaths.isEmpty()) {
            Iterator<LinkedList<V>> it = augmentingPaths.iterator();
            while (it.hasNext()) {
                LinkedList<V> augmentingPath = it.next();
                this.unmatchedVertices1.remove(augmentingPath.getFirst());
                this.unmatchedVertices2.remove(augmentingPath.getLast());
                this.symmetricDifference(augmentingPath);
                it.remove();
            }
            augmentingPaths.addAll(this.getAugmentingPaths());
        }
    }

    private void symmetricDifference(LinkedList<V> augmentingPath) {
        int operation = 0;
        while (augmentingPath.size() > 1) {
            Object edge = this.graph.getEdge(augmentingPath.poll(), augmentingPath.peek());
            if (operation % 2 == 0) {
                this.matching.add(edge);
            } else {
                this.matching.remove(edge);
            }
            ++operation;
        }
    }

    private List<LinkedList<V>> getAugmentingPaths() {
        HashSet<V> evenLayer;
        ArrayList<LinkedList<V>> augmentingPaths = new ArrayList<LinkedList<V>>();
        HashMap layeredMap = new HashMap();
        for (V vertex : this.unmatchedVertices1) {
            layeredMap.put(vertex, new HashSet());
        }
        HashSet<Object> oddLayer = new HashSet<V>(this.unmatchedVertices1);
        HashSet<V> usedVertices = new HashSet<V>(this.unmatchedVertices1);
        while (true) {
            List<V> neighbors;
            evenLayer = new HashSet<V>();
            for (Object e : oddLayer) {
                neighbors = Graphs.neighborListOf(this.graph, e);
                for (V neighbor : neighbors) {
                    if (usedVertices.contains(neighbor)) continue;
                    evenLayer.add(neighbor);
                    if (!layeredMap.containsKey(neighbor)) {
                        layeredMap.put(neighbor, new HashSet());
                    }
                    ((Set)layeredMap.get(neighbor)).add(e);
                }
            }
            usedVertices.addAll(evenLayer);
            if (evenLayer.size() == 0 || this.interSectionNotEmpty(evenLayer, this.unmatchedVertices2)) break;
            oddLayer = new HashSet();
            for (Object e : evenLayer) {
                neighbors = Graphs.neighborListOf(this.graph, e);
                for (V neighbor : neighbors) {
                    if (usedVertices.contains(neighbor) || !this.matching.contains(this.graph.getEdge(e, neighbor))) continue;
                    oddLayer.add(neighbor);
                    if (!layeredMap.containsKey(neighbor)) {
                        layeredMap.put(neighbor, new HashSet());
                    }
                    ((Set)layeredMap.get(neighbor)).add(e);
                }
            }
            usedVertices.addAll(oddLayer);
        }
        if (evenLayer.size() == 0) {
            return augmentingPaths;
        }
        evenLayer.retainAll(this.unmatchedVertices2);
        for (Object e : evenLayer) {
            LinkedList augmentingPath = this.dfs(e, layeredMap);
            if (augmentingPath == null) continue;
            augmentingPaths.add(augmentingPath);
            for (Object augmentingVertex : augmentingPath) {
                layeredMap.remove(augmentingVertex);
            }
        }
        return augmentingPaths;
    }

    private LinkedList<V> dfs(V startVertex, Map<V, Set<V>> layeredMap) {
        if (!layeredMap.containsKey(startVertex)) {
            return null;
        }
        if (this.unmatchedVertices1.contains(startVertex)) {
            LinkedList<V> list = new LinkedList<V>();
            list.add(startVertex);
            return list;
        }
        LinkedList<V> partialPath = null;
        for (V vertex : layeredMap.get(startVertex)) {
            partialPath = this.dfs(vertex, layeredMap);
            if (partialPath == null) continue;
            partialPath.add(startVertex);
            break;
        }
        return partialPath;
    }

    private boolean interSectionNotEmpty(Set<V> vertexSet1, Set<V> vertexSet2) {
        for (V vertex : vertexSet1) {
            if (!vertexSet2.contains(vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<E> getMatching() {
        return Collections.unmodifiableSet(this.matching);
    }

    @Override
    public MatchingAlgorithm.Matching<E> computeMatching() {
        Set<E> m = this.getMatching();
        double w = 0.0;
        for (E e : m) {
            w += this.graph.getEdgeWeight(e);
        }
        return new MatchingAlgorithm.MatchingImpl<E>(m, w);
    }
}

