/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import java.util.Map;
import java.util.Set;
import org.springframework.data.mongodb.MongoTransactionOptions;
import org.springframework.data.mongodb.MongoTransactionOptionsResolver;
import org.springframework.data.mongodb.SimpleMongoTransactionOptions;
import org.springframework.lang.Nullable;

enum DefaultMongoTransactionOptionsResolver implements MongoTransactionOptionsResolver
{
    INSTANCE;

    private static final String PREFIX = "mongo:";

    @Override
    public MongoTransactionOptions convert(Map<String, String> options) {
        DefaultMongoTransactionOptionsResolver.validateKeys(options.keySet());
        return SimpleMongoTransactionOptions.of(options);
    }

    @Override
    @Nullable
    public String getLabelPrefix() {
        return PREFIX;
    }

    private static void validateKeys(Set<String> keys) {
        if (!SimpleMongoTransactionOptions.KNOWN_KEYS.containsAll(keys)) {
            throw new IllegalArgumentException("Transaction labels contained invalid values. Has to be one of %s".formatted(SimpleMongoTransactionOptions.KNOWN_KEYS));
        }
    }
}

