/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.SystemVariable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

abstract class AbstractAggregationExpression
implements AggregationExpression {
    private final Object value;

    protected AbstractAggregationExpression(Object value) {
        this.value = value;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return this.toDocument(this.value, context);
    }

    public Document toDocument(Object value, AggregationOperationContext context) {
        return new Document(this.getMongoMethod(), this.unpack(value, context));
    }

    protected static List<Field> asFields(String ... fieldRefs) {
        if (ObjectUtils.isEmpty((Object[])fieldRefs)) {
            return Collections.emptyList();
        }
        return Fields.fields(fieldRefs).asList();
    }

    private Object unpack(Object value, AggregationOperationContext context) {
        if (value instanceof AggregationExpression) {
            AggregationExpression aggregationExpression = (AggregationExpression)value;
            return aggregationExpression.toDocument(context);
        }
        if (value instanceof Field) {
            Field field = (Field)value;
            return context.getReference(field).toString();
        }
        if (value instanceof Fields) {
            Fields fields = (Fields)value;
            ArrayList<Object> mapped = new ArrayList<Object>(fields.size());
            for (Field field : fields) {
                mapped.add(this.unpack(field, context));
            }
            return mapped;
        }
        if (value instanceof Sort) {
            Sort sort = (Sort)value;
            Document sortDoc = new Document();
            for (Sort.Order order : sort) {
                ExposedFields.FieldReference reference = context.getReference(order.getProperty());
                sortDoc.put(reference.getRaw(), (Object)(order.isAscending() ? 1 : -1));
            }
            return sortDoc;
        }
        if (value instanceof List) {
            List sourceList = (List)value;
            ArrayList<Object> mappedList = new ArrayList<Object>(sourceList.size());
            for (Object o : sourceList) {
                mappedList.add(this.unpack(o, context));
            }
            return mappedList;
        }
        if (value instanceof Map) {
            Document targetDocument = new Document();
            Map sourceMap = (Map)value;
            sourceMap.forEach((k, v) -> targetDocument.append(k, this.unpack(v, context)));
            return targetDocument;
        }
        if (value instanceof SystemVariable) {
            return value.toString();
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List<Object> append(Object value, Expand expandList) {
        if (!(this.value instanceof List)) {
            return Arrays.asList(this.value, value);
        }
        ArrayList<Object> clone = new ArrayList<Object>((List)this.value);
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (Expand.EXPAND_VALUES.equals((Object)expandList)) {
                clone.addAll(collection);
                return clone;
            }
        }
        clone.add(value);
        return clone;
    }

    protected List<Object> append(Object value) {
        return this.append(value, Expand.EXPAND_VALUES);
    }

    protected Map<String, Object> append(String key, Object value) {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map");
        return this.append((Map)this.value, key, value);
    }

    private Map<String, Object> append(Map<String, Object> existing, String key, Object value) {
        LinkedHashMap<String, Object> clone = new LinkedHashMap<String, Object>(existing);
        clone.put(key, value);
        return clone;
    }

    protected Map<String, Object> appendTo(String key, Object value) {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map");
        Object object = this.value;
        if (object instanceof Map) {
            Map map = (Map)object;
            HashMap<String, Object> target = new HashMap<String, Object>(map);
            if (!target.containsKey(key)) {
                target.put(key, value);
                return target;
            }
            target.computeIfPresent(key, (k, v) -> {
                if (v instanceof List) {
                    List list = (List)v;
                    ArrayList<Object> targetList = new ArrayList<Object>(list);
                    targetList.add(value);
                    return targetList;
                }
                return Arrays.asList(v, value);
            });
            return target;
        }
        throw new IllegalStateException(String.format("Cannot append value to %s type", ObjectUtils.nullSafeClassName((Object)this.value)));
    }

    protected Map<String, Object> remove(String key) {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map");
        LinkedHashMap<String, Object> clone = new LinkedHashMap<String, Object>((Map)this.value);
        clone.remove(key);
        return clone;
    }

    protected Map<String, Object> appendAt(int index, String key, Object value) {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map");
        LinkedHashMap<String, Object> clone = new LinkedHashMap<String, Object>();
        int i = 0;
        for (Map.Entry entry : ((Map)this.value).entrySet()) {
            if (i == index) {
                clone.put(key, value);
            }
            if (!((String)entry.getKey()).equals(key)) {
                clone.put((String)entry.getKey(), entry.getValue());
            }
            ++i;
        }
        if (i <= index) {
            clone.put(key, value);
        }
        return clone;
    }

    protected List<Object> values() {
        if (this.value instanceof List) {
            return new ArrayList<Object>((List)this.value);
        }
        if (this.value instanceof Map) {
            return new ArrayList<Object>(((Map)this.value).values());
        }
        return new ArrayList<Object>(Collections.singletonList(this.value));
    }

    protected <T> T get(int index) {
        return (T)this.values().get(index);
    }

    protected <T> T get(Object key) {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map");
        return (T)((Map)this.value).get(key);
    }

    protected boolean isArgumentMap() {
        return this.value instanceof Map;
    }

    protected Map<String, Object> argumentMap() {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map");
        return Collections.unmodifiableMap((Map)this.value);
    }

    protected boolean contains(Object key) {
        if (!(this.value instanceof Map)) {
            return false;
        }
        return ((Map)this.value).containsKey(key);
    }

    protected abstract String getMongoMethod();

    protected static enum Expand {
        EXPAND_VALUES,
        KEEP_SOURCE;

    }
}

