/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.util.List;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.index.IndexOptions;
import org.springframework.data.mongodb.core.index.ReactiveIndexOperations;
import org.springframework.util.Assert;

public interface IndexOperationsAdapter
extends IndexOperations {
    public static IndexOperationsAdapter blocking(final ReactiveIndexOperations reactiveIndexOperations) {
        Assert.notNull((Object)reactiveIndexOperations, (String)"ReactiveIndexOperations must not be null");
        return new IndexOperationsAdapter(){

            @Override
            public String ensureIndex(IndexDefinition indexDefinition) {
                return (String)reactiveIndexOperations.ensureIndex(indexDefinition).block();
            }

            @Override
            public void dropIndex(String name) {
                reactiveIndexOperations.dropIndex(name).block();
            }

            @Override
            public void alterIndex(String name, IndexOptions options) {
                reactiveIndexOperations.alterIndex(name, options);
            }

            @Override
            public void dropAllIndexes() {
                reactiveIndexOperations.dropAllIndexes().block();
            }

            @Override
            public List<IndexInfo> getIndexInfo() {
                return (List)reactiveIndexOperations.getIndexInfo().collectList().block();
            }
        };
    }
}

