/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.repository.query.MongoEntityMetadata;
import org.springframework.util.Assert;

class SimpleMongoEntityMetadata<T>
implements MongoEntityMetadata<T> {
    private final Class<T> type;
    private final MongoPersistentEntity<?> collectionEntity;

    public SimpleMongoEntityMetadata(Class<T> type, MongoPersistentEntity<?> collectionEntity) {
        Assert.notNull(type, (String)"Type must not be null");
        Assert.notNull(collectionEntity, (String)"Collection entity must not be null or empty");
        this.type = type;
        this.collectionEntity = collectionEntity;
    }

    public Class<T> getJavaType() {
        return this.type;
    }

    @Override
    public String getCollectionName() {
        return this.collectionEntity.getCollection();
    }

    @Override
    public MongoPersistentEntity<?> getCollectionEntity() {
        return this.collectionEntity;
    }
}

