/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.PathBuilder;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbSerializer;
import org.springframework.data.querydsl.QSort;
import org.springframework.data.repository.core.EntityInformation;

abstract class QuerydslPredicateExecutorSupport<T> {
    private final SpringDataMongodbSerializer serializer;
    private final PathBuilder<T> builder;
    private final EntityInformation<T, ?> entityInformation;

    QuerydslPredicateExecutorSupport(MongoConverter converter, PathBuilder<T> builder, EntityInformation<T, ?> entityInformation) {
        this.serializer = new SpringDataMongodbSerializer(converter);
        this.builder = builder;
        this.entityInformation = entityInformation;
    }

    protected static <E> PathBuilder<E> pathBuilderFor(EntityPath<E> path) {
        return new PathBuilder(path.getType(), path.getMetadata());
    }

    protected EntityInformation<T, ?> typeInformation() {
        return this.entityInformation;
    }

    protected SpringDataMongodbSerializer mongodbSerializer() {
        return this.serializer;
    }

    protected OrderSpecifier<?> toOrder(Sort.Order order) {
        PathBuilder property = this.builder.get(order.getProperty());
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, (Expression)property);
    }

    protected List<OrderSpecifier<?>> toOrderSpecifiers(Sort sort) {
        if (sort instanceof QSort) {
            QSort qSort = (QSort)sort;
            return qSort.getOrderSpecifiers();
        }
        return sort.stream().map(this::toOrder).collect(Collectors.toList());
    }
}

