/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.context;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import org.springframework.util.Assert;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.ServletContextAwareProcessor;

public class WebApplicationContextServletContextAwareProcessor
extends ServletContextAwareProcessor {
    private final ConfigurableWebApplicationContext webApplicationContext;

    public WebApplicationContextServletContextAwareProcessor(ConfigurableWebApplicationContext webApplicationContext) {
        Assert.notNull((Object)webApplicationContext, (String)"WebApplicationContext must not be null");
        this.webApplicationContext = webApplicationContext;
    }

    protected ServletContext getServletContext() {
        ServletContext servletContext = this.webApplicationContext.getServletContext();
        return servletContext != null ? servletContext : super.getServletContext();
    }

    protected ServletConfig getServletConfig() {
        ServletConfig servletConfig = this.webApplicationContext.getServletConfig();
        return servletConfig != null ? servletConfig : super.getServletConfig();
    }
}

