/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.SearchScore;
import com.mongodb.internal.client.model.AbstractConstructibleBsonElement;
import com.mongodb.lang.Nullable;
import org.bson.conversions.Bson;

abstract class RangeConstructibleBsonElement<T, S extends RangeConstructibleBsonElement<T, S>>
extends AbstractConstructibleBsonElement<S> {
    RangeConstructibleBsonElement(String name, Bson value) {
        super(name, value);
    }

    RangeConstructibleBsonElement(Bson baseElement, Bson appendedElementValue) {
        super(baseElement, appendedElementValue);
    }

    public final S score(SearchScore modifier) {
        return (S)((RangeConstructibleBsonElement)this.newWithAppendedValue("score", Assertions.notNull("modifier", modifier)));
    }

    final S internalGt(T l) {
        return this.newWithMutatedValue(l, false, null, false);
    }

    final S internalLt(T u) {
        return this.newWithMutatedValue(null, false, u, false);
    }

    final S internalGte(T l) {
        return this.newWithMutatedValue(l, true, null, false);
    }

    final S internalLte(T u) {
        return this.newWithMutatedValue(null, false, u, true);
    }

    final S internalGtLt(T l, T u) {
        return this.newWithMutatedValue(l, false, u, false);
    }

    final S internalGteLte(T l, T u) {
        return this.newWithMutatedValue(l, true, u, true);
    }

    final S internalGtLte(T l, T u) {
        return this.newWithMutatedValue(l, false, u, true);
    }

    final S internalGteLt(T l, T u) {
        return this.newWithMutatedValue(l, true, u, false);
    }

    private S newWithMutatedValue(@Nullable T l, boolean includeL, @Nullable T u, boolean includeU) {
        if (l == null) {
            Assertions.notNull("u", u);
        } else if (u == null) {
            Assertions.notNull("l", l);
        }
        return (S)((RangeConstructibleBsonElement)this.newWithMutatedValue(doc -> {
            doc.remove((Object)"gte");
            doc.remove((Object)"gt");
            doc.remove((Object)"lte");
            doc.remove((Object)"lt");
            if (l != null) {
                if (includeL) {
                    doc.append("gte", l);
                } else {
                    doc.append("gt", l);
                }
            }
            if (u != null) {
                if (includeU) {
                    doc.append("lte", u);
                } else {
                    doc.append("lt", u);
                }
            }
        }));
    }
}

