/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.transport.verification;

import com.hierynomus.sshj.transport.mac.Macs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Pattern;
import net.schmizz.sshj.common.Base64Decoder;
import net.schmizz.sshj.common.Base64DecodingException;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.transport.mac.MAC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnownHostMatchers {
    private static final Logger log = LoggerFactory.getLogger(KnownHostMatchers.class);

    public static HostMatcher createMatcher(String hostEntry) throws SSHException {
        if (hostEntry.contains(",")) {
            return new AnyHostMatcher(hostEntry);
        }
        if (hostEntry.startsWith("!")) {
            return new NegateHostMatcher(hostEntry);
        }
        if (hostEntry.startsWith("|1|")) {
            return new HashedHostMatcher(hostEntry);
        }
        if (hostEntry.contains("*") || hostEntry.contains("?")) {
            return new WildcardHostMatcher(hostEntry);
        }
        return new EquiHostMatcher(hostEntry);
    }

    private static class WildcardHostMatcher
    implements HostMatcher {
        private final Pattern pattern;

        public WildcardHostMatcher(String hostEntry) {
            this.pattern = Pattern.compile("^" + hostEntry.replace("[", "\\[").replace("]", "\\]").replace(".", "\\.").replace("*", ".*").replace("?", ".") + "$");
        }

        @Override
        public boolean match(String hostname) throws IOException {
            return this.pattern.matcher(hostname).matches();
        }

        public String toString() {
            return "WildcardHostMatcher[" + this.pattern + ']';
        }
    }

    private static class NegateHostMatcher
    implements HostMatcher {
        private final HostMatcher matcher;

        NegateHostMatcher(String hostEntry) throws SSHException {
            this.matcher = KnownHostMatchers.createMatcher(hostEntry.substring(1));
        }

        @Override
        public boolean match(String hostname) throws IOException {
            return !this.matcher.match(hostname);
        }
    }

    private static class AnyHostMatcher
    implements HostMatcher {
        private final List<HostMatcher> matchers = new ArrayList<HostMatcher>();

        AnyHostMatcher(String hostEntry) throws SSHException {
            for (String subEntry : hostEntry.split(",")) {
                this.matchers.add(KnownHostMatchers.createMatcher(subEntry));
            }
        }

        @Override
        public boolean match(String hostname) throws IOException {
            for (HostMatcher matcher : this.matchers) {
                if (!matcher.match(hostname)) continue;
                return true;
            }
            return false;
        }
    }

    private static class HashedHostMatcher
    implements HostMatcher {
        private final MAC sha1 = Macs.HMACSHA1().create();
        private final String hash;
        private final String salt;
        private byte[] saltyBytes;

        HashedHostMatcher(String hash) throws SSHException {
            this.hash = hash;
            String[] hostParts = hash.split("\\|");
            if (hostParts.length != 4) {
                throw new SSHException("Unrecognized format for hashed hostname");
            }
            this.salt = hostParts[2];
        }

        @Override
        public boolean match(String hostname) throws IOException {
            try {
                return this.hash.equals(this.hashHost(hostname));
            }
            catch (Base64DecodingException err) {
                log.warn("Hostname [{}] not matched: salt decoding failed", (Object)hostname, (Object)err);
                return false;
            }
        }

        private String hashHost(String host) throws IOException, Base64DecodingException {
            this.sha1.init(this.getSaltyBytes());
            return "|1|" + this.salt + "|" + Base64.getEncoder().encodeToString(this.sha1.doFinal(host.getBytes(IOUtils.UTF8)));
        }

        private byte[] getSaltyBytes() throws IOException, Base64DecodingException {
            if (this.saltyBytes == null) {
                this.saltyBytes = Base64Decoder.decode(this.salt);
            }
            return this.saltyBytes;
        }
    }

    private static class EquiHostMatcher
    implements HostMatcher {
        private String host;

        public EquiHostMatcher(String host) {
            this.host = host;
        }

        @Override
        public boolean match(String hostname) {
            return this.host.equals(hostname);
        }
    }

    public static interface HostMatcher {
        public boolean match(String var1) throws IOException;
    }
}

