/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Arrays;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.digest.Digest;
import net.schmizz.sshj.transport.kex.KeyExchange;

public abstract class KeyExchangeBase
implements KeyExchange {
    protected Transport trans;
    protected final Digest digest;
    protected byte[] H;
    protected PublicKey hostKey;
    private String V_S;
    private String V_C;
    private byte[] I_S;
    private byte[] I_C;

    public KeyExchangeBase(Digest digest) {
        this.digest = digest;
    }

    @Override
    public void init(Transport trans, String V_S, String V_C, byte[] I_S, byte[] I_C) throws GeneralSecurityException, TransportException {
        this.trans = trans;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = Arrays.copyOf(I_S, I_S.length);
        this.I_C = Arrays.copyOf(I_C, I_C.length);
    }

    protected Buffer.PlainBuffer initializedBuffer() {
        return (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.V_C)).putString(this.V_S)).putString(this.I_C)).putString(this.I_S);
    }

    @Override
    public byte[] getH() {
        return Arrays.copyOf(this.H, this.H.length);
    }

    @Override
    public Digest getHash() {
        return this.digest;
    }

    @Override
    public PublicKey getHostKey() {
        return this.hostKey;
    }
}

