/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.auth.eap.gtc.client;

import com.axlradius.radclient4.ClientReceiveException;
import com.axlradius.radclient4.ClientSendException;
import com.axlradius.radclient4.PacketType;
import com.axlradius.radclient4.RADIUSClient;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.auth.eap.ClientLayer;
import com.axlradius.radclient4.auth.eap.EAPException;
import com.axlradius.radclient4.auth.eap.EAPPacket;
import com.axlradius.radclient4.auth.eap.EAPParameters;
import com.axlradius.radclient4.auth.eap.EAPType;
import com.axlradius.radclient4.auth.eap.PublicState;
import com.axlradius.radclient4.auth.eap.gtc.client.GTCClientParameters;
import com.axlradius.radclient4.auth.eap.tls.ttls.client.c;
import com.axlradius.radclient4.radutil.Util;
import java.net.SocketException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class EAPGTCClient
implements c {
    private RADIUSClient a;
    private ClientLayer a;
    private boolean debug;
    private GTCClientParameters a;
    private int S;
    private EAPPacket a;
    private EAPPacket b;
    private byte[] w;
    private PublicState a;

    public EAPGTCClient(RADIUSClient rADIUSClient) {
        this.a = rADIUSClient;
        this.debug = rADIUSClient.getDebugIndicator();
    }

    public EAPGTCClient() {
    }

    @Override
    public final void a(EAPPacket eAPPacket) {
        this.b = eAPPacket;
    }

    public static EAPType getEAPType() {
        return EAPType.TYPE.GTC.getType();
    }

    @Override
    public final void a(EAPParameters eAPParameters) {
        this.a = (GTCClientParameters)eAPParameters;
        this.a = PublicState.CONTINUE;
        this.a = this.a.getClientLayer();
    }

    @Override
    public final PublicState authenticate() throws ClientSendException, SocketException, ClientReceiveException, EAPException {
        if (this.a == null) {
            return this.a("GTCClientParameters is null");
        }
        switch (this.a) {
            case FAIL: 
            case ERROR: {
                return this.a;
            }
            case COMPLETE: 
            case CONTINUE: {
                break;
            }
            case NONE: {
                break;
            }
            default: {
                return this.a("Unexpected PublicState - " + (Object)((Object)this.a) + " " + this.a.getMessage());
            }
        }
        this.S = 1;
        if (this.b == null) {
            return this.a("Missing initial EAP packet from Client Layer");
        }
        this.a = this.b;
        if (this.a.getDebugIndicator()) {
            this.a.logToDebug("EAP-GTC: State: " + this.getStateName());
        }
        if (this.a == PublicState.COMPLETE) {
            return this.a("Internal error - Received packet after authentication completed.");
        }
        Object object = this.a;
        Object object2 = this;
        if (((EAPGTCClient)object2).debug) {
            ((EAPGTCClient)object2).logToDebug("EAP-GTC: State for receive is " + ((EAPGTCClient)object2).getStateName());
        }
        if (((EAPPacket)object).isFailure()) {
            if (((EAPGTCClient)object2).debug) {
                ((EAPGTCClient)object2).logToDebug("EAP-GTC: Received EAP-Failure");
            }
            ((EAPGTCClient)object2).S = 0;
            ((EAPGTCClient)object2).b("Received EAP-Failure");
        } else {
            switch (((EAPGTCClient)object2).S) {
                case 3: {
                    if (((EAPPacket)object).isSuccess()) {
                        if (((EAPGTCClient)object2).debug) {
                            ((EAPGTCClient)object2).logToDebug("EAP-GTC: Received EAP-Success");
                        }
                        ((EAPGTCClient)object2).a();
                    } else {
                        ((EAPGTCClient)object2).b("Received " + ((EAPPacket)object).getCodeName());
                    }
                    ((EAPGTCClient)object2).S = 0;
                    break;
                }
                case 1: {
                    ((EAPGTCClient)object2).w = ((EAPPacket)object).getData();
                    if (((EAPGTCClient)object2).w == null || ((EAPGTCClient)object2).w.length == 0) {
                        ((EAPGTCClient)object2).S = 0;
                        ((EAPGTCClient)object2).a("Server data is empty");
                    }
                    if (((EAPGTCClient)object2).debug) {
                        ((EAPGTCClient)object2).logToDebug("EAP-GTC: Recieved server message " + ((EAPGTCClient)object2).w.length + "\n" + Util.dump(((EAPGTCClient)object2).w));
                    }
                    ((EAPGTCClient)object2).S = 2;
                    break;
                }
                default: {
                    ((EAPGTCClient)object2).S = 0;
                    ((EAPGTCClient)object2).a("Internal Error - unknown state: " + ((EAPGTCClient)object2).getStateName());
                }
            }
        }
        switch (this.a) {
            case FAIL: 
            case ERROR: {
                return this.a;
            }
        }
        object = this.a;
        object2 = this;
        if (((EAPGTCClient)object2).debug) {
            ((EAPGTCClient)object2).logToDebug("EAP-GTC: State for send is " + ((EAPGTCClient)object2).getStateName());
        }
        switch (((EAPGTCClient)object2).S) {
            case 0: {
                ((EAPGTCClient)object2).a("Internal error - Illegal state: " + ((EAPGTCClient)object2).getStateName());
                ((EAPGTCClient)object2).S = 0;
                break;
            }
            case 2: {
                object = ((EAPPacket)object).getData();
                if (((EAPGTCClient)object2).debug) {
                    ((EAPGTCClient)object2).logToDebug("EAP-GTC: processSend: STATE_SERVER_RESPONSE got server message: " + ((Object)object).length + " [" + Util.toUTF8((byte[])object) + "] " + Util.toUTF8((byte[])object));
                }
                ((EAPGTCClient)object2).a = new EAPPacket(2, 0, 6, ((EAPGTCClient)object2).a.getPassword());
                ((EAPGTCClient)object2).S = 3;
                if (!((EAPGTCClient)object2).debug) break;
                ((EAPGTCClient)object2).logToDebug("EAP-GTC: Sending password: " + Util.toUTF8(((EAPGTCClient)object2).a.getPassword()) + " - " + Util.toHexString(((EAPGTCClient)object2).a.getPassword()));
                break;
            }
            default: {
                ((EAPGTCClient)object2).a("Internal error - Unknown state found while receiving data: " + ((EAPGTCClient)object2).getStateName());
                ((EAPGTCClient)object2).S = 0;
            }
        }
        switch (this.a) {
            case FAIL: 
            case ERROR: {
                return this.a;
            }
        }
        object2 = this.a.toAttributeList();
        try {
            object2 = this.a.transaction(this.a, (AttributeList)object2);
        }
        catch (Exception exception) {
            return this.a("Exception: " + exception);
        }
        int n2 = this.a.getPacketType();
        new PacketType();
        this.logToDebug(PacketType.getName(n2) + " received");
        switch (n2) {
            case 2: {
                this.a = new EAPPacket((AttributeList)object2);
                ClientLayer.verifyPacket(this.a, this.a);
                if (this.a.isSuccess()) {
                    this.a = this.a();
                    break;
                }
                this.a = this.b("Unexpected EAP type returned: " + this.a.getTypeName());
                break;
            }
            case 11: {
                this.a = this.a("Error: Unexpected packet type " + PacketType.getName(n2));
            }
        }
        return this.a;
    }

    private String getStateName() {
        String string;
        switch (this.S) {
            case 1: {
                string = "STATE_CLIENT_CHALLENGE";
                break;
            }
            case 2: {
                string = "STATE_SERVER_RESPONSE";
                break;
            }
            case 3: {
                string = "STATE_CHECK_SUCCESS";
                break;
            }
            case 0: {
                string = "STATE_NONE";
                break;
            }
            default: {
                string = "Unknown (" + this.S + ")";
            }
        }
        return string;
    }

    private PublicState b(String string) {
        this.a = PublicState.FAIL;
        this.a.setMessage(string);
        return this.a;
    }

    private PublicState a(String string) {
        this.a = PublicState.ERROR;
        this.a.setMessage(string);
        return this.a;
    }

    private PublicState a() {
        this.a = PublicState.COMPLETE;
        return this.a;
    }

    private void logToDebug(String string) {
        if (this.debug) {
            this.a.logToDebug("EAP-GTC: " + string);
        }
    }
}

