/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.radutil;

import com.axlradius.radclient4.radutil.Util;
import com.axlradius.radclient4.radutil.g;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public class SecretAmplification {
    public static final int ITERATIONS = 0x100000;
    public static final int DKLEN = 12;
    private Mac b;
    private int aC;
    private g a;
    private byte[] ad;
    private int aD;
    private int aE;
    private static final char[] e = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1'};

    public SecretAmplification(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, InvalidKeyException {
        this.a = new g(byArray);
        this.ad = byArray2 == null ? new byte[]{} : byArray2;
        this.aD = 0x100000;
        this.aE = 12;
        this.init();
    }

    public SecretAmplification(byte[] byArray, byte[] byArray2, int n2, int n3) throws IllegalArgumentException, NoSuchAlgorithmException, InvalidKeyException {
        this.a = new g(byArray);
        this.ad = byArray2 == null ? new byte[]{} : byArray2;
        this.aD = n2;
        this.init();
        if (n3 > 1 - 1 * this.aC) {
            throw new IllegalArgumentException("Derived key too long - result would be " + n3 + " bytes.");
        }
    }

    private void init() throws NoSuchAlgorithmException, InvalidKeyException {
        this.b = Mac.getInstance("HMACSHA1");
        this.b.init(this.a);
        this.aC = this.b.getMacLength();
    }

    public byte[] amplify() {
        int n2;
        Object object;
        int n3 = this.aC;
        int n4 = (this.aE + n3 - 1) / n3 * n3;
        if (n4 == 0) {
            n4 = n3;
        }
        byte[] byArray = new byte[n4];
        int n5 = byArray.length / this.aC;
        int n6 = 0;
        for (int i2 = 1; i2 <= n5; ++i2) {
            n4 = i2;
            int n7 = this.aD;
            byte[] byArray2 = this.ad;
            object = this;
            ((SecretAmplification)object).b.reset();
            ((SecretAmplification)object).b.update(byArray2);
            byte[] byArray3 = new byte[4];
            byArray2 = byArray3;
            byArray3[0] = n4 >> 24;
            byArray2[1] = (byte)(n4 >>> 16);
            byArray2[2] = (byte)(n4 >>> 8);
            byArray2[3] = (byte)n4;
            byte[] byArray4 = ((SecretAmplification)object).b.doFinal(byArray2);
            byte[] byArray5 = new byte[((SecretAmplification)object).aC];
            System.arraycopy(byArray4, 0, byArray5, 0, ((SecretAmplification)object).aC);
            for (n2 = n4; n2 < n7; ++n2) {
                byArray5 = ((SecretAmplification)object).b.doFinal(byArray5);
                for (int i3 = 0; i3 < ((SecretAmplification)object).aC; ++i3) {
                    int n8 = i3;
                    byArray4[n8] = (byte)(byArray4[n8] ^ byArray5[i3]);
                }
            }
            System.arraycopy(byArray4, 0, byArray, n6, this.aC);
            n6 += this.aC;
        }
        byte[] byArray6 = new byte[this.aE];
        System.arraycopy(byArray, 0, byArray6, 0, this.aE);
        object = byArray6;
        char[] cArray = new char[4 * (((Object)object).length + (3 - ((Object)object).length % 3) % 3) / 3];
        n4 = 0;
        n3 = 0;
        while (n3 < ((Object)object).length) {
            Object object2;
            int n9 = ((Object)object).length - n3;
            if (n9 > 2) {
                object2 = ((object[n3++] & 0xFF) << 8 | object[n3++] & 0xFF) << 8 | object[n3++] & 0xFF;
                if (n3 == 3) {
                    n2 = ((object2 & 0xFC0000) >> 18) % 52;
                    cArray[n4++] = e[n2];
                    n2 = ((object2 & 0x3F000) >> 12) % 10 + 52;
                    cArray[n4++] = e[n2];
                } else {
                    cArray[n4++] = e[(object2 & 0xFC0000) >> 18];
                    cArray[n4++] = e[(object2 & 0x3F000) >> 12];
                }
                cArray[n4++] = e[(object2 & 0xFC0) >> 6];
                cArray[n4++] = e[object2 & 0x3F];
                continue;
            }
            if (n9 == 2) {
                object2 = (object[n3++] << 8) + object[n3++] << 8;
                cArray[n4++] = e[(object2 & 0xFC0000) >> 18];
                cArray[n4++] = e[(object2 & 0x3F000) >> 12];
                cArray[n4++] = e[(object2 & 0xFC0) >> 6];
                cArray[n4++] = 61;
                continue;
            }
            object2 = object[n3++] << 16;
            cArray[n4++] = e[(object2 & 0xFC0000) >> 18];
            cArray[n4++] = e[(object2 & 0x3F000) >> 12];
            cArray[n4++] = 61;
            cArray[n4++] = 61;
        }
        byte[] byArray7 = new byte[cArray.length];
        for (n3 = 0; n3 < cArray.length; ++n3) {
            byArray7[n3] = (byte)cArray[n3];
        }
        return byArray7;
    }

    public static void main(String[] object) {
        try {
            if (((String[])object).length == 0) {
                System.err.println("Usage: SecretAmplification <secret> [salt - optional]\n\tThe secret and salt are ASCII strings of any length");
                System.exit(1);
            }
            String string = ((String[])object).length == 2 ? object[1] : new String();
            object = object[0];
            object = new SecretAmplification(object.getBytes(), string.getBytes()).amplify();
            System.out.println(Util.toUTF8((byte[])object) + " length " + ((String[])object).length);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

