/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.BitGene;
import io.jenetics.BitGeneISeq;
import io.jenetics.BitGeneMSeq;
import io.jenetics.Chromosome;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.internal.util.bit;
import io.jenetics.internal.util.require;
import io.jenetics.util.ISeq;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class BitChromosome
extends Number
implements Chromosome<BitGene>,
Comparable<BitChromosome>,
Serializable {
    private static final long serialVersionUID = 2L;
    protected double _p;
    protected int _length;
    protected byte[] _genes;
    private transient BitGeneISeq _seq;

    private BitChromosome(byte[] bits, int length, double p) {
        this._genes = bits;
        this._length = length;
        this._p = p;
        this._seq = BitGeneMSeq.of(this._genes, length).toISeq();
    }

    public BitChromosome(byte[] bits, int start, int end) {
        this(bit.copy(bits, start, end), Math.min(bits.length << 3, end) - start, 0.0);
        this._p = (double)bit.count(this._genes) / (double)this._length;
    }

    public BitChromosome(byte[] bits) {
        this(bits, 0, bits.length << 3);
    }

    private BitChromosome(byte[] bits, int length) {
        this(bits, length == -1 ? bits.length * 8 : length, (double)bit.count(bits) / (double)(length == -1 ? bits.length * 8 : length));
    }

    private static byte[] toByteArray(CharSequence value) {
        byte[] bytes = bit.newArray(value.length());
        int i = value.length();
        while (--i >= 0) {
            char c = value.charAt(i);
            if (c == '1') {
                bit.set(bytes, i);
                continue;
            }
            if (c == '0') continue;
            throw new IllegalArgumentException(String.format("Illegal character '%s' at position %d", Character.valueOf(c), i));
        }
        return bytes;
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this._length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + this._length);
        }
    }

    public double getOneProbability() {
        return this._p;
    }

    @Override
    public BitGene getGene() {
        assert (this._genes != null);
        assert (this._genes.length > 0);
        return BitGene.of(bit.get(this._genes, 0));
    }

    @Deprecated
    public boolean get() {
        return bit.get(this._genes, 0);
    }

    public boolean booleanValue() {
        return bit.get(this._genes, 0);
    }

    @Override
    public BitGene getGene(int index) {
        this.rangeCheck(index);
        assert (this._genes != null);
        return BitGene.of(bit.get(this._genes, index));
    }

    @Deprecated
    public boolean get(int index) {
        this.rangeCheck(index);
        return bit.get(this._genes, index);
    }

    public boolean booleanValue(int index) {
        this.rangeCheck(index);
        return bit.get(this._genes, index);
    }

    @Override
    public ISeq<BitGene> toSeq() {
        return this._seq;
    }

    @Override
    public int length() {
        return this._length;
    }

    public int bitCount() {
        return bit.count(this._genes);
    }

    @Override
    public Iterator<BitGene> iterator() {
        return this._seq.iterator();
    }

    public ListIterator<BitGene> listIterator() {
        return this._seq.listIterator();
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.toBigInteger().longValue();
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public BigInteger toBigInteger() {
        return new BigInteger(this._genes);
    }

    public int toByteArray(byte[] bytes) {
        if (bytes.length < this._genes.length) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this._genes, 0, bytes, 0, this._genes.length);
        return this._genes.length;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this._genes.length];
        this.toByteArray(data);
        return data;
    }

    public BitSet toBitSet() {
        BitSet set = new BitSet(this.length());
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            set.set(i, this.getGene(i).getBit());
        }
        return set;
    }

    public IntStream ones() {
        return IntStream.range(0, this.length()).filter(index -> bit.get(this._genes, index));
    }

    public IntStream zeros() {
        return IntStream.range(0, this.length()).filter(index -> !bit.get(this._genes, index));
    }

    public BitChromosome newInstance(ISeq<BitGene> genes) {
        Objects.requireNonNull(genes, "Genes");
        if (genes.isEmpty()) {
            throw new IllegalArgumentException("The genes sequence must contain at least one gene.");
        }
        BitChromosome chromosome = new BitChromosome(bit.newArray(genes.length()), genes.length());
        int ones = 0;
        if (genes instanceof BitGeneISeq) {
            BitGeneISeq iseq = (BitGeneISeq)genes;
            iseq.copyTo(chromosome._genes);
            ones = bit.count(chromosome._genes);
        } else {
            int i = genes.length();
            while (--i >= 0) {
                if (!((BitGene)genes.get(i)).booleanValue()) continue;
                bit.set(chromosome._genes, i);
                ++ones;
            }
        }
        chromosome._p = (double)ones / (double)genes.length();
        return chromosome;
    }

    @Override
    public BitChromosome newInstance() {
        return BitChromosome.of(this._length, this._p);
    }

    public String toCanonicalString() {
        return this.toSeq().stream().map(g -> g.booleanValue() ? "1" : "0").collect(Collectors.joining());
    }

    @Override
    public int compareTo(BitChromosome that) {
        return this.toBigInteger().compareTo(that.toBigInteger());
    }

    public BitChromosome invert() {
        byte[] data = (byte[])this._genes.clone();
        bit.invert(data);
        return new BitChromosome(data, this._length, 1.0 - this._p);
    }

    public static BitChromosome of(int length, double p) {
        return new BitChromosome(bit.newArray(length, p), length, p);
    }

    public static BitChromosome of(int length) {
        return new BitChromosome(bit.newArray(length, 0.5), length, 0.5);
    }

    public static BitChromosome of(BitSet bits, int length) {
        byte[] bytes = bit.newArray(length);
        for (int i = 0; i < length; ++i) {
            if (!bits.get(i)) continue;
            bit.set(bytes, i);
        }
        double p = (double)bit.count(bytes) / (double)length;
        return new BitChromosome(bytes, length, p);
    }

    public static BitChromosome of(BitSet bits, int length, double p) {
        byte[] bytes = bit.newArray(length);
        for (int i = 0; i < length; ++i) {
            if (!bits.get(i)) continue;
            bit.set(bytes, i);
        }
        return new BitChromosome(bytes, length, require.probability(p));
    }

    public static BitChromosome of(BitSet bits) {
        return new BitChromosome(bits.toByteArray(), -1);
    }

    public static BitChromosome of(BigInteger value) {
        return new BitChromosome(value.toByteArray(), -1);
    }

    public static BitChromosome of(BigInteger value, double p) {
        byte[] bits = value.toByteArray();
        return new BitChromosome(bits, bits.length * 8, require.probability(p));
    }

    public static BitChromosome of(CharSequence value) {
        return new BitChromosome(BitChromosome.toByteArray(Objects.requireNonNull(value, "Input")), -1);
    }

    public static BitChromosome of(CharSequence value, double p) {
        byte[] bits = BitChromosome.toByteArray(Objects.requireNonNull(value, "Input"));
        return new BitChromosome(bits, bits.length * 8, require.probability(p));
    }

    public static BitChromosome of(CharSequence value, int length, double p) {
        byte[] bits = BitChromosome.toByteArray(Objects.requireNonNull(value, "Input"));
        return new BitChromosome(bits, length, require.probability(p));
    }

    public int hashCode() {
        return Hash.of(this.getClass()).and(this._genes).value();
    }

    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(c -> {
            boolean equals = this.length() == c.length();
            int n = this.length();
            for (int i = 0; equals && i < n; ++i) {
                equals = this.getGene(i) == c.getGene(i);
            }
            return equals;
        });
    }

    public String toString() {
        return bit.toByteString(this._genes);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._length);
        out.writeDouble(this._p);
        out.writeInt(this._genes.length);
        out.write(this._genes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._length = in.readInt();
        this._p = in.readDouble();
        int bytes = in.readInt();
        this._genes = new byte[bytes];
        in.readFully(this._genes);
        this._seq = BitGeneISeq.of(this._genes, this._length);
    }
}

