/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.collection;

import io.jenetics.internal.collection.Array;
import io.jenetics.internal.collection.ArrayISeq;
import io.jenetics.internal.collection.ArrayMIterator;
import io.jenetics.internal.collection.ArraySeq;
import io.jenetics.internal.collection.Empty;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;

public class ArrayMSeq<T>
extends ArraySeq<T>
implements MSeq<T> {
    private static final long serialVersionUID = 1L;

    public ArrayMSeq(Array<T> array2) {
        super(array2);
    }

    @Override
    public MSeq<T> copy() {
        return this.isEmpty() ? this : new ArrayMSeq(this.array.copy());
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ArrayMIterator(this.array);
    }

    @Override
    public void set(int index, T value) {
        this.array.set(index, value);
    }

    @Override
    public MSeq<T> setAll(Iterator<? extends T> it) {
        for (int i = 0; i < this.array.length() && it.hasNext(); ++i) {
            this.array.set(i, it.next());
        }
        return this;
    }

    @Override
    public MSeq<T> setAll(Iterable<? extends T> values) {
        return this.setAll(values.iterator());
    }

    @Override
    public MSeq<T> setAll(T[] values) {
        int n = Math.min(this.array.length(), values.length);
        for (int i = 0; i < n; ++i) {
            this.array.set(i, values[i]);
        }
        return this;
    }

    @Override
    public MSeq<T> fill(Supplier<? extends T> supplier) {
        for (int i = 0; i < this.array.length(); ++i) {
            this.array.set(i, supplier.get());
        }
        return this;
    }

    @Override
    public ArrayMSeq<T> sort(int start, int end, Comparator<? super T> comparator) {
        this.array.sort(start, end, comparator);
        return this;
    }

    @Override
    public MSeq<T> shuffle(Random random2) {
        for (int j = this.length() - 1; j > 0; --j) {
            this.swap(j, random2.nextInt(j + 1));
        }
        return this;
    }

    @Override
    public void swap(int i, int j) {
        Object temp = this.array.get(i);
        this.array.set(i, this.array.get(j));
        this.array.set(j, temp);
    }

    @Override
    public void swap(int start, int end, MSeq<T> other, int otherStart) {
        this.checkIndex(start, end, otherStart, other.length());
        if (start < end) {
            int i = end - start;
            while (--i >= 0) {
                Object temp = this.array.get(i + start);
                this.array.set(i + start, other.get(otherStart + i));
                other.set(otherStart + i, temp);
            }
        }
    }

    protected void checkIndex(int start, int end, int otherStart, int otherLength) {
        this.array.checkIndex(start, end);
        if (otherStart < 0 || otherStart + (end - start) > otherLength) {
            throw new ArrayIndexOutOfBoundsException(String.format("Invalid index range: [%d, %d)", otherStart, otherStart + end - start));
        }
    }

    @Override
    public MSeq<T> subSeq(int start, int end) {
        if (start > end) {
            throw new ArrayIndexOutOfBoundsException(String.format("start[%d] > end[%d]", start, end));
        }
        if (start < 0 || end > this.length()) {
            throw new ArrayIndexOutOfBoundsException(String.format("Indexes (%d, %d) range: [%d..%d)", start, end, 0, this.length()));
        }
        return start == end ? Empty.mseq() : new ArrayMSeq(this.array.slice(start, end));
    }

    @Override
    public MSeq<T> subSeq(int start) {
        if (start < 0 || start > this.length()) {
            throw new ArrayIndexOutOfBoundsException(String.format("Index %d range: [%d..%d)", start, 0, this.length()));
        }
        return start == this.length() ? Empty.mseq() : new ArrayMSeq(this.array.slice(start, this.length()));
    }

    @Override
    public <B> MSeq<B> map(Function<? super T, ? extends B> mapper) {
        Array<B> mapped = Array.ofLength(this.length());
        for (int i = 0; i < this.length(); ++i) {
            mapped.set(i, mapper.apply(this.array.get(i)));
        }
        return new ArrayMSeq(mapped);
    }

    @Override
    public MSeq<T> append(Iterable<? extends T> values) {
        return new ArrayMSeq<T>(this.__append(values));
    }

    @Override
    public MSeq<T> prepend(Iterable<? extends T> values) {
        return new ArrayMSeq<T>(this.__prepend(values));
    }

    @Override
    public ISeq<T> toISeq() {
        return this.isEmpty() ? Empty.iseq() : new ArrayISeq(this.array.seal());
    }
}

