/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.collection;

import io.jenetics.internal.collection.Array;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;

public final class ObjectStore<T>
implements Array.Store<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object[] _array;

    private ObjectStore(Object[] array2) {
        this._array = Objects.requireNonNull(array2);
    }

    @Override
    public void set(int index, T value) {
        this._array[index] = value;
    }

    @Override
    public T get(int index) {
        return (T)this._array[index];
    }

    @Override
    public void sort(int from, int until, Comparator<? super T> comparator) {
        Arrays.sort(this._array, from, until, comparator);
    }

    @Override
    public ObjectStore<T> copy(int from, int until) {
        return new ObjectStore<T>(Arrays.copyOfRange(this._array, from, until));
    }

    @Override
    public ObjectStore<T> newInstance(int length) {
        return ObjectStore.ofLength(length);
    }

    @Override
    public int length() {
        return this._array.length;
    }

    public static <T> ObjectStore<T> of(Object[] array2) {
        return new ObjectStore<T>(array2);
    }

    public static <T> ObjectStore<T> ofLength(int length) {
        return new ObjectStore<T>(new Object[length]);
    }
}

