/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import io.jenetics.internal.collection.Array;
import io.jenetics.internal.collection.ArrayMSeq;
import io.jenetics.internal.collection.Empty;
import io.jenetics.internal.collection.ObjectStore;
import io.jenetics.util.Copyable;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeqList;
import io.jenetics.util.RandomRegistry;
import io.jenetics.util.Seq;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public interface MSeq<T>
extends Seq<T>,
Copyable<MSeq<T>> {
    public static final MSeq<?> EMPTY = Empty.EmptyMSeq.INSTANCE;

    @Override
    default public List<T> asList() {
        return new MSeqList(this);
    }

    public void set(int var1, T var2);

    default public MSeq<T> setAll(Iterator<? extends T> it) {
        int n = this.length();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            this.set(i, it.next());
        }
        return this;
    }

    default public MSeq<T> setAll(Iterable<? extends T> values) {
        this.setAll(values.iterator());
        return this;
    }

    default public MSeq<T> setAll(T[] values) {
        int n = Math.min(this.length(), values.length);
        for (int i = 0; i < n; ++i) {
            this.set(i, values[i]);
        }
        return this;
    }

    default public MSeq<T> fill(Supplier<? extends T> supplier) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            this.set(i, supplier.get());
        }
        return this;
    }

    default public void swap(int i, int j) {
        Object temp = this.get(i);
        this.set(i, this.get(j));
        this.set(j, temp);
    }

    default public void swap(int start, int end, MSeq<T> other, int otherStart) {
        if (otherStart < 0 || otherStart + (end - start) > this.length()) {
            throw new ArrayIndexOutOfBoundsException(String.format("Invalid index range: [%d, %d)", otherStart, otherStart + (end - start)));
        }
        if (start < end) {
            int i = end - start;
            while (--i >= 0) {
                Object temp = this.get(start + i);
                this.set(start + i, other.get(otherStart + i));
                other.set(otherStart + i, temp);
            }
        }
    }

    default public void swap(int index, MSeq<T> other) {
        Object temp = this.get(index);
        this.set(index, other.get(index));
        other.set(index, temp);
    }

    default public MSeq<T> shuffle() {
        return this.shuffle(RandomRegistry.getRandom());
    }

    default public MSeq<T> shuffle(Random random2) {
        for (int j = this.length() - 1; j > 0; --j) {
            this.swap(j, random2.nextInt(j + 1));
        }
        return this;
    }

    public MSeq<T> sort(int var1, int var2, Comparator<? super T> var3);

    default public MSeq<T> sort(int start, int end) {
        return this.sort(start, end, null);
    }

    default public MSeq<T> sort(int start, Comparator<? super T> comparator) {
        return this.sort(start, this.length(), comparator);
    }

    default public MSeq<T> sort(int start) {
        return this.sort(start, this.length(), null);
    }

    default public MSeq<T> sort(Comparator<? super T> comparator) {
        return this.sort(0, this.length(), comparator);
    }

    default public MSeq<T> sort() {
        return this.sort(0, this.length(), null);
    }

    default public MSeq<T> reverse() {
        int i = 0;
        for (int j = this.length() - 1; i < j; ++i, --j) {
            this.swap(i, j);
        }
        return this;
    }

    @Override
    default public ListIterator<T> listIterator() {
        return this.asList().listIterator();
    }

    @Override
    public MSeq<T> subSeq(int var1, int var2);

    @Override
    public MSeq<T> subSeq(int var1);

    @Override
    public <B> MSeq<B> map(Function<? super T, ? extends B> var1);

    @Override
    default public MSeq<T> append(T ... values) {
        return this.append(MSeq.of(values));
    }

    @Override
    public MSeq<T> append(Iterable<? extends T> var1);

    @Override
    default public MSeq<T> prepend(T ... values) {
        return this.prepend(MSeq.of(values));
    }

    @Override
    public MSeq<T> prepend(Iterable<? extends T> var1);

    public ISeq<T> toISeq();

    public static <T> MSeq<T> empty() {
        return Empty.mseq();
    }

    public static <T> Collector<T, ?, MSeq<T>> toMSeq() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, MSeq::of, new Collector.Characteristics[0]);
    }

    public static <T> MSeq<T> ofLength(int length) {
        return length == 0 ? MSeq.empty() : new ArrayMSeq(Array.of(ObjectStore.ofLength(length)));
    }

    @SafeVarargs
    public static <T> MSeq<T> of(T ... values) {
        return values.length == 0 ? MSeq.empty() : new ArrayMSeq(Array.of(ObjectStore.of((Object[])values.clone())));
    }

    public static <T> MSeq<T> of(Iterable<? extends T> values) {
        ArrayMSeq mseq;
        if (values instanceof ISeq) {
            ISeq seq = (ISeq)values;
            mseq = seq.isEmpty() ? MSeq.empty() : seq.copy();
        } else if (values instanceof MSeq) {
            MSeq seq = (MSeq)values;
            mseq = seq.isEmpty() ? MSeq.empty() : MSeq.of(seq);
        } else if (values instanceof Collection) {
            Collection collection = (Collection)values;
            mseq = collection.isEmpty() ? MSeq.empty() : MSeq.ofLength(collection.size()).setAll(values);
        } else {
            Stream.Builder builder = Stream.builder();
            values.forEach(builder::add);
            Object[] objects = builder.build().toArray();
            mseq = objects.length == 0 ? MSeq.empty() : new ArrayMSeq(Array.of(ObjectStore.of(objects)));
        }
        return mseq;
    }

    public static <T> MSeq<T> of(Supplier<? extends T> supplier, int length) {
        Objects.requireNonNull(supplier);
        return length == 0 ? MSeq.empty() : MSeq.ofLength(length).fill(supplier);
    }

    public static <T> MSeq<T> of(Seq<? extends T> values) {
        Object result = values instanceof MSeq ? (MSeq)((MSeq)values).copy() : (values instanceof ISeq ? ((ISeq)values).copy() : MSeq.ofLength(values.length()).setAll(values));
        return result;
    }
}

