/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.service.invoker.AbstractNamedValueArgumentResolver;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.ReactiveHttpRequestValues;
import org.springframework.web.service.invoker.ReactorHttpExchangeAdapter;

public class RequestPartArgumentResolver
extends AbstractNamedValueArgumentResolver {
    private static final boolean REACTOR_PRESENT = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", (ClassLoader)RequestPartArgumentResolver.class.getClassLoader());
    @Nullable
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    public RequestPartArgumentResolver(HttpExchangeAdapter exchangeAdapter) {
        if (REACTOR_PRESENT) {
            ReactiveAdapterRegistry reactiveAdapterRegistry;
            if (exchangeAdapter instanceof ReactorHttpExchangeAdapter) {
                ReactorHttpExchangeAdapter reactorAdapter = (ReactorHttpExchangeAdapter)exchangeAdapter;
                reactiveAdapterRegistry = reactorAdapter.getReactiveAdapterRegistry();
            } else {
                reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
            }
            this.reactiveAdapterRegistry = reactiveAdapterRegistry;
        } else {
            this.reactiveAdapterRegistry = null;
        }
    }

    @Override
    @Nullable
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        String label;
        RequestPart annot = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        boolean isMultiPartFile = parameter.nestedIfOptional().getNestedParameterType().equals(MultipartFile.class);
        String string = label = isMultiPartFile ? "MultipartFile" : "request part";
        if (annot != null) {
            return new AbstractNamedValueArgumentResolver.NamedValueInfo(annot.name(), annot.required(), null, label, true);
        }
        if (isMultiPartFile) {
            return new AbstractNamedValueArgumentResolver.NamedValueInfo("", true, null, label, true);
        }
        return null;
    }

    @Override
    protected void addRequestValue(String name, Object value, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        Class type;
        ReactiveAdapter adapter;
        if (this.reactiveAdapterRegistry != null && (adapter = this.reactiveAdapterRegistry.getAdapter(type = parameter.getParameterType())) != null) {
            MethodParameter nestedParameter = parameter.nested();
            String message = "Async type for @RequestPart should produce value(s)";
            Assert.isTrue((!adapter.isNoValue() ? 1 : 0) != 0, (String)message);
            Assert.isTrue((nestedParameter.getNestedParameterType() != Void.class ? 1 : 0) != 0, (String)message);
            if (!(requestValues instanceof ReactiveHttpRequestValues.Builder)) {
                throw new IllegalStateException("RequestPart with a reactive type is only supported with reactive client");
            }
            ReactiveHttpRequestValues.Builder reactiveValues = (ReactiveHttpRequestValues.Builder)requestValues;
            reactiveValues.addRequestPartPublisher(name, adapter.toPublisher(value), RequestPartArgumentResolver.asParameterizedTypeRef(nestedParameter));
            return;
        }
        if (value instanceof MultipartFile) {
            MultipartFile multipartFile = (MultipartFile)value;
            value = RequestPartArgumentResolver.toHttpEntity(name, multipartFile);
        }
        requestValues.addRequestPart(name, value);
    }

    private static ParameterizedTypeReference<Object> asParameterizedTypeRef(MethodParameter nestedParam) {
        return ParameterizedTypeReference.forType((Type)nestedParam.getNestedGenericParameterType());
    }

    private static Object toHttpEntity(String name, MultipartFile multipartFile) {
        HttpHeaders headers = new HttpHeaders();
        if (multipartFile.getOriginalFilename() != null) {
            headers.setContentDispositionFormData(name, multipartFile.getOriginalFilename());
        }
        if (multipartFile.getContentType() != null) {
            headers.add("Content-Type", multipartFile.getContentType());
        }
        return new HttpEntity<Resource>(multipartFile.getResource(), headers);
    }
}

