/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data.mdnsproxy;

import com.ubnt.data.X;
import com.ubnt.data.mdnsproxy.ApScopeMode;
import com.ubnt.data.mdnsproxy.MdnsCustomService;
import com.ubnt.data.mdnsproxy.MdnsPredefinedService;
import com.ubnt.data.mdnsproxy.ServicesMode;
import java.util.List;
import lombok.Generated;

public record MdnsProxyCustom(List<String> networkConfIds, ApScopeMode apScopeMode, List<String> apMacs, List<String> apGroupIds, boolean isolationEnabled, ServicesMode servicesMode, List<MdnsPredefinedService> mdnsPredefinedServices, List<MdnsCustomService> mdnsCustomServices) {
    public static MdnsProxyCustom of(X x2) {
        return MdnsProxyCustom.builder().networkConfIds(x2.getStringList("networkconf_ids")).apScopeMode(ApScopeMode.fromString(x2.getString("ap_scope_mode")).orElse(ApScopeMode.ALL)).apMacs(x2.getStringList("ap_macs")).apGroupIds(x2.getStringList("ap_group_ids")).isolationEnabled(x2.is("isolation_enabled", false)).servicesMode(ServicesMode.fromStringValue(x2.getString("services_mode")).orElse(ServicesMode.ALL)).mdnsPredefinedServices(x2.getList("predefined_services").stream().map(MdnsPredefinedService::of).toList()).mdnsCustomServices(x2.getList("custom_services").stream().map(MdnsCustomService::of).toList()).build();
    }

    public X toLegacy() {
        return new X().append("networkconf_ids", this.networkConfIds).append("ap_scope_mode", (Object)this.apScopeMode).append("ap_macs", this.apMacs).append("ap_group_ids", this.apGroupIds).append("isolation_enabled", this.isolationEnabled).append("services_mode", (Object)this.servicesMode).append("predefined_services", this.mdnsPredefinedServices.stream().map(MdnsPredefinedService::toLegacy).toList()).append("custom_services", this.mdnsCustomServices.stream().map(MdnsCustomService::toLegacy).toList());
    }

    @Generated
    public static MdnsProxyCustomBuilder builder() {
        return new MdnsProxyCustomBuilder();
    }

    public static class MdnsProxyCustomBuilder {
        @Generated
        private List<String> networkConfIds = List.of();
        @Generated
        private ApScopeMode apScopeMode = ApScopeMode.ALL;
        @Generated
        private List<String> apMacs = List.of();
        @Generated
        private List<String> apGroupIds = List.of();
        @Generated
        private boolean isolationEnabled;
        @Generated
        private ServicesMode servicesMode = ServicesMode.ALL;
        @Generated
        private List<MdnsPredefinedService> mdnsPredefinedServices = List.of();
        @Generated
        private List<MdnsCustomService> mdnsCustomServices = List.of();

        @Generated
        public MdnsProxyCustomBuilder networkConfIds(List<String> list) {
            this.networkConfIds = list;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder apScopeMode(ApScopeMode apScopeMode) {
            this.apScopeMode = apScopeMode;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder apMacs(List<String> list) {
            this.apMacs = list;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder apGroupIds(List<String> list) {
            this.apGroupIds = list;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder isolationEnabled(boolean bl) {
            this.isolationEnabled = bl;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder servicesMode(ServicesMode servicesMode) {
            this.servicesMode = servicesMode;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder mdnsPredefinedServices(List<MdnsPredefinedService> list) {
            this.mdnsPredefinedServices = list;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder mdnsCustomServices(List<MdnsCustomService> list) {
            this.mdnsCustomServices = list;
            return this;
        }

        @Generated
        public MdnsProxyCustom build() {
            return new MdnsProxyCustom(this.networkConfIds, this.apScopeMode, this.apMacs, this.apGroupIds, this.isolationEnabled, this.servicesMode, this.mdnsPredefinedServices, this.mdnsCustomServices);
        }

        @Generated
        public String toString() {
            return "MdnsProxyCustom.MdnsProxyCustomBuilder(networkConfIds=" + this.networkConfIds + ", apScopeMode=" + this.apScopeMode + ", apMacs=" + this.apMacs + ", apGroupIds=" + this.apGroupIds + ", isolationEnabled=" + this.isolationEnabled + ", servicesMode=" + this.servicesMode + ", mdnsPredefinedServices=" + this.mdnsPredefinedServices + ", mdnsCustomServices=" + this.mdnsCustomServices + ")";
        }
    }
}

