/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.alert;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.alert.AlertClientsDtoParameters;
import com.ubnt.model.api.alert.AlertDtoParameters;
import com.ubnt.model.api.alert.ClientDto;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Generated(from="AlertClientsDtoParameters", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableAlertClientsDtoParameters
implements AlertClientsDtoParameters {
    private final String id;
    private final String name;
    @Nullable
    private final Boolean notActionable;
    @Nullable
    private final Boolean enclosedWithBrackets;
    private final List<ClientDto> clients;

    private ImmutableAlertClientsDtoParameters(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.notActionable = builder.notActionable;
        this.enclosedWithBrackets = builder.enclosedWithBrackets;
        this.clients = ImmutableAlertClientsDtoParameters.class(true, builder.clients);
    }

    @Override
    @Schema(name="ID of the referenced entity")
    public String id() {
        return this.id;
    }

    @Override
    @Schema(name="Name of the referenced entity")
    public String name() {
        return this.name;
    }

    @Override
    @Schema(name="System log parameter not actionable", example="true")
    public Optional<Boolean> notActionable() {
        return Optional.ofNullable(this.notActionable);
    }

    @Override
    @Schema(name="enclose the parameter with brackets")
    public Optional<Boolean> enclosedWithBrackets() {
        return Optional.ofNullable(this.enclosedWithBrackets);
    }

    @Override
    @Schema(name="Clients")
    public List<ClientDto> clients() {
        return this.clients;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableAlertClientsDtoParameters && this.\u00d800000(0, (ImmutableAlertClientsDtoParameters)object);
    }

    private boolean \u00d800000(int n2, ImmutableAlertClientsDtoParameters immutableAlertClientsDtoParameters) {
        return Objects.equals(this.id, immutableAlertClientsDtoParameters.id) && Objects.equals(this.name, immutableAlertClientsDtoParameters.name) && Objects.equals(this.notActionable, immutableAlertClientsDtoParameters.notActionable) && Objects.equals(this.enclosedWithBrackets, immutableAlertClientsDtoParameters.enclosedWithBrackets) && this.clients.equals(immutableAlertClientsDtoParameters.clients);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + Objects.hashCode(this.id);
        n2 += (n2 << 5) + Objects.hashCode(this.name);
        n2 += (n2 << 5) + Objects.hashCode(this.notActionable);
        n2 += (n2 << 5) + Objects.hashCode(this.enclosedWithBrackets);
        n2 += (n2 << 5) + this.clients.hashCode();
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AlertClientsDtoParameters{");
        if (this.id != null) {
            stringBuilder.append("id=").append(this.id);
        }
        if (this.name != null) {
            if (stringBuilder.length() > 26) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("name=").append(this.name);
        }
        if (this.notActionable != null) {
            if (stringBuilder.length() > 26) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("notActionable=").append(this.notActionable);
        }
        if (this.enclosedWithBrackets != null) {
            if (stringBuilder.length() > 26) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("enclosedWithBrackets=").append(this.enclosedWithBrackets);
        }
        if (stringBuilder.length() > 26) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("clients=").append(this.clients);
        return stringBuilder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> \u00d600000(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl2 && t2 == null) continue;
            if (bl) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> class(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AlertClientsDtoParameters", generator="Immutables")
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private Boolean notActionable;
        @Nullable
        private Boolean enclosedWithBrackets;
        private List<ClientDto> clients = new ArrayList<ClientDto>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AlertDtoParameters alertDtoParameters) {
            Objects.requireNonNull(alertDtoParameters, "instance");
            this.o00000((short)0, alertDtoParameters);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AlertClientsDtoParameters alertClientsDtoParameters) {
            Objects.requireNonNull(alertClientsDtoParameters, "instance");
            this.o00000((short)0, alertClientsDtoParameters);
            return this;
        }

        private void o00000(short s2, Object object) {
            Optional<Boolean> optional;
            AlertDtoParameters alertDtoParameters;
            long l2 = 0L;
            if (object instanceof AlertDtoParameters) {
                alertDtoParameters = (AlertDtoParameters)object;
                if ((l2 & 4L) == 0L) {
                    optional = alertDtoParameters.name();
                    if (optional != null) {
                        this.name((String)((Object)optional));
                    }
                    l2 |= 4L;
                }
                if ((l2 & 8L) == 0L) {
                    optional = alertDtoParameters.id();
                    if (optional != null) {
                        this.id((String)((Object)optional));
                    }
                    l2 |= 8L;
                }
                if ((l2 & 1L) == 0L) {
                    optional = alertDtoParameters.enclosedWithBrackets();
                    if (optional.isPresent()) {
                        this.enclosedWithBrackets(optional);
                    }
                    l2 |= 1L;
                }
                if ((l2 & 2L) == 0L) {
                    optional = alertDtoParameters.notActionable();
                    if (optional.isPresent()) {
                        this.notActionable(optional);
                    }
                    l2 |= 2L;
                }
            }
            if (object instanceof AlertClientsDtoParameters) {
                alertDtoParameters = (AlertClientsDtoParameters)object;
                if ((l2 & 4L) == 0L) {
                    optional = alertDtoParameters.name();
                    if (optional != null) {
                        this.name((String)((Object)optional));
                    }
                    l2 |= 4L;
                }
                this.addAllClients(alertDtoParameters.clients());
                if ((l2 & 8L) == 0L) {
                    optional = alertDtoParameters.id();
                    if (optional != null) {
                        this.id((String)((Object)optional));
                    }
                    l2 |= 8L;
                }
                if ((l2 & 1L) == 0L) {
                    optional = alertDtoParameters.enclosedWithBrackets();
                    if (optional.isPresent()) {
                        this.enclosedWithBrackets(optional);
                    }
                    l2 |= 1L;
                }
                if ((l2 & 2L) == 0L) {
                    optional = alertDtoParameters.notActionable();
                    if (optional.isPresent()) {
                        this.notActionable(optional);
                    }
                    l2 |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(String string) {
            this.id = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String string) {
            this.name = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder notActionable(@Nullable Boolean bl) {
            this.notActionable = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder notActionable(Optional<Boolean> optional) {
            this.notActionable = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enclosedWithBrackets(@Nullable Boolean bl) {
            this.enclosedWithBrackets = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enclosedWithBrackets(Optional<Boolean> optional) {
            this.enclosedWithBrackets = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addClients(@Nullable ClientDto clientDto) {
            this.clients.add(clientDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addClients(ClientDto ... clientDtoArray) {
            for (ClientDto clientDto : clientDtoArray) {
                this.clients.add(clientDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clients(Iterable<? extends ClientDto> iterable) {
            this.clients.clear();
            return this.addAllClients(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllClients(Iterable<? extends ClientDto> iterable) {
            for (ClientDto clientDto : iterable) {
                this.clients.add(clientDto);
            }
            return this;
        }

        public ImmutableAlertClientsDtoParameters build() {
            return new ImmutableAlertClientsDtoParameters(this);
        }
    }
}

