/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.vpn;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.model.api.network.configuration.VpnNetworkProtocol;
import com.ubnt.model.api.vpn.ImmutableOpenVpnConfigurationRequestDto;
import com.ubnt.net.v2.validation.constraints.Ip;
import com.ubnt.return.F;
import com.ubnt.service.vpn.J;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableOpenVpnConfigurationRequestDto.class)
@Value.Immutable
@F
public interface OpenVpnConfigurationRequestDto {
    @JsonProperty(value="remote_ip")
    @NotEmpty
    @Ip
    public String remoteIp();

    @JsonProperty(value="remote_port")
    @Min(value=1L)
    @Max(value=65535L)
    public @Min(value=1L) @Max(value=65535L) int remotePort();

    @JsonProperty(value="protocol")
    @NotNull
    public VpnNetworkProtocol protocol();

    @JsonProperty(value="dns")
    public List<@Ip String> dns();

    @JsonProperty(value="ca_certificate")
    @NotEmpty
    public String caCertificate();

    @JsonProperty(value="tls_auth")
    @NotEmpty
    public String tlsAuth();

    @JsonProperty(value="certificate")
    @NotEmpty
    public String clientCertificate();

    @JsonProperty(value="key")
    @NotEmpty
    public String clientKey();

    default public J toOpenVpnConfigurationProfile() {
        return J.\u00d200000().for(this.remoteIp()).String(this.remotePort()).oO0000(this.protocol()).\u00d200000(this.dns()).\u00f500000(this.caCertificate()).\u00d600000(this.tlsAuth()).o00000(this.clientCertificate()).\u00f800000(this.clientKey()).null();
    }
}

