/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wlan;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.ace.Q;
import com.ubnt.data.Hotspot2Conf;
import com.ubnt.model.api.wlan.Hotspot2VenueNameDto;
import com.ubnt.model.api.wlan.ImmutableHotspot2ConfigDto;
import com.ubnt.model.api.wlan.hotspot2.CellularNetworkDto;
import com.ubnt.model.api.wlan.hotspot2.ConnectionCapabilityDto;
import com.ubnt.model.api.wlan.hotspot2.FriendlyNameDto;
import com.ubnt.model.api.wlan.hotspot2.Hotspot2NetworkType;
import com.ubnt.model.api.wlan.hotspot2.Hotspot2VenueGroup;
import com.ubnt.model.api.wlan.hotspot2.IPv4AvailabilityAddressType;
import com.ubnt.model.api.wlan.hotspot2.IPv6AvailabilityAddressType;
import com.ubnt.model.api.wlan.hotspot2.MetricsInfo;
import com.ubnt.model.api.wlan.hotspot2.NaiRealmDto;
import com.ubnt.model.api.wlan.hotspot2.RoamingConsortiumDto;
import com.ubnt.return.F;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="Wlan Hotspot2 Config", description="Hotspot2 configuration details for WLAN network")
@Value.Immutable
@F
public interface Hotspot2ConfigDto {
    @JsonProperty(value="venue_name")
    @Schema(name="Venue Name List")
    public List<Hotspot2VenueNameDto> venueNames();

    @JsonProperty(value="venue_group")
    @Schema(name="Venue Group")
    public Hotspot2VenueGroup venueGroup();

    @JsonProperty(value="venue_type")
    @Schema(name="Venue Type based on venue group")
    public int venueType();

    @JsonProperty(value="network_type")
    @Schema(name="Network Type")
    public Hotspot2NetworkType networkType();

    @JsonProperty(value="ipaddr_type_avail_v4")
    @Schema(name="IPv4 Address Type Availability")
    public IPv4AvailabilityAddressType ipV4AddressTypeAvailability();

    @JsonProperty(value="ipaddr_type_avail_v6")
    @Schema(name="IPv6 Address Type Availability")
    public IPv6AvailabilityAddressType ipV6AddressTypeAvailability();

    @JsonProperty(value="nai_realm_list")
    @Schema(name="NAI Realm List")
    public List<NaiRealmDto> naiRealmList();

    @JsonProperty(value="roaming_consortium_list")
    @Schema(name="Roaming Consortium List")
    public List<RoamingConsortiumDto> roamingConsortiumList();

    @JsonProperty(value="domain_name_list")
    @Schema(name="Domain Name List")
    public List<String> domainNameList();

    @JsonProperty(value="cellular_network_list")
    @Schema(name="Cellular Network List")
    public List<CellularNetworkDto> cellularNetworkList();

    @JsonProperty(value="friendly_name")
    @Schema(name="Friendly Name")
    public List<FriendlyNameDto> friendlyName();

    @JsonProperty(value="metrics_status")
    @Schema(name="Metrics Status")
    public boolean metricsStatus();

    @JsonProperty(value="metrics_info_link_status")
    @Schema(name="Metrics Info")
    public Optional<MetricsInfo> metricsInfo();

    @JsonProperty(value="metrics_info_symmetric")
    @Schema(name="Metrics Symmetric")
    public boolean metricsSymmetric();

    @JsonProperty(value="metrics_info_at_capacity")
    @Schema(name="Metrics Info At Capacity")
    public boolean metricsInfoAtCapacity();

    @JsonProperty(value="metrics_downlink_speed_set")
    @Schema(name="Metrics Downlink Speed Enabled")
    public boolean metricsDownlinkSpeedEnabled();

    @JsonProperty(value="metrics_downlink_speed")
    @Schema(name="Metrics Downlink Speed")
    public int metricsDownlinkSpeed();

    @JsonProperty(value="metrics_uplink_speed_set")
    @Schema(name="Metrics Uplink Speed Enabled")
    public boolean metricsUplinkSpeedEnabled();

    @JsonProperty(value="metrics_uplink_speed")
    @Schema(name="Metrics Uplink Speed")
    public int metricsUplinkSpeed();

    @JsonProperty(value="metrics_downlink_load_set")
    @Schema(name="Metrics Downlink Load Enabled")
    public boolean metricsDownlinkLoadEnabled();

    @JsonProperty(value="metrics_downlink_load")
    @Schema(name="Metrics Downlink Load")
    public int metricsDownlinkLoad();

    @JsonProperty(value="metrics_uplink_load_set")
    @Schema(name="Metrics Uplink Load Enabled")
    public boolean metricsUplinkLoadEnabled();

    @JsonProperty(value="metrics_uplink_load")
    @Schema(name="Metrics Uplink Load")
    public int metricsUplinkLoad();

    @JsonProperty(value="metrics_measurement_set")
    @Schema(name="Metrics Measurement Enabled")
    public boolean metricsMeasurementEnabled();

    @JsonProperty(value="metrics_measurement")
    @Schema(name="Metrics Measurement")
    public int metricsMeasurement();

    @JsonProperty(value="capab")
    @Schema(name="Connection Capability")
    public List<ConnectionCapabilityDto> connectionCapability();

    public static Hotspot2ConfigDto of(Hotspot2Conf hotspot2Conf) {
        return ImmutableHotspot2ConfigDto.builder().venueNames(hotspot2Conf.getList("venue_name").stream().map(Hotspot2VenueNameDto::of).toList()).venueGroup(Q.\u00d4O0000(Hotspot2VenueGroup.class, hotspot2Conf.getString("venue_group")).orElse(Hotspot2VenueGroup.UNSPECIFIED)).venueType(hotspot2Conf.getInt("venue_type")).networkType(Q.\u00d4O0000(Hotspot2NetworkType.class, hotspot2Conf.getString("network_type")).orElse(Hotspot2NetworkType.PRIVATE_NETWORK)).ipV4AddressTypeAvailability(Q.\u00d4O0000(IPv4AvailabilityAddressType.class, hotspot2Conf.getString("ipaddr_type_avail_v4")).orElse(IPv4AvailabilityAddressType.UNAVAILABLE)).ipV6AddressTypeAvailability(Q.\u00d4O0000(IPv6AvailabilityAddressType.class, hotspot2Conf.getString("ipaddr_type_avail_v6")).orElse(IPv6AvailabilityAddressType.UNAVAILABLE)).naiRealmList(hotspot2Conf.getList("nai_realm_list").stream().map(NaiRealmDto::of).toList()).roamingConsortiumList(hotspot2Conf.getList("roaming_consortium_list").stream().map(RoamingConsortiumDto::of).toList()).domainNameList(hotspot2Conf.getStringList("domain_name_list")).cellularNetworkList(hotspot2Conf.getList("cellular_network_list").stream().map(CellularNetworkDto::of).toList()).friendlyName(hotspot2Conf.getList("friendly_name").stream().map(FriendlyNameDto::of).toList()).metricsStatus(hotspot2Conf.getBoolean("metrics_status")).metricsInfo(Q.\u00d4O0000(MetricsInfo.class, hotspot2Conf.getString("metrics_info_link_status"))).metricsSymmetric(hotspot2Conf.getBoolean("metrics_info_symmetric")).metricsDownlinkSpeedEnabled(hotspot2Conf.getBoolean("metrics_downlink_speed_set")).metricsDownlinkSpeed(hotspot2Conf.getInt("metrics_downlink_speed")).metricsUplinkSpeedEnabled(hotspot2Conf.getBoolean("metrics_uplink_speed_set")).metricsUplinkSpeed(hotspot2Conf.getInt("metrics_uplink_speed")).metricsDownlinkLoadEnabled(hotspot2Conf.getBoolean("metrics_downlink_load_set")).metricsDownlinkLoad(hotspot2Conf.getInt("metrics_downlink_load")).metricsUplinkLoadEnabled(hotspot2Conf.getBoolean("metrics_uplink_load_set")).metricsUplinkLoad(hotspot2Conf.getInt("metrics_uplink_load")).metricsMeasurementEnabled(hotspot2Conf.getBoolean("metrics_measurement_set")).metricsMeasurement(hotspot2Conf.getInt("metrics_measurement")).connectionCapability(hotspot2Conf.getList("capab").stream().map(ConnectionCapabilityDto::of).toList()).build();
    }

    public static Hotspot2Conf toLegacy(Hotspot2ConfigDto hotspot2ConfigDto) {
        Hotspot2Conf hotspot2Conf = new Hotspot2Conf().append("venue_name", hotspot2ConfigDto.venueNames().stream().map(Hotspot2VenueNameDto::toLegacy).toList()).append("venue_group", hotspot2ConfigDto.venueGroup().getValue()).append("venue_type", hotspot2ConfigDto.venueType()).append("network_type", hotspot2ConfigDto.networkType().toString()).append("ipaddr_type_avail_v4", hotspot2ConfigDto.ipV4AddressTypeAvailability().toString()).append("ipaddr_type_avail_v6", hotspot2ConfigDto.ipV6AddressTypeAvailability().toString()).append("nai_realm_list", hotspot2ConfigDto.naiRealmList().stream().map(NaiRealmDto::toLegacy).toList()).append("roaming_consortium_list", hotspot2ConfigDto.roamingConsortiumList().stream().map(RoamingConsortiumDto::toLegacy).toList()).append("domain_name_list", hotspot2ConfigDto.domainNameList()).append("cellular_network_list", hotspot2ConfigDto.cellularNetworkList().stream().map(CellularNetworkDto::toLegacy).toList()).append("friendly_name", hotspot2ConfigDto.friendlyName().stream().map(FriendlyNameDto::toLegacy).toList()).append("metrics_status", hotspot2ConfigDto.metricsStatus()).append("metrics_info_symmetric", hotspot2ConfigDto.metricsSymmetric()).append("metrics_downlink_speed_set", hotspot2ConfigDto.metricsDownlinkSpeedEnabled()).append("metrics_downlink_speed", hotspot2ConfigDto.metricsDownlinkSpeed()).append("metrics_uplink_speed_set", hotspot2ConfigDto.metricsUplinkSpeedEnabled()).append("metrics_uplink_speed", hotspot2ConfigDto.metricsUplinkSpeed()).append("metrics_downlink_load_set", hotspot2ConfigDto.metricsDownlinkLoadEnabled()).append("metrics_downlink_load", hotspot2ConfigDto.metricsDownlinkLoad()).append("metrics_uplink_load_set", hotspot2ConfigDto.metricsUplinkLoadEnabled()).append("metrics_uplink_load", hotspot2ConfigDto.metricsUplinkLoad()).append("metrics_measurement_set", hotspot2ConfigDto.metricsMeasurementEnabled()).append("metrics_measurement", hotspot2ConfigDto.metricsMeasurement()).append("capab", hotspot2ConfigDto.connectionCapability().stream().map(ConnectionCapabilityDto::toLegacy).toList());
        hotspot2Conf.putIfPresent("metrics_info_link_status", hotspot2ConfigDto.metricsInfo().map(Enum::toString));
        return hotspot2Conf;
    }
}

