/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.trafficrule;

import com.ubnt.data.Site;
import com.ubnt.model.api.trafficrule.TrafficRuleDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.trafficrule.J;
import com.ubnt.service.trafficrule.TrafficRuleDocument;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Traffic Rules")
public class TrafficRuleController {
    private final J super;

    public TrafficRuleController(J j2) {
        this.super = j2;
    }

    @GetMapping(value={"/api/site/{siteName}/trafficrules"})
    @Operation(summary="List Traffic Rules")
    public List<TrafficRuleDto> listTrafficRules(@PathVariable(value="siteName") Site site) {
        return this.super.\u00d600000(site.getId()).stream().map(TrafficRuleDto::fromDocument).collect(Collectors.toList());
    }

    @GetMapping(value={"/api/site/{siteName}/trafficrule/{ruleId}"})
    @Operation(summary="Get Traffic Rule")
    public TrafficRuleDto getTrafficRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string) {
        return TrafficRuleDto.fromDocument(this.super.null(site.getId(), string));
    }

    @PostMapping(value={"/api/site/{siteName}/trafficrules"}, consumes={"application/json"})
    @Operation(summary="Create a new Traffic Rule")
    @ResponseStatus(value=HttpStatus.CREATED)
    public TrafficRuleDto createTrafficRule(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull TrafficRuleDto trafficRuleDto) {
        TrafficRuleDocument trafficRuleDocument = this.super.String(trafficRuleDto.toDocument(site.getId()));
        return TrafficRuleDto.fromDocument(trafficRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/trafficrules/{ruleId}"}, consumes={"application/json"})
    @Operation(summary="Update Traffic Rule")
    public TrafficRuleDto updateTrafficRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string, @RequestBody @Valid @NotNull TrafficRuleDto trafficRuleDto) {
        TrafficRuleDto trafficRuleDto2 = TrafficRuleDto.withId(trafficRuleDto, string);
        TrafficRuleDocument trafficRuleDocument = this.super.\u00d200000(trafficRuleDto2.toDocument(site.getId()));
        return TrafficRuleDto.fromDocument(trafficRuleDocument);
    }

    @DeleteMapping(value={"/api/site/{siteName}/trafficrules/{ruleId}"})
    @Operation(summary="Delete Traffic Rule")
    public void deleteTrafficRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string) {
        this.super.\u00d800000(site.getId(), string);
    }
}

