/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.sdnotify;

import com.ubnt.sdnotify.B;
import com.ubnt.service.system.mA;
import com.ubnt.service.system.nullString;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class SDNotify
implements B {
    private static final Logger \u00d200000 = mA.if;
    private static boolean o00000 = false;

    private static native int sdnotifyjni(int var0, String var1);

    @Override
    public void status(String string) {
        SDNotify.notify(0, "STATUS=" + string);
    }

    @Override
    public void ready() {
        SDNotify.notify(0, "READY=1");
    }

    @Override
    public void watchdog() {
        SDNotify.notify(0, "WATCHDOG=1");
    }

    @Override
    public void stopping() {
        SDNotify.notify(0, "STOPPING=1");
    }

    @Override
    public void extendStartTimeout(int n2) {
        SDNotify.notify(0, "EXTEND_TIMEOUT_USEC=" + TimeUnit.SECONDS.toMicros(n2));
    }

    public static void notify(int n2, String string) {
        if (!o00000) {
            SDNotify.loadLibrary();
        }
        if (o00000) {
            SDNotify.executeCommand(n2, string);
        }
    }

    private static void loadLibrary() {
        try {
            File file = nullString.\u00d8o\u00f4000("ubnt_sdnotify_jni");
            if (file != null) {
                System.load(file.getAbsolutePath());
                o00000 = true;
                \u00d200000.info("ubnt_sdnotify_jni is loaded from: " + file.getAbsolutePath());
            } else {
                \u00d200000.error("failed to locate ubnt_sdnotify_jni");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            \u00d200000.error("failed to load ubnt_sdnotify_jni", (Throwable)unsatisfiedLinkError);
        }
    }

    private static void executeCommand(int n2, String string) {
        try {
            int n3 = SDNotify.sdnotifyjni(n2, string);
            if (n3 < 0) {
                \u00d200000.error("systemd-notify command[{} {}] exited with error code[{}]", new Object[]{n2, string, n3});
            } else {
                \u00d200000.debug("systemd-notify command[{} {}] executed", (Object)n2, (Object)string);
            }
        }
        catch (Exception exception) {
            \u00d200000.error("failed to run systemd-notify command[{} {}]:", new Object[]{n2, string, exception});
        }
    }
}

