/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.grammar.serialization;

import java.io.IOException;
import java.io.Reader;
import org.vinniks.parsla.exception.GrammarException;
import org.vinniks.parsla.exception.ParsingException;
import org.vinniks.parsla.grammar.Grammar;
import org.vinniks.parsla.grammar.serialization.ExtendedGrammarBuilder;
import org.vinniks.parsla.grammar.serialization.GrammarReader;
import org.vinniks.parsla.grammar.serialization.GrammarTokenizer;
import org.vinniks.parsla.grammar.serialization.StandardIdentifierCharacterValidator;
import org.vinniks.parsla.parser.text.TextParser;
import org.vinniks.parsla.syntaxtree.SyntaxTreeNode;
import org.vinniks.parsla.tokenizer.text.TextPosition;
import org.vinniks.parsla.tokenizer.text.buffered.CharacterBufferProvider;

public class ExtendedGrammarReader
implements GrammarReader {
    private static final int DEFAULT_CHARACTER_BUFFER_SIZE = 8192;
    private static final ExtendedGrammarReader INSTANCE = new ExtendedGrammarReader(() -> new char[8192]);
    private final TextParser parser;

    public static ExtendedGrammarReader instance() {
        return INSTANCE;
    }

    public static Grammar grammarGrammar() {
        return Grammar.readStandard("options: ^;\noptions: >option options;\n\noption: output >rule-name {colon} >sequences {semicolon};\n\noutput: ^;\n>output: {gt};\n\nrule-name: {identifier, >};\n\nsequences: sequence sequences-tail;\n\nsequence: {>caret};\n>sequence: item items-tail;\n\n>item: >body quantifier;\n\nbody: {left-bracket} >sub-option {right-bracket};\nbody: >token;\nbody: >rule;\n\nsub-option: >sequences;\n\nsequences-tail: ^;\nsequences-tail: {pipe} sequence sequences-tail;\n\ntoken: {left-curly-bracket} token-type token-value {right-curly-bracket} >elevations;\n\ntoken-type: output-type type;\n\noutput-type: ^;\n>output-type: {gt};\n\ntype: ^;\n>type: {identifier, >};\n\ntoken-value: ^;\ntoken-value: {comma} output-value value;\n\noutput-value: ^;\n>output-value: {gt};\n\nvalue: ^;\n>value: {string, >};\n\nelevations: ^;\nelevations: >elevation elevations;\n\nelevation: {exclamation};\n\nrule: output >name;\n\nname: {identifier, >};\n\nquantifier: ^;\n>quantifier: >zero-or-one;\n>quantifier: >zero-or-many;\n>quantifier: >one-or-many;\n\nzero-or-one: {question};\nzero-or-many: {asterisk};\none-or-many: {plus};\n\nitems-tail: ^;\nitems-tail: item items-tail;\n");
    }

    public ExtendedGrammarReader(CharacterBufferProvider characterBufferProvider) {
        this.parser = new TextParser(ExtendedGrammarReader.grammarGrammar(), new GrammarTokenizer(true, new StandardIdentifierCharacterValidator(), characterBufferProvider));
    }

    @Override
    public Grammar read(Reader reader) throws IOException {
        try {
            SyntaxTreeNode<TextPosition> syntaxTree = this.parser.parse(reader, "options");
            return ExtendedGrammarBuilder.build(syntaxTree);
        }
        catch (ParsingException e) {
            throw new GrammarException("failed to read extended grammar", e);
        }
    }
}

