/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.grammar.serialization;

import lombok.Generated;
import lombok.NonNull;
import org.vinniks.parsla.exception.ParsingException;
import org.vinniks.parsla.grammar.serialization.IdentifierCharacterValidator;
import org.vinniks.parsla.tokenizer.Token;
import org.vinniks.parsla.tokenizer.text.AbstractTextTokenIterator;
import org.vinniks.parsla.tokenizer.text.CharacterIterator;
import org.vinniks.parsla.tokenizer.text.TextPosition;
import org.vinniks.parsla.tokenizer.text.buffered.AbstractBufferedTextTokenizer;
import org.vinniks.parsla.tokenizer.text.buffered.CharacterBufferProvider;

public final class GrammarTokenizer
extends AbstractBufferedTextTokenizer {
    private static final String IDENTIFIER = "identifier";
    private static final String COLON = "colon";
    private static final String GT = "gt";
    private static final String LEFT_CURLY_BRACKET = "left-curly-bracket";
    private static final String RIGHT_CURLY_BRACKET = "right-curly-bracket";
    private static final String EXCLAMATION = "exclamation";
    private static final String COMMA = "comma";
    private static final String STRING = "string";
    private static final String SEMICOLON = "semicolon";
    private static final String CARET = "caret";
    private static final Token COLON_TOKEN = new Token("colon");
    private static final Token GT_TOKEN = new Token("gt");
    private static final Token LEFT_CURLY_BRACKET_TOKEN = new Token("left-curly-bracket");
    private static final Token RIGHT_CURLY_BRACKET_TOKEN = new Token("right-curly-bracket");
    private static final Token EXCLAMATION_TOKEN = new Token("exclamation");
    private static final Token COMMA_TOKEN = new Token("comma");
    private static final Token SEMICOLON_TOKEN = new Token("semicolon");
    private static final Token CARET_TOKEN = new Token("caret");
    private static final String LEFT_BRACKET = "left-bracket";
    private static final String RIGHT_BRACKET = "right-bracket";
    private static final String PLUS = "plus";
    private static final String ASTERISK = "asterisk";
    private static final String QUESTION = "question";
    private static final String PIPE = "pipe";
    private static final Token LEFT_BRACKET_TOKEN = new Token("left-bracket");
    private static final Token RIGHT_BRACKET_TOKEN = new Token("right-bracket");
    private static final Token PLUS_TOKEN = new Token("plus");
    private static final Token ASTERISK_TOKEN = new Token("asterisk");
    private static final Token QUESTION_MARK_TOKEN = new Token("question");
    private static final Token PIPE_TOKEN = new Token("pipe");
    private final boolean extended;
    private final IdentifierCharacterValidator identifierCharacterValidator;

    GrammarTokenizer(boolean extended, @NonNull IdentifierCharacterValidator identifierCharacterValidator, CharacterBufferProvider characterBufferProvider) {
        super(characterBufferProvider);
        if (identifierCharacterValidator == null) {
            throw new NullPointerException("identifierCharacterValidator is marked non-null but is null");
        }
        this.extended = extended;
        this.identifierCharacterValidator = identifierCharacterValidator;
    }

    @Override
    public AbstractTextTokenIterator getTokenIterator(CharacterIterator characterIterator) {
        return new GrammarTokenIterator(characterIterator, this.extended);
    }

    @Generated
    public boolean isExtended() {
        return this.extended;
    }

    private class GrammarTokenIterator
    extends AbstractTextTokenIterator {
        private final boolean extended;
        private State state;
        private final StringBuilder valueBuilder;
        private final StringBuilder characterCodeBuilder;
        private TextPosition tokenPosition;

        private GrammarTokenIterator(CharacterIterator characterIterator, boolean extended) {
            super(characterIterator);
            this.extended = extended;
            this.state = State.LF_TOKEN;
            this.valueBuilder = new StringBuilder();
            this.characterCodeBuilder = new StringBuilder();
        }

        @Override
        protected void character(char c) {
            if (this.state == State.LF_TOKEN) {
                this.lfToken(c);
            } else if (this.state == State.R_IDENTIFIER) {
                this.rIdentifier(c);
            } else if (this.state == State.R_STRING) {
                this.rString(c);
            } else if (this.state == State.LF_COMMENT_START) {
                this.lfCommentStart(c);
            } else if (this.state == State.R_SHORT_COMMENT) {
                this.rShortComment(c);
            } else if (this.state == State.R_LONG_COMMENT) {
                this.rLongComment(c);
            } else if (this.state == State.LF_LONG_COMMENT_END) {
                this.lfLongCommentEnd(c);
            } else if (this.state == State.LF_ESCAPED_CHARACTER) {
                this.lfEscapedCharacter(c);
            } else {
                this.rUnicodeCharacterCode(c);
            }
        }

        @Override
        protected void end() {
            if (this.state == State.R_IDENTIFIER) {
                this.push(new Token(GrammarTokenizer.IDENTIFIER, this.valueBuilder.toString()), this.tokenPosition);
            } else if (this.state == State.R_LONG_COMMENT || this.state == State.LF_COMMENT_START || this.state == State.LF_LONG_COMMENT_END || this.state == State.R_STRING || this.state == State.R_UNICODE_CHARACTER_CODE) {
                throw new ParsingException("unexpected end of the input", this.characterPosition());
            }
        }

        private void lfToken(char c) {
            if (this.isValidFirstIdentifierCharacter(c)) {
                this.valueBuilder.setLength(0);
                this.valueBuilder.append(c);
                this.state = State.R_IDENTIFIER;
                this.tokenPosition = this.characterPosition();
            } else if (c == ':') {
                this.push(COLON_TOKEN, this.characterPosition());
            } else if (c == '>') {
                this.push(GT_TOKEN, this.characterPosition());
            } else if (c == '{') {
                this.push(LEFT_CURLY_BRACKET_TOKEN, this.characterPosition());
            } else if (c == '}') {
                this.push(RIGHT_CURLY_BRACKET_TOKEN, this.characterPosition());
            } else if (c == '!') {
                this.push(EXCLAMATION_TOKEN, this.characterPosition());
            } else if (c == ',') {
                this.push(COMMA_TOKEN, this.characterPosition());
            } else if (c == '\"') {
                this.valueBuilder.setLength(0);
                this.state = State.R_STRING;
                this.tokenPosition = this.characterPosition();
            } else if (c == ';') {
                this.push(SEMICOLON_TOKEN, this.characterPosition());
            } else if (c == '^') {
                this.push(CARET_TOKEN, this.characterPosition());
            } else if (c == '/') {
                this.state = State.LF_COMMENT_START;
            } else if (this.extended) {
                this.lfExtendedToken(c);
            } else if (!Character.isWhitespace(c)) {
                throw this.unexpectedCharacter(c);
            }
        }

        private void lfExtendedToken(char c) {
            if (c == '(') {
                this.push(LEFT_BRACKET_TOKEN, this.characterPosition());
            } else if (c == ')') {
                this.push(RIGHT_BRACKET_TOKEN, this.characterPosition());
            } else if (c == '+') {
                this.push(PLUS_TOKEN, this.characterPosition());
            } else if (c == '*') {
                this.push(ASTERISK_TOKEN, this.characterPosition());
            } else if (c == '?') {
                this.push(QUESTION_MARK_TOKEN, this.characterPosition());
            } else if (c == '|') {
                this.push(PIPE_TOKEN, this.characterPosition());
            } else if (!Character.isWhitespace(c)) {
                throw this.unexpectedCharacter(c);
            }
        }

        private void rIdentifier(char c) {
            if (this.isValidNextIdentifierCharacter(c)) {
                this.valueBuilder.append(c);
            } else {
                String value = this.valueBuilder.toString();
                TextPosition position = this.tokenPosition;
                this.state = State.LF_TOKEN;
                this.lfToken(c);
                this.push(new Token(GrammarTokenizer.IDENTIFIER, value), position);
            }
        }

        private void rString(char c) {
            if (c == '\"') {
                this.push(new Token(GrammarTokenizer.STRING, this.valueBuilder.toString()), this.tokenPosition);
                this.state = State.LF_TOKEN;
            } else if (c == '\\') {
                this.state = State.LF_ESCAPED_CHARACTER;
            } else {
                this.valueBuilder.append(c);
            }
        }

        private void lfCommentStart(char c) {
            if (c == '/') {
                this.state = State.R_SHORT_COMMENT;
            } else if (c == '*') {
                this.state = State.R_LONG_COMMENT;
            } else {
                throw this.unexpectedCharacter(c);
            }
        }

        private void rShortComment(char c) {
            if (c == '\n') {
                this.state = State.LF_TOKEN;
            }
        }

        private void rLongComment(char c) {
            if (c == '*') {
                this.state = State.LF_LONG_COMMENT_END;
            }
        }

        private void lfLongCommentEnd(char c) {
            this.state = c == '/' ? State.LF_TOKEN : State.R_LONG_COMMENT;
        }

        private void lfEscapedCharacter(char c) {
            if (c == 't') {
                this.valueBuilder.append('\t');
                this.state = State.R_STRING;
            } else if (c == 'b') {
                this.valueBuilder.append('\b');
                this.state = State.R_STRING;
            } else if (c == 'n') {
                this.valueBuilder.append('\n');
                this.state = State.R_STRING;
            } else if (c == 'r') {
                this.valueBuilder.append('\r');
                this.state = State.R_STRING;
            } else if (c == 'f') {
                this.valueBuilder.append('\f');
                this.state = State.R_STRING;
            } else if (c == '\'') {
                this.valueBuilder.append('\'');
                this.state = State.R_STRING;
            } else if (c == '\"') {
                this.valueBuilder.append('\"');
                this.state = State.R_STRING;
            } else if (c == '\\') {
                this.valueBuilder.append('\\');
                this.state = State.R_STRING;
            } else if (c == 'u') {
                this.characterCodeBuilder.setLength(0);
                this.state = State.R_UNICODE_CHARACTER_CODE;
            } else {
                throw new ParsingException(String.format("invalid escape character %s", Character.valueOf(c)), this.characterPosition());
            }
        }

        private void rUnicodeCharacterCode(char c) {
            if (c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f' || c >= '0' && c <= '9') {
                this.characterCodeBuilder.append(c);
                if (this.characterCodeBuilder.length() == 4) {
                    this.valueBuilder.append((char)Integer.parseInt(this.characterCodeBuilder.toString(), 16));
                    this.state = State.R_STRING;
                }
            } else {
                throw new ParsingException(String.format("invalid hexadecimal digit %s in character code", Character.valueOf(c)), this.characterPosition());
            }
        }

        private boolean isValidFirstIdentifierCharacter(char c) {
            return GrammarTokenizer.this.identifierCharacterValidator.isValidFirstCharacter(c) && !this.isReservedCharacter(c);
        }

        private boolean isValidNextIdentifierCharacter(char c) {
            return GrammarTokenizer.this.identifierCharacterValidator.isValidNextCharacter(c) && !this.isReservedCharacter(c);
        }

        private boolean isReservedCharacter(char c) {
            return Character.isWhitespace(c) || c == '{' || c == '}' || c == '\"' || c == '>' || c == ',' || c == ';' || c == ':' || c == '!' || this.extended && (c == '(' || c == ')' || c == '?' || c == '+' || c == '*' || c == '|');
        }

        private ParsingException unexpectedCharacter(char c) {
            return new ParsingException(String.format("unexpected character %s", Character.valueOf(c)), this.characterPosition());
        }

        private static enum State {
            LF_TOKEN,
            R_IDENTIFIER,
            R_STRING,
            LF_COMMENT_START,
            R_SHORT_COMMENT,
            R_LONG_COMMENT,
            LF_LONG_COMMENT_END,
            LF_ESCAPED_CHARACTER,
            R_UNICODE_CHARACTER_CODE;

        }
    }
}

