/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.syntaxtree;

import java.io.StringWriter;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.vinniks.parsla.exception.SyntaxTreeException;
import org.vinniks.parsla.syntaxtree.serialization.DefaultSyntaxTreeWriter;

public class SyntaxTreeNode<P> {
    private final P position;
    private final String value;
    private final List<SyntaxTreeNode<P>> children;

    public P position() {
        return this.position;
    }

    public String value() {
        return this.value;
    }

    public List<SyntaxTreeNode<P>> children() {
        return this.children;
    }

    public String toString() {
        String string;
        try (StringWriter writer = new StringWriter();){
            new DefaultSyntaxTreeWriter(true).write(this, writer);
            string = writer.toString();
        }
        return string;
    }

    public boolean valueIs(String value) {
        return this.value.equals(value);
    }

    public Optional<SyntaxTreeNode<P>> optionalChild(String childValue) {
        List<SyntaxTreeNode> matchingChildren = this.children.stream().filter(childNode -> childNode.value.equals(childValue)).toList();
        if (matchingChildren.size() > 1) {
            throw new SyntaxTreeException(String.format("%s has multiple %s", this.value, childValue));
        }
        return matchingChildren.stream().findFirst();
    }

    public boolean hasChild(String childValue) {
        return this.optionalChild(childValue).isPresent();
    }

    public SyntaxTreeNode<P> child(String childValue) {
        return this.optionalChild(childValue).orElseThrow(() -> new SyntaxTreeException(String.format("%s does not contain %s", this.value, childValue)));
    }

    public Optional<SyntaxTreeNode<P>> optionalChild() {
        if (this.children.size() > 1) {
            throw new SyntaxTreeException(String.format("%s has multiple children", this.value));
        }
        return this.children.stream().findFirst();
    }

    public SyntaxTreeNode<P> child() {
        return this.optionalChild().orElseThrow(() -> new SyntaxTreeException(String.format("%s does not have children", this.value)));
    }

    public Optional<String> optionalChildValue() {
        return this.optionalChild().map(SyntaxTreeNode::value);
    }

    public String childValue() {
        return this.child().value;
    }

    public Optional<String> optionalSingular(String childValue) {
        return this.optionalChild(childValue).map(SyntaxTreeNode::child).map(SyntaxTreeNode::value);
    }

    public String singular(String childValue) {
        return this.child(childValue).childValue();
    }

    @Generated
    public SyntaxTreeNode(P position, String value, List<SyntaxTreeNode<P>> children) {
        this.position = position;
        this.value = value;
        this.children = children;
    }
}

