// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
	"github.com/censys/censys-sdk-go/internal/utils"
	"time"
)

type CollectionStatus string

const (
	CollectionStatusUnspecified CollectionStatus = "unspecified"
	CollectionStatusPopulating  CollectionStatus = "populating"
	CollectionStatusActive      CollectionStatus = "active"
	CollectionStatusPaused      CollectionStatus = "paused"
	CollectionStatusArchived    CollectionStatus = "archived"
)

func (e CollectionStatus) ToPointer() *CollectionStatus {
	return &e
}
func (e *CollectionStatus) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "unspecified":
		fallthrough
	case "populating":
		fallthrough
	case "active":
		fallthrough
	case "paused":
		fallthrough
	case "archived":
		*e = CollectionStatus(v)
		return nil
	default:
		return fmt.Errorf("invalid value for CollectionStatus: %v", v)
	}
}

type StatusReason string

const (
	StatusReasonUnspecified      StatusReason = "unspecified"
	StatusReasonNotEnoughCredits StatusReason = "not_enough_credits"
	StatusReasonNotEntitled      StatusReason = "not_entitled"
	StatusReasonTooManyAssets    StatusReason = "too_many_assets"
	StatusReasonManual           StatusReason = "manual"
	StatusReasonQueryChanged     StatusReason = "query_changed"
	StatusReasonInitial          StatusReason = "initial"
)

func (e StatusReason) ToPointer() *StatusReason {
	return &e
}
func (e *StatusReason) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "unspecified":
		fallthrough
	case "not_enough_credits":
		fallthrough
	case "not_entitled":
		fallthrough
	case "too_many_assets":
		fallthrough
	case "manual":
		fallthrough
	case "query_changed":
		fallthrough
	case "initial":
		*e = StatusReason(v)
		return nil
	default:
		return fmt.Errorf("invalid value for StatusReason: %v", v)
	}
}

type Collection struct {
	AddedAssets24Hours   int64            `json:"added_assets_24_hours"`
	CreateTime           time.Time        `json:"create_time"`
	Description          string           `json:"description"`
	ID                   string           `json:"id"`
	Name                 string           `json:"name"`
	Query                string           `json:"query"`
	RemovedAssets24Hours int64            `json:"removed_assets_24_hours"`
	Status               CollectionStatus `json:"status"`
	StatusReason         *StatusReason    `json:"status_reason"`
	TotalAssets          int64            `json:"total_assets"`
}

func (c Collection) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(c, "", false)
}

func (c *Collection) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &c, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *Collection) GetAddedAssets24Hours() int64 {
	if o == nil {
		return 0
	}
	return o.AddedAssets24Hours
}

func (o *Collection) GetCreateTime() time.Time {
	if o == nil {
		return time.Time{}
	}
	return o.CreateTime
}

func (o *Collection) GetDescription() string {
	if o == nil {
		return ""
	}
	return o.Description
}

func (o *Collection) GetID() string {
	if o == nil {
		return ""
	}
	return o.ID
}

func (o *Collection) GetName() string {
	if o == nil {
		return ""
	}
	return o.Name
}

func (o *Collection) GetQuery() string {
	if o == nil {
		return ""
	}
	return o.Query
}

func (o *Collection) GetRemovedAssets24Hours() int64 {
	if o == nil {
		return 0
	}
	return o.RemovedAssets24Hours
}

func (o *Collection) GetStatus() CollectionStatus {
	if o == nil {
		return CollectionStatus("")
	}
	return o.Status
}

func (o *Collection) GetStatusReason() *StatusReason {
	if o == nil {
		return nil
	}
	return o.StatusReason
}

func (o *Collection) GetTotalAssets() int64 {
	if o == nil {
		return 0
	}
	return o.TotalAssets
}
