/*


Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	corev1alpha1 "github.com/tilt-dev/tilt-apiserver/pkg/apis/core/v1alpha1"
	applyconfigurationcorev1alpha1 "github.com/tilt-dev/tilt-apiserver/pkg/generated/applyconfiguration/core/v1alpha1"
	scheme "github.com/tilt-dev/tilt-apiserver/pkg/generated/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ManifestsGetter has a method to return a ManifestInterface.
// A group's client should implement this interface.
type ManifestsGetter interface {
	Manifests() ManifestInterface
}

// ManifestInterface has methods to work with Manifest resources.
type ManifestInterface interface {
	Create(ctx context.Context, manifest *corev1alpha1.Manifest, opts v1.CreateOptions) (*corev1alpha1.Manifest, error)
	Update(ctx context.Context, manifest *corev1alpha1.Manifest, opts v1.UpdateOptions) (*corev1alpha1.Manifest, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, manifest *corev1alpha1.Manifest, opts v1.UpdateOptions) (*corev1alpha1.Manifest, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*corev1alpha1.Manifest, error)
	List(ctx context.Context, opts v1.ListOptions) (*corev1alpha1.ManifestList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *corev1alpha1.Manifest, err error)
	Apply(ctx context.Context, manifest *applyconfigurationcorev1alpha1.ManifestApplyConfiguration, opts v1.ApplyOptions) (result *corev1alpha1.Manifest, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, manifest *applyconfigurationcorev1alpha1.ManifestApplyConfiguration, opts v1.ApplyOptions) (result *corev1alpha1.Manifest, err error)
	ManifestExpansion
}

// manifests implements ManifestInterface
type manifests struct {
	*gentype.ClientWithListAndApply[*corev1alpha1.Manifest, *corev1alpha1.ManifestList, *applyconfigurationcorev1alpha1.ManifestApplyConfiguration]
}

// newManifests returns a Manifests
func newManifests(c *CoreV1alpha1Client) *manifests {
	return &manifests{
		gentype.NewClientWithListAndApply[*corev1alpha1.Manifest, *corev1alpha1.ManifestList, *applyconfigurationcorev1alpha1.ManifestApplyConfiguration](
			"manifests",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *corev1alpha1.Manifest { return &corev1alpha1.Manifest{} },
			func() *corev1alpha1.ManifestList { return &corev1alpha1.ManifestList{} },
		),
	}
}
