/*


Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	corev1alpha1 "github.com/tilt-dev/tilt-apiserver/pkg/apis/core/v1alpha1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// ManifestLister helps list Manifests.
// All objects returned here must be treated as read-only.
type ManifestLister interface {
	// List lists all Manifests in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*corev1alpha1.Manifest, err error)
	// Get retrieves the Manifest from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*corev1alpha1.Manifest, error)
	ManifestListerExpansion
}

// manifestLister implements the ManifestLister interface.
type manifestLister struct {
	listers.ResourceIndexer[*corev1alpha1.Manifest]
}

// NewManifestLister returns a new ManifestLister.
func NewManifestLister(indexer cache.Indexer) ManifestLister {
	return &manifestLister{listers.New[*corev1alpha1.Manifest](indexer, corev1alpha1.Resource("manifest"))}
}
