package purview

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/purview/mgmt/2021-07-01/purview"

// AccessKeys the Account access keys.
type AccessKeys struct {
	autorest.Response `json:"-"`
	// AtlasKafkaPrimaryEndpoint - Gets or sets the primary connection string.
	AtlasKafkaPrimaryEndpoint *string `json:"atlasKafkaPrimaryEndpoint,omitempty"`
	// AtlasKafkaSecondaryEndpoint - Gets or sets the secondary connection string.
	AtlasKafkaSecondaryEndpoint *string `json:"atlasKafkaSecondaryEndpoint,omitempty"`
}

// Account account resource
type Account struct {
	autorest.Response `json:"-"`
	// AccountProperties - Gets or sets the properties.
	*AccountProperties `json:"properties,omitempty"`
	// Sku - Gets or sets the Sku.
	Sku *AccountSku `json:"sku,omitempty"`
	// ID - READ-ONLY; Gets or sets the identifier.
	ID *string `json:"id,omitempty"`
	// Identity - Identity Info on the tracked resource
	Identity *Identity `json:"identity,omitempty"`
	// Location - Gets or sets the location.
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *TrackedResourceSystemData `json:"systemData,omitempty"`
	// Tags - Tags on the azure resource.
	Tags map[string]*string `json:"tags"`
	// Type - READ-ONLY; Gets or sets the type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	if a.Sku != nil {
		objectMap["sku"] = a.Sku
	}
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "sku":
			if v != nil {
				var sku AccountSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				a.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				a.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "systemData":
			if v != nil {
				var systemData TrackedResourceSystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				a.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AccountEndpoints the account endpoints
type AccountEndpoints struct {
	// Catalog - READ-ONLY; Gets the catalog endpoint.
	Catalog *string `json:"catalog,omitempty"`
	// Guardian - READ-ONLY; Gets the guardian endpoint.
	Guardian *string `json:"guardian,omitempty"`
	// Scan - READ-ONLY; Gets the scan endpoint.
	Scan *string `json:"scan,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountEndpoints.
func (ae AccountEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AccountList paged list of account resources
type AccountList struct {
	autorest.Response `json:"-"`
	// Count - Total item count.
	Count *int64 `json:"count,omitempty"`
	// NextLink - The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Collection of items of type results.
	Value *[]Account `json:"value,omitempty"`
}

// AccountListIterator provides access to a complete listing of Account values.
type AccountListIterator struct {
	i    int
	page AccountListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListIterator) Response() AccountList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListIterator) Value() Account {
	if !iter.page.NotDone() {
		return Account{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListIterator type.
func NewAccountListIterator(page AccountListPage) AccountListIterator {
	return AccountListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AccountList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AccountList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// accountListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AccountList) accountListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AccountListPage contains a page of Account values.
type AccountListPage struct {
	fn func(context.Context, AccountList) (AccountList, error)
	al AccountList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListPage) Response() AccountList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListPage) Values() []Account {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AccountListPage type.
func NewAccountListPage(cur AccountList, getNextPage func(context.Context, AccountList) (AccountList, error)) AccountListPage {
	return AccountListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AccountProperties the account properties
type AccountProperties struct {
	// CloudConnectors - Cloud connectors.
	// External cloud identifier used as part of scanning configuration.
	CloudConnectors *CloudConnectors `json:"cloudConnectors,omitempty"`
	// CreatedAt - READ-ONLY; Gets the time at which the entity was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// CreatedBy - READ-ONLY; Gets the creator of the entity.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByObjectID - READ-ONLY; Gets the creators of the entity's object id.
	CreatedByObjectID *string `json:"createdByObjectId,omitempty"`
	// Endpoints - READ-ONLY; The URIs that are the public endpoints of the account.
	Endpoints *AccountPropertiesEndpoints `json:"endpoints,omitempty"`
	// FriendlyName - READ-ONLY; Gets or sets the friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ManagedResourceGroupName - Gets or sets the managed resource group name
	ManagedResourceGroupName *string `json:"managedResourceGroupName,omitempty"`
	// ManagedResources - READ-ONLY; Gets the resource identifiers of the managed resources.
	ManagedResources *AccountPropertiesManagedResources `json:"managedResources,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; Gets the private endpoint connections information.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// ProvisioningState - READ-ONLY; Gets or sets the state of the provisioning. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateCreating', 'ProvisioningStateMoving', 'ProvisioningStateDeleting', 'ProvisioningStateSoftDeleting', 'ProvisioningStateSoftDeleted', 'ProvisioningStateFailed', 'ProvisioningStateSucceeded', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PublicNetworkAccess - Gets or sets the public network access. Possible values include: 'PublicNetworkAccessNotSpecified', 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountProperties.
func (ap AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.CloudConnectors != nil {
		objectMap["cloudConnectors"] = ap.CloudConnectors
	}
	if ap.ManagedResourceGroupName != nil {
		objectMap["managedResourceGroupName"] = ap.ManagedResourceGroupName
	}
	if ap.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = ap.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// AccountPropertiesEndpoints the URIs that are the public endpoints of the account.
type AccountPropertiesEndpoints struct {
	// Catalog - READ-ONLY; Gets the catalog endpoint.
	Catalog *string `json:"catalog,omitempty"`
	// Guardian - READ-ONLY; Gets the guardian endpoint.
	Guardian *string `json:"guardian,omitempty"`
	// Scan - READ-ONLY; Gets the scan endpoint.
	Scan *string `json:"scan,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountPropertiesEndpoints.
func (ap AccountPropertiesEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AccountPropertiesManagedResources gets the resource identifiers of the managed resources.
type AccountPropertiesManagedResources struct {
	// EventHubNamespace - READ-ONLY; Gets the managed event hub namespace resource identifier.
	EventHubNamespace *string `json:"eventHubNamespace,omitempty"`
	// ResourceGroup - READ-ONLY; Gets the managed resource group resource identifier. This resource group will host resource dependencies for the account.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// StorageAccount - READ-ONLY; Gets the managed storage account resource identifier.
	StorageAccount *string `json:"storageAccount,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountPropertiesManagedResources.
func (apR AccountPropertiesManagedResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AccountsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (Account, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsCreateOrUpdateFuture.Result.
func (future *AccountsCreateOrUpdateFuture) result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "purview.AccountsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("purview.AccountsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateOrUpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "purview.AccountsCreateOrUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsDeleteFuture.Result.
func (future *AccountsDeleteFuture) result(client AccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "purview.AccountsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("purview.AccountsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AccountSku the Sku
type AccountSku struct {
	// Capacity - Gets or sets the sku capacity. Possible values include: 4, 16
	Capacity *int32 `json:"capacity,omitempty"`
	// Name - Gets or sets the sku name. Possible values include: 'NameStandard'
	Name Name `json:"name,omitempty"`
}

// AccountsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (Account, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsUpdateFuture.Result.
func (future *AccountsUpdateFuture) result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "purview.AccountsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("purview.AccountsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.UpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "purview.AccountsUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountUpdateParameters the account update properties.
type AccountUpdateParameters struct {
	// Properties - The account properties.
	Properties *AccountProperties `json:"properties,omitempty"`
	// Tags - Tags on the azure resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AccountUpdateParameters.
func (aup AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aup.Properties != nil {
		objectMap["properties"] = aup.Properties
	}
	if aup.Tags != nil {
		objectMap["tags"] = aup.Tags
	}
	return json.Marshal(objectMap)
}

// CheckNameAvailabilityRequest the request payload for CheckNameAvailability API
type CheckNameAvailabilityRequest struct {
	// Name - Resource name to verify for availability
	Name *string `json:"name,omitempty"`
	// Type - Fully qualified resource type which includes provider namespace
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult the response payload for CheckNameAvailability API
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Message - Error message
	Message *string `json:"message,omitempty"`
	// NameAvailable - Indicates if name is valid and available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason the name is not available. Possible values include: 'ReasonInvalid', 'ReasonAlreadyExists'
	Reason Reason `json:"reason,omitempty"`
}

// CloudConnectors ...
type CloudConnectors struct {
	// AwsExternalID - READ-ONLY; AWS external identifier.
	// Configured in AWS to allow use of the role arn used for scanning
	AwsExternalID *string `json:"awsExternalId,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudConnectors.
func (cc CloudConnectors) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CollectionAdminUpdate collection administrator update.
type CollectionAdminUpdate struct {
	// ObjectID - Gets or sets the object identifier of the admin.
	ObjectID *string `json:"objectId,omitempty"`
}

// DefaultAccountPayload payload to get and set the default account in the given scope
type DefaultAccountPayload struct {
	autorest.Response `json:"-"`
	// AccountName - The name of the account that is set as the default.
	AccountName *string `json:"accountName,omitempty"`
	// ResourceGroupName - The resource group name of the account that is set as the default.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// Scope - The scope object ID. For example, sub ID or tenant ID.
	Scope *string `json:"scope,omitempty"`
	// ScopeTenantID - The scope tenant in which the default account is set.
	ScopeTenantID *string `json:"scopeTenantId,omitempty"`
	// ScopeType - The scope where the default account is set. Possible values include: 'ScopeTypeTenant', 'ScopeTypeSubscription'
	ScopeType ScopeType `json:"scopeType,omitempty"`
	// SubscriptionID - The subscription ID of the account that is set as the default.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
}

// DimensionProperties properties for dimension
type DimensionProperties struct {
	// DisplayName - localized display name of the dimension to customer
	DisplayName *string `json:"displayName,omitempty"`
	// Name - dimension name
	Name *string `json:"name,omitempty"`
	// ToBeExportedForCustomer - flag indicating whether this dimension should be included to the customer in Azure Monitor logs (aka Shoebox)
	ToBeExportedForCustomer *bool `json:"toBeExportedForCustomer,omitempty"`
}

// ErrorModel default error model
type ErrorModel struct {
	// Code - READ-ONLY; Gets or sets the code.
	Code *string `json:"code,omitempty"`
	// Details - READ-ONLY; Gets or sets the details.
	Details *[]ErrorModel `json:"details,omitempty"`
	// Message - READ-ONLY; Gets or sets the messages.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; Gets or sets the target.
	Target *string `json:"target,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorModel.
func (em ErrorModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponseModel default error response model
type ErrorResponseModel struct {
	// Error - READ-ONLY; Gets or sets the error.
	Error *ErrorResponseModelError `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponseModel.
func (erm ErrorResponseModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponseModelError gets or sets the error.
type ErrorResponseModelError struct {
	// Code - READ-ONLY; Gets or sets the code.
	Code *string `json:"code,omitempty"`
	// Details - READ-ONLY; Gets or sets the details.
	Details *[]ErrorModel `json:"details,omitempty"`
	// Message - READ-ONLY; Gets or sets the messages.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; Gets or sets the target.
	Target *string `json:"target,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponseModelError.
func (erm ErrorResponseModelError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Identity the Managed Identity of the resource
type Identity struct {
	// PrincipalID - READ-ONLY; Service principal object Id
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; Tenant Id
	TenantID *string `json:"tenantId,omitempty"`
	// Type - Identity Type. Possible values include: 'TypeSystemAssigned'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// ManagedResources the managed resources in customer subscription.
type ManagedResources struct {
	// EventHubNamespace - READ-ONLY; Gets the managed event hub namespace resource identifier.
	EventHubNamespace *string `json:"eventHubNamespace,omitempty"`
	// ResourceGroup - READ-ONLY; Gets the managed resource group resource identifier. This resource group will host resource dependencies for the account.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// StorageAccount - READ-ONLY; Gets the managed storage account resource identifier.
	StorageAccount *string `json:"storageAccount,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedResources.
func (mr ManagedResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Operation operation resource
type Operation struct {
	// Display - Properties on the operation
	Display *OperationDisplay `json:"display,omitempty"`
	// IsDataAction - Whether operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Name - Operation name for display purposes
	Name *string `json:"name,omitempty"`
	// Origin - origin of the operation
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - properties for the operation meta info
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "isDataAction":
			if v != nil {
				var isDataAction bool
				err = json.Unmarshal(*v, &isDataAction)
				if err != nil {
					return err
				}
				o.IsDataAction = &isDataAction
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay the response model for get operation properties
type OperationDisplay struct {
	// Description - Description of the operation for display purposes
	Description *string `json:"description,omitempty"`
	// Operation - Name of the operation for display purposes
	Operation *string `json:"operation,omitempty"`
	// Provider - Name of the provider for display purposes
	Provider *string `json:"provider,omitempty"`
	// Resource - Name of the resource type for display purposes
	Resource *string `json:"resource,omitempty"`
}

// OperationList paged list of operation resources
type OperationList struct {
	autorest.Response `json:"-"`
	// Count - Total item count.
	Count *int64 `json:"count,omitempty"`
	// NextLink - The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Collection of items of type results.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OperationMetaLogSpecification log specifications for operation api
type OperationMetaLogSpecification struct {
	// BlobDuration - blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`
	// DisplayName - localized name of the log category
	DisplayName *string `json:"displayName,omitempty"`
	// Name - name of the log category
	Name *string `json:"name,omitempty"`
}

// OperationMetaMetricSpecification metric specifications for the operation
type OperationMetaMetricSpecification struct {
	// AggregationType - aggregation type of metric
	AggregationType *string `json:"aggregationType,omitempty"`
	// Dimensions - properties for dimension
	Dimensions *[]DimensionProperties `json:"dimensions,omitempty"`
	// DisplayDescription - description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// DisplayName - localized name of the metric
	DisplayName *string `json:"displayName,omitempty"`
	// EnableRegionalMdmAccount - enable regional mdm account
	EnableRegionalMdmAccount *string `json:"enableRegionalMdmAccount,omitempty"`
	// InternalMetricName - internal metric name
	InternalMetricName *string `json:"internalMetricName,omitempty"`
	// Name - name of the metric
	Name *string `json:"name,omitempty"`
	// ResourceIDDimensionNameOverride - dimension name use to replace resource id if specified
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
	// SourceMdmNamespace - Metric namespace.
	// Only set the namespace if different from the default value,
	// leaving it empty makes it use the value from the ARM manifest.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
	// SupportedAggregationTypes - supported aggregation types
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// SupportedTimeGrainTypes - supported time grain types
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
	// Unit - units for the metric
	Unit *string `json:"unit,omitempty"`
}

// OperationMetaServiceSpecification the operation meta service specification
type OperationMetaServiceSpecification struct {
	// LogSpecifications - log specifications for the operation
	LogSpecifications *[]OperationMetaLogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - metric specifications for the operation
	MetricSpecifications *[]OperationMetaMetricSpecification `json:"metricSpecifications,omitempty"`
}

// OperationProperties properties on meta info
type OperationProperties struct {
	// ServiceSpecification - meta service specification
	ServiceSpecification *OperationMetaServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PrivateEndpoint a private endpoint class.
type PrivateEndpoint struct {
	// ID - The private endpoint identifier.
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection a private endpoint connection class.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - The connection identifier.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Gets or sets the identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets or sets the type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionList paged list of private endpoint connections
type PrivateEndpointConnectionList struct {
	autorest.Response `json:"-"`
	// Count - Total item count.
	Count *int64 `json:"count,omitempty"`
	// NextLink - The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Collection of items of type results.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionListIterator provides access to a complete listing of PrivateEndpointConnection
// values.
type PrivateEndpointConnectionListIterator struct {
	i    int
	page PrivateEndpointConnectionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListIterator) Response() PrivateEndpointConnectionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListIterator type.
func NewPrivateEndpointConnectionListIterator(page PrivateEndpointConnectionListPage) PrivateEndpointConnectionListIterator {
	return PrivateEndpointConnectionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pecl PrivateEndpointConnectionList) IsEmpty() bool {
	return pecl.Value == nil || len(*pecl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pecl PrivateEndpointConnectionList) hasNextLink() bool {
	return pecl.NextLink != nil && len(*pecl.NextLink) != 0
}

// privateEndpointConnectionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pecl PrivateEndpointConnectionList) privateEndpointConnectionListPreparer(ctx context.Context) (*http.Request, error) {
	if !pecl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pecl.NextLink)))
}

// PrivateEndpointConnectionListPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListPage struct {
	fn   func(context.Context, PrivateEndpointConnectionList) (PrivateEndpointConnectionList, error)
	pecl PrivateEndpointConnectionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pecl)
		if err != nil {
			return err
		}
		page.pecl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListPage) NotDone() bool {
	return !page.pecl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListPage) Response() PrivateEndpointConnectionList {
	return page.pecl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListPage) Values() []PrivateEndpointConnection {
	if page.pecl.IsEmpty() {
		return nil
	}
	return *page.pecl.Value
}

// Creates a new instance of the PrivateEndpointConnectionListPage type.
func NewPrivateEndpointConnectionListPage(cur PrivateEndpointConnectionList, getNextPage func(context.Context, PrivateEndpointConnectionList) (PrivateEndpointConnectionList, error)) PrivateEndpointConnectionListPage {
	return PrivateEndpointConnectionListPage{
		fn:   getNextPage,
		pecl: cur,
	}
}

// PrivateEndpointConnectionProperties a private endpoint connection properties class.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The private endpoint information.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - The private link service connection state.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pecp.PrivateEndpoint
	}
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "purview.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("purview.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "purview.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "purview.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("purview.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkResource a privately linkable resource.
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The private link resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The private link resource name.
	Name *string `json:"name,omitempty"`
	// Properties - READ-ONLY; The private link resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`
	// Type - READ-ONLY; The private link resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateLinkResourceList paged list of private link resources
type PrivateLinkResourceList struct {
	autorest.Response `json:"-"`
	// Count - Total item count.
	Count *int64 `json:"count,omitempty"`
	// NextLink - The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Collection of items of type results.
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceListIterator provides access to a complete listing of PrivateLinkResource values.
type PrivateLinkResourceListIterator struct {
	i    int
	page PrivateLinkResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourceListIterator) Response() PrivateLinkResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourceListIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourceListIterator type.
func NewPrivateLinkResourceListIterator(page PrivateLinkResourceListPage) PrivateLinkResourceListIterator {
	return PrivateLinkResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plrl PrivateLinkResourceList) IsEmpty() bool {
	return plrl.Value == nil || len(*plrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plrl PrivateLinkResourceList) hasNextLink() bool {
	return plrl.NextLink != nil && len(*plrl.NextLink) != 0
}

// privateLinkResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plrl PrivateLinkResourceList) privateLinkResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !plrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plrl.NextLink)))
}

// PrivateLinkResourceListPage contains a page of PrivateLinkResource values.
type PrivateLinkResourceListPage struct {
	fn   func(context.Context, PrivateLinkResourceList) (PrivateLinkResourceList, error)
	plrl PrivateLinkResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plrl)
		if err != nil {
			return err
		}
		page.plrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourceListPage) NotDone() bool {
	return !page.plrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourceListPage) Response() PrivateLinkResourceList {
	return page.plrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourceListPage) Values() []PrivateLinkResource {
	if page.plrl.IsEmpty() {
		return nil
	}
	return *page.plrl.Value
}

// Creates a new instance of the PrivateLinkResourceListPage type.
func NewPrivateLinkResourceListPage(cur PrivateLinkResourceList, getNextPage func(context.Context, PrivateLinkResourceList) (PrivateLinkResourceList, error)) PrivateLinkResourceListPage {
	return PrivateLinkResourceListPage{
		fn:   getNextPage,
		plrl: cur,
	}
}

// PrivateLinkResourceProperties a privately linkable resource properties.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group identifier.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; This translates to how many Private IPs should be created for each privately linkable resource.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - READ-ONLY; The required zone names for private link resource.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState the private link service connection state.
type PrivateLinkServiceConnectionState struct {
	// ActionsRequired - The required actions.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
	// Description - The description.
	Description *string `json:"description,omitempty"`
	// Status - The status. Possible values include: 'StatusUnknown', 'StatusPending', 'StatusApproved', 'StatusRejected', 'StatusDisconnected'
	Status Status `json:"status,omitempty"`
}

// ProxyResource proxy Azure Resource
type ProxyResource struct {
	// ID - READ-ONLY; Gets or sets the identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets or sets the type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedAt - READ-ONLY; The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// CreatedBy - READ-ONLY; The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - READ-ONLY; The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// LastModifiedAt - READ-ONLY; The timestamp of the last modification the resource (UTC).
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
	// LastModifiedBy - READ-ONLY; The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - READ-ONLY; The type of identity that last modified the resource. Possible values include: 'LastModifiedByTypeUser', 'LastModifiedByTypeApplication', 'LastModifiedByTypeManagedIdentity', 'LastModifiedByTypeKey'
	LastModifiedByType LastModifiedByType `json:"lastModifiedByType,omitempty"`
}

// MarshalJSON is the custom marshaler for SystemData.
func (sd SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TrackedResource azure ARM Tracked Resource
type TrackedResource struct {
	// ID - READ-ONLY; Gets or sets the identifier.
	ID *string `json:"id,omitempty"`
	// Identity - Identity Info on the tracked resource
	Identity *Identity `json:"identity,omitempty"`
	// Location - Gets or sets the location.
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *TrackedResourceSystemData `json:"systemData,omitempty"`
	// Tags - Tags on the azure resource.
	Tags map[string]*string `json:"tags"`
	// Type - READ-ONLY; Gets or sets the type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Identity != nil {
		objectMap["identity"] = tr.Identity
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TrackedResourceSystemData metadata pertaining to creation and last modification of the resource.
type TrackedResourceSystemData struct {
	// CreatedAt - READ-ONLY; The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// CreatedBy - READ-ONLY; The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - READ-ONLY; The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// LastModifiedAt - READ-ONLY; The timestamp of the last modification the resource (UTC).
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
	// LastModifiedBy - READ-ONLY; The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - READ-ONLY; The type of identity that last modified the resource. Possible values include: 'LastModifiedByTypeUser', 'LastModifiedByTypeApplication', 'LastModifiedByTypeManagedIdentity', 'LastModifiedByTypeKey'
	LastModifiedByType LastModifiedByType `json:"lastModifiedByType,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResourceSystemData.
func (trD TrackedResourceSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}
