// Copyright 2019 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.13.0
// source: proto/v1/grafeas.proto

package grafeas_go_proto

import (
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An instance of an analysis type that has been found on a resource.
type Occurrence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. A URI that represents the resource for which the
	// occurrence applies. For example,
	// `https://gcr.io/project/image@sha256:123abc` for a Docker image.
	ResourceUri string `protobuf:"bytes,2,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	// Required. Immutable. The analysis note associated with this occurrence, in
	// the form of `projects/[PROVIDER_ID]/notes/[NOTE_ID]`. This field can be
	// used as a filter in list requests.
	NoteName string `protobuf:"bytes,3,opt,name=note_name,json=noteName,proto3" json:"note_name,omitempty"`
	// Output only. This explicitly denotes which of the occurrence details are
	// specified. This field can be used as a filter in list requests.
	Kind NoteKind `protobuf:"varint,4,opt,name=kind,proto3,enum=grafeas.v1.NoteKind" json:"kind,omitempty"`
	// A description of actions that can be taken to remedy the note.
	Remediation string `protobuf:"bytes,5,opt,name=remediation,proto3" json:"remediation,omitempty"`
	// Output only. The time this occurrence was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this occurrence was last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Immutable. Describes the details of the note kind found on this
	// resource.
	//
	// Types that are assignable to Details:
	//
	//	*Occurrence_Vulnerability
	//	*Occurrence_Build
	//	*Occurrence_Image
	//	*Occurrence_Package
	//	*Occurrence_Deployment
	//	*Occurrence_Discovery
	//	*Occurrence_Attestation
	//	*Occurrence_Upgrade
	//	*Occurrence_Compliance
	//	*Occurrence_DsseAttestation
	//	*Occurrence_SbomReference
	Details isOccurrence_Details `protobuf_oneof:"details"`
	// https://github.com/secure-systems-lab/dsse
	Envelope *Envelope `protobuf:"bytes,18,opt,name=envelope,proto3" json:"envelope,omitempty"`
}

func (x *Occurrence) Reset() {
	*x = Occurrence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Occurrence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Occurrence) ProtoMessage() {}

func (x *Occurrence) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Occurrence.ProtoReflect.Descriptor instead.
func (*Occurrence) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{0}
}

func (x *Occurrence) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Occurrence) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

func (x *Occurrence) GetNoteName() string {
	if x != nil {
		return x.NoteName
	}
	return ""
}

func (x *Occurrence) GetKind() NoteKind {
	if x != nil {
		return x.Kind
	}
	return NoteKind_NOTE_KIND_UNSPECIFIED
}

func (x *Occurrence) GetRemediation() string {
	if x != nil {
		return x.Remediation
	}
	return ""
}

func (x *Occurrence) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Occurrence) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (m *Occurrence) GetDetails() isOccurrence_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *Occurrence) GetVulnerability() *VulnerabilityOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_Vulnerability); ok {
		return x.Vulnerability
	}
	return nil
}

func (x *Occurrence) GetBuild() *BuildOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_Build); ok {
		return x.Build
	}
	return nil
}

func (x *Occurrence) GetImage() *ImageOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_Image); ok {
		return x.Image
	}
	return nil
}

func (x *Occurrence) GetPackage() *PackageOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_Package); ok {
		return x.Package
	}
	return nil
}

func (x *Occurrence) GetDeployment() *DeploymentOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (x *Occurrence) GetDiscovery() *DiscoveryOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_Discovery); ok {
		return x.Discovery
	}
	return nil
}

func (x *Occurrence) GetAttestation() *AttestationOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_Attestation); ok {
		return x.Attestation
	}
	return nil
}

func (x *Occurrence) GetUpgrade() *UpgradeOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_Upgrade); ok {
		return x.Upgrade
	}
	return nil
}

func (x *Occurrence) GetCompliance() *ComplianceOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_Compliance); ok {
		return x.Compliance
	}
	return nil
}

func (x *Occurrence) GetDsseAttestation() *DSSEAttestationOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_DsseAttestation); ok {
		return x.DsseAttestation
	}
	return nil
}

func (x *Occurrence) GetSbomReference() *SBOMReferenceOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_SbomReference); ok {
		return x.SbomReference
	}
	return nil
}

func (x *Occurrence) GetEnvelope() *Envelope {
	if x != nil {
		return x.Envelope
	}
	return nil
}

type isOccurrence_Details interface {
	isOccurrence_Details()
}

type Occurrence_Vulnerability struct {
	// Describes a security vulnerability.
	Vulnerability *VulnerabilityOccurrence `protobuf:"bytes,8,opt,name=vulnerability,proto3,oneof"`
}

type Occurrence_Build struct {
	// Describes a verifiable build.
	Build *BuildOccurrence `protobuf:"bytes,9,opt,name=build,proto3,oneof"`
}

type Occurrence_Image struct {
	// Describes how this resource derives from the basis in the associated
	// note.
	Image *ImageOccurrence `protobuf:"bytes,10,opt,name=image,proto3,oneof"`
}

type Occurrence_Package struct {
	// Describes the installation of a package on the linked resource.
	Package *PackageOccurrence `protobuf:"bytes,11,opt,name=package,proto3,oneof"`
}

type Occurrence_Deployment struct {
	// Describes the deployment of an artifact on a runtime.
	Deployment *DeploymentOccurrence `protobuf:"bytes,12,opt,name=deployment,proto3,oneof"`
}

type Occurrence_Discovery struct {
	// Describes when a resource was discovered.
	Discovery *DiscoveryOccurrence `protobuf:"bytes,13,opt,name=discovery,proto3,oneof"`
}

type Occurrence_Attestation struct {
	// Describes an attestation of an artifact.
	Attestation *AttestationOccurrence `protobuf:"bytes,14,opt,name=attestation,proto3,oneof"`
}

type Occurrence_Upgrade struct {
	// Describes an available package upgrade on the linked resource.
	Upgrade *UpgradeOccurrence `protobuf:"bytes,15,opt,name=upgrade,proto3,oneof"`
}

type Occurrence_Compliance struct {
	// Describes a compliance violation on a linked resource.
	Compliance *ComplianceOccurrence `protobuf:"bytes,16,opt,name=compliance,proto3,oneof"`
}

type Occurrence_DsseAttestation struct {
	// Describes an attestation of an artifact using dsse.
	DsseAttestation *DSSEAttestationOccurrence `protobuf:"bytes,17,opt,name=dsse_attestation,json=dsseAttestation,proto3,oneof"`
}

type Occurrence_SbomReference struct {
	// Describes a specific SBOM reference occurrences.
	SbomReference *SBOMReferenceOccurrence `protobuf:"bytes,19,opt,name=sbom_reference,json=sbomReference,proto3,oneof"`
}

func (*Occurrence_Vulnerability) isOccurrence_Details() {}

func (*Occurrence_Build) isOccurrence_Details() {}

func (*Occurrence_Image) isOccurrence_Details() {}

func (*Occurrence_Package) isOccurrence_Details() {}

func (*Occurrence_Deployment) isOccurrence_Details() {}

func (*Occurrence_Discovery) isOccurrence_Details() {}

func (*Occurrence_Attestation) isOccurrence_Details() {}

func (*Occurrence_Upgrade) isOccurrence_Details() {}

func (*Occurrence_Compliance) isOccurrence_Details() {}

func (*Occurrence_DsseAttestation) isOccurrence_Details() {}

func (*Occurrence_SbomReference) isOccurrence_Details() {}

// A type of analysis that can be done for a resource.
type Note struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A one sentence description of this note.
	ShortDescription string `protobuf:"bytes,2,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// A detailed description of this note.
	LongDescription string `protobuf:"bytes,3,opt,name=long_description,json=longDescription,proto3" json:"long_description,omitempty"`
	// Output only. The type of analysis. This field can be used as a filter in
	// list requests.
	Kind NoteKind `protobuf:"varint,4,opt,name=kind,proto3,enum=grafeas.v1.NoteKind" json:"kind,omitempty"`
	// URLs associated with this note.
	RelatedUrl []*RelatedUrl `protobuf:"bytes,5,rep,name=related_url,json=relatedUrl,proto3" json:"related_url,omitempty"`
	// Time of expiration for this note. Empty if note does not expire.
	ExpirationTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Output only. The time this note was created. This field can be used as a
	// filter in list requests.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this note was last updated. This field can be used as
	// a filter in list requests.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Other notes related to this note.
	RelatedNoteNames []string `protobuf:"bytes,9,rep,name=related_note_names,json=relatedNoteNames,proto3" json:"related_note_names,omitempty"`
	// Required. Immutable. The type of analysis this note represents.
	//
	// Types that are assignable to Type:
	//
	//	*Note_Vulnerability
	//	*Note_Build
	//	*Note_Image
	//	*Note_Package
	//	*Note_Deployment
	//	*Note_Discovery
	//	*Note_Attestation
	//	*Note_Upgrade
	//	*Note_Compliance
	//	*Note_DsseAttestation
	//	*Note_VulnerabilityAssessment
	//	*Note_SbomReference
	Type isNote_Type `protobuf_oneof:"type"`
}

func (x *Note) Reset() {
	*x = Note{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Note) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Note) ProtoMessage() {}

func (x *Note) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Note.ProtoReflect.Descriptor instead.
func (*Note) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{1}
}

func (x *Note) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Note) GetShortDescription() string {
	if x != nil {
		return x.ShortDescription
	}
	return ""
}

func (x *Note) GetLongDescription() string {
	if x != nil {
		return x.LongDescription
	}
	return ""
}

func (x *Note) GetKind() NoteKind {
	if x != nil {
		return x.Kind
	}
	return NoteKind_NOTE_KIND_UNSPECIFIED
}

func (x *Note) GetRelatedUrl() []*RelatedUrl {
	if x != nil {
		return x.RelatedUrl
	}
	return nil
}

func (x *Note) GetExpirationTime() *timestamp.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

func (x *Note) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Note) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Note) GetRelatedNoteNames() []string {
	if x != nil {
		return x.RelatedNoteNames
	}
	return nil
}

func (m *Note) GetType() isNote_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Note) GetVulnerability() *VulnerabilityNote {
	if x, ok := x.GetType().(*Note_Vulnerability); ok {
		return x.Vulnerability
	}
	return nil
}

func (x *Note) GetBuild() *BuildNote {
	if x, ok := x.GetType().(*Note_Build); ok {
		return x.Build
	}
	return nil
}

func (x *Note) GetImage() *ImageNote {
	if x, ok := x.GetType().(*Note_Image); ok {
		return x.Image
	}
	return nil
}

func (x *Note) GetPackage() *PackageNote {
	if x, ok := x.GetType().(*Note_Package); ok {
		return x.Package
	}
	return nil
}

func (x *Note) GetDeployment() *DeploymentNote {
	if x, ok := x.GetType().(*Note_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (x *Note) GetDiscovery() *DiscoveryNote {
	if x, ok := x.GetType().(*Note_Discovery); ok {
		return x.Discovery
	}
	return nil
}

func (x *Note) GetAttestation() *AttestationNote {
	if x, ok := x.GetType().(*Note_Attestation); ok {
		return x.Attestation
	}
	return nil
}

func (x *Note) GetUpgrade() *UpgradeNote {
	if x, ok := x.GetType().(*Note_Upgrade); ok {
		return x.Upgrade
	}
	return nil
}

func (x *Note) GetCompliance() *ComplianceNote {
	if x, ok := x.GetType().(*Note_Compliance); ok {
		return x.Compliance
	}
	return nil
}

func (x *Note) GetDsseAttestation() *DSSEAttestationNote {
	if x, ok := x.GetType().(*Note_DsseAttestation); ok {
		return x.DsseAttestation
	}
	return nil
}

func (x *Note) GetVulnerabilityAssessment() *VulnerabilityAssessmentNote {
	if x, ok := x.GetType().(*Note_VulnerabilityAssessment); ok {
		return x.VulnerabilityAssessment
	}
	return nil
}

func (x *Note) GetSbomReference() *SBOMReferenceNote {
	if x, ok := x.GetType().(*Note_SbomReference); ok {
		return x.SbomReference
	}
	return nil
}

type isNote_Type interface {
	isNote_Type()
}

type Note_Vulnerability struct {
	// A note describing a package vulnerability.
	Vulnerability *VulnerabilityNote `protobuf:"bytes,10,opt,name=vulnerability,proto3,oneof"`
}

type Note_Build struct {
	// A note describing build provenance for a verifiable build.
	Build *BuildNote `protobuf:"bytes,11,opt,name=build,proto3,oneof"`
}

type Note_Image struct {
	// A note describing a base image.
	Image *ImageNote `protobuf:"bytes,12,opt,name=image,proto3,oneof"`
}

type Note_Package struct {
	// A note describing a package hosted by various package managers.
	Package *PackageNote `protobuf:"bytes,13,opt,name=package,proto3,oneof"`
}

type Note_Deployment struct {
	// A note describing something that can be deployed.
	Deployment *DeploymentNote `protobuf:"bytes,14,opt,name=deployment,proto3,oneof"`
}

type Note_Discovery struct {
	// A note describing the initial analysis of a resource.
	Discovery *DiscoveryNote `protobuf:"bytes,15,opt,name=discovery,proto3,oneof"`
}

type Note_Attestation struct {
	// A note describing an attestation role.
	Attestation *AttestationNote `protobuf:"bytes,16,opt,name=attestation,proto3,oneof"`
}

type Note_Upgrade struct {
	// A note describing available package upgrades.
	Upgrade *UpgradeNote `protobuf:"bytes,17,opt,name=upgrade,proto3,oneof"`
}

type Note_Compliance struct {
	// A note describing a compliance check.
	Compliance *ComplianceNote `protobuf:"bytes,18,opt,name=compliance,proto3,oneof"`
}

type Note_DsseAttestation struct {
	// A note describing a dsse attestation note.
	DsseAttestation *DSSEAttestationNote `protobuf:"bytes,19,opt,name=dsse_attestation,json=dsseAttestation,proto3,oneof"`
}

type Note_VulnerabilityAssessment struct {
	// A note describing a vulnerability assessment.
	VulnerabilityAssessment *VulnerabilityAssessmentNote `protobuf:"bytes,20,opt,name=vulnerability_assessment,json=vulnerabilityAssessment,proto3,oneof"`
}

type Note_SbomReference struct {
	// A note describing an SBOM reference.
	SbomReference *SBOMReferenceNote `protobuf:"bytes,21,opt,name=sbom_reference,json=sbomReference,proto3,oneof"`
}

func (*Note_Vulnerability) isNote_Type() {}

func (*Note_Build) isNote_Type() {}

func (*Note_Image) isNote_Type() {}

func (*Note_Package) isNote_Type() {}

func (*Note_Deployment) isNote_Type() {}

func (*Note_Discovery) isNote_Type() {}

func (*Note_Attestation) isNote_Type() {}

func (*Note_Upgrade) isNote_Type() {}

func (*Note_Compliance) isNote_Type() {}

func (*Note_DsseAttestation) isNote_Type() {}

func (*Note_VulnerabilityAssessment) isNote_Type() {}

func (*Note_SbomReference) isNote_Type() {}

// Request to get an occurrence.
type GetOccurrenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOccurrenceRequest) Reset() {
	*x = GetOccurrenceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOccurrenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOccurrenceRequest) ProtoMessage() {}

func (x *GetOccurrenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOccurrenceRequest.ProtoReflect.Descriptor instead.
func (*GetOccurrenceRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{2}
}

func (x *GetOccurrenceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list occurrences.
type ListOccurrencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project to list occurrences for in the form of
	// `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of occurrences to return in the list. Must be positive. Max allowed
	// page size is 1000. If not specified, page size defaults to 20.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListOccurrencesRequest) Reset() {
	*x = ListOccurrencesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOccurrencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOccurrencesRequest) ProtoMessage() {}

func (x *ListOccurrencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOccurrencesRequest.ProtoReflect.Descriptor instead.
func (*ListOccurrencesRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{3}
}

func (x *ListOccurrencesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOccurrencesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListOccurrencesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOccurrencesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for listing occurrences.
type ListOccurrencesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The occurrences requested.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	// The next pagination token in the list response. It should be used as
	// `page_token` for the following request. An empty value means no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListOccurrencesResponse) Reset() {
	*x = ListOccurrencesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOccurrencesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOccurrencesResponse) ProtoMessage() {}

func (x *ListOccurrencesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOccurrencesResponse.ProtoReflect.Descriptor instead.
func (*ListOccurrencesResponse) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{4}
}

func (x *ListOccurrencesResponse) GetOccurrences() []*Occurrence {
	if x != nil {
		return x.Occurrences
	}
	return nil
}

func (x *ListOccurrencesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to delete an occurrence.
type DeleteOccurrenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteOccurrenceRequest) Reset() {
	*x = DeleteOccurrenceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteOccurrenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOccurrenceRequest) ProtoMessage() {}

func (x *DeleteOccurrenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteOccurrenceRequest.ProtoReflect.Descriptor instead.
func (*DeleteOccurrenceRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteOccurrenceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to create a new occurrence.
type CreateOccurrenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the occurrence is to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The occurrence to create.
	Occurrence *Occurrence `protobuf:"bytes,2,opt,name=occurrence,proto3" json:"occurrence,omitempty"`
}

func (x *CreateOccurrenceRequest) Reset() {
	*x = CreateOccurrenceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOccurrenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOccurrenceRequest) ProtoMessage() {}

func (x *CreateOccurrenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOccurrenceRequest.ProtoReflect.Descriptor instead.
func (*CreateOccurrenceRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{6}
}

func (x *CreateOccurrenceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateOccurrenceRequest) GetOccurrence() *Occurrence {
	if x != nil {
		return x.Occurrence
	}
	return nil
}

// Request to update an occurrence.
type UpdateOccurrenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The updated occurrence.
	Occurrence *Occurrence `protobuf:"bytes,2,opt,name=occurrence,proto3" json:"occurrence,omitempty"`
	// The fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateOccurrenceRequest) Reset() {
	*x = UpdateOccurrenceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateOccurrenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOccurrenceRequest) ProtoMessage() {}

func (x *UpdateOccurrenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOccurrenceRequest.ProtoReflect.Descriptor instead.
func (*UpdateOccurrenceRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateOccurrenceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateOccurrenceRequest) GetOccurrence() *Occurrence {
	if x != nil {
		return x.Occurrence
	}
	return nil
}

func (x *UpdateOccurrenceRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to get a note.
type GetNoteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNoteRequest) Reset() {
	*x = GetNoteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNoteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNoteRequest) ProtoMessage() {}

func (x *GetNoteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNoteRequest.ProtoReflect.Descriptor instead.
func (*GetNoteRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{8}
}

func (x *GetNoteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to get the note to which the specified occurrence is attached.
type GetOccurrenceNoteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOccurrenceNoteRequest) Reset() {
	*x = GetOccurrenceNoteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOccurrenceNoteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOccurrenceNoteRequest) ProtoMessage() {}

func (x *GetOccurrenceNoteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOccurrenceNoteRequest.ProtoReflect.Descriptor instead.
func (*GetOccurrenceNoteRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{9}
}

func (x *GetOccurrenceNoteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list notes.
type ListNotesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project to list notes for in the form of
	// `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of notes to return in the list. Must be positive. Max allowed page
	// size is 1000. If not specified, page size defaults to 20.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListNotesRequest) Reset() {
	*x = ListNotesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotesRequest) ProtoMessage() {}

func (x *ListNotesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotesRequest.ProtoReflect.Descriptor instead.
func (*ListNotesRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{10}
}

func (x *ListNotesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNotesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListNotesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNotesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for listing notes.
type ListNotesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The notes requested.
	Notes []*Note `protobuf:"bytes,1,rep,name=notes,proto3" json:"notes,omitempty"`
	// The next pagination token in the list response. It should be used as
	// `page_token` for the following request. An empty value means no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListNotesResponse) Reset() {
	*x = ListNotesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotesResponse) ProtoMessage() {}

func (x *ListNotesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotesResponse.ProtoReflect.Descriptor instead.
func (*ListNotesResponse) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{11}
}

func (x *ListNotesResponse) GetNotes() []*Note {
	if x != nil {
		return x.Notes
	}
	return nil
}

func (x *ListNotesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to delete a note.
type DeleteNoteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteNoteRequest) Reset() {
	*x = DeleteNoteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteNoteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNoteRequest) ProtoMessage() {}

func (x *DeleteNoteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNoteRequest.ProtoReflect.Descriptor instead.
func (*DeleteNoteRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteNoteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to create a new note.
type CreateNoteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the note is to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The ID to use for this note.
	NoteId string `protobuf:"bytes,2,opt,name=note_id,json=noteId,proto3" json:"note_id,omitempty"`
	// The note to create.
	Note *Note `protobuf:"bytes,3,opt,name=note,proto3" json:"note,omitempty"`
}

func (x *CreateNoteRequest) Reset() {
	*x = CreateNoteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNoteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNoteRequest) ProtoMessage() {}

func (x *CreateNoteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNoteRequest.ProtoReflect.Descriptor instead.
func (*CreateNoteRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{13}
}

func (x *CreateNoteRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateNoteRequest) GetNoteId() string {
	if x != nil {
		return x.NoteId
	}
	return ""
}

func (x *CreateNoteRequest) GetNote() *Note {
	if x != nil {
		return x.Note
	}
	return nil
}

// Request to update a note.
type UpdateNoteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The updated note.
	Note *Note `protobuf:"bytes,2,opt,name=note,proto3" json:"note,omitempty"`
	// The fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateNoteRequest) Reset() {
	*x = UpdateNoteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNoteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNoteRequest) ProtoMessage() {}

func (x *UpdateNoteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNoteRequest.ProtoReflect.Descriptor instead.
func (*UpdateNoteRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateNoteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateNoteRequest) GetNote() *Note {
	if x != nil {
		return x.Note
	}
	return nil
}

func (x *UpdateNoteRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to list occurrences for a note.
type ListNoteOccurrencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the note to list occurrences for in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of occurrences to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListNoteOccurrencesRequest) Reset() {
	*x = ListNoteOccurrencesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNoteOccurrencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNoteOccurrencesRequest) ProtoMessage() {}

func (x *ListNoteOccurrencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNoteOccurrencesRequest.ProtoReflect.Descriptor instead.
func (*ListNoteOccurrencesRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{15}
}

func (x *ListNoteOccurrencesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListNoteOccurrencesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListNoteOccurrencesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNoteOccurrencesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for listing occurrences for a note.
type ListNoteOccurrencesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The occurrences attached to the specified note.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListNoteOccurrencesResponse) Reset() {
	*x = ListNoteOccurrencesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNoteOccurrencesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNoteOccurrencesResponse) ProtoMessage() {}

func (x *ListNoteOccurrencesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNoteOccurrencesResponse.ProtoReflect.Descriptor instead.
func (*ListNoteOccurrencesResponse) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{16}
}

func (x *ListNoteOccurrencesResponse) GetOccurrences() []*Occurrence {
	if x != nil {
		return x.Occurrences
	}
	return nil
}

func (x *ListNoteOccurrencesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to create notes in batch.
type BatchCreateNotesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the notes are to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The notes to create. Max allowed length is 1000.
	Notes map[string]*Note `protobuf:"bytes,2,rep,name=notes,proto3" json:"notes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchCreateNotesRequest) Reset() {
	*x = BatchCreateNotesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateNotesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateNotesRequest) ProtoMessage() {}

func (x *BatchCreateNotesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateNotesRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateNotesRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{17}
}

func (x *BatchCreateNotesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateNotesRequest) GetNotes() map[string]*Note {
	if x != nil {
		return x.Notes
	}
	return nil
}

// Response for creating notes in batch.
type BatchCreateNotesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The notes that were created.
	Notes []*Note `protobuf:"bytes,1,rep,name=notes,proto3" json:"notes,omitempty"`
}

func (x *BatchCreateNotesResponse) Reset() {
	*x = BatchCreateNotesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateNotesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateNotesResponse) ProtoMessage() {}

func (x *BatchCreateNotesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateNotesResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateNotesResponse) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{18}
}

func (x *BatchCreateNotesResponse) GetNotes() []*Note {
	if x != nil {
		return x.Notes
	}
	return nil
}

// Request to create occurrences in batch.
type BatchCreateOccurrencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the occurrences are to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The occurrences to create. Max allowed length is 1000.
	Occurrences []*Occurrence `protobuf:"bytes,2,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
}

func (x *BatchCreateOccurrencesRequest) Reset() {
	*x = BatchCreateOccurrencesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateOccurrencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateOccurrencesRequest) ProtoMessage() {}

func (x *BatchCreateOccurrencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateOccurrencesRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateOccurrencesRequest) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{19}
}

func (x *BatchCreateOccurrencesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateOccurrencesRequest) GetOccurrences() []*Occurrence {
	if x != nil {
		return x.Occurrences
	}
	return nil
}

// Response for creating occurrences in batch.
type BatchCreateOccurrencesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The occurrences that were created.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
}

func (x *BatchCreateOccurrencesResponse) Reset() {
	*x = BatchCreateOccurrencesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_grafeas_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateOccurrencesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateOccurrencesResponse) ProtoMessage() {}

func (x *BatchCreateOccurrencesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_grafeas_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateOccurrencesResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateOccurrencesResponse) Descriptor() ([]byte, []int) {
	return file_proto_v1_grafeas_proto_rawDescGZIP(), []int{20}
}

func (x *BatchCreateOccurrencesResponse) GetOccurrences() []*Occurrence {
	if x != nil {
		return x.Occurrences
	}
	return nil
}

var File_proto_v1_grafeas_proto protoreflect.FileDescriptor

var file_proto_v1_grafeas_proto_rawDesc = []byte{
	0x0a, 0x16, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0a, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76,
	0x31, 0x2f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x70,
	0x67, 0x72, 0x61, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x64,
	0x73, 0x73, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x12, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f,
	0x76, 0x65, 0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x13, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x62, 0x6f, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8b,
	0x09, 0x0a, 0x0a, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x55, 0x72, 0x69, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x6f, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x6f, 0x74, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x28, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x14, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74,
	0x65, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x72,
	0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x72, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x0d, 0x76, 0x75, 0x6c, 0x6e, 0x65,
	0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e,
	0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x12, 0x33, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x33, 0x0a, 0x05, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x39,
	0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00,
	0x52, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x42, 0x0a, 0x0a, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a,
	0x09, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x09, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x12, 0x45,
	0x0a, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x07, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x07, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65,
	0x12, 0x42, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x52, 0x0a, 0x10, 0x64, 0x73, 0x73, 0x65, 0x5f, 0x61, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x53, 0x53, 0x45,
	0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x73, 0x73, 0x65, 0x41, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x0e, 0x73, 0x62, 0x6f, 0x6d,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x42,
	0x4f, 0x4d, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x62, 0x6f, 0x6d, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x30, 0x0a, 0x08, 0x65, 0x6e, 0x76, 0x65, 0x6c, 0x6f,
	0x70, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x08,
	0x65, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x3a, 0x47, 0xea, 0x41, 0x44, 0x0a, 0x15, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x12, 0x2b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x7d, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x84, 0x0a, 0x0a,
	0x04, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x68, 0x6f,
	0x72, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x6c, 0x6f, 0x6e, 0x67, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x28, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x14, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74,
	0x65, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x37, 0x0a, 0x0b, 0x72,
	0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x0a, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65,
	0x64, 0x55, 0x72, 0x6c, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6e,
	0x6f, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x10, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4e, 0x6f, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x12, 0x45, 0x0a, 0x0d, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x76, 0x75, 0x6c, 0x6e, 0x65,
	0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x2d, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00,
	0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x2d, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52,
	0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x33, 0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x6f, 0x74, 0x65,
	0x48, 0x00, 0x52, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x3c, 0x0a, 0x0a, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x09, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x09, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x12, 0x3f, 0x0a, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x07, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x48,
	0x00, 0x52, 0x07, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x12, 0x3c, 0x0a, 0x0a, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x4c, 0x0a, 0x10, 0x64, 0x73, 0x73, 0x65,
	0x5f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x53, 0x53, 0x45, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e,
	0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x73, 0x73, 0x65, 0x41, 0x74, 0x74, 0x65, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x18, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x74,
	0x65, 0x48, 0x00, 0x52, 0x17, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x0e,
	0x73, 0x62, 0x6f, 0x6d, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x15,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x42, 0x4f, 0x4d, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e,
	0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x62, 0x6f, 0x6d, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x3a, 0x35, 0xea, 0x41, 0x32, 0x0a, 0x0f, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x1f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6e,
	0x6f, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x74, 0x65, 0x7d, 0x42, 0x06, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x22, 0x49, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x17, 0x0a, 0x15, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4f, 0x63,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0,
	0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x14, 0x0a, 0x12, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x7b, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x0b,
	0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4c,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x17, 0x0a,
	0x15, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8a, 0x01, 0x0a,
	0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x14,
	0x0a, 0x12, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0a,
	0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x63,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6f,
	0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xc6, 0x01, 0x0a, 0x17, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x1d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x17, 0x0a, 0x15, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0a, 0x6f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x3d, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x17, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x11, 0x0a, 0x0f, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x4d, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1d, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x17, 0x0a, 0x15, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f,
	0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x9a, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x14, 0x0a, 0x12, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x63, 0x0a,
	0x11, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x26, 0x0a, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x74, 0x65, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x40, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x17, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x11, 0x0a, 0x0f, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e,
	0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x14, 0x0a, 0x12, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1c,
	0x0a, 0x07, 0x6e, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6e, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x04,
	0x6e, 0x6f, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x17, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x11, 0x0a, 0x0f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f,
	0x4e, 0x6f, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x04, 0x6e, 0x6f,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x6e, 0x6f, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x9d, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x4f,
	0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x2b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x17, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x11, 0x0a, 0x0f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x69, 0x6f, 0x2f, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x7f, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x4f, 0x63,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x38, 0x0a, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0b,
	0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xe4, 0x01, 0x0a, 0x17, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x32, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x1a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x14, 0x0a, 0x12, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x69, 0x6f, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x1a, 0x4a,
	0x0a, 0x0a, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x26,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x42, 0x0a, 0x18, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x22, 0x92,
	0x01, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x63,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x32, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x1a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x14, 0x0a, 0x12, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x22, 0x5a, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x32,
	0xed, 0x0f, 0x0a, 0x07, 0x47, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x12, 0x7d, 0x0a, 0x0d, 0x47,
	0x65, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x20, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x63, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12, 0x23,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x97, 0x01, 0x0a, 0x0f, 0x4c,
	0x69, 0x73, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x22,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12,
	0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x83, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f,
	0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x23, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x63, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x2a, 0x23,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x9c, 0x01, 0x0a, 0x10, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x23, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x4b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x31, 0x22, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x63,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x3a, 0x0a, 0x6f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6f,
	0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0xc0, 0x01, 0x0a, 0x16, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x29, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4f, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x34, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x63, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xa6, 0x01, 0x0a,
	0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x23, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x55,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x32, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x63, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0a, 0x6f, 0x63, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0xda, 0x41, 0x1b, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6f,
	0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x85, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4f, 0x63, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x24, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x10, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x74, 0x65, 0x22, 0x38, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a,
	0x07, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x1a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x10, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x22, 0x2c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x12, 0x1d,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x7f, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65,
	0x73, 0x12, 0x1c, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x35,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x12, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6e, 0x6f, 0x74, 0x65, 0x73, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x71, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e,
	0x6f, 0x74, 0x65, 0x12, 0x1d, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x2c, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x1f, 0x2a, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x80, 0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x1d, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x10, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25,
	0x22, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x3a,
	0x04, 0x6e, 0x6f, 0x74, 0x65, 0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e,
	0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x2c, 0x6e, 0x6f, 0x74, 0x65, 0x12, 0xa2, 0x01, 0x0a, 0x10,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73,
	0x12, 0x23, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f,
	0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2e, 0x22, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74,
	0x65, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x6f, 0x74, 0x65, 0x73,
	0x12, 0x82, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x12,
	0x1d, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x10,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65,
	0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x32, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6e,
	0x6f, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0xda, 0x41, 0x15,
	0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6e, 0x6f, 0x74, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xa7, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f,
	0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e,
	0x6f, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0xda, 0x41, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42,
	0x4d, 0x0a, 0x0d, 0x69, 0x6f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x50, 0x01, 0x5a, 0x34, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x5f,
	0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0xa2, 0x02, 0x03, 0x47, 0x52, 0x41, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_proto_v1_grafeas_proto_rawDescOnce sync.Once
	file_proto_v1_grafeas_proto_rawDescData = file_proto_v1_grafeas_proto_rawDesc
)

func file_proto_v1_grafeas_proto_rawDescGZIP() []byte {
	file_proto_v1_grafeas_proto_rawDescOnce.Do(func() {
		file_proto_v1_grafeas_proto_rawDescData = protoimpl.X.CompressGZIP(file_proto_v1_grafeas_proto_rawDescData)
	})
	return file_proto_v1_grafeas_proto_rawDescData
}

var file_proto_v1_grafeas_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_proto_v1_grafeas_proto_goTypes = []interface{}{
	(*Occurrence)(nil),                     // 0: grafeas.v1.Occurrence
	(*Note)(nil),                           // 1: grafeas.v1.Note
	(*GetOccurrenceRequest)(nil),           // 2: grafeas.v1.GetOccurrenceRequest
	(*ListOccurrencesRequest)(nil),         // 3: grafeas.v1.ListOccurrencesRequest
	(*ListOccurrencesResponse)(nil),        // 4: grafeas.v1.ListOccurrencesResponse
	(*DeleteOccurrenceRequest)(nil),        // 5: grafeas.v1.DeleteOccurrenceRequest
	(*CreateOccurrenceRequest)(nil),        // 6: grafeas.v1.CreateOccurrenceRequest
	(*UpdateOccurrenceRequest)(nil),        // 7: grafeas.v1.UpdateOccurrenceRequest
	(*GetNoteRequest)(nil),                 // 8: grafeas.v1.GetNoteRequest
	(*GetOccurrenceNoteRequest)(nil),       // 9: grafeas.v1.GetOccurrenceNoteRequest
	(*ListNotesRequest)(nil),               // 10: grafeas.v1.ListNotesRequest
	(*ListNotesResponse)(nil),              // 11: grafeas.v1.ListNotesResponse
	(*DeleteNoteRequest)(nil),              // 12: grafeas.v1.DeleteNoteRequest
	(*CreateNoteRequest)(nil),              // 13: grafeas.v1.CreateNoteRequest
	(*UpdateNoteRequest)(nil),              // 14: grafeas.v1.UpdateNoteRequest
	(*ListNoteOccurrencesRequest)(nil),     // 15: grafeas.v1.ListNoteOccurrencesRequest
	(*ListNoteOccurrencesResponse)(nil),    // 16: grafeas.v1.ListNoteOccurrencesResponse
	(*BatchCreateNotesRequest)(nil),        // 17: grafeas.v1.BatchCreateNotesRequest
	(*BatchCreateNotesResponse)(nil),       // 18: grafeas.v1.BatchCreateNotesResponse
	(*BatchCreateOccurrencesRequest)(nil),  // 19: grafeas.v1.BatchCreateOccurrencesRequest
	(*BatchCreateOccurrencesResponse)(nil), // 20: grafeas.v1.BatchCreateOccurrencesResponse
	nil,                                    // 21: grafeas.v1.BatchCreateNotesRequest.NotesEntry
	(NoteKind)(0),                          // 22: grafeas.v1.NoteKind
	(*timestamp.Timestamp)(nil),            // 23: google.protobuf.Timestamp
	(*VulnerabilityOccurrence)(nil),        // 24: grafeas.v1.VulnerabilityOccurrence
	(*BuildOccurrence)(nil),                // 25: grafeas.v1.BuildOccurrence
	(*ImageOccurrence)(nil),                // 26: grafeas.v1.ImageOccurrence
	(*PackageOccurrence)(nil),              // 27: grafeas.v1.PackageOccurrence
	(*DeploymentOccurrence)(nil),           // 28: grafeas.v1.DeploymentOccurrence
	(*DiscoveryOccurrence)(nil),            // 29: grafeas.v1.DiscoveryOccurrence
	(*AttestationOccurrence)(nil),          // 30: grafeas.v1.AttestationOccurrence
	(*UpgradeOccurrence)(nil),              // 31: grafeas.v1.UpgradeOccurrence
	(*ComplianceOccurrence)(nil),           // 32: grafeas.v1.ComplianceOccurrence
	(*DSSEAttestationOccurrence)(nil),      // 33: grafeas.v1.DSSEAttestationOccurrence
	(*SBOMReferenceOccurrence)(nil),        // 34: grafeas.v1.SBOMReferenceOccurrence
	(*Envelope)(nil),                       // 35: grafeas.v1.Envelope
	(*RelatedUrl)(nil),                     // 36: grafeas.v1.RelatedUrl
	(*VulnerabilityNote)(nil),              // 37: grafeas.v1.VulnerabilityNote
	(*BuildNote)(nil),                      // 38: grafeas.v1.BuildNote
	(*ImageNote)(nil),                      // 39: grafeas.v1.ImageNote
	(*PackageNote)(nil),                    // 40: grafeas.v1.PackageNote
	(*DeploymentNote)(nil),                 // 41: grafeas.v1.DeploymentNote
	(*DiscoveryNote)(nil),                  // 42: grafeas.v1.DiscoveryNote
	(*AttestationNote)(nil),                // 43: grafeas.v1.AttestationNote
	(*UpgradeNote)(nil),                    // 44: grafeas.v1.UpgradeNote
	(*ComplianceNote)(nil),                 // 45: grafeas.v1.ComplianceNote
	(*DSSEAttestationNote)(nil),            // 46: grafeas.v1.DSSEAttestationNote
	(*VulnerabilityAssessmentNote)(nil),    // 47: grafeas.v1.VulnerabilityAssessmentNote
	(*SBOMReferenceNote)(nil),              // 48: grafeas.v1.SBOMReferenceNote
	(*field_mask.FieldMask)(nil),           // 49: google.protobuf.FieldMask
	(*empty.Empty)(nil),                    // 50: google.protobuf.Empty
}
var file_proto_v1_grafeas_proto_depIdxs = []int32{
	22, // 0: grafeas.v1.Occurrence.kind:type_name -> grafeas.v1.NoteKind
	23, // 1: grafeas.v1.Occurrence.create_time:type_name -> google.protobuf.Timestamp
	23, // 2: grafeas.v1.Occurrence.update_time:type_name -> google.protobuf.Timestamp
	24, // 3: grafeas.v1.Occurrence.vulnerability:type_name -> grafeas.v1.VulnerabilityOccurrence
	25, // 4: grafeas.v1.Occurrence.build:type_name -> grafeas.v1.BuildOccurrence
	26, // 5: grafeas.v1.Occurrence.image:type_name -> grafeas.v1.ImageOccurrence
	27, // 6: grafeas.v1.Occurrence.package:type_name -> grafeas.v1.PackageOccurrence
	28, // 7: grafeas.v1.Occurrence.deployment:type_name -> grafeas.v1.DeploymentOccurrence
	29, // 8: grafeas.v1.Occurrence.discovery:type_name -> grafeas.v1.DiscoveryOccurrence
	30, // 9: grafeas.v1.Occurrence.attestation:type_name -> grafeas.v1.AttestationOccurrence
	31, // 10: grafeas.v1.Occurrence.upgrade:type_name -> grafeas.v1.UpgradeOccurrence
	32, // 11: grafeas.v1.Occurrence.compliance:type_name -> grafeas.v1.ComplianceOccurrence
	33, // 12: grafeas.v1.Occurrence.dsse_attestation:type_name -> grafeas.v1.DSSEAttestationOccurrence
	34, // 13: grafeas.v1.Occurrence.sbom_reference:type_name -> grafeas.v1.SBOMReferenceOccurrence
	35, // 14: grafeas.v1.Occurrence.envelope:type_name -> grafeas.v1.Envelope
	22, // 15: grafeas.v1.Note.kind:type_name -> grafeas.v1.NoteKind
	36, // 16: grafeas.v1.Note.related_url:type_name -> grafeas.v1.RelatedUrl
	23, // 17: grafeas.v1.Note.expiration_time:type_name -> google.protobuf.Timestamp
	23, // 18: grafeas.v1.Note.create_time:type_name -> google.protobuf.Timestamp
	23, // 19: grafeas.v1.Note.update_time:type_name -> google.protobuf.Timestamp
	37, // 20: grafeas.v1.Note.vulnerability:type_name -> grafeas.v1.VulnerabilityNote
	38, // 21: grafeas.v1.Note.build:type_name -> grafeas.v1.BuildNote
	39, // 22: grafeas.v1.Note.image:type_name -> grafeas.v1.ImageNote
	40, // 23: grafeas.v1.Note.package:type_name -> grafeas.v1.PackageNote
	41, // 24: grafeas.v1.Note.deployment:type_name -> grafeas.v1.DeploymentNote
	42, // 25: grafeas.v1.Note.discovery:type_name -> grafeas.v1.DiscoveryNote
	43, // 26: grafeas.v1.Note.attestation:type_name -> grafeas.v1.AttestationNote
	44, // 27: grafeas.v1.Note.upgrade:type_name -> grafeas.v1.UpgradeNote
	45, // 28: grafeas.v1.Note.compliance:type_name -> grafeas.v1.ComplianceNote
	46, // 29: grafeas.v1.Note.dsse_attestation:type_name -> grafeas.v1.DSSEAttestationNote
	47, // 30: grafeas.v1.Note.vulnerability_assessment:type_name -> grafeas.v1.VulnerabilityAssessmentNote
	48, // 31: grafeas.v1.Note.sbom_reference:type_name -> grafeas.v1.SBOMReferenceNote
	0,  // 32: grafeas.v1.ListOccurrencesResponse.occurrences:type_name -> grafeas.v1.Occurrence
	0,  // 33: grafeas.v1.CreateOccurrenceRequest.occurrence:type_name -> grafeas.v1.Occurrence
	0,  // 34: grafeas.v1.UpdateOccurrenceRequest.occurrence:type_name -> grafeas.v1.Occurrence
	49, // 35: grafeas.v1.UpdateOccurrenceRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 36: grafeas.v1.ListNotesResponse.notes:type_name -> grafeas.v1.Note
	1,  // 37: grafeas.v1.CreateNoteRequest.note:type_name -> grafeas.v1.Note
	1,  // 38: grafeas.v1.UpdateNoteRequest.note:type_name -> grafeas.v1.Note
	49, // 39: grafeas.v1.UpdateNoteRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 40: grafeas.v1.ListNoteOccurrencesResponse.occurrences:type_name -> grafeas.v1.Occurrence
	21, // 41: grafeas.v1.BatchCreateNotesRequest.notes:type_name -> grafeas.v1.BatchCreateNotesRequest.NotesEntry
	1,  // 42: grafeas.v1.BatchCreateNotesResponse.notes:type_name -> grafeas.v1.Note
	0,  // 43: grafeas.v1.BatchCreateOccurrencesRequest.occurrences:type_name -> grafeas.v1.Occurrence
	0,  // 44: grafeas.v1.BatchCreateOccurrencesResponse.occurrences:type_name -> grafeas.v1.Occurrence
	1,  // 45: grafeas.v1.BatchCreateNotesRequest.NotesEntry.value:type_name -> grafeas.v1.Note
	2,  // 46: grafeas.v1.Grafeas.GetOccurrence:input_type -> grafeas.v1.GetOccurrenceRequest
	3,  // 47: grafeas.v1.Grafeas.ListOccurrences:input_type -> grafeas.v1.ListOccurrencesRequest
	5,  // 48: grafeas.v1.Grafeas.DeleteOccurrence:input_type -> grafeas.v1.DeleteOccurrenceRequest
	6,  // 49: grafeas.v1.Grafeas.CreateOccurrence:input_type -> grafeas.v1.CreateOccurrenceRequest
	19, // 50: grafeas.v1.Grafeas.BatchCreateOccurrences:input_type -> grafeas.v1.BatchCreateOccurrencesRequest
	7,  // 51: grafeas.v1.Grafeas.UpdateOccurrence:input_type -> grafeas.v1.UpdateOccurrenceRequest
	9,  // 52: grafeas.v1.Grafeas.GetOccurrenceNote:input_type -> grafeas.v1.GetOccurrenceNoteRequest
	8,  // 53: grafeas.v1.Grafeas.GetNote:input_type -> grafeas.v1.GetNoteRequest
	10, // 54: grafeas.v1.Grafeas.ListNotes:input_type -> grafeas.v1.ListNotesRequest
	12, // 55: grafeas.v1.Grafeas.DeleteNote:input_type -> grafeas.v1.DeleteNoteRequest
	13, // 56: grafeas.v1.Grafeas.CreateNote:input_type -> grafeas.v1.CreateNoteRequest
	17, // 57: grafeas.v1.Grafeas.BatchCreateNotes:input_type -> grafeas.v1.BatchCreateNotesRequest
	14, // 58: grafeas.v1.Grafeas.UpdateNote:input_type -> grafeas.v1.UpdateNoteRequest
	15, // 59: grafeas.v1.Grafeas.ListNoteOccurrences:input_type -> grafeas.v1.ListNoteOccurrencesRequest
	0,  // 60: grafeas.v1.Grafeas.GetOccurrence:output_type -> grafeas.v1.Occurrence
	4,  // 61: grafeas.v1.Grafeas.ListOccurrences:output_type -> grafeas.v1.ListOccurrencesResponse
	50, // 62: grafeas.v1.Grafeas.DeleteOccurrence:output_type -> google.protobuf.Empty
	0,  // 63: grafeas.v1.Grafeas.CreateOccurrence:output_type -> grafeas.v1.Occurrence
	20, // 64: grafeas.v1.Grafeas.BatchCreateOccurrences:output_type -> grafeas.v1.BatchCreateOccurrencesResponse
	0,  // 65: grafeas.v1.Grafeas.UpdateOccurrence:output_type -> grafeas.v1.Occurrence
	1,  // 66: grafeas.v1.Grafeas.GetOccurrenceNote:output_type -> grafeas.v1.Note
	1,  // 67: grafeas.v1.Grafeas.GetNote:output_type -> grafeas.v1.Note
	11, // 68: grafeas.v1.Grafeas.ListNotes:output_type -> grafeas.v1.ListNotesResponse
	50, // 69: grafeas.v1.Grafeas.DeleteNote:output_type -> google.protobuf.Empty
	1,  // 70: grafeas.v1.Grafeas.CreateNote:output_type -> grafeas.v1.Note
	18, // 71: grafeas.v1.Grafeas.BatchCreateNotes:output_type -> grafeas.v1.BatchCreateNotesResponse
	1,  // 72: grafeas.v1.Grafeas.UpdateNote:output_type -> grafeas.v1.Note
	16, // 73: grafeas.v1.Grafeas.ListNoteOccurrences:output_type -> grafeas.v1.ListNoteOccurrencesResponse
	60, // [60:74] is the sub-list for method output_type
	46, // [46:60] is the sub-list for method input_type
	46, // [46:46] is the sub-list for extension type_name
	46, // [46:46] is the sub-list for extension extendee
	0,  // [0:46] is the sub-list for field type_name
}

func init() { file_proto_v1_grafeas_proto_init() }
func file_proto_v1_grafeas_proto_init() {
	if File_proto_v1_grafeas_proto != nil {
		return
	}
	file_proto_v1_attestation_proto_init()
	file_proto_v1_build_proto_init()
	file_proto_v1_common_proto_init()
	file_proto_v1_deployment_proto_init()
	file_proto_v1_discovery_proto_init()
	file_proto_v1_image_proto_init()
	file_proto_v1_package_proto_init()
	file_proto_v1_upgrade_proto_init()
	file_proto_v1_vulnerability_proto_init()
	file_proto_v1_compliance_proto_init()
	file_proto_v1_dsse_attestation_proto_init()
	file_proto_v1_vex_proto_init()
	file_proto_v1_sbom_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_proto_v1_grafeas_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Occurrence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Note); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOccurrenceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOccurrencesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOccurrencesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteOccurrenceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateOccurrenceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateOccurrenceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNoteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOccurrenceNoteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteNoteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateNoteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateNoteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNoteOccurrencesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNoteOccurrencesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateNotesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateNotesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateOccurrencesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_grafeas_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateOccurrencesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_proto_v1_grafeas_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Occurrence_Vulnerability)(nil),
		(*Occurrence_Build)(nil),
		(*Occurrence_Image)(nil),
		(*Occurrence_Package)(nil),
		(*Occurrence_Deployment)(nil),
		(*Occurrence_Discovery)(nil),
		(*Occurrence_Attestation)(nil),
		(*Occurrence_Upgrade)(nil),
		(*Occurrence_Compliance)(nil),
		(*Occurrence_DsseAttestation)(nil),
		(*Occurrence_SbomReference)(nil),
	}
	file_proto_v1_grafeas_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Note_Vulnerability)(nil),
		(*Note_Build)(nil),
		(*Note_Image)(nil),
		(*Note_Package)(nil),
		(*Note_Deployment)(nil),
		(*Note_Discovery)(nil),
		(*Note_Attestation)(nil),
		(*Note_Upgrade)(nil),
		(*Note_Compliance)(nil),
		(*Note_DsseAttestation)(nil),
		(*Note_VulnerabilityAssessment)(nil),
		(*Note_SbomReference)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_proto_v1_grafeas_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_proto_v1_grafeas_proto_goTypes,
		DependencyIndexes: file_proto_v1_grafeas_proto_depIdxs,
		MessageInfos:      file_proto_v1_grafeas_proto_msgTypes,
	}.Build()
	File_proto_v1_grafeas_proto = out.File
	file_proto_v1_grafeas_proto_rawDesc = nil
	file_proto_v1_grafeas_proto_goTypes = nil
	file_proto_v1_grafeas_proto_depIdxs = nil
}
