/*
Copyright 2019 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1beta1 "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeClusterTriggerBindings implements ClusterTriggerBindingInterface
type FakeClusterTriggerBindings struct {
	Fake *FakeTriggersV1beta1
}

var clustertriggerbindingsResource = v1beta1.SchemeGroupVersion.WithResource("clustertriggerbindings")

var clustertriggerbindingsKind = v1beta1.SchemeGroupVersion.WithKind("ClusterTriggerBinding")

// Get takes name of the clusterTriggerBinding, and returns the corresponding clusterTriggerBinding object, and an error if there is any.
func (c *FakeClusterTriggerBindings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.ClusterTriggerBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(clustertriggerbindingsResource, name), &v1beta1.ClusterTriggerBinding{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ClusterTriggerBinding), err
}

// List takes label and field selectors, and returns the list of ClusterTriggerBindings that match those selectors.
func (c *FakeClusterTriggerBindings) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.ClusterTriggerBindingList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(clustertriggerbindingsResource, clustertriggerbindingsKind, opts), &v1beta1.ClusterTriggerBindingList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.ClusterTriggerBindingList{ListMeta: obj.(*v1beta1.ClusterTriggerBindingList).ListMeta}
	for _, item := range obj.(*v1beta1.ClusterTriggerBindingList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested clusterTriggerBindings.
func (c *FakeClusterTriggerBindings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(clustertriggerbindingsResource, opts))
}

// Create takes the representation of a clusterTriggerBinding and creates it.  Returns the server's representation of the clusterTriggerBinding, and an error, if there is any.
func (c *FakeClusterTriggerBindings) Create(ctx context.Context, clusterTriggerBinding *v1beta1.ClusterTriggerBinding, opts v1.CreateOptions) (result *v1beta1.ClusterTriggerBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(clustertriggerbindingsResource, clusterTriggerBinding), &v1beta1.ClusterTriggerBinding{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ClusterTriggerBinding), err
}

// Update takes the representation of a clusterTriggerBinding and updates it. Returns the server's representation of the clusterTriggerBinding, and an error, if there is any.
func (c *FakeClusterTriggerBindings) Update(ctx context.Context, clusterTriggerBinding *v1beta1.ClusterTriggerBinding, opts v1.UpdateOptions) (result *v1beta1.ClusterTriggerBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(clustertriggerbindingsResource, clusterTriggerBinding), &v1beta1.ClusterTriggerBinding{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ClusterTriggerBinding), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeClusterTriggerBindings) UpdateStatus(ctx context.Context, clusterTriggerBinding *v1beta1.ClusterTriggerBinding, opts v1.UpdateOptions) (*v1beta1.ClusterTriggerBinding, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(clustertriggerbindingsResource, "status", clusterTriggerBinding), &v1beta1.ClusterTriggerBinding{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ClusterTriggerBinding), err
}

// Delete takes name of the clusterTriggerBinding and deletes it. Returns an error if one occurs.
func (c *FakeClusterTriggerBindings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(clustertriggerbindingsResource, name, opts), &v1beta1.ClusterTriggerBinding{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeClusterTriggerBindings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(clustertriggerbindingsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.ClusterTriggerBindingList{})
	return err
}

// Patch applies the patch and returns the patched clusterTriggerBinding.
func (c *FakeClusterTriggerBindings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ClusterTriggerBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(clustertriggerbindingsResource, name, pt, data, subresources...), &v1beta1.ClusterTriggerBinding{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ClusterTriggerBinding), err
}
