package alertsmanagementapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/alertsmanagement/mgmt/2019-03-01/alertsmanagement"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result alertsmanagement.OperationsListPage, err error)
	ListComplete(ctx context.Context) (result alertsmanagement.OperationsListIterator, err error)
}

var _ OperationsClientAPI = (*alertsmanagement.OperationsClient)(nil)

// AlertsClientAPI contains the set of methods on the AlertsClient type.
type AlertsClientAPI interface {
	ChangeState(ctx context.Context, alertID string, newState alertsmanagement.AlertState) (result alertsmanagement.Alert, err error)
	GetAll(ctx context.Context, targetResource string, targetResourceType string, targetResourceGroup string, monitorService alertsmanagement.MonitorService, monitorCondition alertsmanagement.MonitorCondition, severity alertsmanagement.Severity, alertState alertsmanagement.AlertState, alertRule string, smartGroupID string, includeContext *bool, includeEgressConfig *bool, pageCount *int32, sortBy alertsmanagement.AlertsSortByFields, sortOrder string, selectParameter string, timeRange alertsmanagement.TimeRange, customTimeRange string) (result alertsmanagement.AlertsListPage, err error)
	GetAllComplete(ctx context.Context, targetResource string, targetResourceType string, targetResourceGroup string, monitorService alertsmanagement.MonitorService, monitorCondition alertsmanagement.MonitorCondition, severity alertsmanagement.Severity, alertState alertsmanagement.AlertState, alertRule string, smartGroupID string, includeContext *bool, includeEgressConfig *bool, pageCount *int32, sortBy alertsmanagement.AlertsSortByFields, sortOrder string, selectParameter string, timeRange alertsmanagement.TimeRange, customTimeRange string) (result alertsmanagement.AlertsListIterator, err error)
	GetByID(ctx context.Context, alertID string) (result alertsmanagement.Alert, err error)
	GetHistory(ctx context.Context, alertID string) (result alertsmanagement.AlertModification, err error)
	GetSummary(ctx context.Context, groupby alertsmanagement.AlertsSummaryGroupByFields, includeSmartGroupsCount *bool, targetResource string, targetResourceType string, targetResourceGroup string, monitorService alertsmanagement.MonitorService, monitorCondition alertsmanagement.MonitorCondition, severity alertsmanagement.Severity, alertState alertsmanagement.AlertState, alertRule string, timeRange alertsmanagement.TimeRange, customTimeRange string) (result alertsmanagement.AlertsSummary, err error)
	MetaData(ctx context.Context) (result alertsmanagement.AlertsMetaData, err error)
}

var _ AlertsClientAPI = (*alertsmanagement.AlertsClient)(nil)

// SmartDetectorAlertRulesClientAPI contains the set of methods on the SmartDetectorAlertRulesClient type.
type SmartDetectorAlertRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, alertRuleName string, parameters alertsmanagement.AlertRule) (result alertsmanagement.AlertRule, err error)
	Delete(ctx context.Context, resourceGroupName string, alertRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, alertRuleName string, expandDetector *bool) (result alertsmanagement.AlertRule, err error)
	List(ctx context.Context) (result alertsmanagement.AlertRulesListPage, err error)
	ListComplete(ctx context.Context) (result alertsmanagement.AlertRulesListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result alertsmanagement.AlertRulesListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result alertsmanagement.AlertRulesListIterator, err error)
}

var _ SmartDetectorAlertRulesClientAPI = (*alertsmanagement.SmartDetectorAlertRulesClient)(nil)
