package blocks

import (
	"git.sr.ht/~bouncepaw/mycomarkup/v5/links"
)

// ImgEntry is an entry of an image gallery. It can only be nested into Img. V3: proper readers, encapsulate
type ImgEntry struct {
	Target      links.Link
	hyphaName   string
	width       string
	height      string
	description []Block
}

// NewImgEntry returns a new ImgEntry.
func NewImgEntry(target links.Link, hyphaName, width, height string, description []Block) ImgEntry {
	return ImgEntry{
		Target:      target,
		hyphaName:   hyphaName,
		width:       width,
		height:      height,
		description: description,
	}
}

// Width returns the width property of the entry.
func (entry ImgEntry) Width() string { return entry.width }

// Height returns the height property of the entry.
func (entry ImgEntry) Height() string { return entry.height }

// Description returns the description of the entry. The description is unparsed Mycomarkup string.
func (entry ImgEntry) Description() []Block { return entry.description }
