// Code generated by ./cmd/ch-gen-col, DO NOT EDIT.

package proto

// ColFloat64 represents Float64 column.
type ColFloat64 []float64

// Compile-time assertions for ColFloat64.
var (
	_ ColInput  = ColFloat64{}
	_ ColResult = (*ColFloat64)(nil)
	_ Column    = (*ColFloat64)(nil)
)

// Rows returns count of rows in column.
func (c ColFloat64) Rows() int {
	return len(c)
}

// Reset resets data in row, preserving capacity for efficiency.
func (c *ColFloat64) Reset() {
	*c = (*c)[:0]
}

// Type returns ColumnType of Float64.
func (ColFloat64) Type() ColumnType {
	return ColumnTypeFloat64
}

// Row returns i-th row of column.
func (c ColFloat64) Row(i int) float64 {
	return c[i]
}

// Append float64 to column.
func (c *ColFloat64) Append(v float64) {
	*c = append(*c, v)
}

// Append float64 slice to column.
func (c *ColFloat64) AppendArr(vs []float64) {
	*c = append(*c, vs...)
}

// LowCardinality returns LowCardinality for Float64 .
func (c *ColFloat64) LowCardinality() *ColLowCardinality[float64] {
	return &ColLowCardinality[float64]{
		index: c,
	}
}

// Array is helper that creates Array of float64.
func (c *ColFloat64) Array() *ColArr[float64] {
	return &ColArr[float64]{
		Data: c,
	}
}

// Nullable is helper that creates Nullable(float64).
func (c *ColFloat64) Nullable() *ColNullable[float64] {
	return &ColNullable[float64]{
		Values: c,
	}
}

// NewArrFloat64 returns new Array(Float64).
func NewArrFloat64() *ColArr[float64] {
	return &ColArr[float64]{
		Data: new(ColFloat64),
	}
}
