// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costandusagereportservice

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opDeleteReportDefinition = "DeleteReportDefinition"

// DeleteReportDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReportDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReportDefinition for more information on using the DeleteReportDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReportDefinitionRequest method.
//	req, resp := client.DeleteReportDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DeleteReportDefinition
func (c *CostandUsageReportService) DeleteReportDefinitionRequest(input *DeleteReportDefinitionInput) (req *request.Request, output *DeleteReportDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteReportDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReportDefinitionInput{}
	}

	output = &DeleteReportDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReportDefinition API operation for AWS Cost and Usage Report Service.
//
// Deletes the specified report. Any tags associated with the report are also
// deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost and Usage Report Service's
// API operation DeleteReportDefinition for usage and error information.
//
// Returned Error Types:
//
//   - InternalErrorException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DeleteReportDefinition
func (c *CostandUsageReportService) DeleteReportDefinition(input *DeleteReportDefinitionInput) (*DeleteReportDefinitionOutput, error) {
	req, out := c.DeleteReportDefinitionRequest(input)
	return out, req.Send()
}

// DeleteReportDefinitionWithContext is the same as DeleteReportDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReportDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) DeleteReportDefinitionWithContext(ctx aws.Context, input *DeleteReportDefinitionInput, opts ...request.Option) (*DeleteReportDefinitionOutput, error) {
	req, out := c.DeleteReportDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReportDefinitions = "DescribeReportDefinitions"

// DescribeReportDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReportDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReportDefinitions for more information on using the DescribeReportDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReportDefinitionsRequest method.
//	req, resp := client.DescribeReportDefinitionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions
func (c *CostandUsageReportService) DescribeReportDefinitionsRequest(input *DescribeReportDefinitionsInput) (req *request.Request, output *DescribeReportDefinitionsOutput) {
	op := &request.Operation{
		Name:       opDescribeReportDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReportDefinitionsInput{}
	}

	output = &DescribeReportDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReportDefinitions API operation for AWS Cost and Usage Report Service.
//
// Lists the Amazon Web Services Cost and Usage Report available to this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost and Usage Report Service's
// API operation DescribeReportDefinitions for usage and error information.
//
// Returned Error Types:
//   - InternalErrorException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions
func (c *CostandUsageReportService) DescribeReportDefinitions(input *DescribeReportDefinitionsInput) (*DescribeReportDefinitionsOutput, error) {
	req, out := c.DescribeReportDefinitionsRequest(input)
	return out, req.Send()
}

// DescribeReportDefinitionsWithContext is the same as DescribeReportDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReportDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) DescribeReportDefinitionsWithContext(ctx aws.Context, input *DescribeReportDefinitionsInput, opts ...request.Option) (*DescribeReportDefinitionsOutput, error) {
	req, out := c.DescribeReportDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReportDefinitionsPages iterates over the pages of a DescribeReportDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReportDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReportDefinitions operation.
//	pageNum := 0
//	err := client.DescribeReportDefinitionsPages(params,
//	    func(page *costandusagereportservice.DescribeReportDefinitionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CostandUsageReportService) DescribeReportDefinitionsPages(input *DescribeReportDefinitionsInput, fn func(*DescribeReportDefinitionsOutput, bool) bool) error {
	return c.DescribeReportDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReportDefinitionsPagesWithContext same as DescribeReportDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) DescribeReportDefinitionsPagesWithContext(ctx aws.Context, input *DescribeReportDefinitionsInput, fn func(*DescribeReportDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReportDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReportDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReportDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/ListTagsForResource
func (c *CostandUsageReportService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Cost and Usage Report Service.
//
// Lists the tags associated with the specified report definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost and Usage Report Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified report (ReportName) in the request doesn't exist.
//
//   - InternalErrorException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/ListTagsForResource
func (c *CostandUsageReportService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReportDefinition = "ModifyReportDefinition"

// ModifyReportDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReportDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReportDefinition for more information on using the ModifyReportDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyReportDefinitionRequest method.
//	req, resp := client.ModifyReportDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/ModifyReportDefinition
func (c *CostandUsageReportService) ModifyReportDefinitionRequest(input *ModifyReportDefinitionInput) (req *request.Request, output *ModifyReportDefinitionOutput) {
	op := &request.Operation{
		Name:       opModifyReportDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReportDefinitionInput{}
	}

	output = &ModifyReportDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyReportDefinition API operation for AWS Cost and Usage Report Service.
//
// Allows you to programmatically update your report preferences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost and Usage Report Service's
// API operation ModifyReportDefinition for usage and error information.
//
// Returned Error Types:
//
//   - InternalErrorException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/ModifyReportDefinition
func (c *CostandUsageReportService) ModifyReportDefinition(input *ModifyReportDefinitionInput) (*ModifyReportDefinitionOutput, error) {
	req, out := c.ModifyReportDefinitionRequest(input)
	return out, req.Send()
}

// ModifyReportDefinitionWithContext is the same as ModifyReportDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReportDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) ModifyReportDefinitionWithContext(ctx aws.Context, input *ModifyReportDefinitionInput, opts ...request.Option) (*ModifyReportDefinitionOutput, error) {
	req, out := c.ModifyReportDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutReportDefinition = "PutReportDefinition"

// PutReportDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the PutReportDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutReportDefinition for more information on using the PutReportDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutReportDefinitionRequest method.
//	req, resp := client.PutReportDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/PutReportDefinition
func (c *CostandUsageReportService) PutReportDefinitionRequest(input *PutReportDefinitionInput) (req *request.Request, output *PutReportDefinitionOutput) {
	op := &request.Operation{
		Name:       opPutReportDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutReportDefinitionInput{}
	}

	output = &PutReportDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutReportDefinition API operation for AWS Cost and Usage Report Service.
//
// Creates a new report using the description that you provide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost and Usage Report Service's
// API operation PutReportDefinition for usage and error information.
//
// Returned Error Types:
//
//   - DuplicateReportNameException
//     A report with the specified name already exists in the account. Specify a
//     different report name.
//
//   - ReportLimitReachedException
//     This account already has five reports defined. To define a new report, you
//     must delete an existing report.
//
//   - InternalErrorException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The specified report (ReportName) in the request doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/PutReportDefinition
func (c *CostandUsageReportService) PutReportDefinition(input *PutReportDefinitionInput) (*PutReportDefinitionOutput, error) {
	req, out := c.PutReportDefinitionRequest(input)
	return out, req.Send()
}

// PutReportDefinitionWithContext is the same as PutReportDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See PutReportDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) PutReportDefinitionWithContext(ctx aws.Context, input *PutReportDefinitionInput, opts ...request.Option) (*PutReportDefinitionOutput, error) {
	req, out := c.PutReportDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/TagResource
func (c *CostandUsageReportService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Cost and Usage Report Service.
//
// Associates a set of tags with a report definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost and Usage Report Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified report (ReportName) in the request doesn't exist.
//
//   - InternalErrorException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/TagResource
func (c *CostandUsageReportService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/UntagResource
func (c *CostandUsageReportService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Cost and Usage Report Service.
//
// Disassociates a set of tags from a report definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost and Usage Report Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified report (ReportName) in the request doesn't exist.
//
//   - InternalErrorException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/UntagResource
func (c *CostandUsageReportService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Deletes the specified report.
type DeleteReportDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The name of the report that you want to delete. The name must be unique,
	// is case sensitive, and can't include spaces.
	//
	// ReportName is a required field
	ReportName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReportDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReportDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReportDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReportDefinitionInput"}
	if s.ReportName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportName sets the ReportName field's value.
func (s *DeleteReportDefinitionInput) SetReportName(v string) *DeleteReportDefinitionInput {
	s.ReportName = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response.
type DeleteReportDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// Whether the deletion was successful or not.
	ResponseMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReportDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReportDefinitionOutput) GoString() string {
	return s.String()
}

// SetResponseMessage sets the ResponseMessage field's value.
func (s *DeleteReportDefinitionOutput) SetResponseMessage(v string) *DeleteReportDefinitionOutput {
	s.ResponseMessage = &v
	return s
}

// Requests a Amazon Web Services Cost and Usage Report list owned by the account.
type DescribeReportDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that Amazon Web Services returns for the operation.
	MaxResults *int64 `min:"5" type:"integer"`

	// A generic string.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportDefinitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReportDefinitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReportDefinitionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReportDefinitionsInput) SetMaxResults(v int64) *DescribeReportDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReportDefinitionsInput) SetNextToken(v string) *DescribeReportDefinitionsInput {
	s.NextToken = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response.
type DescribeReportDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// A generic string.
	NextToken *string `type:"string"`

	// An Amazon Web Services Cost and Usage Report list owned by the account.
	ReportDefinitions []*ReportDefinition `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportDefinitionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReportDefinitionsOutput) SetNextToken(v string) *DescribeReportDefinitionsOutput {
	s.NextToken = &v
	return s
}

// SetReportDefinitions sets the ReportDefinitions field's value.
func (s *DescribeReportDefinitionsOutput) SetReportDefinitions(v []*ReportDefinition) *DescribeReportDefinitionsOutput {
	s.ReportDefinitions = v
	return s
}

// A report with the specified name already exists in the account. Specify a
// different report name.
type DuplicateReportNameException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message to show the detail of the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateReportNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateReportNameException) GoString() string {
	return s.String()
}

func newErrorDuplicateReportNameException(v protocol.ResponseMetadata) error {
	return &DuplicateReportNameException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateReportNameException) Code() string {
	return "DuplicateReportNameException"
}

// Message returns the exception's message.
func (s *DuplicateReportNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateReportNameException) OrigErr() error {
	return nil
}

func (s *DuplicateReportNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateReportNameException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateReportNameException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An error on the server occurred during the processing of your request. Try
// again later.
type InternalErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message to show the detail of the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalErrorException) GoString() string {
	return s.String()
}

func newErrorInternalErrorException(v protocol.ResponseMetadata) error {
	return &InternalErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalErrorException) Code() string {
	return "InternalErrorException"
}

// Message returns the exception's message.
func (s *InternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalErrorException) OrigErr() error {
	return nil
}

func (s *InternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The report name of the report definition that tags are to be returned for.
	//
	// ReportName is a required field
	ReportName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ReportName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportName sets the ReportName field's value.
func (s *ListTagsForResourceInput) SetReportName(v string) *ListTagsForResourceInput {
	s.ReportName = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags assigned to the report definition resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ModifyReportDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The definition of Amazon Web Services Cost and Usage Report. You can specify
	// the report name, time unit, report format, compression format, S3 bucket,
	// additional artifacts, and schema elements in the definition.
	//
	// ReportDefinition is a required field
	ReportDefinition *ReportDefinition `type:"structure" required:"true"`

	// The name of the report that you want to create. The name must be unique,
	// is case sensitive, and can't include spaces.
	//
	// ReportName is a required field
	ReportName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyReportDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyReportDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReportDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReportDefinitionInput"}
	if s.ReportDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportDefinition"))
	}
	if s.ReportName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportName"))
	}
	if s.ReportDefinition != nil {
		if err := s.ReportDefinition.Validate(); err != nil {
			invalidParams.AddNested("ReportDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportDefinition sets the ReportDefinition field's value.
func (s *ModifyReportDefinitionInput) SetReportDefinition(v *ReportDefinition) *ModifyReportDefinitionInput {
	s.ReportDefinition = v
	return s
}

// SetReportName sets the ReportName field's value.
func (s *ModifyReportDefinitionInput) SetReportName(v string) *ModifyReportDefinitionInput {
	s.ReportName = &v
	return s
}

type ModifyReportDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyReportDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyReportDefinitionOutput) GoString() string {
	return s.String()
}

// Creates a Cost and Usage Report.
type PutReportDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Represents the output of the PutReportDefinition operation. The content consists
	// of the detailed metadata and data file information.
	//
	// ReportDefinition is a required field
	ReportDefinition *ReportDefinition `type:"structure" required:"true"`

	// The tags to be assigned to the report definition resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutReportDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutReportDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutReportDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutReportDefinitionInput"}
	if s.ReportDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportDefinition"))
	}
	if s.ReportDefinition != nil {
		if err := s.ReportDefinition.Validate(); err != nil {
			invalidParams.AddNested("ReportDefinition", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportDefinition sets the ReportDefinition field's value.
func (s *PutReportDefinitionInput) SetReportDefinition(v *ReportDefinition) *PutReportDefinitionInput {
	s.ReportDefinition = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutReportDefinitionInput) SetTags(v []*Tag) *PutReportDefinitionInput {
	s.Tags = v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
type PutReportDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutReportDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutReportDefinitionOutput) GoString() string {
	return s.String()
}

// The definition of Amazon Web Services Cost and Usage Report. You can specify
// the report name, time unit, report format, compression format, S3 bucket,
// additional artifacts, and schema elements in the definition.
type ReportDefinition struct {
	_ struct{} `type:"structure"`

	// A list of manifests that you want Amazon Web Services to create for this
	// report.
	AdditionalArtifacts []*string `type:"list" enum:"AdditionalArtifact"`

	// A list of strings that indicate additional content that Amazon Web Services
	// includes in the report, such as individual resource IDs.
	//
	// AdditionalSchemaElements is a required field
	AdditionalSchemaElements []*string `type:"list" required:"true" enum:"SchemaElement"`

	// The Amazon resource name of the billing view. The BillingViewArn is needed
	// to create Amazon Web Services Cost and Usage Report for each billing group
	// maintained in the Amazon Web Services Billing Conductor service. The BillingViewArn
	// for a billing group can be constructed as: arn:aws:billing::payer-account-id:billingview/billing-group-primary-account-id
	BillingViewArn *string `type:"string"`

	// The compression format that Amazon Web Services uses for the report.
	//
	// Compression is a required field
	Compression *string `type:"string" required:"true" enum:"CompressionFormat"`

	// The format that Amazon Web Services saves the report in.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"ReportFormat"`

	// Whether you want Amazon Web Services to update your reports after they have
	// been finalized if Amazon Web Services detects charges related to previous
	// months. These charges can include refunds, credits, or support fees.
	RefreshClosedReports *bool `type:"boolean"`

	// The name of the report that you want to create. The name must be unique,
	// is case sensitive, and can't include spaces.
	//
	// ReportName is a required field
	ReportName *string `type:"string" required:"true"`

	// The status of the report.
	ReportStatus *ReportStatus `type:"structure"`

	// Whether you want Amazon Web Services to overwrite the previous version of
	// each report or to deliver the report in addition to the previous versions.
	ReportVersioning *string `type:"string" enum:"ReportVersioning"`

	// The S3 bucket where Amazon Web Services delivers the report.
	//
	// S3Bucket is a required field
	S3Bucket *string `type:"string" required:"true"`

	// The prefix that Amazon Web Services adds to the report name when Amazon Web
	// Services delivers the report. Your prefix can't include spaces.
	//
	// S3Prefix is a required field
	S3Prefix *string `type:"string" required:"true"`

	// The region of the S3 bucket that Amazon Web Services delivers the report
	// into.
	//
	// S3Region is a required field
	S3Region *string `type:"string" required:"true" enum:"AWSRegion"`

	// The length of time covered by the report.
	//
	// TimeUnit is a required field
	TimeUnit *string `type:"string" required:"true" enum:"TimeUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReportDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReportDefinition"}
	if s.AdditionalSchemaElements == nil {
		invalidParams.Add(request.NewErrParamRequired("AdditionalSchemaElements"))
	}
	if s.Compression == nil {
		invalidParams.Add(request.NewErrParamRequired("Compression"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.ReportName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportName"))
	}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Prefix"))
	}
	if s.S3Region == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Region"))
	}
	if s.TimeUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeUnit"))
	}
	if s.ReportStatus != nil {
		if err := s.ReportStatus.Validate(); err != nil {
			invalidParams.AddNested("ReportStatus", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalArtifacts sets the AdditionalArtifacts field's value.
func (s *ReportDefinition) SetAdditionalArtifacts(v []*string) *ReportDefinition {
	s.AdditionalArtifacts = v
	return s
}

// SetAdditionalSchemaElements sets the AdditionalSchemaElements field's value.
func (s *ReportDefinition) SetAdditionalSchemaElements(v []*string) *ReportDefinition {
	s.AdditionalSchemaElements = v
	return s
}

// SetBillingViewArn sets the BillingViewArn field's value.
func (s *ReportDefinition) SetBillingViewArn(v string) *ReportDefinition {
	s.BillingViewArn = &v
	return s
}

// SetCompression sets the Compression field's value.
func (s *ReportDefinition) SetCompression(v string) *ReportDefinition {
	s.Compression = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ReportDefinition) SetFormat(v string) *ReportDefinition {
	s.Format = &v
	return s
}

// SetRefreshClosedReports sets the RefreshClosedReports field's value.
func (s *ReportDefinition) SetRefreshClosedReports(v bool) *ReportDefinition {
	s.RefreshClosedReports = &v
	return s
}

// SetReportName sets the ReportName field's value.
func (s *ReportDefinition) SetReportName(v string) *ReportDefinition {
	s.ReportName = &v
	return s
}

// SetReportStatus sets the ReportStatus field's value.
func (s *ReportDefinition) SetReportStatus(v *ReportStatus) *ReportDefinition {
	s.ReportStatus = v
	return s
}

// SetReportVersioning sets the ReportVersioning field's value.
func (s *ReportDefinition) SetReportVersioning(v string) *ReportDefinition {
	s.ReportVersioning = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *ReportDefinition) SetS3Bucket(v string) *ReportDefinition {
	s.S3Bucket = &v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *ReportDefinition) SetS3Prefix(v string) *ReportDefinition {
	s.S3Prefix = &v
	return s
}

// SetS3Region sets the S3Region field's value.
func (s *ReportDefinition) SetS3Region(v string) *ReportDefinition {
	s.S3Region = &v
	return s
}

// SetTimeUnit sets the TimeUnit field's value.
func (s *ReportDefinition) SetTimeUnit(v string) *ReportDefinition {
	s.TimeUnit = &v
	return s
}

// This account already has five reports defined. To define a new report, you
// must delete an existing report.
type ReportLimitReachedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message to show the detail of the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportLimitReachedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportLimitReachedException) GoString() string {
	return s.String()
}

func newErrorReportLimitReachedException(v protocol.ResponseMetadata) error {
	return &ReportLimitReachedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ReportLimitReachedException) Code() string {
	return "ReportLimitReachedException"
}

// Message returns the exception's message.
func (s *ReportLimitReachedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ReportLimitReachedException) OrigErr() error {
	return nil
}

func (s *ReportLimitReachedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ReportLimitReachedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ReportLimitReachedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A two element dictionary with a lastDelivery and lastStatus key whose values
// describe the date and status of the last delivered report for a particular
// report definition.
type ReportStatus struct {
	_ struct{} `type:"structure"`

	// A timestamp that gives the date of a report delivery.
	LastDelivery *string `locationName:"lastDelivery" min:"16" type:"string"`

	// An enum that gives the status of a report delivery.
	LastStatus *string `locationName:"lastStatus" type:"string" enum:"LastStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportStatus) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReportStatus) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReportStatus"}
	if s.LastDelivery != nil && len(*s.LastDelivery) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("LastDelivery", 16))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLastDelivery sets the LastDelivery field's value.
func (s *ReportStatus) SetLastDelivery(v string) *ReportStatus {
	s.LastDelivery = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *ReportStatus) SetLastStatus(v string) *ReportStatus {
	s.LastStatus = &v
	return s
}

// The specified report (ReportName) in the request doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message to show the detail of the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a tag. A tag is a key-value pair. You can add up to 50 tags to
// a report definition.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag. Tag keys are case sensitive. Each report definition can
	// only have up to one tag with the same key. If you try to add an existing
	// tag with the same key, the existing tag value will be updated to the new
	// value.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag. Tag values are case-sensitive. This can be an empty
	// string.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The report name of the report definition that tags are to be associated with.
	//
	// ReportName is a required field
	ReportName *string `type:"string" required:"true"`

	// The tags to be assigned to the report definition resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ReportName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportName"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportName sets the ReportName field's value.
func (s *TagResourceInput) SetReportName(v string) *TagResourceInput {
	s.ReportName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The report name of the report definition that tags are to be disassociated
	// from.
	//
	// ReportName is a required field
	ReportName *string `type:"string" required:"true"`

	// The tags to be disassociated from the report definition resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ReportName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportName"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportName sets the ReportName field's value.
func (s *UntagResourceInput) SetReportName(v string) *UntagResourceInput {
	s.ReportName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message to show the detail of the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The region of the S3 bucket that Amazon Web Services delivers the report
// into.
const (
	// AWSRegionAfSouth1 is a AWSRegion enum value
	AWSRegionAfSouth1 = "af-south-1"

	// AWSRegionApEast1 is a AWSRegion enum value
	AWSRegionApEast1 = "ap-east-1"

	// AWSRegionApSouth1 is a AWSRegion enum value
	AWSRegionApSouth1 = "ap-south-1"

	// AWSRegionApSouth2 is a AWSRegion enum value
	AWSRegionApSouth2 = "ap-south-2"

	// AWSRegionApSoutheast1 is a AWSRegion enum value
	AWSRegionApSoutheast1 = "ap-southeast-1"

	// AWSRegionApSoutheast2 is a AWSRegion enum value
	AWSRegionApSoutheast2 = "ap-southeast-2"

	// AWSRegionApSoutheast3 is a AWSRegion enum value
	AWSRegionApSoutheast3 = "ap-southeast-3"

	// AWSRegionApNortheast1 is a AWSRegion enum value
	AWSRegionApNortheast1 = "ap-northeast-1"

	// AWSRegionApNortheast2 is a AWSRegion enum value
	AWSRegionApNortheast2 = "ap-northeast-2"

	// AWSRegionApNortheast3 is a AWSRegion enum value
	AWSRegionApNortheast3 = "ap-northeast-3"

	// AWSRegionCaCentral1 is a AWSRegion enum value
	AWSRegionCaCentral1 = "ca-central-1"

	// AWSRegionEuCentral1 is a AWSRegion enum value
	AWSRegionEuCentral1 = "eu-central-1"

	// AWSRegionEuCentral2 is a AWSRegion enum value
	AWSRegionEuCentral2 = "eu-central-2"

	// AWSRegionEuWest1 is a AWSRegion enum value
	AWSRegionEuWest1 = "eu-west-1"

	// AWSRegionEuWest2 is a AWSRegion enum value
	AWSRegionEuWest2 = "eu-west-2"

	// AWSRegionEuWest3 is a AWSRegion enum value
	AWSRegionEuWest3 = "eu-west-3"

	// AWSRegionEuNorth1 is a AWSRegion enum value
	AWSRegionEuNorth1 = "eu-north-1"

	// AWSRegionEuSouth1 is a AWSRegion enum value
	AWSRegionEuSouth1 = "eu-south-1"

	// AWSRegionEuSouth2 is a AWSRegion enum value
	AWSRegionEuSouth2 = "eu-south-2"

	// AWSRegionMeCentral1 is a AWSRegion enum value
	AWSRegionMeCentral1 = "me-central-1"

	// AWSRegionMeSouth1 is a AWSRegion enum value
	AWSRegionMeSouth1 = "me-south-1"

	// AWSRegionSaEast1 is a AWSRegion enum value
	AWSRegionSaEast1 = "sa-east-1"

	// AWSRegionUsEast1 is a AWSRegion enum value
	AWSRegionUsEast1 = "us-east-1"

	// AWSRegionUsEast2 is a AWSRegion enum value
	AWSRegionUsEast2 = "us-east-2"

	// AWSRegionUsWest1 is a AWSRegion enum value
	AWSRegionUsWest1 = "us-west-1"

	// AWSRegionUsWest2 is a AWSRegion enum value
	AWSRegionUsWest2 = "us-west-2"

	// AWSRegionCnNorth1 is a AWSRegion enum value
	AWSRegionCnNorth1 = "cn-north-1"

	// AWSRegionCnNorthwest1 is a AWSRegion enum value
	AWSRegionCnNorthwest1 = "cn-northwest-1"
)

// AWSRegion_Values returns all elements of the AWSRegion enum
func AWSRegion_Values() []string {
	return []string{
		AWSRegionAfSouth1,
		AWSRegionApEast1,
		AWSRegionApSouth1,
		AWSRegionApSouth2,
		AWSRegionApSoutheast1,
		AWSRegionApSoutheast2,
		AWSRegionApSoutheast3,
		AWSRegionApNortheast1,
		AWSRegionApNortheast2,
		AWSRegionApNortheast3,
		AWSRegionCaCentral1,
		AWSRegionEuCentral1,
		AWSRegionEuCentral2,
		AWSRegionEuWest1,
		AWSRegionEuWest2,
		AWSRegionEuWest3,
		AWSRegionEuNorth1,
		AWSRegionEuSouth1,
		AWSRegionEuSouth2,
		AWSRegionMeCentral1,
		AWSRegionMeSouth1,
		AWSRegionSaEast1,
		AWSRegionUsEast1,
		AWSRegionUsEast2,
		AWSRegionUsWest1,
		AWSRegionUsWest2,
		AWSRegionCnNorth1,
		AWSRegionCnNorthwest1,
	}
}

// The types of manifest that you want Amazon Web Services to create for this
// report.
const (
	// AdditionalArtifactRedshift is a AdditionalArtifact enum value
	AdditionalArtifactRedshift = "REDSHIFT"

	// AdditionalArtifactQuicksight is a AdditionalArtifact enum value
	AdditionalArtifactQuicksight = "QUICKSIGHT"

	// AdditionalArtifactAthena is a AdditionalArtifact enum value
	AdditionalArtifactAthena = "ATHENA"
)

// AdditionalArtifact_Values returns all elements of the AdditionalArtifact enum
func AdditionalArtifact_Values() []string {
	return []string{
		AdditionalArtifactRedshift,
		AdditionalArtifactQuicksight,
		AdditionalArtifactAthena,
	}
}

// The compression format that Amazon Web Services uses for the report.
const (
	// CompressionFormatZip is a CompressionFormat enum value
	CompressionFormatZip = "ZIP"

	// CompressionFormatGzip is a CompressionFormat enum value
	CompressionFormatGzip = "GZIP"

	// CompressionFormatParquet is a CompressionFormat enum value
	CompressionFormatParquet = "Parquet"
)

// CompressionFormat_Values returns all elements of the CompressionFormat enum
func CompressionFormat_Values() []string {
	return []string{
		CompressionFormatZip,
		CompressionFormatGzip,
		CompressionFormatParquet,
	}
}

const (
	// LastStatusSuccess is a LastStatus enum value
	LastStatusSuccess = "SUCCESS"

	// LastStatusErrorPermissions is a LastStatus enum value
	LastStatusErrorPermissions = "ERROR_PERMISSIONS"

	// LastStatusErrorNoBucket is a LastStatus enum value
	LastStatusErrorNoBucket = "ERROR_NO_BUCKET"
)

// LastStatus_Values returns all elements of the LastStatus enum
func LastStatus_Values() []string {
	return []string{
		LastStatusSuccess,
		LastStatusErrorPermissions,
		LastStatusErrorNoBucket,
	}
}

// The format that Amazon Web Services saves the report in.
const (
	// ReportFormatTextOrcsv is a ReportFormat enum value
	ReportFormatTextOrcsv = "textORcsv"

	// ReportFormatParquet is a ReportFormat enum value
	ReportFormatParquet = "Parquet"
)

// ReportFormat_Values returns all elements of the ReportFormat enum
func ReportFormat_Values() []string {
	return []string{
		ReportFormatTextOrcsv,
		ReportFormatParquet,
	}
}

const (
	// ReportVersioningCreateNewReport is a ReportVersioning enum value
	ReportVersioningCreateNewReport = "CREATE_NEW_REPORT"

	// ReportVersioningOverwriteReport is a ReportVersioning enum value
	ReportVersioningOverwriteReport = "OVERWRITE_REPORT"
)

// ReportVersioning_Values returns all elements of the ReportVersioning enum
func ReportVersioning_Values() []string {
	return []string{
		ReportVersioningCreateNewReport,
		ReportVersioningOverwriteReport,
	}
}

// Whether or not Amazon Web Services includes resource IDs in the report.
const (
	// SchemaElementResources is a SchemaElement enum value
	SchemaElementResources = "RESOURCES"

	// SchemaElementSplitCostAllocationData is a SchemaElement enum value
	SchemaElementSplitCostAllocationData = "SPLIT_COST_ALLOCATION_DATA"

	// SchemaElementManualDiscountCompatibility is a SchemaElement enum value
	SchemaElementManualDiscountCompatibility = "MANUAL_DISCOUNT_COMPATIBILITY"
)

// SchemaElement_Values returns all elements of the SchemaElement enum
func SchemaElement_Values() []string {
	return []string{
		SchemaElementResources,
		SchemaElementSplitCostAllocationData,
		SchemaElementManualDiscountCompatibility,
	}
}

// The length of time covered by the report.
const (
	// TimeUnitHourly is a TimeUnit enum value
	TimeUnitHourly = "HOURLY"

	// TimeUnitDaily is a TimeUnit enum value
	TimeUnitDaily = "DAILY"

	// TimeUnitMonthly is a TimeUnit enum value
	TimeUnitMonthly = "MONTHLY"
)

// TimeUnit_Values returns all elements of the TimeUnit enum
func TimeUnit_Values() []string {
	return []string{
		TimeUnitHourly,
		TimeUnitDaily,
		TimeUnitMonthly,
	}
}
