// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package repostspaceiface provides an interface to enable mocking the AWS re:Post Private service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package repostspaceiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/repostspace"
)

// RepostspaceAPI provides an interface to enable mocking the
// repostspace.Repostspace service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS re:Post Private.
//	func myFunc(svc repostspaceiface.RepostspaceAPI) bool {
//	    // Make svc.CreateSpace request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := repostspace.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockRepostspaceClient struct {
//	    repostspaceiface.RepostspaceAPI
//	}
//	func (m *mockRepostspaceClient) CreateSpace(input *repostspace.CreateSpaceInput) (*repostspace.CreateSpaceOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockRepostspaceClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type RepostspaceAPI interface {
	CreateSpace(*repostspace.CreateSpaceInput) (*repostspace.CreateSpaceOutput, error)
	CreateSpaceWithContext(aws.Context, *repostspace.CreateSpaceInput, ...request.Option) (*repostspace.CreateSpaceOutput, error)
	CreateSpaceRequest(*repostspace.CreateSpaceInput) (*request.Request, *repostspace.CreateSpaceOutput)

	DeleteSpace(*repostspace.DeleteSpaceInput) (*repostspace.DeleteSpaceOutput, error)
	DeleteSpaceWithContext(aws.Context, *repostspace.DeleteSpaceInput, ...request.Option) (*repostspace.DeleteSpaceOutput, error)
	DeleteSpaceRequest(*repostspace.DeleteSpaceInput) (*request.Request, *repostspace.DeleteSpaceOutput)

	DeregisterAdmin(*repostspace.DeregisterAdminInput) (*repostspace.DeregisterAdminOutput, error)
	DeregisterAdminWithContext(aws.Context, *repostspace.DeregisterAdminInput, ...request.Option) (*repostspace.DeregisterAdminOutput, error)
	DeregisterAdminRequest(*repostspace.DeregisterAdminInput) (*request.Request, *repostspace.DeregisterAdminOutput)

	GetSpace(*repostspace.GetSpaceInput) (*repostspace.GetSpaceOutput, error)
	GetSpaceWithContext(aws.Context, *repostspace.GetSpaceInput, ...request.Option) (*repostspace.GetSpaceOutput, error)
	GetSpaceRequest(*repostspace.GetSpaceInput) (*request.Request, *repostspace.GetSpaceOutput)

	ListSpaces(*repostspace.ListSpacesInput) (*repostspace.ListSpacesOutput, error)
	ListSpacesWithContext(aws.Context, *repostspace.ListSpacesInput, ...request.Option) (*repostspace.ListSpacesOutput, error)
	ListSpacesRequest(*repostspace.ListSpacesInput) (*request.Request, *repostspace.ListSpacesOutput)

	ListSpacesPages(*repostspace.ListSpacesInput, func(*repostspace.ListSpacesOutput, bool) bool) error
	ListSpacesPagesWithContext(aws.Context, *repostspace.ListSpacesInput, func(*repostspace.ListSpacesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*repostspace.ListTagsForResourceInput) (*repostspace.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *repostspace.ListTagsForResourceInput, ...request.Option) (*repostspace.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*repostspace.ListTagsForResourceInput) (*request.Request, *repostspace.ListTagsForResourceOutput)

	RegisterAdmin(*repostspace.RegisterAdminInput) (*repostspace.RegisterAdminOutput, error)
	RegisterAdminWithContext(aws.Context, *repostspace.RegisterAdminInput, ...request.Option) (*repostspace.RegisterAdminOutput, error)
	RegisterAdminRequest(*repostspace.RegisterAdminInput) (*request.Request, *repostspace.RegisterAdminOutput)

	SendInvites(*repostspace.SendInvitesInput) (*repostspace.SendInvitesOutput, error)
	SendInvitesWithContext(aws.Context, *repostspace.SendInvitesInput, ...request.Option) (*repostspace.SendInvitesOutput, error)
	SendInvitesRequest(*repostspace.SendInvitesInput) (*request.Request, *repostspace.SendInvitesOutput)

	TagResource(*repostspace.TagResourceInput) (*repostspace.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *repostspace.TagResourceInput, ...request.Option) (*repostspace.TagResourceOutput, error)
	TagResourceRequest(*repostspace.TagResourceInput) (*request.Request, *repostspace.TagResourceOutput)

	UntagResource(*repostspace.UntagResourceInput) (*repostspace.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *repostspace.UntagResourceInput, ...request.Option) (*repostspace.UntagResourceOutput, error)
	UntagResourceRequest(*repostspace.UntagResourceInput) (*request.Request, *repostspace.UntagResourceOutput)

	UpdateSpace(*repostspace.UpdateSpaceInput) (*repostspace.UpdateSpaceOutput, error)
	UpdateSpaceWithContext(aws.Context, *repostspace.UpdateSpaceInput, ...request.Option) (*repostspace.UpdateSpaceOutput, error)
	UpdateSpaceRequest(*repostspace.UpdateSpaceInput) (*request.Request, *repostspace.UpdateSpaceOutput)
}

var _ RepostspaceAPI = (*repostspace.Repostspace)(nil)
