// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package drs

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateSourceNetworkStack = "AssociateSourceNetworkStack"

// AssociateSourceNetworkStackRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSourceNetworkStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSourceNetworkStack for more information on using the AssociateSourceNetworkStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateSourceNetworkStackRequest method.
//	req, resp := client.AssociateSourceNetworkStackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/AssociateSourceNetworkStack
func (c *Drs) AssociateSourceNetworkStackRequest(input *AssociateSourceNetworkStackInput) (req *request.Request, output *AssociateSourceNetworkStackOutput) {
	op := &request.Operation{
		Name:       opAssociateSourceNetworkStack,
		HTTPMethod: "POST",
		HTTPPath:   "/AssociateSourceNetworkStack",
	}

	if input == nil {
		input = &AssociateSourceNetworkStackInput{}
	}

	output = &AssociateSourceNetworkStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateSourceNetworkStack API operation for Elastic Disaster Recovery Service.
//
// Associate a Source Network to an existing CloudFormation Stack and modify
// launch templates to use this network. Can be used for reverting to previously
// deployed CloudFormation stacks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation AssociateSourceNetworkStack for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ServiceQuotaExceededException
//     The request could not be completed because its exceeded the service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/AssociateSourceNetworkStack
func (c *Drs) AssociateSourceNetworkStack(input *AssociateSourceNetworkStackInput) (*AssociateSourceNetworkStackOutput, error) {
	req, out := c.AssociateSourceNetworkStackRequest(input)
	return out, req.Send()
}

// AssociateSourceNetworkStackWithContext is the same as AssociateSourceNetworkStack with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSourceNetworkStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) AssociateSourceNetworkStackWithContext(ctx aws.Context, input *AssociateSourceNetworkStackInput, opts ...request.Option) (*AssociateSourceNetworkStackOutput, error) {
	req, out := c.AssociateSourceNetworkStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExtendedSourceServer = "CreateExtendedSourceServer"

// CreateExtendedSourceServerRequest generates a "aws/request.Request" representing the
// client's request for the CreateExtendedSourceServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExtendedSourceServer for more information on using the CreateExtendedSourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateExtendedSourceServerRequest method.
//	req, resp := client.CreateExtendedSourceServerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateExtendedSourceServer
func (c *Drs) CreateExtendedSourceServerRequest(input *CreateExtendedSourceServerInput) (req *request.Request, output *CreateExtendedSourceServerOutput) {
	op := &request.Operation{
		Name:       opCreateExtendedSourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateExtendedSourceServer",
	}

	if input == nil {
		input = &CreateExtendedSourceServerInput{}
	}

	output = &CreateExtendedSourceServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExtendedSourceServer API operation for Elastic Disaster Recovery Service.
//
// Create an extended source server in the target Account based on the source
// server in staging account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation CreateExtendedSourceServer for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ServiceQuotaExceededException
//     The request could not be completed because its exceeded the service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateExtendedSourceServer
func (c *Drs) CreateExtendedSourceServer(input *CreateExtendedSourceServerInput) (*CreateExtendedSourceServerOutput, error) {
	req, out := c.CreateExtendedSourceServerRequest(input)
	return out, req.Send()
}

// CreateExtendedSourceServerWithContext is the same as CreateExtendedSourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExtendedSourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) CreateExtendedSourceServerWithContext(ctx aws.Context, input *CreateExtendedSourceServerInput, opts ...request.Option) (*CreateExtendedSourceServerOutput, error) {
	req, out := c.CreateExtendedSourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLaunchConfigurationTemplate = "CreateLaunchConfigurationTemplate"

// CreateLaunchConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateLaunchConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLaunchConfigurationTemplate for more information on using the CreateLaunchConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLaunchConfigurationTemplateRequest method.
//	req, resp := client.CreateLaunchConfigurationTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateLaunchConfigurationTemplate
func (c *Drs) CreateLaunchConfigurationTemplateRequest(input *CreateLaunchConfigurationTemplateInput) (req *request.Request, output *CreateLaunchConfigurationTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateLaunchConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateLaunchConfigurationTemplate",
	}

	if input == nil {
		input = &CreateLaunchConfigurationTemplateInput{}
	}

	output = &CreateLaunchConfigurationTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLaunchConfigurationTemplate API operation for Elastic Disaster Recovery Service.
//
// Creates a new Launch Configuration Template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation CreateLaunchConfigurationTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ServiceQuotaExceededException
//     The request could not be completed because its exceeded the service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateLaunchConfigurationTemplate
func (c *Drs) CreateLaunchConfigurationTemplate(input *CreateLaunchConfigurationTemplateInput) (*CreateLaunchConfigurationTemplateOutput, error) {
	req, out := c.CreateLaunchConfigurationTemplateRequest(input)
	return out, req.Send()
}

// CreateLaunchConfigurationTemplateWithContext is the same as CreateLaunchConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLaunchConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) CreateLaunchConfigurationTemplateWithContext(ctx aws.Context, input *CreateLaunchConfigurationTemplateInput, opts ...request.Option) (*CreateLaunchConfigurationTemplateOutput, error) {
	req, out := c.CreateLaunchConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationConfigurationTemplate = "CreateReplicationConfigurationTemplate"

// CreateReplicationConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationConfigurationTemplate for more information on using the CreateReplicationConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReplicationConfigurationTemplateRequest method.
//	req, resp := client.CreateReplicationConfigurationTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateReplicationConfigurationTemplate
func (c *Drs) CreateReplicationConfigurationTemplateRequest(input *CreateReplicationConfigurationTemplateInput) (req *request.Request, output *CreateReplicationConfigurationTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateReplicationConfigurationTemplate",
	}

	if input == nil {
		input = &CreateReplicationConfigurationTemplateInput{}
	}

	output = &CreateReplicationConfigurationTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationConfigurationTemplate API operation for Elastic Disaster Recovery Service.
//
// Creates a new ReplicationConfigurationTemplate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation CreateReplicationConfigurationTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ServiceQuotaExceededException
//     The request could not be completed because its exceeded the service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateReplicationConfigurationTemplate
func (c *Drs) CreateReplicationConfigurationTemplate(input *CreateReplicationConfigurationTemplateInput) (*CreateReplicationConfigurationTemplateOutput, error) {
	req, out := c.CreateReplicationConfigurationTemplateRequest(input)
	return out, req.Send()
}

// CreateReplicationConfigurationTemplateWithContext is the same as CreateReplicationConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) CreateReplicationConfigurationTemplateWithContext(ctx aws.Context, input *CreateReplicationConfigurationTemplateInput, opts ...request.Option) (*CreateReplicationConfigurationTemplateOutput, error) {
	req, out := c.CreateReplicationConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSourceNetwork = "CreateSourceNetwork"

// CreateSourceNetworkRequest generates a "aws/request.Request" representing the
// client's request for the CreateSourceNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSourceNetwork for more information on using the CreateSourceNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSourceNetworkRequest method.
//	req, resp := client.CreateSourceNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateSourceNetwork
func (c *Drs) CreateSourceNetworkRequest(input *CreateSourceNetworkInput) (req *request.Request, output *CreateSourceNetworkOutput) {
	op := &request.Operation{
		Name:       opCreateSourceNetwork,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateSourceNetwork",
	}

	if input == nil {
		input = &CreateSourceNetworkInput{}
	}

	output = &CreateSourceNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSourceNetwork API operation for Elastic Disaster Recovery Service.
//
// Create a new Source Network resource for a provided VPC ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation CreateSourceNetwork for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ServiceQuotaExceededException
//     The request could not be completed because its exceeded the service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateSourceNetwork
func (c *Drs) CreateSourceNetwork(input *CreateSourceNetworkInput) (*CreateSourceNetworkOutput, error) {
	req, out := c.CreateSourceNetworkRequest(input)
	return out, req.Send()
}

// CreateSourceNetworkWithContext is the same as CreateSourceNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSourceNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) CreateSourceNetworkWithContext(ctx aws.Context, input *CreateSourceNetworkInput, opts ...request.Option) (*CreateSourceNetworkOutput, error) {
	req, out := c.CreateSourceNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJob = "DeleteJob"

// DeleteJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJob for more information on using the DeleteJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteJobRequest method.
//	req, resp := client.DeleteJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteJob
func (c *Drs) DeleteJobRequest(input *DeleteJobInput) (req *request.Request, output *DeleteJobOutput) {
	op := &request.Operation{
		Name:       opDeleteJob,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteJob",
	}

	if input == nil {
		input = &DeleteJobInput{}
	}

	output = &DeleteJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteJob API operation for Elastic Disaster Recovery Service.
//
// Deletes a single Job by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DeleteJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteJob
func (c *Drs) DeleteJob(input *DeleteJobInput) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	return out, req.Send()
}

// DeleteJobWithContext is the same as DeleteJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DeleteJobWithContext(ctx aws.Context, input *DeleteJobInput, opts ...request.Option) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLaunchAction = "DeleteLaunchAction"

// DeleteLaunchActionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLaunchAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLaunchAction for more information on using the DeleteLaunchAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLaunchActionRequest method.
//	req, resp := client.DeleteLaunchActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteLaunchAction
func (c *Drs) DeleteLaunchActionRequest(input *DeleteLaunchActionInput) (req *request.Request, output *DeleteLaunchActionOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunchAction,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteLaunchAction",
	}

	if input == nil {
		input = &DeleteLaunchActionInput{}
	}

	output = &DeleteLaunchActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLaunchAction API operation for Elastic Disaster Recovery Service.
//
// Deletes a resource launch action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DeleteLaunchAction for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteLaunchAction
func (c *Drs) DeleteLaunchAction(input *DeleteLaunchActionInput) (*DeleteLaunchActionOutput, error) {
	req, out := c.DeleteLaunchActionRequest(input)
	return out, req.Send()
}

// DeleteLaunchActionWithContext is the same as DeleteLaunchAction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLaunchAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DeleteLaunchActionWithContext(ctx aws.Context, input *DeleteLaunchActionInput, opts ...request.Option) (*DeleteLaunchActionOutput, error) {
	req, out := c.DeleteLaunchActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLaunchConfigurationTemplate = "DeleteLaunchConfigurationTemplate"

// DeleteLaunchConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLaunchConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLaunchConfigurationTemplate for more information on using the DeleteLaunchConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLaunchConfigurationTemplateRequest method.
//	req, resp := client.DeleteLaunchConfigurationTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteLaunchConfigurationTemplate
func (c *Drs) DeleteLaunchConfigurationTemplateRequest(input *DeleteLaunchConfigurationTemplateInput) (req *request.Request, output *DeleteLaunchConfigurationTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunchConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteLaunchConfigurationTemplate",
	}

	if input == nil {
		input = &DeleteLaunchConfigurationTemplateInput{}
	}

	output = &DeleteLaunchConfigurationTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLaunchConfigurationTemplate API operation for Elastic Disaster Recovery Service.
//
// Deletes a single Launch Configuration Template by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DeleteLaunchConfigurationTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteLaunchConfigurationTemplate
func (c *Drs) DeleteLaunchConfigurationTemplate(input *DeleteLaunchConfigurationTemplateInput) (*DeleteLaunchConfigurationTemplateOutput, error) {
	req, out := c.DeleteLaunchConfigurationTemplateRequest(input)
	return out, req.Send()
}

// DeleteLaunchConfigurationTemplateWithContext is the same as DeleteLaunchConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLaunchConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DeleteLaunchConfigurationTemplateWithContext(ctx aws.Context, input *DeleteLaunchConfigurationTemplateInput, opts ...request.Option) (*DeleteLaunchConfigurationTemplateOutput, error) {
	req, out := c.DeleteLaunchConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRecoveryInstance = "DeleteRecoveryInstance"

// DeleteRecoveryInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRecoveryInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRecoveryInstance for more information on using the DeleteRecoveryInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRecoveryInstanceRequest method.
//	req, resp := client.DeleteRecoveryInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteRecoveryInstance
func (c *Drs) DeleteRecoveryInstanceRequest(input *DeleteRecoveryInstanceInput) (req *request.Request, output *DeleteRecoveryInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteRecoveryInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteRecoveryInstance",
	}

	if input == nil {
		input = &DeleteRecoveryInstanceInput{}
	}

	output = &DeleteRecoveryInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRecoveryInstance API operation for Elastic Disaster Recovery Service.
//
// Deletes a single Recovery Instance by ID. This deletes the Recovery Instance
// resource from Elastic Disaster Recovery. The Recovery Instance must be disconnected
// first in order to delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DeleteRecoveryInstance for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteRecoveryInstance
func (c *Drs) DeleteRecoveryInstance(input *DeleteRecoveryInstanceInput) (*DeleteRecoveryInstanceOutput, error) {
	req, out := c.DeleteRecoveryInstanceRequest(input)
	return out, req.Send()
}

// DeleteRecoveryInstanceWithContext is the same as DeleteRecoveryInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRecoveryInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DeleteRecoveryInstanceWithContext(ctx aws.Context, input *DeleteRecoveryInstanceInput, opts ...request.Option) (*DeleteRecoveryInstanceOutput, error) {
	req, out := c.DeleteRecoveryInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationConfigurationTemplate = "DeleteReplicationConfigurationTemplate"

// DeleteReplicationConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationConfigurationTemplate for more information on using the DeleteReplicationConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReplicationConfigurationTemplateRequest method.
//	req, resp := client.DeleteReplicationConfigurationTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteReplicationConfigurationTemplate
func (c *Drs) DeleteReplicationConfigurationTemplateRequest(input *DeleteReplicationConfigurationTemplateInput) (req *request.Request, output *DeleteReplicationConfigurationTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteReplicationConfigurationTemplate",
	}

	if input == nil {
		input = &DeleteReplicationConfigurationTemplateInput{}
	}

	output = &DeleteReplicationConfigurationTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReplicationConfigurationTemplate API operation for Elastic Disaster Recovery Service.
//
// # Deletes a single Replication Configuration Template by ID
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DeleteReplicationConfigurationTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteReplicationConfigurationTemplate
func (c *Drs) DeleteReplicationConfigurationTemplate(input *DeleteReplicationConfigurationTemplateInput) (*DeleteReplicationConfigurationTemplateOutput, error) {
	req, out := c.DeleteReplicationConfigurationTemplateRequest(input)
	return out, req.Send()
}

// DeleteReplicationConfigurationTemplateWithContext is the same as DeleteReplicationConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DeleteReplicationConfigurationTemplateWithContext(ctx aws.Context, input *DeleteReplicationConfigurationTemplateInput, opts ...request.Option) (*DeleteReplicationConfigurationTemplateOutput, error) {
	req, out := c.DeleteReplicationConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSourceNetwork = "DeleteSourceNetwork"

// DeleteSourceNetworkRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSourceNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSourceNetwork for more information on using the DeleteSourceNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSourceNetworkRequest method.
//	req, resp := client.DeleteSourceNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteSourceNetwork
func (c *Drs) DeleteSourceNetworkRequest(input *DeleteSourceNetworkInput) (req *request.Request, output *DeleteSourceNetworkOutput) {
	op := &request.Operation{
		Name:       opDeleteSourceNetwork,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteSourceNetwork",
	}

	if input == nil {
		input = &DeleteSourceNetworkInput{}
	}

	output = &DeleteSourceNetworkOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSourceNetwork API operation for Elastic Disaster Recovery Service.
//
// Delete Source Network resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DeleteSourceNetwork for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteSourceNetwork
func (c *Drs) DeleteSourceNetwork(input *DeleteSourceNetworkInput) (*DeleteSourceNetworkOutput, error) {
	req, out := c.DeleteSourceNetworkRequest(input)
	return out, req.Send()
}

// DeleteSourceNetworkWithContext is the same as DeleteSourceNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSourceNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DeleteSourceNetworkWithContext(ctx aws.Context, input *DeleteSourceNetworkInput, opts ...request.Option) (*DeleteSourceNetworkOutput, error) {
	req, out := c.DeleteSourceNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSourceServer = "DeleteSourceServer"

// DeleteSourceServerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSourceServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSourceServer for more information on using the DeleteSourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSourceServerRequest method.
//	req, resp := client.DeleteSourceServerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteSourceServer
func (c *Drs) DeleteSourceServerRequest(input *DeleteSourceServerInput) (req *request.Request, output *DeleteSourceServerOutput) {
	op := &request.Operation{
		Name:       opDeleteSourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteSourceServer",
	}

	if input == nil {
		input = &DeleteSourceServerInput{}
	}

	output = &DeleteSourceServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSourceServer API operation for Elastic Disaster Recovery Service.
//
// Deletes a single Source Server by ID. The Source Server must be disconnected
// first.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DeleteSourceServer for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteSourceServer
func (c *Drs) DeleteSourceServer(input *DeleteSourceServerInput) (*DeleteSourceServerOutput, error) {
	req, out := c.DeleteSourceServerRequest(input)
	return out, req.Send()
}

// DeleteSourceServerWithContext is the same as DeleteSourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DeleteSourceServerWithContext(ctx aws.Context, input *DeleteSourceServerInput, opts ...request.Option) (*DeleteSourceServerOutput, error) {
	req, out := c.DeleteSourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJobLogItems = "DescribeJobLogItems"

// DescribeJobLogItemsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobLogItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobLogItems for more information on using the DescribeJobLogItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeJobLogItemsRequest method.
//	req, resp := client.DescribeJobLogItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobLogItems
func (c *Drs) DescribeJobLogItemsRequest(input *DescribeJobLogItemsInput) (req *request.Request, output *DescribeJobLogItemsOutput) {
	op := &request.Operation{
		Name:       opDescribeJobLogItems,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeJobLogItems",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeJobLogItemsInput{}
	}

	output = &DescribeJobLogItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobLogItems API operation for Elastic Disaster Recovery Service.
//
// Retrieves a detailed Job log with pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DescribeJobLogItems for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobLogItems
func (c *Drs) DescribeJobLogItems(input *DescribeJobLogItemsInput) (*DescribeJobLogItemsOutput, error) {
	req, out := c.DescribeJobLogItemsRequest(input)
	return out, req.Send()
}

// DescribeJobLogItemsWithContext is the same as DescribeJobLogItems with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobLogItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeJobLogItemsWithContext(ctx aws.Context, input *DescribeJobLogItemsInput, opts ...request.Option) (*DescribeJobLogItemsOutput, error) {
	req, out := c.DescribeJobLogItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeJobLogItemsPages iterates over the pages of a DescribeJobLogItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeJobLogItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeJobLogItems operation.
//	pageNum := 0
//	err := client.DescribeJobLogItemsPages(params,
//	    func(page *drs.DescribeJobLogItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Drs) DescribeJobLogItemsPages(input *DescribeJobLogItemsInput, fn func(*DescribeJobLogItemsOutput, bool) bool) error {
	return c.DescribeJobLogItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeJobLogItemsPagesWithContext same as DescribeJobLogItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeJobLogItemsPagesWithContext(ctx aws.Context, input *DescribeJobLogItemsInput, fn func(*DescribeJobLogItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeJobLogItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeJobLogItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeJobLogItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeJobs = "DescribeJobs"

// DescribeJobsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobs for more information on using the DescribeJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeJobsRequest method.
//	req, resp := client.DescribeJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobs
func (c *Drs) DescribeJobsRequest(input *DescribeJobsInput) (req *request.Request, output *DescribeJobsOutput) {
	op := &request.Operation{
		Name:       opDescribeJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeJobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeJobsInput{}
	}

	output = &DescribeJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobs API operation for Elastic Disaster Recovery Service.
//
// Returns a list of Jobs. Use the JobsID and fromDate and toDate filters to
// limit which jobs are returned. The response is sorted by creationDataTime
// - latest date first. Jobs are created by the StartRecovery, TerminateRecoveryInstances
// and StartFailbackLaunch APIs. Jobs are also created by DiagnosticLaunch and
// TerminateDiagnosticInstances, which are APIs available only to *Support*
// and only used in response to relevant support tickets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DescribeJobs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobs
func (c *Drs) DescribeJobs(input *DescribeJobsInput) (*DescribeJobsOutput, error) {
	req, out := c.DescribeJobsRequest(input)
	return out, req.Send()
}

// DescribeJobsWithContext is the same as DescribeJobs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeJobsWithContext(ctx aws.Context, input *DescribeJobsInput, opts ...request.Option) (*DescribeJobsOutput, error) {
	req, out := c.DescribeJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeJobsPages iterates over the pages of a DescribeJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeJobs operation.
//	pageNum := 0
//	err := client.DescribeJobsPages(params,
//	    func(page *drs.DescribeJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Drs) DescribeJobsPages(input *DescribeJobsInput, fn func(*DescribeJobsOutput, bool) bool) error {
	return c.DescribeJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeJobsPagesWithContext same as DescribeJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeJobsPagesWithContext(ctx aws.Context, input *DescribeJobsInput, fn func(*DescribeJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeLaunchConfigurationTemplates = "DescribeLaunchConfigurationTemplates"

// DescribeLaunchConfigurationTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLaunchConfigurationTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLaunchConfigurationTemplates for more information on using the DescribeLaunchConfigurationTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLaunchConfigurationTemplatesRequest method.
//	req, resp := client.DescribeLaunchConfigurationTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeLaunchConfigurationTemplates
func (c *Drs) DescribeLaunchConfigurationTemplatesRequest(input *DescribeLaunchConfigurationTemplatesInput) (req *request.Request, output *DescribeLaunchConfigurationTemplatesOutput) {
	op := &request.Operation{
		Name:       opDescribeLaunchConfigurationTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeLaunchConfigurationTemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLaunchConfigurationTemplatesInput{}
	}

	output = &DescribeLaunchConfigurationTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLaunchConfigurationTemplates API operation for Elastic Disaster Recovery Service.
//
// Lists all Launch Configuration Templates, filtered by Launch Configuration
// Template IDs
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DescribeLaunchConfigurationTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeLaunchConfigurationTemplates
func (c *Drs) DescribeLaunchConfigurationTemplates(input *DescribeLaunchConfigurationTemplatesInput) (*DescribeLaunchConfigurationTemplatesOutput, error) {
	req, out := c.DescribeLaunchConfigurationTemplatesRequest(input)
	return out, req.Send()
}

// DescribeLaunchConfigurationTemplatesWithContext is the same as DescribeLaunchConfigurationTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLaunchConfigurationTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeLaunchConfigurationTemplatesWithContext(ctx aws.Context, input *DescribeLaunchConfigurationTemplatesInput, opts ...request.Option) (*DescribeLaunchConfigurationTemplatesOutput, error) {
	req, out := c.DescribeLaunchConfigurationTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeLaunchConfigurationTemplatesPages iterates over the pages of a DescribeLaunchConfigurationTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLaunchConfigurationTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeLaunchConfigurationTemplates operation.
//	pageNum := 0
//	err := client.DescribeLaunchConfigurationTemplatesPages(params,
//	    func(page *drs.DescribeLaunchConfigurationTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Drs) DescribeLaunchConfigurationTemplatesPages(input *DescribeLaunchConfigurationTemplatesInput, fn func(*DescribeLaunchConfigurationTemplatesOutput, bool) bool) error {
	return c.DescribeLaunchConfigurationTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeLaunchConfigurationTemplatesPagesWithContext same as DescribeLaunchConfigurationTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeLaunchConfigurationTemplatesPagesWithContext(ctx aws.Context, input *DescribeLaunchConfigurationTemplatesInput, fn func(*DescribeLaunchConfigurationTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeLaunchConfigurationTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeLaunchConfigurationTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeLaunchConfigurationTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRecoveryInstances = "DescribeRecoveryInstances"

// DescribeRecoveryInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecoveryInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRecoveryInstances for more information on using the DescribeRecoveryInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRecoveryInstancesRequest method.
//	req, resp := client.DescribeRecoveryInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoveryInstances
func (c *Drs) DescribeRecoveryInstancesRequest(input *DescribeRecoveryInstancesInput) (req *request.Request, output *DescribeRecoveryInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeRecoveryInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeRecoveryInstances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRecoveryInstancesInput{}
	}

	output = &DescribeRecoveryInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecoveryInstances API operation for Elastic Disaster Recovery Service.
//
// Lists all Recovery Instances or multiple Recovery Instances by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DescribeRecoveryInstances for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoveryInstances
func (c *Drs) DescribeRecoveryInstances(input *DescribeRecoveryInstancesInput) (*DescribeRecoveryInstancesOutput, error) {
	req, out := c.DescribeRecoveryInstancesRequest(input)
	return out, req.Send()
}

// DescribeRecoveryInstancesWithContext is the same as DescribeRecoveryInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecoveryInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeRecoveryInstancesWithContext(ctx aws.Context, input *DescribeRecoveryInstancesInput, opts ...request.Option) (*DescribeRecoveryInstancesOutput, error) {
	req, out := c.DescribeRecoveryInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRecoveryInstancesPages iterates over the pages of a DescribeRecoveryInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRecoveryInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeRecoveryInstances operation.
//	pageNum := 0
//	err := client.DescribeRecoveryInstancesPages(params,
//	    func(page *drs.DescribeRecoveryInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Drs) DescribeRecoveryInstancesPages(input *DescribeRecoveryInstancesInput, fn func(*DescribeRecoveryInstancesOutput, bool) bool) error {
	return c.DescribeRecoveryInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRecoveryInstancesPagesWithContext same as DescribeRecoveryInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeRecoveryInstancesPagesWithContext(ctx aws.Context, input *DescribeRecoveryInstancesInput, fn func(*DescribeRecoveryInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRecoveryInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRecoveryInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRecoveryInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRecoverySnapshots = "DescribeRecoverySnapshots"

// DescribeRecoverySnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecoverySnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRecoverySnapshots for more information on using the DescribeRecoverySnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRecoverySnapshotsRequest method.
//	req, resp := client.DescribeRecoverySnapshotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoverySnapshots
func (c *Drs) DescribeRecoverySnapshotsRequest(input *DescribeRecoverySnapshotsInput) (req *request.Request, output *DescribeRecoverySnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeRecoverySnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeRecoverySnapshots",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRecoverySnapshotsInput{}
	}

	output = &DescribeRecoverySnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecoverySnapshots API operation for Elastic Disaster Recovery Service.
//
// Lists all Recovery Snapshots for a single Source Server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DescribeRecoverySnapshots for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoverySnapshots
func (c *Drs) DescribeRecoverySnapshots(input *DescribeRecoverySnapshotsInput) (*DescribeRecoverySnapshotsOutput, error) {
	req, out := c.DescribeRecoverySnapshotsRequest(input)
	return out, req.Send()
}

// DescribeRecoverySnapshotsWithContext is the same as DescribeRecoverySnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecoverySnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeRecoverySnapshotsWithContext(ctx aws.Context, input *DescribeRecoverySnapshotsInput, opts ...request.Option) (*DescribeRecoverySnapshotsOutput, error) {
	req, out := c.DescribeRecoverySnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRecoverySnapshotsPages iterates over the pages of a DescribeRecoverySnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRecoverySnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeRecoverySnapshots operation.
//	pageNum := 0
//	err := client.DescribeRecoverySnapshotsPages(params,
//	    func(page *drs.DescribeRecoverySnapshotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Drs) DescribeRecoverySnapshotsPages(input *DescribeRecoverySnapshotsInput, fn func(*DescribeRecoverySnapshotsOutput, bool) bool) error {
	return c.DescribeRecoverySnapshotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRecoverySnapshotsPagesWithContext same as DescribeRecoverySnapshotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeRecoverySnapshotsPagesWithContext(ctx aws.Context, input *DescribeRecoverySnapshotsInput, fn func(*DescribeRecoverySnapshotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRecoverySnapshotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRecoverySnapshotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRecoverySnapshotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationConfigurationTemplates = "DescribeReplicationConfigurationTemplates"

// DescribeReplicationConfigurationTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationConfigurationTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationConfigurationTemplates for more information on using the DescribeReplicationConfigurationTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationConfigurationTemplatesRequest method.
//	req, resp := client.DescribeReplicationConfigurationTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeReplicationConfigurationTemplates
func (c *Drs) DescribeReplicationConfigurationTemplatesRequest(input *DescribeReplicationConfigurationTemplatesInput) (req *request.Request, output *DescribeReplicationConfigurationTemplatesOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationConfigurationTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeReplicationConfigurationTemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationConfigurationTemplatesInput{}
	}

	output = &DescribeReplicationConfigurationTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationConfigurationTemplates API operation for Elastic Disaster Recovery Service.
//
// Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DescribeReplicationConfigurationTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeReplicationConfigurationTemplates
func (c *Drs) DescribeReplicationConfigurationTemplates(input *DescribeReplicationConfigurationTemplatesInput) (*DescribeReplicationConfigurationTemplatesOutput, error) {
	req, out := c.DescribeReplicationConfigurationTemplatesRequest(input)
	return out, req.Send()
}

// DescribeReplicationConfigurationTemplatesWithContext is the same as DescribeReplicationConfigurationTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationConfigurationTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeReplicationConfigurationTemplatesWithContext(ctx aws.Context, input *DescribeReplicationConfigurationTemplatesInput, opts ...request.Option) (*DescribeReplicationConfigurationTemplatesOutput, error) {
	req, out := c.DescribeReplicationConfigurationTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationConfigurationTemplatesPages iterates over the pages of a DescribeReplicationConfigurationTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationConfigurationTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReplicationConfigurationTemplates operation.
//	pageNum := 0
//	err := client.DescribeReplicationConfigurationTemplatesPages(params,
//	    func(page *drs.DescribeReplicationConfigurationTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Drs) DescribeReplicationConfigurationTemplatesPages(input *DescribeReplicationConfigurationTemplatesInput, fn func(*DescribeReplicationConfigurationTemplatesOutput, bool) bool) error {
	return c.DescribeReplicationConfigurationTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationConfigurationTemplatesPagesWithContext same as DescribeReplicationConfigurationTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeReplicationConfigurationTemplatesPagesWithContext(ctx aws.Context, input *DescribeReplicationConfigurationTemplatesInput, fn func(*DescribeReplicationConfigurationTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationConfigurationTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationConfigurationTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationConfigurationTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSourceNetworks = "DescribeSourceNetworks"

// DescribeSourceNetworksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSourceNetworks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSourceNetworks for more information on using the DescribeSourceNetworks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSourceNetworksRequest method.
//	req, resp := client.DescribeSourceNetworksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeSourceNetworks
func (c *Drs) DescribeSourceNetworksRequest(input *DescribeSourceNetworksInput) (req *request.Request, output *DescribeSourceNetworksOutput) {
	op := &request.Operation{
		Name:       opDescribeSourceNetworks,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeSourceNetworks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSourceNetworksInput{}
	}

	output = &DescribeSourceNetworksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSourceNetworks API operation for Elastic Disaster Recovery Service.
//
// Lists all Source Networks or multiple Source Networks filtered by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DescribeSourceNetworks for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeSourceNetworks
func (c *Drs) DescribeSourceNetworks(input *DescribeSourceNetworksInput) (*DescribeSourceNetworksOutput, error) {
	req, out := c.DescribeSourceNetworksRequest(input)
	return out, req.Send()
}

// DescribeSourceNetworksWithContext is the same as DescribeSourceNetworks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSourceNetworks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeSourceNetworksWithContext(ctx aws.Context, input *DescribeSourceNetworksInput, opts ...request.Option) (*DescribeSourceNetworksOutput, error) {
	req, out := c.DescribeSourceNetworksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSourceNetworksPages iterates over the pages of a DescribeSourceNetworks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSourceNetworks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeSourceNetworks operation.
//	pageNum := 0
//	err := client.DescribeSourceNetworksPages(params,
//	    func(page *drs.DescribeSourceNetworksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Drs) DescribeSourceNetworksPages(input *DescribeSourceNetworksInput, fn func(*DescribeSourceNetworksOutput, bool) bool) error {
	return c.DescribeSourceNetworksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSourceNetworksPagesWithContext same as DescribeSourceNetworksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeSourceNetworksPagesWithContext(ctx aws.Context, input *DescribeSourceNetworksInput, fn func(*DescribeSourceNetworksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSourceNetworksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSourceNetworksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSourceNetworksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSourceServers = "DescribeSourceServers"

// DescribeSourceServersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSourceServers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSourceServers for more information on using the DescribeSourceServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSourceServersRequest method.
//	req, resp := client.DescribeSourceServersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeSourceServers
func (c *Drs) DescribeSourceServersRequest(input *DescribeSourceServersInput) (req *request.Request, output *DescribeSourceServersOutput) {
	op := &request.Operation{
		Name:       opDescribeSourceServers,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeSourceServers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSourceServersInput{}
	}

	output = &DescribeSourceServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSourceServers API operation for Elastic Disaster Recovery Service.
//
// Lists all Source Servers or multiple Source Servers filtered by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DescribeSourceServers for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeSourceServers
func (c *Drs) DescribeSourceServers(input *DescribeSourceServersInput) (*DescribeSourceServersOutput, error) {
	req, out := c.DescribeSourceServersRequest(input)
	return out, req.Send()
}

// DescribeSourceServersWithContext is the same as DescribeSourceServers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSourceServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeSourceServersWithContext(ctx aws.Context, input *DescribeSourceServersInput, opts ...request.Option) (*DescribeSourceServersOutput, error) {
	req, out := c.DescribeSourceServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSourceServersPages iterates over the pages of a DescribeSourceServers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSourceServers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeSourceServers operation.
//	pageNum := 0
//	err := client.DescribeSourceServersPages(params,
//	    func(page *drs.DescribeSourceServersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Drs) DescribeSourceServersPages(input *DescribeSourceServersInput, fn func(*DescribeSourceServersOutput, bool) bool) error {
	return c.DescribeSourceServersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSourceServersPagesWithContext same as DescribeSourceServersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DescribeSourceServersPagesWithContext(ctx aws.Context, input *DescribeSourceServersInput, fn func(*DescribeSourceServersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSourceServersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSourceServersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSourceServersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDisconnectRecoveryInstance = "DisconnectRecoveryInstance"

// DisconnectRecoveryInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DisconnectRecoveryInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisconnectRecoveryInstance for more information on using the DisconnectRecoveryInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisconnectRecoveryInstanceRequest method.
//	req, resp := client.DisconnectRecoveryInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DisconnectRecoveryInstance
func (c *Drs) DisconnectRecoveryInstanceRequest(input *DisconnectRecoveryInstanceInput) (req *request.Request, output *DisconnectRecoveryInstanceOutput) {
	op := &request.Operation{
		Name:       opDisconnectRecoveryInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/DisconnectRecoveryInstance",
	}

	if input == nil {
		input = &DisconnectRecoveryInstanceInput{}
	}

	output = &DisconnectRecoveryInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisconnectRecoveryInstance API operation for Elastic Disaster Recovery Service.
//
// Disconnect a Recovery Instance from Elastic Disaster Recovery. Data replication
// is stopped immediately. All AWS resources created by Elastic Disaster Recovery
// for enabling the replication of the Recovery Instance will be terminated
// / deleted within 90 minutes. If the agent on the Recovery Instance has not
// been prevented from communicating with the Elastic Disaster Recovery service,
// then it will receive a command to uninstall itself (within approximately
// 10 minutes). The following properties of the Recovery Instance will be changed
// immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED;
// The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks
// will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration
// will be nullified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DisconnectRecoveryInstance for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DisconnectRecoveryInstance
func (c *Drs) DisconnectRecoveryInstance(input *DisconnectRecoveryInstanceInput) (*DisconnectRecoveryInstanceOutput, error) {
	req, out := c.DisconnectRecoveryInstanceRequest(input)
	return out, req.Send()
}

// DisconnectRecoveryInstanceWithContext is the same as DisconnectRecoveryInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectRecoveryInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DisconnectRecoveryInstanceWithContext(ctx aws.Context, input *DisconnectRecoveryInstanceInput, opts ...request.Option) (*DisconnectRecoveryInstanceOutput, error) {
	req, out := c.DisconnectRecoveryInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisconnectSourceServer = "DisconnectSourceServer"

// DisconnectSourceServerRequest generates a "aws/request.Request" representing the
// client's request for the DisconnectSourceServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisconnectSourceServer for more information on using the DisconnectSourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisconnectSourceServerRequest method.
//	req, resp := client.DisconnectSourceServerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DisconnectSourceServer
func (c *Drs) DisconnectSourceServerRequest(input *DisconnectSourceServerInput) (req *request.Request, output *DisconnectSourceServerOutput) {
	op := &request.Operation{
		Name:       opDisconnectSourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/DisconnectSourceServer",
	}

	if input == nil {
		input = &DisconnectSourceServerInput{}
	}

	output = &DisconnectSourceServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisconnectSourceServer API operation for Elastic Disaster Recovery Service.
//
// Disconnects a specific Source Server from Elastic Disaster Recovery. Data
// replication is stopped immediately. All AWS resources created by Elastic
// Disaster Recovery for enabling the replication of the Source Server will
// be terminated / deleted within 90 minutes. You cannot disconnect a Source
// Server if it has a Recovery Instance. If the agent on the Source Server has
// not been prevented from communicating with the Elastic Disaster Recovery
// service, then it will receive a command to uninstall itself (within approximately
// 10 minutes). The following properties of the SourceServer will be changed
// immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED;
// The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks
// will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration
// will be nullified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation DisconnectSourceServer for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DisconnectSourceServer
func (c *Drs) DisconnectSourceServer(input *DisconnectSourceServerInput) (*DisconnectSourceServerOutput, error) {
	req, out := c.DisconnectSourceServerRequest(input)
	return out, req.Send()
}

// DisconnectSourceServerWithContext is the same as DisconnectSourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectSourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) DisconnectSourceServerWithContext(ctx aws.Context, input *DisconnectSourceServerInput, opts ...request.Option) (*DisconnectSourceServerOutput, error) {
	req, out := c.DisconnectSourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportSourceNetworkCfnTemplate = "ExportSourceNetworkCfnTemplate"

// ExportSourceNetworkCfnTemplateRequest generates a "aws/request.Request" representing the
// client's request for the ExportSourceNetworkCfnTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportSourceNetworkCfnTemplate for more information on using the ExportSourceNetworkCfnTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExportSourceNetworkCfnTemplateRequest method.
//	req, resp := client.ExportSourceNetworkCfnTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ExportSourceNetworkCfnTemplate
func (c *Drs) ExportSourceNetworkCfnTemplateRequest(input *ExportSourceNetworkCfnTemplateInput) (req *request.Request, output *ExportSourceNetworkCfnTemplateOutput) {
	op := &request.Operation{
		Name:       opExportSourceNetworkCfnTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/ExportSourceNetworkCfnTemplate",
	}

	if input == nil {
		input = &ExportSourceNetworkCfnTemplateInput{}
	}

	output = &ExportSourceNetworkCfnTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportSourceNetworkCfnTemplate API operation for Elastic Disaster Recovery Service.
//
// Export the Source Network CloudFormation template to an S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation ExportSourceNetworkCfnTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ExportSourceNetworkCfnTemplate
func (c *Drs) ExportSourceNetworkCfnTemplate(input *ExportSourceNetworkCfnTemplateInput) (*ExportSourceNetworkCfnTemplateOutput, error) {
	req, out := c.ExportSourceNetworkCfnTemplateRequest(input)
	return out, req.Send()
}

// ExportSourceNetworkCfnTemplateWithContext is the same as ExportSourceNetworkCfnTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See ExportSourceNetworkCfnTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) ExportSourceNetworkCfnTemplateWithContext(ctx aws.Context, input *ExportSourceNetworkCfnTemplateInput, opts ...request.Option) (*ExportSourceNetworkCfnTemplateOutput, error) {
	req, out := c.ExportSourceNetworkCfnTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFailbackReplicationConfiguration = "GetFailbackReplicationConfiguration"

// GetFailbackReplicationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetFailbackReplicationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFailbackReplicationConfiguration for more information on using the GetFailbackReplicationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFailbackReplicationConfigurationRequest method.
//	req, resp := client.GetFailbackReplicationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetFailbackReplicationConfiguration
func (c *Drs) GetFailbackReplicationConfigurationRequest(input *GetFailbackReplicationConfigurationInput) (req *request.Request, output *GetFailbackReplicationConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetFailbackReplicationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetFailbackReplicationConfiguration",
	}

	if input == nil {
		input = &GetFailbackReplicationConfigurationInput{}
	}

	output = &GetFailbackReplicationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFailbackReplicationConfiguration API operation for Elastic Disaster Recovery Service.
//
// Lists all Failback ReplicationConfigurations, filtered by Recovery Instance
// ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation GetFailbackReplicationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetFailbackReplicationConfiguration
func (c *Drs) GetFailbackReplicationConfiguration(input *GetFailbackReplicationConfigurationInput) (*GetFailbackReplicationConfigurationOutput, error) {
	req, out := c.GetFailbackReplicationConfigurationRequest(input)
	return out, req.Send()
}

// GetFailbackReplicationConfigurationWithContext is the same as GetFailbackReplicationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetFailbackReplicationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) GetFailbackReplicationConfigurationWithContext(ctx aws.Context, input *GetFailbackReplicationConfigurationInput, opts ...request.Option) (*GetFailbackReplicationConfigurationOutput, error) {
	req, out := c.GetFailbackReplicationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLaunchConfiguration = "GetLaunchConfiguration"

// GetLaunchConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetLaunchConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLaunchConfiguration for more information on using the GetLaunchConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLaunchConfigurationRequest method.
//	req, resp := client.GetLaunchConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetLaunchConfiguration
func (c *Drs) GetLaunchConfigurationRequest(input *GetLaunchConfigurationInput) (req *request.Request, output *GetLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetLaunchConfiguration",
	}

	if input == nil {
		input = &GetLaunchConfigurationInput{}
	}

	output = &GetLaunchConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLaunchConfiguration API operation for Elastic Disaster Recovery Service.
//
// Gets a LaunchConfiguration, filtered by Source Server IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation GetLaunchConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetLaunchConfiguration
func (c *Drs) GetLaunchConfiguration(input *GetLaunchConfigurationInput) (*GetLaunchConfigurationOutput, error) {
	req, out := c.GetLaunchConfigurationRequest(input)
	return out, req.Send()
}

// GetLaunchConfigurationWithContext is the same as GetLaunchConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetLaunchConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) GetLaunchConfigurationWithContext(ctx aws.Context, input *GetLaunchConfigurationInput, opts ...request.Option) (*GetLaunchConfigurationOutput, error) {
	req, out := c.GetLaunchConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReplicationConfiguration = "GetReplicationConfiguration"

// GetReplicationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetReplicationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReplicationConfiguration for more information on using the GetReplicationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReplicationConfigurationRequest method.
//	req, resp := client.GetReplicationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetReplicationConfiguration
func (c *Drs) GetReplicationConfigurationRequest(input *GetReplicationConfigurationInput) (req *request.Request, output *GetReplicationConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetReplicationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetReplicationConfiguration",
	}

	if input == nil {
		input = &GetReplicationConfigurationInput{}
	}

	output = &GetReplicationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReplicationConfiguration API operation for Elastic Disaster Recovery Service.
//
// Gets a ReplicationConfiguration, filtered by Source Server ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation GetReplicationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetReplicationConfiguration
func (c *Drs) GetReplicationConfiguration(input *GetReplicationConfigurationInput) (*GetReplicationConfigurationOutput, error) {
	req, out := c.GetReplicationConfigurationRequest(input)
	return out, req.Send()
}

// GetReplicationConfigurationWithContext is the same as GetReplicationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetReplicationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) GetReplicationConfigurationWithContext(ctx aws.Context, input *GetReplicationConfigurationInput, opts ...request.Option) (*GetReplicationConfigurationOutput, error) {
	req, out := c.GetReplicationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInitializeService = "InitializeService"

// InitializeServiceRequest generates a "aws/request.Request" representing the
// client's request for the InitializeService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InitializeService for more information on using the InitializeService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InitializeServiceRequest method.
//	req, resp := client.InitializeServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/InitializeService
func (c *Drs) InitializeServiceRequest(input *InitializeServiceInput) (req *request.Request, output *InitializeServiceOutput) {
	op := &request.Operation{
		Name:       opInitializeService,
		HTTPMethod: "POST",
		HTTPPath:   "/InitializeService",
	}

	if input == nil {
		input = &InitializeServiceInput{}
	}

	output = &InitializeServiceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// InitializeService API operation for Elastic Disaster Recovery Service.
//
// Initialize Elastic Disaster Recovery.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation InitializeService for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/InitializeService
func (c *Drs) InitializeService(input *InitializeServiceInput) (*InitializeServiceOutput, error) {
	req, out := c.InitializeServiceRequest(input)
	return out, req.Send()
}

// InitializeServiceWithContext is the same as InitializeService with the addition of
// the ability to pass a context and additional request options.
//
// See InitializeService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) InitializeServiceWithContext(ctx aws.Context, input *InitializeServiceInput, opts ...request.Option) (*InitializeServiceOutput, error) {
	req, out := c.InitializeServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListExtensibleSourceServers = "ListExtensibleSourceServers"

// ListExtensibleSourceServersRequest generates a "aws/request.Request" representing the
// client's request for the ListExtensibleSourceServers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExtensibleSourceServers for more information on using the ListExtensibleSourceServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExtensibleSourceServersRequest method.
//	req, resp := client.ListExtensibleSourceServersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListExtensibleSourceServers
func (c *Drs) ListExtensibleSourceServersRequest(input *ListExtensibleSourceServersInput) (req *request.Request, output *ListExtensibleSourceServersOutput) {
	op := &request.Operation{
		Name:       opListExtensibleSourceServers,
		HTTPMethod: "POST",
		HTTPPath:   "/ListExtensibleSourceServers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExtensibleSourceServersInput{}
	}

	output = &ListExtensibleSourceServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExtensibleSourceServers API operation for Elastic Disaster Recovery Service.
//
// Returns a list of source servers on a staging account that are extensible,
// which means that: a. The source server is not already extended into this
// Account. b. The source server on the Account we’re reading from is not
// an extension of another source server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation ListExtensibleSourceServers for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListExtensibleSourceServers
func (c *Drs) ListExtensibleSourceServers(input *ListExtensibleSourceServersInput) (*ListExtensibleSourceServersOutput, error) {
	req, out := c.ListExtensibleSourceServersRequest(input)
	return out, req.Send()
}

// ListExtensibleSourceServersWithContext is the same as ListExtensibleSourceServers with the addition of
// the ability to pass a context and additional request options.
//
// See ListExtensibleSourceServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) ListExtensibleSourceServersWithContext(ctx aws.Context, input *ListExtensibleSourceServersInput, opts ...request.Option) (*ListExtensibleSourceServersOutput, error) {
	req, out := c.ListExtensibleSourceServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExtensibleSourceServersPages iterates over the pages of a ListExtensibleSourceServers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExtensibleSourceServers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExtensibleSourceServers operation.
//	pageNum := 0
//	err := client.ListExtensibleSourceServersPages(params,
//	    func(page *drs.ListExtensibleSourceServersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Drs) ListExtensibleSourceServersPages(input *ListExtensibleSourceServersInput, fn func(*ListExtensibleSourceServersOutput, bool) bool) error {
	return c.ListExtensibleSourceServersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExtensibleSourceServersPagesWithContext same as ListExtensibleSourceServersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) ListExtensibleSourceServersPagesWithContext(ctx aws.Context, input *ListExtensibleSourceServersInput, fn func(*ListExtensibleSourceServersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExtensibleSourceServersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExtensibleSourceServersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExtensibleSourceServersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLaunchActions = "ListLaunchActions"

// ListLaunchActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListLaunchActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLaunchActions for more information on using the ListLaunchActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLaunchActionsRequest method.
//	req, resp := client.ListLaunchActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListLaunchActions
func (c *Drs) ListLaunchActionsRequest(input *ListLaunchActionsInput) (req *request.Request, output *ListLaunchActionsOutput) {
	op := &request.Operation{
		Name:       opListLaunchActions,
		HTTPMethod: "POST",
		HTTPPath:   "/ListLaunchActions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLaunchActionsInput{}
	}

	output = &ListLaunchActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLaunchActions API operation for Elastic Disaster Recovery Service.
//
// Lists resource launch actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation ListLaunchActions for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ServiceQuotaExceededException
//     The request could not be completed because its exceeded the service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListLaunchActions
func (c *Drs) ListLaunchActions(input *ListLaunchActionsInput) (*ListLaunchActionsOutput, error) {
	req, out := c.ListLaunchActionsRequest(input)
	return out, req.Send()
}

// ListLaunchActionsWithContext is the same as ListLaunchActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListLaunchActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) ListLaunchActionsWithContext(ctx aws.Context, input *ListLaunchActionsInput, opts ...request.Option) (*ListLaunchActionsOutput, error) {
	req, out := c.ListLaunchActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLaunchActionsPages iterates over the pages of a ListLaunchActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLaunchActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLaunchActions operation.
//	pageNum := 0
//	err := client.ListLaunchActionsPages(params,
//	    func(page *drs.ListLaunchActionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Drs) ListLaunchActionsPages(input *ListLaunchActionsInput, fn func(*ListLaunchActionsOutput, bool) bool) error {
	return c.ListLaunchActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLaunchActionsPagesWithContext same as ListLaunchActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) ListLaunchActionsPagesWithContext(ctx aws.Context, input *ListLaunchActionsInput, fn func(*ListLaunchActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLaunchActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLaunchActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLaunchActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStagingAccounts = "ListStagingAccounts"

// ListStagingAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListStagingAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStagingAccounts for more information on using the ListStagingAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStagingAccountsRequest method.
//	req, resp := client.ListStagingAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListStagingAccounts
func (c *Drs) ListStagingAccountsRequest(input *ListStagingAccountsInput) (req *request.Request, output *ListStagingAccountsOutput) {
	op := &request.Operation{
		Name:       opListStagingAccounts,
		HTTPMethod: "GET",
		HTTPPath:   "/ListStagingAccounts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStagingAccountsInput{}
	}

	output = &ListStagingAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStagingAccounts API operation for Elastic Disaster Recovery Service.
//
// Returns an array of staging accounts for existing extended source servers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation ListStagingAccounts for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListStagingAccounts
func (c *Drs) ListStagingAccounts(input *ListStagingAccountsInput) (*ListStagingAccountsOutput, error) {
	req, out := c.ListStagingAccountsRequest(input)
	return out, req.Send()
}

// ListStagingAccountsWithContext is the same as ListStagingAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListStagingAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) ListStagingAccountsWithContext(ctx aws.Context, input *ListStagingAccountsInput, opts ...request.Option) (*ListStagingAccountsOutput, error) {
	req, out := c.ListStagingAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStagingAccountsPages iterates over the pages of a ListStagingAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStagingAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStagingAccounts operation.
//	pageNum := 0
//	err := client.ListStagingAccountsPages(params,
//	    func(page *drs.ListStagingAccountsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Drs) ListStagingAccountsPages(input *ListStagingAccountsInput, fn func(*ListStagingAccountsOutput, bool) bool) error {
	return c.ListStagingAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStagingAccountsPagesWithContext same as ListStagingAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) ListStagingAccountsPagesWithContext(ctx aws.Context, input *ListStagingAccountsInput, fn func(*ListStagingAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStagingAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStagingAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStagingAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListTagsForResource
func (c *Drs) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Elastic Disaster Recovery Service.
//
// List all tags for your Elastic Disaster Recovery resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListTagsForResource
func (c *Drs) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLaunchAction = "PutLaunchAction"

// PutLaunchActionRequest generates a "aws/request.Request" representing the
// client's request for the PutLaunchAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLaunchAction for more information on using the PutLaunchAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutLaunchActionRequest method.
//	req, resp := client.PutLaunchActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/PutLaunchAction
func (c *Drs) PutLaunchActionRequest(input *PutLaunchActionInput) (req *request.Request, output *PutLaunchActionOutput) {
	op := &request.Operation{
		Name:       opPutLaunchAction,
		HTTPMethod: "POST",
		HTTPPath:   "/PutLaunchAction",
	}

	if input == nil {
		input = &PutLaunchActionInput{}
	}

	output = &PutLaunchActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutLaunchAction API operation for Elastic Disaster Recovery Service.
//
// Puts a resource launch action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation PutLaunchAction for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/PutLaunchAction
func (c *Drs) PutLaunchAction(input *PutLaunchActionInput) (*PutLaunchActionOutput, error) {
	req, out := c.PutLaunchActionRequest(input)
	return out, req.Send()
}

// PutLaunchActionWithContext is the same as PutLaunchAction with the addition of
// the ability to pass a context and additional request options.
//
// See PutLaunchAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) PutLaunchActionWithContext(ctx aws.Context, input *PutLaunchActionInput, opts ...request.Option) (*PutLaunchActionOutput, error) {
	req, out := c.PutLaunchActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRetryDataReplication = "RetryDataReplication"

// RetryDataReplicationRequest generates a "aws/request.Request" representing the
// client's request for the RetryDataReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RetryDataReplication for more information on using the RetryDataReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RetryDataReplicationRequest method.
//	req, resp := client.RetryDataReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/RetryDataReplication
//
// Deprecated: WARNING: RetryDataReplication is deprecated
func (c *Drs) RetryDataReplicationRequest(input *RetryDataReplicationInput) (req *request.Request, output *RetryDataReplicationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, RetryDataReplication, has been deprecated")
	}
	op := &request.Operation{
		Name:       opRetryDataReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/RetryDataReplication",
	}

	if input == nil {
		input = &RetryDataReplicationInput{}
	}

	output = &RetryDataReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetryDataReplication API operation for Elastic Disaster Recovery Service.
//
// WARNING: RetryDataReplication is deprecated. Causes the data replication
// initiation sequence to begin immediately upon next Handshake for the specified
// Source Server ID, regardless of when the previous initiation started. This
// command will work only if the Source Server is stalled or is in a DISCONNECTED
// or STOPPED state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation RetryDataReplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/RetryDataReplication
//
// Deprecated: WARNING: RetryDataReplication is deprecated
func (c *Drs) RetryDataReplication(input *RetryDataReplicationInput) (*RetryDataReplicationOutput, error) {
	req, out := c.RetryDataReplicationRequest(input)
	return out, req.Send()
}

// RetryDataReplicationWithContext is the same as RetryDataReplication with the addition of
// the ability to pass a context and additional request options.
//
// See RetryDataReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: WARNING: RetryDataReplication is deprecated
func (c *Drs) RetryDataReplicationWithContext(ctx aws.Context, input *RetryDataReplicationInput, opts ...request.Option) (*RetryDataReplicationOutput, error) {
	req, out := c.RetryDataReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReverseReplication = "ReverseReplication"

// ReverseReplicationRequest generates a "aws/request.Request" representing the
// client's request for the ReverseReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReverseReplication for more information on using the ReverseReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReverseReplicationRequest method.
//	req, resp := client.ReverseReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ReverseReplication
func (c *Drs) ReverseReplicationRequest(input *ReverseReplicationInput) (req *request.Request, output *ReverseReplicationOutput) {
	op := &request.Operation{
		Name:       opReverseReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/ReverseReplication",
	}

	if input == nil {
		input = &ReverseReplicationInput{}
	}

	output = &ReverseReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReverseReplication API operation for Elastic Disaster Recovery Service.
//
// Start replication to origin / target region - applies only to protected instances
// that originated in EC2. For recovery instances on target region - starts
// replication back to origin region. For failback instances on origin region
// - starts replication to target region to re-protect them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation ReverseReplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ReverseReplication
func (c *Drs) ReverseReplication(input *ReverseReplicationInput) (*ReverseReplicationOutput, error) {
	req, out := c.ReverseReplicationRequest(input)
	return out, req.Send()
}

// ReverseReplicationWithContext is the same as ReverseReplication with the addition of
// the ability to pass a context and additional request options.
//
// See ReverseReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) ReverseReplicationWithContext(ctx aws.Context, input *ReverseReplicationInput, opts ...request.Option) (*ReverseReplicationOutput, error) {
	req, out := c.ReverseReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFailbackLaunch = "StartFailbackLaunch"

// StartFailbackLaunchRequest generates a "aws/request.Request" representing the
// client's request for the StartFailbackLaunch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFailbackLaunch for more information on using the StartFailbackLaunch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartFailbackLaunchRequest method.
//	req, resp := client.StartFailbackLaunchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartFailbackLaunch
func (c *Drs) StartFailbackLaunchRequest(input *StartFailbackLaunchInput) (req *request.Request, output *StartFailbackLaunchOutput) {
	op := &request.Operation{
		Name:       opStartFailbackLaunch,
		HTTPMethod: "POST",
		HTTPPath:   "/StartFailbackLaunch",
	}

	if input == nil {
		input = &StartFailbackLaunchInput{}
	}

	output = &StartFailbackLaunchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFailbackLaunch API operation for Elastic Disaster Recovery Service.
//
// Initiates a Job for launching the machine that is being failed back to from
// the specified Recovery Instance. This will run conversion on the failback
// client and will reboot your machine, thus completing the failback process.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation StartFailbackLaunch for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ServiceQuotaExceededException
//     The request could not be completed because its exceeded the service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartFailbackLaunch
func (c *Drs) StartFailbackLaunch(input *StartFailbackLaunchInput) (*StartFailbackLaunchOutput, error) {
	req, out := c.StartFailbackLaunchRequest(input)
	return out, req.Send()
}

// StartFailbackLaunchWithContext is the same as StartFailbackLaunch with the addition of
// the ability to pass a context and additional request options.
//
// See StartFailbackLaunch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) StartFailbackLaunchWithContext(ctx aws.Context, input *StartFailbackLaunchInput, opts ...request.Option) (*StartFailbackLaunchOutput, error) {
	req, out := c.StartFailbackLaunchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartRecovery = "StartRecovery"

// StartRecoveryRequest generates a "aws/request.Request" representing the
// client's request for the StartRecovery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartRecovery for more information on using the StartRecovery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartRecoveryRequest method.
//	req, resp := client.StartRecoveryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartRecovery
func (c *Drs) StartRecoveryRequest(input *StartRecoveryInput) (req *request.Request, output *StartRecoveryOutput) {
	op := &request.Operation{
		Name:       opStartRecovery,
		HTTPMethod: "POST",
		HTTPPath:   "/StartRecovery",
	}

	if input == nil {
		input = &StartRecoveryInput{}
	}

	output = &StartRecoveryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartRecovery API operation for Elastic Disaster Recovery Service.
//
// Launches Recovery Instances for the specified Source Servers. For each Source
// Server you may choose a point in time snapshot to launch from, or use an
// on demand snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation StartRecovery for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ServiceQuotaExceededException
//     The request could not be completed because its exceeded the service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartRecovery
func (c *Drs) StartRecovery(input *StartRecoveryInput) (*StartRecoveryOutput, error) {
	req, out := c.StartRecoveryRequest(input)
	return out, req.Send()
}

// StartRecoveryWithContext is the same as StartRecovery with the addition of
// the ability to pass a context and additional request options.
//
// See StartRecovery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) StartRecoveryWithContext(ctx aws.Context, input *StartRecoveryInput, opts ...request.Option) (*StartRecoveryOutput, error) {
	req, out := c.StartRecoveryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplication = "StartReplication"

// StartReplicationRequest generates a "aws/request.Request" representing the
// client's request for the StartReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplication for more information on using the StartReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartReplicationRequest method.
//	req, resp := client.StartReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartReplication
func (c *Drs) StartReplicationRequest(input *StartReplicationInput) (req *request.Request, output *StartReplicationOutput) {
	op := &request.Operation{
		Name:       opStartReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/StartReplication",
	}

	if input == nil {
		input = &StartReplicationInput{}
	}

	output = &StartReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplication API operation for Elastic Disaster Recovery Service.
//
// Starts replication for a stopped Source Server. This action would make the
// Source Server protected again and restart billing for it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation StartReplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartReplication
func (c *Drs) StartReplication(input *StartReplicationInput) (*StartReplicationOutput, error) {
	req, out := c.StartReplicationRequest(input)
	return out, req.Send()
}

// StartReplicationWithContext is the same as StartReplication with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) StartReplicationWithContext(ctx aws.Context, input *StartReplicationInput, opts ...request.Option) (*StartReplicationOutput, error) {
	req, out := c.StartReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSourceNetworkRecovery = "StartSourceNetworkRecovery"

// StartSourceNetworkRecoveryRequest generates a "aws/request.Request" representing the
// client's request for the StartSourceNetworkRecovery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSourceNetworkRecovery for more information on using the StartSourceNetworkRecovery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartSourceNetworkRecoveryRequest method.
//	req, resp := client.StartSourceNetworkRecoveryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartSourceNetworkRecovery
func (c *Drs) StartSourceNetworkRecoveryRequest(input *StartSourceNetworkRecoveryInput) (req *request.Request, output *StartSourceNetworkRecoveryOutput) {
	op := &request.Operation{
		Name:       opStartSourceNetworkRecovery,
		HTTPMethod: "POST",
		HTTPPath:   "/StartSourceNetworkRecovery",
	}

	if input == nil {
		input = &StartSourceNetworkRecoveryInput{}
	}

	output = &StartSourceNetworkRecoveryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSourceNetworkRecovery API operation for Elastic Disaster Recovery Service.
//
// Deploy VPC for the specified Source Network and modify launch templates to
// use this network. The VPC will be deployed using a dedicated CloudFormation
// stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation StartSourceNetworkRecovery for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ServiceQuotaExceededException
//     The request could not be completed because its exceeded the service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartSourceNetworkRecovery
func (c *Drs) StartSourceNetworkRecovery(input *StartSourceNetworkRecoveryInput) (*StartSourceNetworkRecoveryOutput, error) {
	req, out := c.StartSourceNetworkRecoveryRequest(input)
	return out, req.Send()
}

// StartSourceNetworkRecoveryWithContext is the same as StartSourceNetworkRecovery with the addition of
// the ability to pass a context and additional request options.
//
// See StartSourceNetworkRecovery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) StartSourceNetworkRecoveryWithContext(ctx aws.Context, input *StartSourceNetworkRecoveryInput, opts ...request.Option) (*StartSourceNetworkRecoveryOutput, error) {
	req, out := c.StartSourceNetworkRecoveryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSourceNetworkReplication = "StartSourceNetworkReplication"

// StartSourceNetworkReplicationRequest generates a "aws/request.Request" representing the
// client's request for the StartSourceNetworkReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSourceNetworkReplication for more information on using the StartSourceNetworkReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartSourceNetworkReplicationRequest method.
//	req, resp := client.StartSourceNetworkReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartSourceNetworkReplication
func (c *Drs) StartSourceNetworkReplicationRequest(input *StartSourceNetworkReplicationInput) (req *request.Request, output *StartSourceNetworkReplicationOutput) {
	op := &request.Operation{
		Name:       opStartSourceNetworkReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/StartSourceNetworkReplication",
	}

	if input == nil {
		input = &StartSourceNetworkReplicationInput{}
	}

	output = &StartSourceNetworkReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSourceNetworkReplication API operation for Elastic Disaster Recovery Service.
//
// Starts replication for a Source Network. This action would make the Source
// Network protected.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation StartSourceNetworkReplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartSourceNetworkReplication
func (c *Drs) StartSourceNetworkReplication(input *StartSourceNetworkReplicationInput) (*StartSourceNetworkReplicationOutput, error) {
	req, out := c.StartSourceNetworkReplicationRequest(input)
	return out, req.Send()
}

// StartSourceNetworkReplicationWithContext is the same as StartSourceNetworkReplication with the addition of
// the ability to pass a context and additional request options.
//
// See StartSourceNetworkReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) StartSourceNetworkReplicationWithContext(ctx aws.Context, input *StartSourceNetworkReplicationInput, opts ...request.Option) (*StartSourceNetworkReplicationOutput, error) {
	req, out := c.StartSourceNetworkReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopFailback = "StopFailback"

// StopFailbackRequest generates a "aws/request.Request" representing the
// client's request for the StopFailback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopFailback for more information on using the StopFailback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopFailbackRequest method.
//	req, resp := client.StopFailbackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StopFailback
func (c *Drs) StopFailbackRequest(input *StopFailbackInput) (req *request.Request, output *StopFailbackOutput) {
	op := &request.Operation{
		Name:       opStopFailback,
		HTTPMethod: "POST",
		HTTPPath:   "/StopFailback",
	}

	if input == nil {
		input = &StopFailbackInput{}
	}

	output = &StopFailbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopFailback API operation for Elastic Disaster Recovery Service.
//
// Stops the failback process for a specified Recovery Instance. This changes
// the Failback State of the Recovery Instance back to FAILBACK_NOT_STARTED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation StopFailback for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StopFailback
func (c *Drs) StopFailback(input *StopFailbackInput) (*StopFailbackOutput, error) {
	req, out := c.StopFailbackRequest(input)
	return out, req.Send()
}

// StopFailbackWithContext is the same as StopFailback with the addition of
// the ability to pass a context and additional request options.
//
// See StopFailback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) StopFailbackWithContext(ctx aws.Context, input *StopFailbackInput, opts ...request.Option) (*StopFailbackOutput, error) {
	req, out := c.StopFailbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopReplication = "StopReplication"

// StopReplicationRequest generates a "aws/request.Request" representing the
// client's request for the StopReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopReplication for more information on using the StopReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopReplicationRequest method.
//	req, resp := client.StopReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StopReplication
func (c *Drs) StopReplicationRequest(input *StopReplicationInput) (req *request.Request, output *StopReplicationOutput) {
	op := &request.Operation{
		Name:       opStopReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/StopReplication",
	}

	if input == nil {
		input = &StopReplicationInput{}
	}

	output = &StopReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopReplication API operation for Elastic Disaster Recovery Service.
//
// Stops replication for a Source Server. This action would make the Source
// Server unprotected, delete its existing snapshots and stop billing for it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation StopReplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StopReplication
func (c *Drs) StopReplication(input *StopReplicationInput) (*StopReplicationOutput, error) {
	req, out := c.StopReplicationRequest(input)
	return out, req.Send()
}

// StopReplicationWithContext is the same as StopReplication with the addition of
// the ability to pass a context and additional request options.
//
// See StopReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) StopReplicationWithContext(ctx aws.Context, input *StopReplicationInput, opts ...request.Option) (*StopReplicationOutput, error) {
	req, out := c.StopReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopSourceNetworkReplication = "StopSourceNetworkReplication"

// StopSourceNetworkReplicationRequest generates a "aws/request.Request" representing the
// client's request for the StopSourceNetworkReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopSourceNetworkReplication for more information on using the StopSourceNetworkReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopSourceNetworkReplicationRequest method.
//	req, resp := client.StopSourceNetworkReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StopSourceNetworkReplication
func (c *Drs) StopSourceNetworkReplicationRequest(input *StopSourceNetworkReplicationInput) (req *request.Request, output *StopSourceNetworkReplicationOutput) {
	op := &request.Operation{
		Name:       opStopSourceNetworkReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/StopSourceNetworkReplication",
	}

	if input == nil {
		input = &StopSourceNetworkReplicationInput{}
	}

	output = &StopSourceNetworkReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopSourceNetworkReplication API operation for Elastic Disaster Recovery Service.
//
// Stops replication for a Source Network. This action would make the Source
// Network unprotected.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation StopSourceNetworkReplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StopSourceNetworkReplication
func (c *Drs) StopSourceNetworkReplication(input *StopSourceNetworkReplicationInput) (*StopSourceNetworkReplicationOutput, error) {
	req, out := c.StopSourceNetworkReplicationRequest(input)
	return out, req.Send()
}

// StopSourceNetworkReplicationWithContext is the same as StopSourceNetworkReplication with the addition of
// the ability to pass a context and additional request options.
//
// See StopSourceNetworkReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) StopSourceNetworkReplicationWithContext(ctx aws.Context, input *StopSourceNetworkReplicationInput, opts ...request.Option) (*StopSourceNetworkReplicationOutput, error) {
	req, out := c.StopSourceNetworkReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/TagResource
func (c *Drs) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Elastic Disaster Recovery Service.
//
// Adds or overwrites only the specified tags for the specified Elastic Disaster
// Recovery resource or resources. When you specify an existing tag key, the
// value is overwritten with the new value. Each resource can have a maximum
// of 50 tags. Each tag consists of a key and optional value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/TagResource
func (c *Drs) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateRecoveryInstances = "TerminateRecoveryInstances"

// TerminateRecoveryInstancesRequest generates a "aws/request.Request" representing the
// client's request for the TerminateRecoveryInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateRecoveryInstances for more information on using the TerminateRecoveryInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TerminateRecoveryInstancesRequest method.
//	req, resp := client.TerminateRecoveryInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/TerminateRecoveryInstances
func (c *Drs) TerminateRecoveryInstancesRequest(input *TerminateRecoveryInstancesInput) (req *request.Request, output *TerminateRecoveryInstancesOutput) {
	op := &request.Operation{
		Name:       opTerminateRecoveryInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/TerminateRecoveryInstances",
	}

	if input == nil {
		input = &TerminateRecoveryInstancesInput{}
	}

	output = &TerminateRecoveryInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateRecoveryInstances API operation for Elastic Disaster Recovery Service.
//
// Initiates a Job for terminating the EC2 resources associated with the specified
// Recovery Instances, and then will delete the Recovery Instances from the
// Elastic Disaster Recovery service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation TerminateRecoveryInstances for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ServiceQuotaExceededException
//     The request could not be completed because its exceeded the service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/TerminateRecoveryInstances
func (c *Drs) TerminateRecoveryInstances(input *TerminateRecoveryInstancesInput) (*TerminateRecoveryInstancesOutput, error) {
	req, out := c.TerminateRecoveryInstancesRequest(input)
	return out, req.Send()
}

// TerminateRecoveryInstancesWithContext is the same as TerminateRecoveryInstances with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateRecoveryInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) TerminateRecoveryInstancesWithContext(ctx aws.Context, input *TerminateRecoveryInstancesInput, opts ...request.Option) (*TerminateRecoveryInstancesOutput, error) {
	req, out := c.TerminateRecoveryInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UntagResource
func (c *Drs) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Elastic Disaster Recovery Service.
//
// Deletes the specified set of tags from the specified set of Elastic Disaster
// Recovery resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UntagResource
func (c *Drs) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFailbackReplicationConfiguration = "UpdateFailbackReplicationConfiguration"

// UpdateFailbackReplicationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFailbackReplicationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFailbackReplicationConfiguration for more information on using the UpdateFailbackReplicationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFailbackReplicationConfigurationRequest method.
//	req, resp := client.UpdateFailbackReplicationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateFailbackReplicationConfiguration
func (c *Drs) UpdateFailbackReplicationConfigurationRequest(input *UpdateFailbackReplicationConfigurationInput) (req *request.Request, output *UpdateFailbackReplicationConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateFailbackReplicationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateFailbackReplicationConfiguration",
	}

	if input == nil {
		input = &UpdateFailbackReplicationConfigurationInput{}
	}

	output = &UpdateFailbackReplicationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFailbackReplicationConfiguration API operation for Elastic Disaster Recovery Service.
//
// Allows you to update the failback replication configuration of a Recovery
// Instance by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation UpdateFailbackReplicationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateFailbackReplicationConfiguration
func (c *Drs) UpdateFailbackReplicationConfiguration(input *UpdateFailbackReplicationConfigurationInput) (*UpdateFailbackReplicationConfigurationOutput, error) {
	req, out := c.UpdateFailbackReplicationConfigurationRequest(input)
	return out, req.Send()
}

// UpdateFailbackReplicationConfigurationWithContext is the same as UpdateFailbackReplicationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFailbackReplicationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) UpdateFailbackReplicationConfigurationWithContext(ctx aws.Context, input *UpdateFailbackReplicationConfigurationInput, opts ...request.Option) (*UpdateFailbackReplicationConfigurationOutput, error) {
	req, out := c.UpdateFailbackReplicationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLaunchConfiguration = "UpdateLaunchConfiguration"

// UpdateLaunchConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLaunchConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLaunchConfiguration for more information on using the UpdateLaunchConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLaunchConfigurationRequest method.
//	req, resp := client.UpdateLaunchConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateLaunchConfiguration
func (c *Drs) UpdateLaunchConfigurationRequest(input *UpdateLaunchConfigurationInput) (req *request.Request, output *UpdateLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateLaunchConfiguration",
	}

	if input == nil {
		input = &UpdateLaunchConfigurationInput{}
	}

	output = &UpdateLaunchConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLaunchConfiguration API operation for Elastic Disaster Recovery Service.
//
// Updates a LaunchConfiguration by Source Server ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation UpdateLaunchConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateLaunchConfiguration
func (c *Drs) UpdateLaunchConfiguration(input *UpdateLaunchConfigurationInput) (*UpdateLaunchConfigurationOutput, error) {
	req, out := c.UpdateLaunchConfigurationRequest(input)
	return out, req.Send()
}

// UpdateLaunchConfigurationWithContext is the same as UpdateLaunchConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLaunchConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) UpdateLaunchConfigurationWithContext(ctx aws.Context, input *UpdateLaunchConfigurationInput, opts ...request.Option) (*UpdateLaunchConfigurationOutput, error) {
	req, out := c.UpdateLaunchConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLaunchConfigurationTemplate = "UpdateLaunchConfigurationTemplate"

// UpdateLaunchConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLaunchConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLaunchConfigurationTemplate for more information on using the UpdateLaunchConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLaunchConfigurationTemplateRequest method.
//	req, resp := client.UpdateLaunchConfigurationTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateLaunchConfigurationTemplate
func (c *Drs) UpdateLaunchConfigurationTemplateRequest(input *UpdateLaunchConfigurationTemplateInput) (req *request.Request, output *UpdateLaunchConfigurationTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateLaunchConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateLaunchConfigurationTemplate",
	}

	if input == nil {
		input = &UpdateLaunchConfigurationTemplateInput{}
	}

	output = &UpdateLaunchConfigurationTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLaunchConfigurationTemplate API operation for Elastic Disaster Recovery Service.
//
// Updates an existing Launch Configuration Template by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation UpdateLaunchConfigurationTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateLaunchConfigurationTemplate
func (c *Drs) UpdateLaunchConfigurationTemplate(input *UpdateLaunchConfigurationTemplateInput) (*UpdateLaunchConfigurationTemplateOutput, error) {
	req, out := c.UpdateLaunchConfigurationTemplateRequest(input)
	return out, req.Send()
}

// UpdateLaunchConfigurationTemplateWithContext is the same as UpdateLaunchConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLaunchConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) UpdateLaunchConfigurationTemplateWithContext(ctx aws.Context, input *UpdateLaunchConfigurationTemplateInput, opts ...request.Option) (*UpdateLaunchConfigurationTemplateOutput, error) {
	req, out := c.UpdateLaunchConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReplicationConfiguration = "UpdateReplicationConfiguration"

// UpdateReplicationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReplicationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReplicationConfiguration for more information on using the UpdateReplicationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateReplicationConfigurationRequest method.
//	req, resp := client.UpdateReplicationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateReplicationConfiguration
func (c *Drs) UpdateReplicationConfigurationRequest(input *UpdateReplicationConfigurationInput) (req *request.Request, output *UpdateReplicationConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateReplicationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateReplicationConfiguration",
	}

	if input == nil {
		input = &UpdateReplicationConfigurationInput{}
	}

	output = &UpdateReplicationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReplicationConfiguration API operation for Elastic Disaster Recovery Service.
//
// Allows you to update a ReplicationConfiguration by Source Server ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation UpdateReplicationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateReplicationConfiguration
func (c *Drs) UpdateReplicationConfiguration(input *UpdateReplicationConfigurationInput) (*UpdateReplicationConfigurationOutput, error) {
	req, out := c.UpdateReplicationConfigurationRequest(input)
	return out, req.Send()
}

// UpdateReplicationConfigurationWithContext is the same as UpdateReplicationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReplicationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) UpdateReplicationConfigurationWithContext(ctx aws.Context, input *UpdateReplicationConfigurationInput, opts ...request.Option) (*UpdateReplicationConfigurationOutput, error) {
	req, out := c.UpdateReplicationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReplicationConfigurationTemplate = "UpdateReplicationConfigurationTemplate"

// UpdateReplicationConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReplicationConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReplicationConfigurationTemplate for more information on using the UpdateReplicationConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateReplicationConfigurationTemplateRequest method.
//	req, resp := client.UpdateReplicationConfigurationTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateReplicationConfigurationTemplate
func (c *Drs) UpdateReplicationConfigurationTemplateRequest(input *UpdateReplicationConfigurationTemplateInput) (req *request.Request, output *UpdateReplicationConfigurationTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateReplicationConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateReplicationConfigurationTemplate",
	}

	if input == nil {
		input = &UpdateReplicationConfigurationTemplateInput{}
	}

	output = &UpdateReplicationConfigurationTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReplicationConfigurationTemplate API operation for Elastic Disaster Recovery Service.
//
// Updates a ReplicationConfigurationTemplate by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Disaster Recovery Service's
// API operation UpdateReplicationConfigurationTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource for this operation was not found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the AWS service.
//
//   - UninitializedAccountException
//     The account performing the request has not been initialized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateReplicationConfigurationTemplate
func (c *Drs) UpdateReplicationConfigurationTemplate(input *UpdateReplicationConfigurationTemplateInput) (*UpdateReplicationConfigurationTemplateOutput, error) {
	req, out := c.UpdateReplicationConfigurationTemplateRequest(input)
	return out, req.Send()
}

// UpdateReplicationConfigurationTemplateWithContext is the same as UpdateReplicationConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReplicationConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Drs) UpdateReplicationConfigurationTemplateWithContext(ctx aws.Context, input *UpdateReplicationConfigurationTemplateInput, opts ...request.Option) (*UpdateReplicationConfigurationTemplateOutput, error) {
	req, out := c.UpdateReplicationConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS account.
type Account struct {
	_ struct{} `type:"structure"`

	// Account ID of AWS account.
	AccountID *string `locationName:"accountID" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Account) GoString() string {
	return s.String()
}

// SetAccountID sets the AccountID field's value.
func (s *Account) SetAccountID(v string) *Account {
	s.AccountID = &v
	return s
}

type AssociateSourceNetworkStackInput struct {
	_ struct{} `type:"structure"`

	// CloudFormation template to associate with a Source Network.
	//
	// CfnStackName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssociateSourceNetworkStackInput's
	// String and GoString methods.
	//
	// CfnStackName is a required field
	CfnStackName *string `locationName:"cfnStackName" min:"1" type:"string" required:"true" sensitive:"true"`

	// The Source Network ID to associate with CloudFormation template.
	//
	// SourceNetworkID is a required field
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSourceNetworkStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSourceNetworkStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSourceNetworkStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateSourceNetworkStackInput"}
	if s.CfnStackName == nil {
		invalidParams.Add(request.NewErrParamRequired("CfnStackName"))
	}
	if s.CfnStackName != nil && len(*s.CfnStackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CfnStackName", 1))
	}
	if s.SourceNetworkID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceNetworkID"))
	}
	if s.SourceNetworkID != nil && len(*s.SourceNetworkID) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceNetworkID", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCfnStackName sets the CfnStackName field's value.
func (s *AssociateSourceNetworkStackInput) SetCfnStackName(v string) *AssociateSourceNetworkStackInput {
	s.CfnStackName = &v
	return s
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *AssociateSourceNetworkStackInput) SetSourceNetworkID(v string) *AssociateSourceNetworkStackInput {
	s.SourceNetworkID = &v
	return s
}

type AssociateSourceNetworkStackOutput struct {
	_ struct{} `type:"structure"`

	// The Source Network association Job.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSourceNetworkStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSourceNetworkStackOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *AssociateSourceNetworkStackOutput) SetJob(v *Job) *AssociateSourceNetworkStackOutput {
	s.Job = v
	return s
}

// Information about a server's CPU.
type CPU struct {
	_ struct{} `type:"structure"`

	// The number of CPU cores.
	Cores *int64 `locationName:"cores" type:"long"`

	// The model name of the CPU.
	ModelName *string `locationName:"modelName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CPU) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CPU) GoString() string {
	return s.String()
}

// SetCores sets the Cores field's value.
func (s *CPU) SetCores(v int64) *CPU {
	s.Cores = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CPU) SetModelName(v string) *CPU {
	s.ModelName = &v
	return s
}

// The request could not be completed due to a conflict with the current state
// of the target resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Properties of a conversion job
type ConversionProperties struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the snapshot being converted was taken
	DataTimestamp *string `locationName:"dataTimestamp" type:"string"`

	// Whether the volume being converted uses UEFI or not
	ForceUefi *bool `locationName:"forceUefi" type:"boolean"`

	// The root volume name of a conversion job
	RootVolumeName *string `locationName:"rootVolumeName" type:"string"`

	// A mapping between the volumes being converted and the converted snapshot
	// ids
	VolumeToConversionMap map[string]map[string]*string `locationName:"volumeToConversionMap" type:"map"`

	// A mapping between the volumes being converted and the product codes associated
	// with them
	VolumeToProductCodes map[string][]*ProductCode `locationName:"volumeToProductCodes" type:"map"`

	// A mapping between the volumes and their sizes
	VolumeToVolumeSize map[string]*int64 `locationName:"volumeToVolumeSize" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversionProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversionProperties) GoString() string {
	return s.String()
}

// SetDataTimestamp sets the DataTimestamp field's value.
func (s *ConversionProperties) SetDataTimestamp(v string) *ConversionProperties {
	s.DataTimestamp = &v
	return s
}

// SetForceUefi sets the ForceUefi field's value.
func (s *ConversionProperties) SetForceUefi(v bool) *ConversionProperties {
	s.ForceUefi = &v
	return s
}

// SetRootVolumeName sets the RootVolumeName field's value.
func (s *ConversionProperties) SetRootVolumeName(v string) *ConversionProperties {
	s.RootVolumeName = &v
	return s
}

// SetVolumeToConversionMap sets the VolumeToConversionMap field's value.
func (s *ConversionProperties) SetVolumeToConversionMap(v map[string]map[string]*string) *ConversionProperties {
	s.VolumeToConversionMap = v
	return s
}

// SetVolumeToProductCodes sets the VolumeToProductCodes field's value.
func (s *ConversionProperties) SetVolumeToProductCodes(v map[string][]*ProductCode) *ConversionProperties {
	s.VolumeToProductCodes = v
	return s
}

// SetVolumeToVolumeSize sets the VolumeToVolumeSize field's value.
func (s *ConversionProperties) SetVolumeToVolumeSize(v map[string]*int64) *ConversionProperties {
	s.VolumeToVolumeSize = v
	return s
}

type CreateExtendedSourceServerInput struct {
	_ struct{} `type:"structure"`

	// This defines the ARN of the source server in staging Account based on which
	// you want to create an extended source server.
	//
	// SourceServerArn is a required field
	SourceServerArn *string `locationName:"sourceServerArn" min:"20" type:"string" required:"true"`

	// A list of tags associated with the extended source server.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateExtendedSourceServerInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtendedSourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtendedSourceServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExtendedSourceServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExtendedSourceServerInput"}
	if s.SourceServerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerArn"))
	}
	if s.SourceServerArn != nil && len(*s.SourceServerArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerArn sets the SourceServerArn field's value.
func (s *CreateExtendedSourceServerInput) SetSourceServerArn(v string) *CreateExtendedSourceServerInput {
	s.SourceServerArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateExtendedSourceServerInput) SetTags(v map[string]*string) *CreateExtendedSourceServerInput {
	s.Tags = v
	return s
}

type CreateExtendedSourceServerOutput struct {
	_ struct{} `type:"structure"`

	// Created extended source server.
	SourceServer *SourceServer `locationName:"sourceServer" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtendedSourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtendedSourceServerOutput) GoString() string {
	return s.String()
}

// SetSourceServer sets the SourceServer field's value.
func (s *CreateExtendedSourceServerOutput) SetSourceServer(v *SourceServer) *CreateExtendedSourceServerOutput {
	s.SourceServer = v
	return s
}

type CreateLaunchConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// Copy private IP.
	CopyPrivateIp *bool `locationName:"copyPrivateIp" type:"boolean"`

	// Copy tags.
	CopyTags *bool `locationName:"copyTags" type:"boolean"`

	// S3 bucket ARN to export Source Network templates.
	ExportBucketArn *string `locationName:"exportBucketArn" min:"20" type:"string"`

	// Launch disposition.
	LaunchDisposition *string `locationName:"launchDisposition" type:"string" enum:"LaunchDisposition"`

	// DRS will set the 'launch into instance ID' of any source server when performing
	// a drill, recovery or failback to the previous region or availability zone,
	// using the instance ID of the source instance.
	LaunchIntoSourceInstance *bool `locationName:"launchIntoSourceInstance" type:"boolean"`

	// Licensing.
	Licensing *Licensing `locationName:"licensing" type:"structure"`

	// Whether we want to activate post-launch actions.
	PostLaunchEnabled *bool `locationName:"postLaunchEnabled" type:"boolean"`

	// Request to associate tags during creation of a Launch Configuration Template.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateLaunchConfigurationTemplateInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Target instance type right-sizing method.
	TargetInstanceTypeRightSizingMethod *string `locationName:"targetInstanceTypeRightSizingMethod" type:"string" enum:"TargetInstanceTypeRightSizingMethod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLaunchConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLaunchConfigurationTemplateInput"}
	if s.ExportBucketArn != nil && len(*s.ExportBucketArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExportBucketArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyPrivateIp sets the CopyPrivateIp field's value.
func (s *CreateLaunchConfigurationTemplateInput) SetCopyPrivateIp(v bool) *CreateLaunchConfigurationTemplateInput {
	s.CopyPrivateIp = &v
	return s
}

// SetCopyTags sets the CopyTags field's value.
func (s *CreateLaunchConfigurationTemplateInput) SetCopyTags(v bool) *CreateLaunchConfigurationTemplateInput {
	s.CopyTags = &v
	return s
}

// SetExportBucketArn sets the ExportBucketArn field's value.
func (s *CreateLaunchConfigurationTemplateInput) SetExportBucketArn(v string) *CreateLaunchConfigurationTemplateInput {
	s.ExportBucketArn = &v
	return s
}

// SetLaunchDisposition sets the LaunchDisposition field's value.
func (s *CreateLaunchConfigurationTemplateInput) SetLaunchDisposition(v string) *CreateLaunchConfigurationTemplateInput {
	s.LaunchDisposition = &v
	return s
}

// SetLaunchIntoSourceInstance sets the LaunchIntoSourceInstance field's value.
func (s *CreateLaunchConfigurationTemplateInput) SetLaunchIntoSourceInstance(v bool) *CreateLaunchConfigurationTemplateInput {
	s.LaunchIntoSourceInstance = &v
	return s
}

// SetLicensing sets the Licensing field's value.
func (s *CreateLaunchConfigurationTemplateInput) SetLicensing(v *Licensing) *CreateLaunchConfigurationTemplateInput {
	s.Licensing = v
	return s
}

// SetPostLaunchEnabled sets the PostLaunchEnabled field's value.
func (s *CreateLaunchConfigurationTemplateInput) SetPostLaunchEnabled(v bool) *CreateLaunchConfigurationTemplateInput {
	s.PostLaunchEnabled = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLaunchConfigurationTemplateInput) SetTags(v map[string]*string) *CreateLaunchConfigurationTemplateInput {
	s.Tags = v
	return s
}

// SetTargetInstanceTypeRightSizingMethod sets the TargetInstanceTypeRightSizingMethod field's value.
func (s *CreateLaunchConfigurationTemplateInput) SetTargetInstanceTypeRightSizingMethod(v string) *CreateLaunchConfigurationTemplateInput {
	s.TargetInstanceTypeRightSizingMethod = &v
	return s
}

type CreateLaunchConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Created Launch Configuration Template.
	LaunchConfigurationTemplate *LaunchConfigurationTemplate `locationName:"launchConfigurationTemplate" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchConfigurationTemplateOutput) GoString() string {
	return s.String()
}

// SetLaunchConfigurationTemplate sets the LaunchConfigurationTemplate field's value.
func (s *CreateLaunchConfigurationTemplateOutput) SetLaunchConfigurationTemplate(v *LaunchConfigurationTemplate) *CreateLaunchConfigurationTemplateOutput {
	s.LaunchConfigurationTemplate = v
	return s
}

type CreateReplicationConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// Whether to associate the default Elastic Disaster Recovery Security group
	// with the Replication Configuration Template.
	//
	// AssociateDefaultSecurityGroup is a required field
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean" required:"true"`

	// Whether to allow the AWS replication agent to automatically replicate newly
	// added disks.
	AutoReplicateNewDisks *bool `locationName:"autoReplicateNewDisks" type:"boolean"`

	// Configure bandwidth throttling for the outbound data transfer rate of the
	// Source Server in Mbps.
	//
	// BandwidthThrottling is a required field
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long" required:"true"`

	// Whether to create a Public IP for the Recovery Instance by default.
	//
	// CreatePublicIP is a required field
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean" required:"true"`

	// The data plane routing mechanism that will be used for replication.
	//
	// DataPlaneRouting is a required field
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" required:"true" enum:"ReplicationConfigurationDataPlaneRouting"`

	// The Staging Disk EBS volume type to be used during replication.
	//
	// DefaultLargeStagingDiskType is a required field
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" required:"true" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// The type of EBS encryption to be used during replication.
	//
	// EbsEncryption is a required field
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" required:"true" enum:"ReplicationConfigurationEbsEncryption"`

	// The ARN of the EBS encryption key to be used during replication.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// The Point in time (PIT) policy to manage snapshots taken during replication.
	//
	// PitPolicy is a required field
	PitPolicy []*PITPolicyRule `locationName:"pitPolicy" min:"1" type:"list" required:"true"`

	// The instance type to be used for the replication server.
	//
	// ReplicationServerInstanceType is a required field
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string" required:"true"`

	// The security group IDs that will be used by the replication server.
	//
	// ReplicationServersSecurityGroupsIDs is a required field
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list" required:"true"`

	// The subnet to be used by the replication staging area.
	//
	// StagingAreaSubnetId is a required field
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string" required:"true"`

	// A set of tags to be associated with all resources created in the replication
	// staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateReplicationConfigurationTemplateInput's
	// String and GoString methods.
	//
	// StagingAreaTags is a required field
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" required:"true" sensitive:"true"`

	// A set of tags to be associated with the Replication Configuration Template
	// resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateReplicationConfigurationTemplateInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Whether to use a dedicated Replication Server in the replication staging
	// area.
	//
	// UseDedicatedReplicationServer is a required field
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationConfigurationTemplateInput"}
	if s.AssociateDefaultSecurityGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociateDefaultSecurityGroup"))
	}
	if s.BandwidthThrottling == nil {
		invalidParams.Add(request.NewErrParamRequired("BandwidthThrottling"))
	}
	if s.CreatePublicIP == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatePublicIP"))
	}
	if s.DataPlaneRouting == nil {
		invalidParams.Add(request.NewErrParamRequired("DataPlaneRouting"))
	}
	if s.DefaultLargeStagingDiskType == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultLargeStagingDiskType"))
	}
	if s.EbsEncryption == nil {
		invalidParams.Add(request.NewErrParamRequired("EbsEncryption"))
	}
	if s.EbsEncryptionKeyArn != nil && len(*s.EbsEncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EbsEncryptionKeyArn", 20))
	}
	if s.PitPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("PitPolicy"))
	}
	if s.PitPolicy != nil && len(s.PitPolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PitPolicy", 1))
	}
	if s.ReplicationServerInstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationServerInstanceType"))
	}
	if s.ReplicationServersSecurityGroupsIDs == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationServersSecurityGroupsIDs"))
	}
	if s.StagingAreaSubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("StagingAreaSubnetId"))
	}
	if s.StagingAreaTags == nil {
		invalidParams.Add(request.NewErrParamRequired("StagingAreaTags"))
	}
	if s.UseDedicatedReplicationServer == nil {
		invalidParams.Add(request.NewErrParamRequired("UseDedicatedReplicationServer"))
	}
	if s.PitPolicy != nil {
		for i, v := range s.PitPolicy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PitPolicy", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetAssociateDefaultSecurityGroup(v bool) *CreateReplicationConfigurationTemplateInput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetAutoReplicateNewDisks sets the AutoReplicateNewDisks field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetAutoReplicateNewDisks(v bool) *CreateReplicationConfigurationTemplateInput {
	s.AutoReplicateNewDisks = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetBandwidthThrottling(v int64) *CreateReplicationConfigurationTemplateInput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetCreatePublicIP(v bool) *CreateReplicationConfigurationTemplateInput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetDataPlaneRouting(v string) *CreateReplicationConfigurationTemplateInput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetDefaultLargeStagingDiskType(v string) *CreateReplicationConfigurationTemplateInput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetEbsEncryption(v string) *CreateReplicationConfigurationTemplateInput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetEbsEncryptionKeyArn(v string) *CreateReplicationConfigurationTemplateInput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetPitPolicy sets the PitPolicy field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetPitPolicy(v []*PITPolicyRule) *CreateReplicationConfigurationTemplateInput {
	s.PitPolicy = v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetReplicationServerInstanceType(v string) *CreateReplicationConfigurationTemplateInput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetReplicationServersSecurityGroupsIDs(v []*string) *CreateReplicationConfigurationTemplateInput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetStagingAreaSubnetId(v string) *CreateReplicationConfigurationTemplateInput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetStagingAreaTags(v map[string]*string) *CreateReplicationConfigurationTemplateInput {
	s.StagingAreaTags = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetTags(v map[string]*string) *CreateReplicationConfigurationTemplateInput {
	s.Tags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetUseDedicatedReplicationServer(v bool) *CreateReplicationConfigurationTemplateInput {
	s.UseDedicatedReplicationServer = &v
	return s
}

type CreateReplicationConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Replication Configuration Template ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Whether to associate the default Elastic Disaster Recovery Security group
	// with the Replication Configuration Template.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Whether to allow the AWS replication agent to automatically replicate newly
	// added disks.
	AutoReplicateNewDisks *bool `locationName:"autoReplicateNewDisks" type:"boolean"`

	// Configure bandwidth throttling for the outbound data transfer rate of the
	// Source Server in Mbps.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Whether to create a Public IP for the Recovery Instance by default.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// The data plane routing mechanism that will be used for replication.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// The Staging Disk EBS volume type to be used during replication.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// The type of EBS encryption to be used during replication.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// The ARN of the EBS encryption key to be used during replication.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// The Point in time (PIT) policy to manage snapshots taken during replication.
	PitPolicy []*PITPolicyRule `locationName:"pitPolicy" min:"1" type:"list"`

	// The Replication Configuration Template ID.
	//
	// ReplicationConfigurationTemplateID is a required field
	ReplicationConfigurationTemplateID *string `locationName:"replicationConfigurationTemplateID" min:"21" type:"string" required:"true"`

	// The instance type to be used for the replication server.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// The security group IDs that will be used by the replication server.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// The subnet to be used by the replication staging area.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// A set of tags to be associated with all resources created in the replication
	// staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateReplicationConfigurationTemplateOutput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// A set of tags to be associated with the Replication Configuration Template
	// resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateReplicationConfigurationTemplateOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Whether to use a dedicated Replication Server in the replication staging
	// area.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetArn(v string) *CreateReplicationConfigurationTemplateOutput {
	s.Arn = &v
	return s
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetAssociateDefaultSecurityGroup(v bool) *CreateReplicationConfigurationTemplateOutput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetAutoReplicateNewDisks sets the AutoReplicateNewDisks field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetAutoReplicateNewDisks(v bool) *CreateReplicationConfigurationTemplateOutput {
	s.AutoReplicateNewDisks = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetBandwidthThrottling(v int64) *CreateReplicationConfigurationTemplateOutput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetCreatePublicIP(v bool) *CreateReplicationConfigurationTemplateOutput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetDataPlaneRouting(v string) *CreateReplicationConfigurationTemplateOutput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetDefaultLargeStagingDiskType(v string) *CreateReplicationConfigurationTemplateOutput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetEbsEncryption(v string) *CreateReplicationConfigurationTemplateOutput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetEbsEncryptionKeyArn(v string) *CreateReplicationConfigurationTemplateOutput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetPitPolicy sets the PitPolicy field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetPitPolicy(v []*PITPolicyRule) *CreateReplicationConfigurationTemplateOutput {
	s.PitPolicy = v
	return s
}

// SetReplicationConfigurationTemplateID sets the ReplicationConfigurationTemplateID field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetReplicationConfigurationTemplateID(v string) *CreateReplicationConfigurationTemplateOutput {
	s.ReplicationConfigurationTemplateID = &v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetReplicationServerInstanceType(v string) *CreateReplicationConfigurationTemplateOutput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetReplicationServersSecurityGroupsIDs(v []*string) *CreateReplicationConfigurationTemplateOutput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetStagingAreaSubnetId(v string) *CreateReplicationConfigurationTemplateOutput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetStagingAreaTags(v map[string]*string) *CreateReplicationConfigurationTemplateOutput {
	s.StagingAreaTags = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetTags(v map[string]*string) *CreateReplicationConfigurationTemplateOutput {
	s.Tags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetUseDedicatedReplicationServer(v bool) *CreateReplicationConfigurationTemplateOutput {
	s.UseDedicatedReplicationServer = &v
	return s
}

type CreateSourceNetworkInput struct {
	_ struct{} `type:"structure"`

	// Account containing the VPC to protect.
	//
	// OriginAccountID is a required field
	OriginAccountID *string `locationName:"originAccountID" min:"12" type:"string" required:"true"`

	// Region containing the VPC to protect.
	//
	// OriginRegion is a required field
	OriginRegion *string `locationName:"originRegion" type:"string" required:"true"`

	// A set of tags to be associated with the Source Network resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSourceNetworkInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Which VPC ID to protect.
	//
	// VpcID is a required field
	VpcID *string `locationName:"vpcID" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSourceNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSourceNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSourceNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSourceNetworkInput"}
	if s.OriginAccountID == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginAccountID"))
	}
	if s.OriginAccountID != nil && len(*s.OriginAccountID) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("OriginAccountID", 12))
	}
	if s.OriginRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginRegion"))
	}
	if s.VpcID == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcID"))
	}
	if s.VpcID != nil && len(*s.VpcID) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("VpcID", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOriginAccountID sets the OriginAccountID field's value.
func (s *CreateSourceNetworkInput) SetOriginAccountID(v string) *CreateSourceNetworkInput {
	s.OriginAccountID = &v
	return s
}

// SetOriginRegion sets the OriginRegion field's value.
func (s *CreateSourceNetworkInput) SetOriginRegion(v string) *CreateSourceNetworkInput {
	s.OriginRegion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSourceNetworkInput) SetTags(v map[string]*string) *CreateSourceNetworkInput {
	s.Tags = v
	return s
}

// SetVpcID sets the VpcID field's value.
func (s *CreateSourceNetworkInput) SetVpcID(v string) *CreateSourceNetworkInput {
	s.VpcID = &v
	return s
}

type CreateSourceNetworkOutput struct {
	_ struct{} `type:"structure"`

	// ID of the created Source Network.
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSourceNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSourceNetworkOutput) GoString() string {
	return s.String()
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *CreateSourceNetworkOutput) SetSourceNetworkID(v string) *CreateSourceNetworkOutput {
	s.SourceNetworkID = &v
	return s
}

// Error in data replication.
type DataReplicationError struct {
	_ struct{} `type:"structure"`

	// Error in data replication.
	Error *string `locationName:"error" type:"string" enum:"DataReplicationErrorString"`

	// Error in data replication.
	RawError *string `locationName:"rawError" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationError) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *DataReplicationError) SetError(v string) *DataReplicationError {
	s.Error = &v
	return s
}

// SetRawError sets the RawError field's value.
func (s *DataReplicationError) SetRawError(v string) *DataReplicationError {
	s.RawError = &v
	return s
}

// Information about Data Replication
type DataReplicationInfo struct {
	_ struct{} `type:"structure"`

	// Error in data replication.
	DataReplicationError *DataReplicationError `locationName:"dataReplicationError" type:"structure"`

	// Information about whether the data replication has been initiated.
	DataReplicationInitiation *DataReplicationInitiation `locationName:"dataReplicationInitiation" type:"structure"`

	// The state of the data replication.
	DataReplicationState *string `locationName:"dataReplicationState" type:"string" enum:"DataReplicationState"`

	// An estimate of when the data replication will be completed.
	EtaDateTime *string `locationName:"etaDateTime" min:"19" type:"string"`

	// Data replication lag duration.
	LagDuration *string `locationName:"lagDuration" min:"1" type:"string"`

	// The disks that should be replicated.
	ReplicatedDisks []*DataReplicationInfoReplicatedDisk `locationName:"replicatedDisks" type:"list"`

	// AWS Availability zone into which data is being replicated.
	StagingAvailabilityZone *string `locationName:"stagingAvailabilityZone" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInfo) GoString() string {
	return s.String()
}

// SetDataReplicationError sets the DataReplicationError field's value.
func (s *DataReplicationInfo) SetDataReplicationError(v *DataReplicationError) *DataReplicationInfo {
	s.DataReplicationError = v
	return s
}

// SetDataReplicationInitiation sets the DataReplicationInitiation field's value.
func (s *DataReplicationInfo) SetDataReplicationInitiation(v *DataReplicationInitiation) *DataReplicationInfo {
	s.DataReplicationInitiation = v
	return s
}

// SetDataReplicationState sets the DataReplicationState field's value.
func (s *DataReplicationInfo) SetDataReplicationState(v string) *DataReplicationInfo {
	s.DataReplicationState = &v
	return s
}

// SetEtaDateTime sets the EtaDateTime field's value.
func (s *DataReplicationInfo) SetEtaDateTime(v string) *DataReplicationInfo {
	s.EtaDateTime = &v
	return s
}

// SetLagDuration sets the LagDuration field's value.
func (s *DataReplicationInfo) SetLagDuration(v string) *DataReplicationInfo {
	s.LagDuration = &v
	return s
}

// SetReplicatedDisks sets the ReplicatedDisks field's value.
func (s *DataReplicationInfo) SetReplicatedDisks(v []*DataReplicationInfoReplicatedDisk) *DataReplicationInfo {
	s.ReplicatedDisks = v
	return s
}

// SetStagingAvailabilityZone sets the StagingAvailabilityZone field's value.
func (s *DataReplicationInfo) SetStagingAvailabilityZone(v string) *DataReplicationInfo {
	s.StagingAvailabilityZone = &v
	return s
}

// A disk that should be replicated.
type DataReplicationInfoReplicatedDisk struct {
	_ struct{} `type:"structure"`

	// The size of the replication backlog in bytes.
	BackloggedStorageBytes *int64 `locationName:"backloggedStorageBytes" type:"long"`

	// The name of the device.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// The amount of data replicated so far in bytes.
	ReplicatedStorageBytes *int64 `locationName:"replicatedStorageBytes" type:"long"`

	// The amount of data to be rescanned in bytes.
	RescannedStorageBytes *int64 `locationName:"rescannedStorageBytes" type:"long"`

	// The total amount of data to be replicated in bytes.
	TotalStorageBytes *int64 `locationName:"totalStorageBytes" type:"long"`

	// The status of the volume.
	VolumeStatus *string `locationName:"volumeStatus" type:"string" enum:"VolumeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInfoReplicatedDisk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInfoReplicatedDisk) GoString() string {
	return s.String()
}

// SetBackloggedStorageBytes sets the BackloggedStorageBytes field's value.
func (s *DataReplicationInfoReplicatedDisk) SetBackloggedStorageBytes(v int64) *DataReplicationInfoReplicatedDisk {
	s.BackloggedStorageBytes = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *DataReplicationInfoReplicatedDisk) SetDeviceName(v string) *DataReplicationInfoReplicatedDisk {
	s.DeviceName = &v
	return s
}

// SetReplicatedStorageBytes sets the ReplicatedStorageBytes field's value.
func (s *DataReplicationInfoReplicatedDisk) SetReplicatedStorageBytes(v int64) *DataReplicationInfoReplicatedDisk {
	s.ReplicatedStorageBytes = &v
	return s
}

// SetRescannedStorageBytes sets the RescannedStorageBytes field's value.
func (s *DataReplicationInfoReplicatedDisk) SetRescannedStorageBytes(v int64) *DataReplicationInfoReplicatedDisk {
	s.RescannedStorageBytes = &v
	return s
}

// SetTotalStorageBytes sets the TotalStorageBytes field's value.
func (s *DataReplicationInfoReplicatedDisk) SetTotalStorageBytes(v int64) *DataReplicationInfoReplicatedDisk {
	s.TotalStorageBytes = &v
	return s
}

// SetVolumeStatus sets the VolumeStatus field's value.
func (s *DataReplicationInfoReplicatedDisk) SetVolumeStatus(v string) *DataReplicationInfoReplicatedDisk {
	s.VolumeStatus = &v
	return s
}

// Data replication initiation.
type DataReplicationInitiation struct {
	_ struct{} `type:"structure"`

	// The date and time of the next attempt to initiate data replication.
	NextAttemptDateTime *string `locationName:"nextAttemptDateTime" min:"19" type:"string"`

	// The date and time of the current attempt to initiate data replication.
	StartDateTime *string `locationName:"startDateTime" min:"19" type:"string"`

	// The steps of the current attempt to initiate data replication.
	Steps []*DataReplicationInitiationStep `locationName:"steps" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInitiation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInitiation) GoString() string {
	return s.String()
}

// SetNextAttemptDateTime sets the NextAttemptDateTime field's value.
func (s *DataReplicationInitiation) SetNextAttemptDateTime(v string) *DataReplicationInitiation {
	s.NextAttemptDateTime = &v
	return s
}

// SetStartDateTime sets the StartDateTime field's value.
func (s *DataReplicationInitiation) SetStartDateTime(v string) *DataReplicationInitiation {
	s.StartDateTime = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *DataReplicationInitiation) SetSteps(v []*DataReplicationInitiationStep) *DataReplicationInitiation {
	s.Steps = v
	return s
}

// Data replication initiation step.
type DataReplicationInitiationStep struct {
	_ struct{} `type:"structure"`

	// The name of the step.
	Name *string `locationName:"name" type:"string" enum:"DataReplicationInitiationStepName"`

	// The status of the step.
	Status *string `locationName:"status" type:"string" enum:"DataReplicationInitiationStepStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInitiationStep) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInitiationStep) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DataReplicationInitiationStep) SetName(v string) *DataReplicationInitiationStep {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataReplicationInitiationStep) SetStatus(v string) *DataReplicationInitiationStep {
	s.Status = &v
	return s
}

type DeleteJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Job to be deleted.
	//
	// JobID is a required field
	JobID *string `locationName:"jobID" min:"24" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobInput"}
	if s.JobID == nil {
		invalidParams.Add(request.NewErrParamRequired("JobID"))
	}
	if s.JobID != nil && len(*s.JobID) < 24 {
		invalidParams.Add(request.NewErrParamMinLen("JobID", 24))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobID sets the JobID field's value.
func (s *DeleteJobInput) SetJobID(v string) *DeleteJobInput {
	s.JobID = &v
	return s
}

type DeleteJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobOutput) GoString() string {
	return s.String()
}

type DeleteLaunchActionInput struct {
	_ struct{} `type:"structure"`

	// Launch action Id.
	//
	// ActionId is a required field
	ActionId *string `locationName:"actionId" min:"1" type:"string" required:"true"`

	// Launch configuration template Id or Source Server Id
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLaunchActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLaunchActionInput"}
	if s.ActionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionId"))
	}
	if s.ActionId != nil && len(*s.ActionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionId", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionId sets the ActionId field's value.
func (s *DeleteLaunchActionInput) SetActionId(v string) *DeleteLaunchActionInput {
	s.ActionId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteLaunchActionInput) SetResourceId(v string) *DeleteLaunchActionInput {
	s.ResourceId = &v
	return s
}

type DeleteLaunchActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchActionOutput) GoString() string {
	return s.String()
}

type DeleteLaunchConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Launch Configuration Template to be deleted.
	//
	// LaunchConfigurationTemplateID is a required field
	LaunchConfigurationTemplateID *string `locationName:"launchConfigurationTemplateID" min:"21" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLaunchConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLaunchConfigurationTemplateInput"}
	if s.LaunchConfigurationTemplateID == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchConfigurationTemplateID"))
	}
	if s.LaunchConfigurationTemplateID != nil && len(*s.LaunchConfigurationTemplateID) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchConfigurationTemplateID", 21))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchConfigurationTemplateID sets the LaunchConfigurationTemplateID field's value.
func (s *DeleteLaunchConfigurationTemplateInput) SetLaunchConfigurationTemplateID(v string) *DeleteLaunchConfigurationTemplateInput {
	s.LaunchConfigurationTemplateID = &v
	return s
}

type DeleteLaunchConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchConfigurationTemplateOutput) GoString() string {
	return s.String()
}

type DeleteRecoveryInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Recovery Instance to be deleted.
	//
	// RecoveryInstanceID is a required field
	RecoveryInstanceID *string `locationName:"recoveryInstanceID" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRecoveryInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRecoveryInstanceInput"}
	if s.RecoveryInstanceID == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryInstanceID"))
	}
	if s.RecoveryInstanceID != nil && len(*s.RecoveryInstanceID) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryInstanceID", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryInstanceID sets the RecoveryInstanceID field's value.
func (s *DeleteRecoveryInstanceInput) SetRecoveryInstanceID(v string) *DeleteRecoveryInstanceInput {
	s.RecoveryInstanceID = &v
	return s
}

type DeleteRecoveryInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryInstanceOutput) GoString() string {
	return s.String()
}

type DeleteReplicationConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Replication Configuration Template to be deleted.
	//
	// ReplicationConfigurationTemplateID is a required field
	ReplicationConfigurationTemplateID *string `locationName:"replicationConfigurationTemplateID" min:"21" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationConfigurationTemplateInput"}
	if s.ReplicationConfigurationTemplateID == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationConfigurationTemplateID"))
	}
	if s.ReplicationConfigurationTemplateID != nil && len(*s.ReplicationConfigurationTemplateID) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicationConfigurationTemplateID", 21))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationConfigurationTemplateID sets the ReplicationConfigurationTemplateID field's value.
func (s *DeleteReplicationConfigurationTemplateInput) SetReplicationConfigurationTemplateID(v string) *DeleteReplicationConfigurationTemplateInput {
	s.ReplicationConfigurationTemplateID = &v
	return s
}

type DeleteReplicationConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationTemplateOutput) GoString() string {
	return s.String()
}

type DeleteSourceNetworkInput struct {
	_ struct{} `type:"structure"`

	// ID of the Source Network to delete.
	//
	// SourceNetworkID is a required field
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSourceNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSourceNetworkInput"}
	if s.SourceNetworkID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceNetworkID"))
	}
	if s.SourceNetworkID != nil && len(*s.SourceNetworkID) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceNetworkID", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *DeleteSourceNetworkInput) SetSourceNetworkID(v string) *DeleteSourceNetworkInput {
	s.SourceNetworkID = &v
	return s
}

type DeleteSourceNetworkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceNetworkOutput) GoString() string {
	return s.String()
}

type DeleteSourceServerInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Source Server to be deleted.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSourceServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSourceServerInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *DeleteSourceServerInput) SetSourceServerID(v string) *DeleteSourceServerInput {
	s.SourceServerID = &v
	return s
}

type DeleteSourceServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceServerOutput) GoString() string {
	return s.String()
}

type DescribeJobLogItemsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Job for which Job log items will be retrieved.
	//
	// JobID is a required field
	JobID *string `locationName:"jobID" min:"24" type:"string" required:"true"`

	// Maximum number of Job log items to retrieve.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token of the next Job log items to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobLogItemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobLogItemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobLogItemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobLogItemsInput"}
	if s.JobID == nil {
		invalidParams.Add(request.NewErrParamRequired("JobID"))
	}
	if s.JobID != nil && len(*s.JobID) < 24 {
		invalidParams.Add(request.NewErrParamMinLen("JobID", 24))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobID sets the JobID field's value.
func (s *DescribeJobLogItemsInput) SetJobID(v string) *DescribeJobLogItemsInput {
	s.JobID = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeJobLogItemsInput) SetMaxResults(v int64) *DescribeJobLogItemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobLogItemsInput) SetNextToken(v string) *DescribeJobLogItemsInput {
	s.NextToken = &v
	return s
}

type DescribeJobLogItemsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Job log items.
	Items []*JobLog `locationName:"items" type:"list"`

	// The token of the next Job log items to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobLogItemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobLogItemsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeJobLogItemsOutput) SetItems(v []*JobLog) *DescribeJobLogItemsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobLogItemsOutput) SetNextToken(v string) *DescribeJobLogItemsOutput {
	s.NextToken = &v
	return s
}

type DescribeJobsInput struct {
	_ struct{} `type:"structure"`

	// A set of filters by which to return Jobs.
	Filters *DescribeJobsRequestFilters `locationName:"filters" type:"structure"`

	// Maximum number of Jobs to retrieve.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token of the next Job to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeJobsInput) SetFilters(v *DescribeJobsRequestFilters) *DescribeJobsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeJobsInput) SetMaxResults(v int64) *DescribeJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobsInput) SetNextToken(v string) *DescribeJobsInput {
	s.NextToken = &v
	return s
}

type DescribeJobsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Jobs.
	Items []*Job `locationName:"items" type:"list"`

	// The token of the next Job to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeJobsOutput) SetItems(v []*Job) *DescribeJobsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobsOutput) SetNextToken(v string) *DescribeJobsOutput {
	s.NextToken = &v
	return s
}

// A set of filters by which to return Jobs.
type DescribeJobsRequestFilters struct {
	_ struct{} `type:"structure"`

	// The start date in a date range query.
	FromDate *string `locationName:"fromDate" min:"19" type:"string"`

	// An array of Job IDs that should be returned. An empty array means all jobs.
	JobIDs []*string `locationName:"jobIDs" type:"list"`

	// The end date in a date range query.
	ToDate *string `locationName:"toDate" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsRequestFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsRequestFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobsRequestFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobsRequestFilters"}
	if s.FromDate != nil && len(*s.FromDate) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("FromDate", 19))
	}
	if s.ToDate != nil && len(*s.ToDate) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ToDate", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromDate sets the FromDate field's value.
func (s *DescribeJobsRequestFilters) SetFromDate(v string) *DescribeJobsRequestFilters {
	s.FromDate = &v
	return s
}

// SetJobIDs sets the JobIDs field's value.
func (s *DescribeJobsRequestFilters) SetJobIDs(v []*string) *DescribeJobsRequestFilters {
	s.JobIDs = v
	return s
}

// SetToDate sets the ToDate field's value.
func (s *DescribeJobsRequestFilters) SetToDate(v string) *DescribeJobsRequestFilters {
	s.ToDate = &v
	return s
}

type DescribeLaunchConfigurationTemplatesInput struct {
	_ struct{} `type:"structure"`

	// Request to filter Launch Configuration Templates list by Launch Configuration
	// Template ID.
	LaunchConfigurationTemplateIDs []*string `locationName:"launchConfigurationTemplateIDs" type:"list"`

	// Maximum results to be returned in DescribeLaunchConfigurationTemplates.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token of the next Launch Configuration Template to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLaunchConfigurationTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLaunchConfigurationTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLaunchConfigurationTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLaunchConfigurationTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchConfigurationTemplateIDs sets the LaunchConfigurationTemplateIDs field's value.
func (s *DescribeLaunchConfigurationTemplatesInput) SetLaunchConfigurationTemplateIDs(v []*string) *DescribeLaunchConfigurationTemplatesInput {
	s.LaunchConfigurationTemplateIDs = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeLaunchConfigurationTemplatesInput) SetMaxResults(v int64) *DescribeLaunchConfigurationTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeLaunchConfigurationTemplatesInput) SetNextToken(v string) *DescribeLaunchConfigurationTemplatesInput {
	s.NextToken = &v
	return s
}

type DescribeLaunchConfigurationTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// List of items returned by DescribeLaunchConfigurationTemplates.
	Items []*LaunchConfigurationTemplate `locationName:"items" type:"list"`

	// The token of the next Launch Configuration Template to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLaunchConfigurationTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLaunchConfigurationTemplatesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeLaunchConfigurationTemplatesOutput) SetItems(v []*LaunchConfigurationTemplate) *DescribeLaunchConfigurationTemplatesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeLaunchConfigurationTemplatesOutput) SetNextToken(v string) *DescribeLaunchConfigurationTemplatesOutput {
	s.NextToken = &v
	return s
}

type DescribeRecoveryInstancesInput struct {
	_ struct{} `type:"structure"`

	// A set of filters by which to return Recovery Instances.
	Filters *DescribeRecoveryInstancesRequestFilters `locationName:"filters" type:"structure"`

	// Maximum number of Recovery Instances to retrieve.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token of the next Recovery Instance to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoveryInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoveryInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecoveryInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecoveryInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeRecoveryInstancesInput) SetFilters(v *DescribeRecoveryInstancesRequestFilters) *DescribeRecoveryInstancesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeRecoveryInstancesInput) SetMaxResults(v int64) *DescribeRecoveryInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRecoveryInstancesInput) SetNextToken(v string) *DescribeRecoveryInstancesInput {
	s.NextToken = &v
	return s
}

type DescribeRecoveryInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An array of Recovery Instances.
	Items []*RecoveryInstance `locationName:"items" type:"list"`

	// The token of the next Recovery Instance to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoveryInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoveryInstancesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeRecoveryInstancesOutput) SetItems(v []*RecoveryInstance) *DescribeRecoveryInstancesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRecoveryInstancesOutput) SetNextToken(v string) *DescribeRecoveryInstancesOutput {
	s.NextToken = &v
	return s
}

// A set of filters by which to return Recovery Instances.
type DescribeRecoveryInstancesRequestFilters struct {
	_ struct{} `type:"structure"`

	// An array of Recovery Instance IDs that should be returned. An empty array
	// means all Recovery Instances.
	RecoveryInstanceIDs []*string `locationName:"recoveryInstanceIDs" type:"list"`

	// An array of Source Server IDs for which associated Recovery Instances should
	// be returned.
	SourceServerIDs []*string `locationName:"sourceServerIDs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoveryInstancesRequestFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoveryInstancesRequestFilters) GoString() string {
	return s.String()
}

// SetRecoveryInstanceIDs sets the RecoveryInstanceIDs field's value.
func (s *DescribeRecoveryInstancesRequestFilters) SetRecoveryInstanceIDs(v []*string) *DescribeRecoveryInstancesRequestFilters {
	s.RecoveryInstanceIDs = v
	return s
}

// SetSourceServerIDs sets the SourceServerIDs field's value.
func (s *DescribeRecoveryInstancesRequestFilters) SetSourceServerIDs(v []*string) *DescribeRecoveryInstancesRequestFilters {
	s.SourceServerIDs = v
	return s
}

type DescribeRecoverySnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A set of filters by which to return Recovery Snapshots.
	Filters *DescribeRecoverySnapshotsRequestFilters `locationName:"filters" type:"structure"`

	// Maximum number of Recovery Snapshots to retrieve.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token of the next Recovery Snapshot to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The sorted ordering by which to return Recovery Snapshots.
	Order *string `locationName:"order" type:"string" enum:"RecoverySnapshotsOrder"`

	// Filter Recovery Snapshots by Source Server ID.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoverySnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoverySnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecoverySnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecoverySnapshotsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeRecoverySnapshotsInput) SetFilters(v *DescribeRecoverySnapshotsRequestFilters) *DescribeRecoverySnapshotsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeRecoverySnapshotsInput) SetMaxResults(v int64) *DescribeRecoverySnapshotsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRecoverySnapshotsInput) SetNextToken(v string) *DescribeRecoverySnapshotsInput {
	s.NextToken = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *DescribeRecoverySnapshotsInput) SetOrder(v string) *DescribeRecoverySnapshotsInput {
	s.Order = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *DescribeRecoverySnapshotsInput) SetSourceServerID(v string) *DescribeRecoverySnapshotsInput {
	s.SourceServerID = &v
	return s
}

type DescribeRecoverySnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Recovery Snapshots.
	Items []*RecoverySnapshot `locationName:"items" type:"list"`

	// The token of the next Recovery Snapshot to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoverySnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoverySnapshotsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeRecoverySnapshotsOutput) SetItems(v []*RecoverySnapshot) *DescribeRecoverySnapshotsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRecoverySnapshotsOutput) SetNextToken(v string) *DescribeRecoverySnapshotsOutput {
	s.NextToken = &v
	return s
}

// A set of filters by which to return Recovery Snapshots.
type DescribeRecoverySnapshotsRequestFilters struct {
	_ struct{} `type:"structure"`

	// The start date in a date range query.
	FromDateTime *string `locationName:"fromDateTime" min:"19" type:"string"`

	// The end date in a date range query.
	ToDateTime *string `locationName:"toDateTime" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoverySnapshotsRequestFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoverySnapshotsRequestFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecoverySnapshotsRequestFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecoverySnapshotsRequestFilters"}
	if s.FromDateTime != nil && len(*s.FromDateTime) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("FromDateTime", 19))
	}
	if s.ToDateTime != nil && len(*s.ToDateTime) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ToDateTime", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromDateTime sets the FromDateTime field's value.
func (s *DescribeRecoverySnapshotsRequestFilters) SetFromDateTime(v string) *DescribeRecoverySnapshotsRequestFilters {
	s.FromDateTime = &v
	return s
}

// SetToDateTime sets the ToDateTime field's value.
func (s *DescribeRecoverySnapshotsRequestFilters) SetToDateTime(v string) *DescribeRecoverySnapshotsRequestFilters {
	s.ToDateTime = &v
	return s
}

type DescribeReplicationConfigurationTemplatesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of Replication Configuration Templates to retrieve.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token of the next Replication Configuration Template to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The IDs of the Replication Configuration Templates to retrieve. An empty
	// list means all Replication Configuration Templates.
	ReplicationConfigurationTemplateIDs []*string `locationName:"replicationConfigurationTemplateIDs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationConfigurationTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationConfigurationTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReplicationConfigurationTemplatesInput) SetMaxResults(v int64) *DescribeReplicationConfigurationTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReplicationConfigurationTemplatesInput) SetNextToken(v string) *DescribeReplicationConfigurationTemplatesInput {
	s.NextToken = &v
	return s
}

// SetReplicationConfigurationTemplateIDs sets the ReplicationConfigurationTemplateIDs field's value.
func (s *DescribeReplicationConfigurationTemplatesInput) SetReplicationConfigurationTemplateIDs(v []*string) *DescribeReplicationConfigurationTemplatesInput {
	s.ReplicationConfigurationTemplateIDs = v
	return s
}

type DescribeReplicationConfigurationTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// An array of Replication Configuration Templates.
	Items []*ReplicationConfigurationTemplate `locationName:"items" type:"list"`

	// The token of the next Replication Configuration Template to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationTemplatesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeReplicationConfigurationTemplatesOutput) SetItems(v []*ReplicationConfigurationTemplate) *DescribeReplicationConfigurationTemplatesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReplicationConfigurationTemplatesOutput) SetNextToken(v string) *DescribeReplicationConfigurationTemplatesOutput {
	s.NextToken = &v
	return s
}

type DescribeSourceNetworksInput struct {
	_ struct{} `type:"structure"`

	// A set of filters by which to return Source Networks.
	Filters *DescribeSourceNetworksRequestFilters `locationName:"filters" type:"structure"`

	// Maximum number of Source Networks to retrieve.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token of the next Source Networks to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceNetworksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceNetworksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSourceNetworksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSourceNetworksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeSourceNetworksInput) SetFilters(v *DescribeSourceNetworksRequestFilters) *DescribeSourceNetworksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSourceNetworksInput) SetMaxResults(v int64) *DescribeSourceNetworksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSourceNetworksInput) SetNextToken(v string) *DescribeSourceNetworksInput {
	s.NextToken = &v
	return s
}

type DescribeSourceNetworksOutput struct {
	_ struct{} `type:"structure"`

	// An array of Source Networks.
	Items []*SourceNetwork `locationName:"items" type:"list"`

	// The token of the next Source Networks to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceNetworksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceNetworksOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeSourceNetworksOutput) SetItems(v []*SourceNetwork) *DescribeSourceNetworksOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSourceNetworksOutput) SetNextToken(v string) *DescribeSourceNetworksOutput {
	s.NextToken = &v
	return s
}

// A set of filters by which to return Source Networks.
type DescribeSourceNetworksRequestFilters struct {
	_ struct{} `type:"structure"`

	// Filter Source Networks by account ID containing the protected VPCs.
	OriginAccountID *string `locationName:"originAccountID" min:"12" type:"string"`

	// Filter Source Networks by the region containing the protected VPCs.
	OriginRegion *string `locationName:"originRegion" type:"string"`

	// An array of Source Network IDs that should be returned. An empty array means
	// all Source Networks.
	SourceNetworkIDs []*string `locationName:"sourceNetworkIDs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceNetworksRequestFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceNetworksRequestFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSourceNetworksRequestFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSourceNetworksRequestFilters"}
	if s.OriginAccountID != nil && len(*s.OriginAccountID) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("OriginAccountID", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOriginAccountID sets the OriginAccountID field's value.
func (s *DescribeSourceNetworksRequestFilters) SetOriginAccountID(v string) *DescribeSourceNetworksRequestFilters {
	s.OriginAccountID = &v
	return s
}

// SetOriginRegion sets the OriginRegion field's value.
func (s *DescribeSourceNetworksRequestFilters) SetOriginRegion(v string) *DescribeSourceNetworksRequestFilters {
	s.OriginRegion = &v
	return s
}

// SetSourceNetworkIDs sets the SourceNetworkIDs field's value.
func (s *DescribeSourceNetworksRequestFilters) SetSourceNetworkIDs(v []*string) *DescribeSourceNetworksRequestFilters {
	s.SourceNetworkIDs = v
	return s
}

type DescribeSourceServersInput struct {
	_ struct{} `type:"structure"`

	// A set of filters by which to return Source Servers.
	Filters *DescribeSourceServersRequestFilters `locationName:"filters" type:"structure"`

	// Maximum number of Source Servers to retrieve.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token of the next Source Server to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSourceServersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSourceServersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeSourceServersInput) SetFilters(v *DescribeSourceServersRequestFilters) *DescribeSourceServersInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSourceServersInput) SetMaxResults(v int64) *DescribeSourceServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSourceServersInput) SetNextToken(v string) *DescribeSourceServersInput {
	s.NextToken = &v
	return s
}

type DescribeSourceServersOutput struct {
	_ struct{} `type:"structure"`

	// An array of Source Servers.
	Items []*SourceServer `locationName:"items" type:"list"`

	// The token of the next Source Server to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeSourceServersOutput) SetItems(v []*SourceServer) *DescribeSourceServersOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSourceServersOutput) SetNextToken(v string) *DescribeSourceServersOutput {
	s.NextToken = &v
	return s
}

// A set of filters by which to return Source Servers.
type DescribeSourceServersRequestFilters struct {
	_ struct{} `type:"structure"`

	// An ID that describes the hardware of the Source Server. This is either an
	// EC2 instance id, a VMware uuid or a mac address.
	HardwareId *string `locationName:"hardwareId" type:"string"`

	// An array of Source Servers IDs that should be returned. An empty array means
	// all Source Servers.
	SourceServerIDs []*string `locationName:"sourceServerIDs" type:"list"`

	// An array of staging account IDs that extended source servers belong to. An
	// empty array means all source servers will be shown.
	StagingAccountIDs []*string `locationName:"stagingAccountIDs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersRequestFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersRequestFilters) GoString() string {
	return s.String()
}

// SetHardwareId sets the HardwareId field's value.
func (s *DescribeSourceServersRequestFilters) SetHardwareId(v string) *DescribeSourceServersRequestFilters {
	s.HardwareId = &v
	return s
}

// SetSourceServerIDs sets the SourceServerIDs field's value.
func (s *DescribeSourceServersRequestFilters) SetSourceServerIDs(v []*string) *DescribeSourceServersRequestFilters {
	s.SourceServerIDs = v
	return s
}

// SetStagingAccountIDs sets the StagingAccountIDs field's value.
func (s *DescribeSourceServersRequestFilters) SetStagingAccountIDs(v []*string) *DescribeSourceServersRequestFilters {
	s.StagingAccountIDs = v
	return s
}

type DisconnectRecoveryInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Recovery Instance to disconnect.
	//
	// RecoveryInstanceID is a required field
	RecoveryInstanceID *string `locationName:"recoveryInstanceID" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectRecoveryInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectRecoveryInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectRecoveryInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectRecoveryInstanceInput"}
	if s.RecoveryInstanceID == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryInstanceID"))
	}
	if s.RecoveryInstanceID != nil && len(*s.RecoveryInstanceID) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryInstanceID", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryInstanceID sets the RecoveryInstanceID field's value.
func (s *DisconnectRecoveryInstanceInput) SetRecoveryInstanceID(v string) *DisconnectRecoveryInstanceInput {
	s.RecoveryInstanceID = &v
	return s
}

type DisconnectRecoveryInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectRecoveryInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectRecoveryInstanceOutput) GoString() string {
	return s.String()
}

type DisconnectSourceServerInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Source Server to disconnect.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectSourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectSourceServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectSourceServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectSourceServerInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *DisconnectSourceServerInput) SetSourceServerID(v string) *DisconnectSourceServerInput {
	s.SourceServerID = &v
	return s
}

type DisconnectSourceServerOutput struct {
	_ struct{} `type:"structure"`

	// The version of the DRS agent installed on the source server
	AgentVersion *string `locationName:"agentVersion" type:"string"`

	// The ARN of the Source Server.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The Data Replication Info of the Source Server.
	DataReplicationInfo *DataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// The status of the last recovery launch of this Source Server.
	LastLaunchResult *string `locationName:"lastLaunchResult" type:"string" enum:"LastLaunchResult"`

	// The lifecycle information of this Source Server.
	LifeCycle *LifeCycle `locationName:"lifeCycle" type:"structure"`

	// The ID of the Recovery Instance associated with this Source Server.
	RecoveryInstanceId *string `locationName:"recoveryInstanceId" min:"10" type:"string"`

	// Replication direction of the Source Server.
	ReplicationDirection *string `locationName:"replicationDirection" type:"string" enum:"ReplicationDirection"`

	// For EC2-originated Source Servers which have been failed over and then failed
	// back, this value will mean the ARN of the Source Server on the opposite replication
	// direction.
	ReversedDirectionSourceServerArn *string `locationName:"reversedDirectionSourceServerArn" min:"20" type:"string"`

	// Source cloud properties of the Source Server.
	SourceCloudProperties *SourceCloudProperties `locationName:"sourceCloudProperties" type:"structure"`

	// ID of the Source Network which is protecting this Source Server's network.
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string"`

	// The source properties of the Source Server.
	SourceProperties *SourceProperties `locationName:"sourceProperties" type:"structure"`

	// The ID of the Source Server.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// The staging area of the source server.
	StagingArea *StagingArea `locationName:"stagingArea" type:"structure"`

	// The tags associated with the Source Server.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DisconnectSourceServerOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectSourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectSourceServerOutput) GoString() string {
	return s.String()
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *DisconnectSourceServerOutput) SetAgentVersion(v string) *DisconnectSourceServerOutput {
	s.AgentVersion = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DisconnectSourceServerOutput) SetArn(v string) *DisconnectSourceServerOutput {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *DisconnectSourceServerOutput) SetDataReplicationInfo(v *DataReplicationInfo) *DisconnectSourceServerOutput {
	s.DataReplicationInfo = v
	return s
}

// SetLastLaunchResult sets the LastLaunchResult field's value.
func (s *DisconnectSourceServerOutput) SetLastLaunchResult(v string) *DisconnectSourceServerOutput {
	s.LastLaunchResult = &v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *DisconnectSourceServerOutput) SetLifeCycle(v *LifeCycle) *DisconnectSourceServerOutput {
	s.LifeCycle = v
	return s
}

// SetRecoveryInstanceId sets the RecoveryInstanceId field's value.
func (s *DisconnectSourceServerOutput) SetRecoveryInstanceId(v string) *DisconnectSourceServerOutput {
	s.RecoveryInstanceId = &v
	return s
}

// SetReplicationDirection sets the ReplicationDirection field's value.
func (s *DisconnectSourceServerOutput) SetReplicationDirection(v string) *DisconnectSourceServerOutput {
	s.ReplicationDirection = &v
	return s
}

// SetReversedDirectionSourceServerArn sets the ReversedDirectionSourceServerArn field's value.
func (s *DisconnectSourceServerOutput) SetReversedDirectionSourceServerArn(v string) *DisconnectSourceServerOutput {
	s.ReversedDirectionSourceServerArn = &v
	return s
}

// SetSourceCloudProperties sets the SourceCloudProperties field's value.
func (s *DisconnectSourceServerOutput) SetSourceCloudProperties(v *SourceCloudProperties) *DisconnectSourceServerOutput {
	s.SourceCloudProperties = v
	return s
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *DisconnectSourceServerOutput) SetSourceNetworkID(v string) *DisconnectSourceServerOutput {
	s.SourceNetworkID = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *DisconnectSourceServerOutput) SetSourceProperties(v *SourceProperties) *DisconnectSourceServerOutput {
	s.SourceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *DisconnectSourceServerOutput) SetSourceServerID(v string) *DisconnectSourceServerOutput {
	s.SourceServerID = &v
	return s
}

// SetStagingArea sets the StagingArea field's value.
func (s *DisconnectSourceServerOutput) SetStagingArea(v *StagingArea) *DisconnectSourceServerOutput {
	s.StagingArea = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DisconnectSourceServerOutput) SetTags(v map[string]*string) *DisconnectSourceServerOutput {
	s.Tags = v
	return s
}

// An object representing a data storage device on a server.
type Disk struct {
	_ struct{} `type:"structure"`

	// The amount of storage on the disk in bytes.
	Bytes *int64 `locationName:"bytes" type:"long"`

	// The disk or device name.
	DeviceName *string `locationName:"deviceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Disk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Disk) GoString() string {
	return s.String()
}

// SetBytes sets the Bytes field's value.
func (s *Disk) SetBytes(v int64) *Disk {
	s.Bytes = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *Disk) SetDeviceName(v string) *Disk {
	s.DeviceName = &v
	return s
}

// Properties of resource related to a job event.
type EventResourceData struct {
	_ struct{} `type:"structure"`

	// Source Network properties.
	SourceNetworkData *SourceNetworkData `locationName:"sourceNetworkData" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventResourceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventResourceData) GoString() string {
	return s.String()
}

// SetSourceNetworkData sets the SourceNetworkData field's value.
func (s *EventResourceData) SetSourceNetworkData(v *SourceNetworkData) *EventResourceData {
	s.SourceNetworkData = v
	return s
}

type ExportSourceNetworkCfnTemplateInput struct {
	_ struct{} `type:"structure"`

	// The Source Network ID to export its CloudFormation template to an S3 bucket.
	//
	// SourceNetworkID is a required field
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSourceNetworkCfnTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSourceNetworkCfnTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportSourceNetworkCfnTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportSourceNetworkCfnTemplateInput"}
	if s.SourceNetworkID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceNetworkID"))
	}
	if s.SourceNetworkID != nil && len(*s.SourceNetworkID) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceNetworkID", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *ExportSourceNetworkCfnTemplateInput) SetSourceNetworkID(v string) *ExportSourceNetworkCfnTemplateInput {
	s.SourceNetworkID = &v
	return s
}

type ExportSourceNetworkCfnTemplateOutput struct {
	_ struct{} `type:"structure"`

	// S3 bucket URL where the Source Network CloudFormation template was exported
	// to.
	S3DestinationUrl *string `locationName:"s3DestinationUrl" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSourceNetworkCfnTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSourceNetworkCfnTemplateOutput) GoString() string {
	return s.String()
}

// SetS3DestinationUrl sets the S3DestinationUrl field's value.
func (s *ExportSourceNetworkCfnTemplateOutput) SetS3DestinationUrl(v string) *ExportSourceNetworkCfnTemplateOutput {
	s.S3DestinationUrl = &v
	return s
}

type GetFailbackReplicationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Recovery Instance whose failback replication configuration
	// should be returned.
	//
	// RecoveryInstanceID is a required field
	RecoveryInstanceID *string `locationName:"recoveryInstanceID" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFailbackReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFailbackReplicationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFailbackReplicationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFailbackReplicationConfigurationInput"}
	if s.RecoveryInstanceID == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryInstanceID"))
	}
	if s.RecoveryInstanceID != nil && len(*s.RecoveryInstanceID) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryInstanceID", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryInstanceID sets the RecoveryInstanceID field's value.
func (s *GetFailbackReplicationConfigurationInput) SetRecoveryInstanceID(v string) *GetFailbackReplicationConfigurationInput {
	s.RecoveryInstanceID = &v
	return s
}

type GetFailbackReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Configure bandwidth throttling for the outbound data transfer rate of the
	// Recovery Instance in Mbps.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// The name of the Failback Replication Configuration.
	Name *string `locationName:"name" type:"string"`

	// The ID of the Recovery Instance.
	//
	// RecoveryInstanceID is a required field
	RecoveryInstanceID *string `locationName:"recoveryInstanceID" min:"10" type:"string" required:"true"`

	// Whether to use Private IP for the failback replication of the Recovery Instance.
	UsePrivateIP *bool `locationName:"usePrivateIP" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFailbackReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFailbackReplicationConfigurationOutput) GoString() string {
	return s.String()
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *GetFailbackReplicationConfigurationOutput) SetBandwidthThrottling(v int64) *GetFailbackReplicationConfigurationOutput {
	s.BandwidthThrottling = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetFailbackReplicationConfigurationOutput) SetName(v string) *GetFailbackReplicationConfigurationOutput {
	s.Name = &v
	return s
}

// SetRecoveryInstanceID sets the RecoveryInstanceID field's value.
func (s *GetFailbackReplicationConfigurationOutput) SetRecoveryInstanceID(v string) *GetFailbackReplicationConfigurationOutput {
	s.RecoveryInstanceID = &v
	return s
}

// SetUsePrivateIP sets the UsePrivateIP field's value.
func (s *GetFailbackReplicationConfigurationOutput) SetUsePrivateIP(v bool) *GetFailbackReplicationConfigurationOutput {
	s.UsePrivateIP = &v
	return s
}

type GetLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Source Server that we want to retrieve a Launch Configuration
	// for.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLaunchConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLaunchConfigurationInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *GetLaunchConfigurationInput) SetSourceServerID(v string) *GetLaunchConfigurationInput {
	s.SourceServerID = &v
	return s
}

type GetLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Whether we should copy the Private IP of the Source Server to the Recovery
	// Instance.
	CopyPrivateIp *bool `locationName:"copyPrivateIp" type:"boolean"`

	// Whether we want to copy the tags of the Source Server to the EC2 machine
	// of the Recovery Instance.
	CopyTags *bool `locationName:"copyTags" type:"boolean"`

	// The EC2 launch template ID of this launch configuration.
	Ec2LaunchTemplateID *string `locationName:"ec2LaunchTemplateID" type:"string"`

	// The state of the Recovery Instance in EC2 after the recovery operation.
	LaunchDisposition *string `locationName:"launchDisposition" type:"string" enum:"LaunchDisposition"`

	// Launch into existing instance properties.
	LaunchIntoInstanceProperties *LaunchIntoInstanceProperties `locationName:"launchIntoInstanceProperties" type:"structure"`

	// The licensing configuration to be used for this launch configuration.
	Licensing *Licensing `locationName:"licensing" type:"structure"`

	// The name of the launch configuration.
	Name *string `locationName:"name" type:"string"`

	// Whether we want to activate post-launch actions for the Source Server.
	PostLaunchEnabled *bool `locationName:"postLaunchEnabled" type:"boolean"`

	// The ID of the Source Server for this launch configuration.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Whether Elastic Disaster Recovery should try to automatically choose the
	// instance type that best matches the OS, CPU, and RAM of your Source Server.
	TargetInstanceTypeRightSizingMethod *string `locationName:"targetInstanceTypeRightSizingMethod" type:"string" enum:"TargetInstanceTypeRightSizingMethod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchConfigurationOutput) GoString() string {
	return s.String()
}

// SetCopyPrivateIp sets the CopyPrivateIp field's value.
func (s *GetLaunchConfigurationOutput) SetCopyPrivateIp(v bool) *GetLaunchConfigurationOutput {
	s.CopyPrivateIp = &v
	return s
}

// SetCopyTags sets the CopyTags field's value.
func (s *GetLaunchConfigurationOutput) SetCopyTags(v bool) *GetLaunchConfigurationOutput {
	s.CopyTags = &v
	return s
}

// SetEc2LaunchTemplateID sets the Ec2LaunchTemplateID field's value.
func (s *GetLaunchConfigurationOutput) SetEc2LaunchTemplateID(v string) *GetLaunchConfigurationOutput {
	s.Ec2LaunchTemplateID = &v
	return s
}

// SetLaunchDisposition sets the LaunchDisposition field's value.
func (s *GetLaunchConfigurationOutput) SetLaunchDisposition(v string) *GetLaunchConfigurationOutput {
	s.LaunchDisposition = &v
	return s
}

// SetLaunchIntoInstanceProperties sets the LaunchIntoInstanceProperties field's value.
func (s *GetLaunchConfigurationOutput) SetLaunchIntoInstanceProperties(v *LaunchIntoInstanceProperties) *GetLaunchConfigurationOutput {
	s.LaunchIntoInstanceProperties = v
	return s
}

// SetLicensing sets the Licensing field's value.
func (s *GetLaunchConfigurationOutput) SetLicensing(v *Licensing) *GetLaunchConfigurationOutput {
	s.Licensing = v
	return s
}

// SetName sets the Name field's value.
func (s *GetLaunchConfigurationOutput) SetName(v string) *GetLaunchConfigurationOutput {
	s.Name = &v
	return s
}

// SetPostLaunchEnabled sets the PostLaunchEnabled field's value.
func (s *GetLaunchConfigurationOutput) SetPostLaunchEnabled(v bool) *GetLaunchConfigurationOutput {
	s.PostLaunchEnabled = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *GetLaunchConfigurationOutput) SetSourceServerID(v string) *GetLaunchConfigurationOutput {
	s.SourceServerID = &v
	return s
}

// SetTargetInstanceTypeRightSizingMethod sets the TargetInstanceTypeRightSizingMethod field's value.
func (s *GetLaunchConfigurationOutput) SetTargetInstanceTypeRightSizingMethod(v string) *GetLaunchConfigurationOutput {
	s.TargetInstanceTypeRightSizingMethod = &v
	return s
}

type GetReplicationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Source Serve for this Replication Configuration.r
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReplicationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReplicationConfigurationInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *GetReplicationConfigurationInput) SetSourceServerID(v string) *GetReplicationConfigurationInput {
	s.SourceServerID = &v
	return s
}

type GetReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Whether to associate the default Elastic Disaster Recovery Security group
	// with the Replication Configuration.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Whether to allow the AWS replication agent to automatically replicate newly
	// added disks.
	AutoReplicateNewDisks *bool `locationName:"autoReplicateNewDisks" type:"boolean"`

	// Configure bandwidth throttling for the outbound data transfer rate of the
	// Source Server in Mbps.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Whether to create a Public IP for the Recovery Instance by default.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// The data plane routing mechanism that will be used for replication.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// The Staging Disk EBS volume type to be used during replication.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// The type of EBS encryption to be used during replication.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// The ARN of the EBS encryption key to be used during replication.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// The name of the Replication Configuration.
	Name *string `locationName:"name" type:"string"`

	// The Point in time (PIT) policy to manage snapshots taken during replication.
	PitPolicy []*PITPolicyRule `locationName:"pitPolicy" min:"1" type:"list"`

	// The configuration of the disks of the Source Server to be replicated.
	ReplicatedDisks []*ReplicationConfigurationReplicatedDisk `locationName:"replicatedDisks" type:"list"`

	// The instance type to be used for the replication server.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// The security group IDs that will be used by the replication server.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// The ID of the Source Server for this Replication Configuration.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// The subnet to be used by the replication staging area.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// A set of tags to be associated with all resources created in the replication
	// staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetReplicationConfigurationOutput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// Whether to use a dedicated Replication Server in the replication staging
	// area.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *GetReplicationConfigurationOutput) SetAssociateDefaultSecurityGroup(v bool) *GetReplicationConfigurationOutput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetAutoReplicateNewDisks sets the AutoReplicateNewDisks field's value.
func (s *GetReplicationConfigurationOutput) SetAutoReplicateNewDisks(v bool) *GetReplicationConfigurationOutput {
	s.AutoReplicateNewDisks = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *GetReplicationConfigurationOutput) SetBandwidthThrottling(v int64) *GetReplicationConfigurationOutput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *GetReplicationConfigurationOutput) SetCreatePublicIP(v bool) *GetReplicationConfigurationOutput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *GetReplicationConfigurationOutput) SetDataPlaneRouting(v string) *GetReplicationConfigurationOutput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *GetReplicationConfigurationOutput) SetDefaultLargeStagingDiskType(v string) *GetReplicationConfigurationOutput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *GetReplicationConfigurationOutput) SetEbsEncryption(v string) *GetReplicationConfigurationOutput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *GetReplicationConfigurationOutput) SetEbsEncryptionKeyArn(v string) *GetReplicationConfigurationOutput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetReplicationConfigurationOutput) SetName(v string) *GetReplicationConfigurationOutput {
	s.Name = &v
	return s
}

// SetPitPolicy sets the PitPolicy field's value.
func (s *GetReplicationConfigurationOutput) SetPitPolicy(v []*PITPolicyRule) *GetReplicationConfigurationOutput {
	s.PitPolicy = v
	return s
}

// SetReplicatedDisks sets the ReplicatedDisks field's value.
func (s *GetReplicationConfigurationOutput) SetReplicatedDisks(v []*ReplicationConfigurationReplicatedDisk) *GetReplicationConfigurationOutput {
	s.ReplicatedDisks = v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *GetReplicationConfigurationOutput) SetReplicationServerInstanceType(v string) *GetReplicationConfigurationOutput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *GetReplicationConfigurationOutput) SetReplicationServersSecurityGroupsIDs(v []*string) *GetReplicationConfigurationOutput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *GetReplicationConfigurationOutput) SetSourceServerID(v string) *GetReplicationConfigurationOutput {
	s.SourceServerID = &v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *GetReplicationConfigurationOutput) SetStagingAreaSubnetId(v string) *GetReplicationConfigurationOutput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *GetReplicationConfigurationOutput) SetStagingAreaTags(v map[string]*string) *GetReplicationConfigurationOutput {
	s.StagingAreaTags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *GetReplicationConfigurationOutput) SetUseDedicatedReplicationServer(v bool) *GetReplicationConfigurationOutput {
	s.UseDedicatedReplicationServer = &v
	return s
}

// Hints used to uniquely identify a machine.
type IdentificationHints struct {
	_ struct{} `type:"structure"`

	// AWS Instance ID identification hint.
	AwsInstanceID *string `locationName:"awsInstanceID" type:"string"`

	// Fully Qualified Domain Name identification hint.
	Fqdn *string `locationName:"fqdn" type:"string"`

	// Hostname identification hint.
	Hostname *string `locationName:"hostname" type:"string"`

	// vCenter VM path identification hint.
	VmWareUuid *string `locationName:"vmWareUuid" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentificationHints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentificationHints) GoString() string {
	return s.String()
}

// SetAwsInstanceID sets the AwsInstanceID field's value.
func (s *IdentificationHints) SetAwsInstanceID(v string) *IdentificationHints {
	s.AwsInstanceID = &v
	return s
}

// SetFqdn sets the Fqdn field's value.
func (s *IdentificationHints) SetFqdn(v string) *IdentificationHints {
	s.Fqdn = &v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *IdentificationHints) SetHostname(v string) *IdentificationHints {
	s.Hostname = &v
	return s
}

// SetVmWareUuid sets the VmWareUuid field's value.
func (s *IdentificationHints) SetVmWareUuid(v string) *IdentificationHints {
	s.VmWareUuid = &v
	return s
}

type InitializeServiceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeServiceInput) GoString() string {
	return s.String()
}

type InitializeServiceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeServiceOutput) GoString() string {
	return s.String()
}

// The request processing has failed because of an unknown error, exception
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds after which the request should be safe to retry.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A job is an asynchronous workflow.
type Job struct {
	_ struct{} `type:"structure"`

	// The ARN of a Job.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The date and time of when the Job was created.
	CreationDateTime *string `locationName:"creationDateTime" min:"19" type:"string"`

	// The date and time of when the Job ended.
	EndDateTime *string `locationName:"endDateTime" min:"19" type:"string"`

	// A string representing who initiated the Job.
	InitiatedBy *string `locationName:"initiatedBy" type:"string" enum:"InitiatedBy"`

	// The ID of the Job.
	//
	// JobID is a required field
	JobID *string `locationName:"jobID" min:"24" type:"string" required:"true"`

	// A list of resources that the Job is acting upon.
	ParticipatingResources []*ParticipatingResource `locationName:"participatingResources" type:"list"`

	// A list of servers that the Job is acting upon.
	ParticipatingServers []*ParticipatingServer `locationName:"participatingServers" type:"list"`

	// The status of the Job.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`

	// A list of tags associated with the Job.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Job's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// The type of the Job.
	Type *string `locationName:"type" type:"string" enum:"JobType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Job) SetArn(v string) *Job {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Job) SetCreationDateTime(v string) *Job {
	s.CreationDateTime = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *Job) SetEndDateTime(v string) *Job {
	s.EndDateTime = &v
	return s
}

// SetInitiatedBy sets the InitiatedBy field's value.
func (s *Job) SetInitiatedBy(v string) *Job {
	s.InitiatedBy = &v
	return s
}

// SetJobID sets the JobID field's value.
func (s *Job) SetJobID(v string) *Job {
	s.JobID = &v
	return s
}

// SetParticipatingResources sets the ParticipatingResources field's value.
func (s *Job) SetParticipatingResources(v []*ParticipatingResource) *Job {
	s.ParticipatingResources = v
	return s
}

// SetParticipatingServers sets the ParticipatingServers field's value.
func (s *Job) SetParticipatingServers(v []*ParticipatingServer) *Job {
	s.ParticipatingServers = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Job) SetStatus(v string) *Job {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Job) SetTags(v map[string]*string) *Job {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Job) SetType(v string) *Job {
	s.Type = &v
	return s
}

// A log outputted by a Job.
type JobLog struct {
	_ struct{} `type:"structure"`

	// The event represents the type of a log.
	Event *string `locationName:"event" type:"string" enum:"JobLogEvent"`

	// Metadata associated with a Job log.
	EventData *JobLogEventData `locationName:"eventData" type:"structure"`

	// The date and time the log was taken.
	LogDateTime *string `locationName:"logDateTime" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobLog) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *JobLog) SetEvent(v string) *JobLog {
	s.Event = &v
	return s
}

// SetEventData sets the EventData field's value.
func (s *JobLog) SetEventData(v *JobLogEventData) *JobLog {
	s.EventData = v
	return s
}

// SetLogDateTime sets the LogDateTime field's value.
func (s *JobLog) SetLogDateTime(v string) *JobLog {
	s.LogDateTime = &v
	return s
}

// Metadata associated with a Job log.
type JobLogEventData struct {
	_ struct{} `type:"structure"`

	// Properties of a conversion job
	ConversionProperties *ConversionProperties `locationName:"conversionProperties" type:"structure"`

	// The ID of a conversion server.
	ConversionServerID *string `locationName:"conversionServerID" type:"string"`

	// Properties of resource related to a job event.
	EventResourceData *EventResourceData `locationName:"eventResourceData" type:"structure"`

	// A string representing a job error.
	RawError *string `locationName:"rawError" type:"string"`

	// The ID of a Source Server.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// The ID of a Recovery Instance.
	TargetInstanceID *string `locationName:"targetInstanceID" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobLogEventData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobLogEventData) GoString() string {
	return s.String()
}

// SetConversionProperties sets the ConversionProperties field's value.
func (s *JobLogEventData) SetConversionProperties(v *ConversionProperties) *JobLogEventData {
	s.ConversionProperties = v
	return s
}

// SetConversionServerID sets the ConversionServerID field's value.
func (s *JobLogEventData) SetConversionServerID(v string) *JobLogEventData {
	s.ConversionServerID = &v
	return s
}

// SetEventResourceData sets the EventResourceData field's value.
func (s *JobLogEventData) SetEventResourceData(v *EventResourceData) *JobLogEventData {
	s.EventResourceData = v
	return s
}

// SetRawError sets the RawError field's value.
func (s *JobLogEventData) SetRawError(v string) *JobLogEventData {
	s.RawError = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *JobLogEventData) SetSourceServerID(v string) *JobLogEventData {
	s.SourceServerID = &v
	return s
}

// SetTargetInstanceID sets the TargetInstanceID field's value.
func (s *JobLogEventData) SetTargetInstanceID(v string) *JobLogEventData {
	s.TargetInstanceID = &v
	return s
}

// Launch action.
type LaunchAction struct {
	_ struct{} `type:"structure"`

	// Launch action code.
	ActionCode *string `locationName:"actionCode" min:"1" type:"string"`

	// Launch action Id.
	ActionId *string `locationName:"actionId" min:"1" type:"string"`

	// Launch action version.
	ActionVersion *string `locationName:"actionVersion" min:"1" type:"string"`

	// Whether the launch action is active.
	Active *bool `locationName:"active" type:"boolean"`

	// Launch action category.
	Category *string `locationName:"category" type:"string" enum:"LaunchActionCategory"`

	// Launch action description.
	Description *string `locationName:"description" type:"string"`

	// Launch action name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Whether the launch will not be marked as failed if this action fails.
	Optional *bool `locationName:"optional" type:"boolean"`

	// Launch action order.
	Order *int64 `locationName:"order" min:"2" type:"integer"`

	// Launch action parameters.
	Parameters map[string]*LaunchActionParameter `locationName:"parameters" type:"map"`

	// Launch action type.
	Type *string `locationName:"type" type:"string" enum:"LaunchActionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchAction) GoString() string {
	return s.String()
}

// SetActionCode sets the ActionCode field's value.
func (s *LaunchAction) SetActionCode(v string) *LaunchAction {
	s.ActionCode = &v
	return s
}

// SetActionId sets the ActionId field's value.
func (s *LaunchAction) SetActionId(v string) *LaunchAction {
	s.ActionId = &v
	return s
}

// SetActionVersion sets the ActionVersion field's value.
func (s *LaunchAction) SetActionVersion(v string) *LaunchAction {
	s.ActionVersion = &v
	return s
}

// SetActive sets the Active field's value.
func (s *LaunchAction) SetActive(v bool) *LaunchAction {
	s.Active = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *LaunchAction) SetCategory(v string) *LaunchAction {
	s.Category = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *LaunchAction) SetDescription(v string) *LaunchAction {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *LaunchAction) SetName(v string) *LaunchAction {
	s.Name = &v
	return s
}

// SetOptional sets the Optional field's value.
func (s *LaunchAction) SetOptional(v bool) *LaunchAction {
	s.Optional = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *LaunchAction) SetOrder(v int64) *LaunchAction {
	s.Order = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *LaunchAction) SetParameters(v map[string]*LaunchActionParameter) *LaunchAction {
	s.Parameters = v
	return s
}

// SetType sets the Type field's value.
func (s *LaunchAction) SetType(v string) *LaunchAction {
	s.Type = &v
	return s
}

// Launch action parameter.
type LaunchActionParameter struct {
	_ struct{} `type:"structure"`

	// Type.
	Type *string `locationName:"type" type:"string" enum:"LaunchActionParameterType"`

	// Value.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchActionParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchActionParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchActionParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LaunchActionParameter"}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *LaunchActionParameter) SetType(v string) *LaunchActionParameter {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *LaunchActionParameter) SetValue(v string) *LaunchActionParameter {
	s.Value = &v
	return s
}

// Launch action run.
type LaunchActionRun struct {
	_ struct{} `type:"structure"`

	// Action.
	Action *LaunchAction `locationName:"action" type:"structure"`

	// Failure reason.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// Run Id.
	RunId *string `locationName:"runId" min:"1" type:"string"`

	// Run status.
	Status *string `locationName:"status" type:"string" enum:"LaunchActionRunStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchActionRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchActionRun) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *LaunchActionRun) SetAction(v *LaunchAction) *LaunchActionRun {
	s.Action = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *LaunchActionRun) SetFailureReason(v string) *LaunchActionRun {
	s.FailureReason = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *LaunchActionRun) SetRunId(v string) *LaunchActionRun {
	s.RunId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LaunchActionRun) SetStatus(v string) *LaunchActionRun {
	s.Status = &v
	return s
}

// Resource launch actions filter.
type LaunchActionsRequestFilters struct {
	_ struct{} `type:"structure"`

	// Launch actions Ids.
	ActionIds []*string `locationName:"actionIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchActionsRequestFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchActionsRequestFilters) GoString() string {
	return s.String()
}

// SetActionIds sets the ActionIds field's value.
func (s *LaunchActionsRequestFilters) SetActionIds(v []*string) *LaunchActionsRequestFilters {
	s.ActionIds = v
	return s
}

// Launch actions status.
type LaunchActionsStatus struct {
	_ struct{} `type:"structure"`

	// List of post launch action status.
	Runs []*LaunchActionRun `locationName:"runs" type:"list"`

	// Time where the AWS Systems Manager was detected as running on the launched
	// instance.
	SsmAgentDiscoveryDatetime *string `locationName:"ssmAgentDiscoveryDatetime" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchActionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchActionsStatus) GoString() string {
	return s.String()
}

// SetRuns sets the Runs field's value.
func (s *LaunchActionsStatus) SetRuns(v []*LaunchActionRun) *LaunchActionsStatus {
	s.Runs = v
	return s
}

// SetSsmAgentDiscoveryDatetime sets the SsmAgentDiscoveryDatetime field's value.
func (s *LaunchActionsStatus) SetSsmAgentDiscoveryDatetime(v string) *LaunchActionsStatus {
	s.SsmAgentDiscoveryDatetime = &v
	return s
}

// Account level Launch Configuration Template.
type LaunchConfigurationTemplate struct {
	_ struct{} `type:"structure"`

	// ARN of the Launch Configuration Template.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Copy private IP.
	CopyPrivateIp *bool `locationName:"copyPrivateIp" type:"boolean"`

	// Copy tags.
	CopyTags *bool `locationName:"copyTags" type:"boolean"`

	// S3 bucket ARN to export Source Network templates.
	ExportBucketArn *string `locationName:"exportBucketArn" min:"20" type:"string"`

	// ID of the Launch Configuration Template.
	LaunchConfigurationTemplateID *string `locationName:"launchConfigurationTemplateID" min:"21" type:"string"`

	// Launch disposition.
	LaunchDisposition *string `locationName:"launchDisposition" type:"string" enum:"LaunchDisposition"`

	// DRS will set the 'launch into instance ID' of any source server when performing
	// a drill, recovery or failback to the previous region or availability zone,
	// using the instance ID of the source instance.
	LaunchIntoSourceInstance *bool `locationName:"launchIntoSourceInstance" type:"boolean"`

	// Licensing.
	Licensing *Licensing `locationName:"licensing" type:"structure"`

	// Post-launch actions activated.
	PostLaunchEnabled *bool `locationName:"postLaunchEnabled" type:"boolean"`

	// Tags of the Launch Configuration Template.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by LaunchConfigurationTemplate's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Target instance type right-sizing method.
	TargetInstanceTypeRightSizingMethod *string `locationName:"targetInstanceTypeRightSizingMethod" type:"string" enum:"TargetInstanceTypeRightSizingMethod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchConfigurationTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchConfigurationTemplate) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *LaunchConfigurationTemplate) SetArn(v string) *LaunchConfigurationTemplate {
	s.Arn = &v
	return s
}

// SetCopyPrivateIp sets the CopyPrivateIp field's value.
func (s *LaunchConfigurationTemplate) SetCopyPrivateIp(v bool) *LaunchConfigurationTemplate {
	s.CopyPrivateIp = &v
	return s
}

// SetCopyTags sets the CopyTags field's value.
func (s *LaunchConfigurationTemplate) SetCopyTags(v bool) *LaunchConfigurationTemplate {
	s.CopyTags = &v
	return s
}

// SetExportBucketArn sets the ExportBucketArn field's value.
func (s *LaunchConfigurationTemplate) SetExportBucketArn(v string) *LaunchConfigurationTemplate {
	s.ExportBucketArn = &v
	return s
}

// SetLaunchConfigurationTemplateID sets the LaunchConfigurationTemplateID field's value.
func (s *LaunchConfigurationTemplate) SetLaunchConfigurationTemplateID(v string) *LaunchConfigurationTemplate {
	s.LaunchConfigurationTemplateID = &v
	return s
}

// SetLaunchDisposition sets the LaunchDisposition field's value.
func (s *LaunchConfigurationTemplate) SetLaunchDisposition(v string) *LaunchConfigurationTemplate {
	s.LaunchDisposition = &v
	return s
}

// SetLaunchIntoSourceInstance sets the LaunchIntoSourceInstance field's value.
func (s *LaunchConfigurationTemplate) SetLaunchIntoSourceInstance(v bool) *LaunchConfigurationTemplate {
	s.LaunchIntoSourceInstance = &v
	return s
}

// SetLicensing sets the Licensing field's value.
func (s *LaunchConfigurationTemplate) SetLicensing(v *Licensing) *LaunchConfigurationTemplate {
	s.Licensing = v
	return s
}

// SetPostLaunchEnabled sets the PostLaunchEnabled field's value.
func (s *LaunchConfigurationTemplate) SetPostLaunchEnabled(v bool) *LaunchConfigurationTemplate {
	s.PostLaunchEnabled = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *LaunchConfigurationTemplate) SetTags(v map[string]*string) *LaunchConfigurationTemplate {
	s.Tags = v
	return s
}

// SetTargetInstanceTypeRightSizingMethod sets the TargetInstanceTypeRightSizingMethod field's value.
func (s *LaunchConfigurationTemplate) SetTargetInstanceTypeRightSizingMethod(v string) *LaunchConfigurationTemplate {
	s.TargetInstanceTypeRightSizingMethod = &v
	return s
}

// Launch into existing instance.
type LaunchIntoInstanceProperties struct {
	_ struct{} `type:"structure"`

	// Optionally holds EC2 instance ID of an instance to launch into, instead of
	// launching a new instance during drill, recovery or failback.
	LaunchIntoEC2InstanceID *string `locationName:"launchIntoEC2InstanceID" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchIntoInstanceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchIntoInstanceProperties) GoString() string {
	return s.String()
}

// SetLaunchIntoEC2InstanceID sets the LaunchIntoEC2InstanceID field's value.
func (s *LaunchIntoInstanceProperties) SetLaunchIntoEC2InstanceID(v string) *LaunchIntoInstanceProperties {
	s.LaunchIntoEC2InstanceID = &v
	return s
}

// Configuration of a machine's license.
type Licensing struct {
	_ struct{} `type:"structure"`

	// Whether to enable "Bring your own license" or not.
	OsByol *bool `locationName:"osByol" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Licensing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Licensing) GoString() string {
	return s.String()
}

// SetOsByol sets the OsByol field's value.
func (s *Licensing) SetOsByol(v bool) *Licensing {
	s.OsByol = &v
	return s
}

// An object representing the Source Server Lifecycle.
type LifeCycle struct {
	_ struct{} `type:"structure"`

	// The date and time of when the Source Server was added to the service.
	AddedToServiceDateTime *string `locationName:"addedToServiceDateTime" min:"19" type:"string"`

	// The amount of time that the Source Server has been replicating for.
	ElapsedReplicationDuration *string `locationName:"elapsedReplicationDuration" min:"1" type:"string"`

	// The date and time of the first byte that was replicated from the Source Server.
	FirstByteDateTime *string `locationName:"firstByteDateTime" min:"19" type:"string"`

	// An object containing information regarding the last launch of the Source
	// Server.
	LastLaunch *LifeCycleLastLaunch `locationName:"lastLaunch" type:"structure"`

	// The date and time this Source Server was last seen by the service.
	LastSeenByServiceDateTime *string `locationName:"lastSeenByServiceDateTime" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycle) GoString() string {
	return s.String()
}

// SetAddedToServiceDateTime sets the AddedToServiceDateTime field's value.
func (s *LifeCycle) SetAddedToServiceDateTime(v string) *LifeCycle {
	s.AddedToServiceDateTime = &v
	return s
}

// SetElapsedReplicationDuration sets the ElapsedReplicationDuration field's value.
func (s *LifeCycle) SetElapsedReplicationDuration(v string) *LifeCycle {
	s.ElapsedReplicationDuration = &v
	return s
}

// SetFirstByteDateTime sets the FirstByteDateTime field's value.
func (s *LifeCycle) SetFirstByteDateTime(v string) *LifeCycle {
	s.FirstByteDateTime = &v
	return s
}

// SetLastLaunch sets the LastLaunch field's value.
func (s *LifeCycle) SetLastLaunch(v *LifeCycleLastLaunch) *LifeCycle {
	s.LastLaunch = v
	return s
}

// SetLastSeenByServiceDateTime sets the LastSeenByServiceDateTime field's value.
func (s *LifeCycle) SetLastSeenByServiceDateTime(v string) *LifeCycle {
	s.LastSeenByServiceDateTime = &v
	return s
}

// An object containing information regarding the last launch of a Source Server.
type LifeCycleLastLaunch struct {
	_ struct{} `type:"structure"`

	// An object containing information regarding the initiation of the last launch
	// of a Source Server.
	Initiated *LifeCycleLastLaunchInitiated `locationName:"initiated" type:"structure"`

	// Status of Source Server's last launch.
	Status *string `locationName:"status" type:"string" enum:"LaunchStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastLaunch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastLaunch) GoString() string {
	return s.String()
}

// SetInitiated sets the Initiated field's value.
func (s *LifeCycleLastLaunch) SetInitiated(v *LifeCycleLastLaunchInitiated) *LifeCycleLastLaunch {
	s.Initiated = v
	return s
}

// SetStatus sets the Status field's value.
func (s *LifeCycleLastLaunch) SetStatus(v string) *LifeCycleLastLaunch {
	s.Status = &v
	return s
}

// An object containing information regarding the initiation of the last launch
// of a Source Server.
type LifeCycleLastLaunchInitiated struct {
	_ struct{} `type:"structure"`

	// The date and time the last Source Server launch was initiated.
	ApiCallDateTime *string `locationName:"apiCallDateTime" min:"19" type:"string"`

	// The ID of the Job that was used to last launch the Source Server.
	JobID *string `locationName:"jobID" min:"24" type:"string"`

	// The Job type that was used to last launch the Source Server.
	Type *string `locationName:"type" type:"string" enum:"LastLaunchType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastLaunchInitiated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastLaunchInitiated) GoString() string {
	return s.String()
}

// SetApiCallDateTime sets the ApiCallDateTime field's value.
func (s *LifeCycleLastLaunchInitiated) SetApiCallDateTime(v string) *LifeCycleLastLaunchInitiated {
	s.ApiCallDateTime = &v
	return s
}

// SetJobID sets the JobID field's value.
func (s *LifeCycleLastLaunchInitiated) SetJobID(v string) *LifeCycleLastLaunchInitiated {
	s.JobID = &v
	return s
}

// SetType sets the Type field's value.
func (s *LifeCycleLastLaunchInitiated) SetType(v string) *LifeCycleLastLaunchInitiated {
	s.Type = &v
	return s
}

type ListExtensibleSourceServersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of extensible source servers to retrieve.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token of the next extensible source server to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Id of the staging Account to retrieve extensible source servers from.
	//
	// StagingAccountID is a required field
	StagingAccountID *string `locationName:"stagingAccountID" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensibleSourceServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensibleSourceServersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExtensibleSourceServersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExtensibleSourceServersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StagingAccountID == nil {
		invalidParams.Add(request.NewErrParamRequired("StagingAccountID"))
	}
	if s.StagingAccountID != nil && len(*s.StagingAccountID) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("StagingAccountID", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExtensibleSourceServersInput) SetMaxResults(v int64) *ListExtensibleSourceServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExtensibleSourceServersInput) SetNextToken(v string) *ListExtensibleSourceServersInput {
	s.NextToken = &v
	return s
}

// SetStagingAccountID sets the StagingAccountID field's value.
func (s *ListExtensibleSourceServersInput) SetStagingAccountID(v string) *ListExtensibleSourceServersInput {
	s.StagingAccountID = &v
	return s
}

type ListExtensibleSourceServersOutput struct {
	_ struct{} `type:"structure"`

	// A list of source servers on a staging Account that are extensible.
	Items []*StagingSourceServer `locationName:"items" type:"list"`

	// The token of the next extensible source server to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensibleSourceServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensibleSourceServersOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListExtensibleSourceServersOutput) SetItems(v []*StagingSourceServer) *ListExtensibleSourceServersOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExtensibleSourceServersOutput) SetNextToken(v string) *ListExtensibleSourceServersOutput {
	s.NextToken = &v
	return s
}

type ListLaunchActionsInput struct {
	_ struct{} `type:"structure"`

	// Filters to apply when listing resource launch actions.
	Filters *LaunchActionsRequestFilters `locationName:"filters" type:"structure"`

	// Maximum amount of items to return when listing resource launch actions.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Next token to use when listing resource launch actions.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Launch configuration template Id or Source Server Id
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLaunchActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLaunchActionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListLaunchActionsInput) SetFilters(v *LaunchActionsRequestFilters) *ListLaunchActionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLaunchActionsInput) SetMaxResults(v int64) *ListLaunchActionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLaunchActionsInput) SetNextToken(v string) *ListLaunchActionsInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ListLaunchActionsInput) SetResourceId(v string) *ListLaunchActionsInput {
	s.ResourceId = &v
	return s
}

type ListLaunchActionsOutput struct {
	_ struct{} `type:"structure"`

	// List of resource launch actions.
	Items []*LaunchAction `locationName:"items" type:"list"`

	// Next token returned when listing resource launch actions.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchActionsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListLaunchActionsOutput) SetItems(v []*LaunchAction) *ListLaunchActionsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLaunchActionsOutput) SetNextToken(v string) *ListLaunchActionsOutput {
	s.NextToken = &v
	return s
}

type ListStagingAccountsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of staging Accounts to retrieve.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token of the next staging Account to retrieve.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagingAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagingAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStagingAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStagingAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStagingAccountsInput) SetMaxResults(v int64) *ListStagingAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStagingAccountsInput) SetNextToken(v string) *ListStagingAccountsInput {
	s.NextToken = &v
	return s
}

type ListStagingAccountsOutput struct {
	_ struct{} `type:"structure"`

	// An array of staging AWS Accounts.
	Accounts []*Account `locationName:"accounts" type:"list"`

	// The token of the next staging Account to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagingAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagingAccountsOutput) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *ListStagingAccountsOutput) SetAccounts(v []*Account) *ListStagingAccountsOutput {
	s.Accounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStagingAccountsOutput) SetNextToken(v string) *ListStagingAccountsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource whose tags should be returned.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags of the requested resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListTagsForResourceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Network interface.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// Network interface IPs.
	Ips []*string `locationName:"ips" type:"list"`

	// Whether this is the primary network interface.
	IsPrimary *bool `locationName:"isPrimary" type:"boolean"`

	// The MAC address of the network interface.
	MacAddress *string `locationName:"macAddress" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetIps sets the Ips field's value.
func (s *NetworkInterface) SetIps(v []*string) *NetworkInterface {
	s.Ips = v
	return s
}

// SetIsPrimary sets the IsPrimary field's value.
func (s *NetworkInterface) SetIsPrimary(v bool) *NetworkInterface {
	s.IsPrimary = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *NetworkInterface) SetMacAddress(v string) *NetworkInterface {
	s.MacAddress = &v
	return s
}

// Operating System.
type OS struct {
	_ struct{} `type:"structure"`

	// The long name of the Operating System.
	FullString *string `locationName:"fullString" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OS) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OS) GoString() string {
	return s.String()
}

// SetFullString sets the FullString field's value.
func (s *OS) SetFullString(v string) *OS {
	s.FullString = &v
	return s
}

// A rule in the Point in Time (PIT) policy representing when to take snapshots
// and how long to retain them for.
type PITPolicyRule struct {
	_ struct{} `type:"structure"`

	// Whether this rule is enabled or not.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// How often, in the chosen units, a snapshot should be taken.
	//
	// Interval is a required field
	Interval *int64 `locationName:"interval" min:"1" type:"integer" required:"true"`

	// The duration to retain a snapshot for, in the chosen units.
	//
	// RetentionDuration is a required field
	RetentionDuration *int64 `locationName:"retentionDuration" min:"1" type:"integer" required:"true"`

	// The ID of the rule.
	RuleID *int64 `locationName:"ruleID" type:"long"`

	// The units used to measure the interval and retentionDuration.
	//
	// Units is a required field
	Units *string `locationName:"units" type:"string" required:"true" enum:"PITPolicyRuleUnits"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PITPolicyRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PITPolicyRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PITPolicyRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PITPolicyRule"}
	if s.Interval == nil {
		invalidParams.Add(request.NewErrParamRequired("Interval"))
	}
	if s.Interval != nil && *s.Interval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Interval", 1))
	}
	if s.RetentionDuration == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionDuration"))
	}
	if s.RetentionDuration != nil && *s.RetentionDuration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RetentionDuration", 1))
	}
	if s.Units == nil {
		invalidParams.Add(request.NewErrParamRequired("Units"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *PITPolicyRule) SetEnabled(v bool) *PITPolicyRule {
	s.Enabled = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *PITPolicyRule) SetInterval(v int64) *PITPolicyRule {
	s.Interval = &v
	return s
}

// SetRetentionDuration sets the RetentionDuration field's value.
func (s *PITPolicyRule) SetRetentionDuration(v int64) *PITPolicyRule {
	s.RetentionDuration = &v
	return s
}

// SetRuleID sets the RuleID field's value.
func (s *PITPolicyRule) SetRuleID(v int64) *PITPolicyRule {
	s.RuleID = &v
	return s
}

// SetUnits sets the Units field's value.
func (s *PITPolicyRule) SetUnits(v string) *PITPolicyRule {
	s.Units = &v
	return s
}

// Represents a resource participating in an asynchronous Job.
type ParticipatingResource struct {
	_ struct{} `type:"structure"`

	// The launch status of a participating resource.
	LaunchStatus *string `locationName:"launchStatus" type:"string" enum:"LaunchStatus"`

	// The ID of a participating resource.
	ParticipatingResourceID *ParticipatingResourceID `locationName:"participatingResourceID" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipatingResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipatingResource) GoString() string {
	return s.String()
}

// SetLaunchStatus sets the LaunchStatus field's value.
func (s *ParticipatingResource) SetLaunchStatus(v string) *ParticipatingResource {
	s.LaunchStatus = &v
	return s
}

// SetParticipatingResourceID sets the ParticipatingResourceID field's value.
func (s *ParticipatingResource) SetParticipatingResourceID(v *ParticipatingResourceID) *ParticipatingResource {
	s.ParticipatingResourceID = v
	return s
}

// ID of a resource participating in an asynchronous Job.
type ParticipatingResourceID struct {
	_ struct{} `type:"structure"`

	// Source Network ID.
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipatingResourceID) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipatingResourceID) GoString() string {
	return s.String()
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *ParticipatingResourceID) SetSourceNetworkID(v string) *ParticipatingResourceID {
	s.SourceNetworkID = &v
	return s
}

// Represents a server participating in an asynchronous Job.
type ParticipatingServer struct {
	_ struct{} `type:"structure"`

	// The post-launch action runs of a participating server.
	LaunchActionsStatus *LaunchActionsStatus `locationName:"launchActionsStatus" type:"structure"`

	// The launch status of a participating server.
	LaunchStatus *string `locationName:"launchStatus" type:"string" enum:"LaunchStatus"`

	// The Recovery Instance ID of a participating server.
	RecoveryInstanceID *string `locationName:"recoveryInstanceID" min:"10" type:"string"`

	// The Source Server ID of a participating server.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipatingServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipatingServer) GoString() string {
	return s.String()
}

// SetLaunchActionsStatus sets the LaunchActionsStatus field's value.
func (s *ParticipatingServer) SetLaunchActionsStatus(v *LaunchActionsStatus) *ParticipatingServer {
	s.LaunchActionsStatus = v
	return s
}

// SetLaunchStatus sets the LaunchStatus field's value.
func (s *ParticipatingServer) SetLaunchStatus(v string) *ParticipatingServer {
	s.LaunchStatus = &v
	return s
}

// SetRecoveryInstanceID sets the RecoveryInstanceID field's value.
func (s *ParticipatingServer) SetRecoveryInstanceID(v string) *ParticipatingServer {
	s.RecoveryInstanceID = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *ParticipatingServer) SetSourceServerID(v string) *ParticipatingServer {
	s.SourceServerID = &v
	return s
}

// Properties of a product code associated with a volume.
type ProductCode struct {
	_ struct{} `type:"structure"`

	// Id of a product code associated with a volume.
	ProductCodeId *string `locationName:"productCodeId" min:"25" type:"string"`

	// Mode of a product code associated with a volume.
	ProductCodeMode *string `locationName:"productCodeMode" type:"string" enum:"ProductCodeMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProductCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProductCode) GoString() string {
	return s.String()
}

// SetProductCodeId sets the ProductCodeId field's value.
func (s *ProductCode) SetProductCodeId(v string) *ProductCode {
	s.ProductCodeId = &v
	return s
}

// SetProductCodeMode sets the ProductCodeMode field's value.
func (s *ProductCode) SetProductCodeMode(v string) *ProductCode {
	s.ProductCodeMode = &v
	return s
}

type PutLaunchActionInput struct {
	_ struct{} `type:"structure"`

	// Launch action code.
	//
	// ActionCode is a required field
	ActionCode *string `locationName:"actionCode" min:"1" type:"string" required:"true"`

	// Launch action Id.
	//
	// ActionId is a required field
	ActionId *string `locationName:"actionId" min:"1" type:"string" required:"true"`

	// Launch action version.
	//
	// ActionVersion is a required field
	ActionVersion *string `locationName:"actionVersion" min:"1" type:"string" required:"true"`

	// Whether the launch action is active.
	//
	// Active is a required field
	Active *bool `locationName:"active" type:"boolean" required:"true"`

	// Launch action category.
	//
	// Category is a required field
	Category *string `locationName:"category" type:"string" required:"true" enum:"LaunchActionCategory"`

	// Launch action description.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// Launch action name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Whether the launch will not be marked as failed if this action fails.
	//
	// Optional is a required field
	Optional *bool `locationName:"optional" type:"boolean" required:"true"`

	// Launch action order.
	//
	// Order is a required field
	Order *int64 `locationName:"order" min:"2" type:"integer" required:"true"`

	// Launch action parameters.
	Parameters map[string]*LaunchActionParameter `locationName:"parameters" type:"map"`

	// Launch configuration template Id or Source Server Id
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLaunchActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLaunchActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLaunchActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLaunchActionInput"}
	if s.ActionCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionCode"))
	}
	if s.ActionCode != nil && len(*s.ActionCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionCode", 1))
	}
	if s.ActionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionId"))
	}
	if s.ActionId != nil && len(*s.ActionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionId", 1))
	}
	if s.ActionVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionVersion"))
	}
	if s.ActionVersion != nil && len(*s.ActionVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionVersion", 1))
	}
	if s.Active == nil {
		invalidParams.Add(request.NewErrParamRequired("Active"))
	}
	if s.Category == nil {
		invalidParams.Add(request.NewErrParamRequired("Category"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Optional == nil {
		invalidParams.Add(request.NewErrParamRequired("Optional"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}
	if s.Order != nil && *s.Order < 2 {
		invalidParams.Add(request.NewErrParamMinValue("Order", 2))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionCode sets the ActionCode field's value.
func (s *PutLaunchActionInput) SetActionCode(v string) *PutLaunchActionInput {
	s.ActionCode = &v
	return s
}

// SetActionId sets the ActionId field's value.
func (s *PutLaunchActionInput) SetActionId(v string) *PutLaunchActionInput {
	s.ActionId = &v
	return s
}

// SetActionVersion sets the ActionVersion field's value.
func (s *PutLaunchActionInput) SetActionVersion(v string) *PutLaunchActionInput {
	s.ActionVersion = &v
	return s
}

// SetActive sets the Active field's value.
func (s *PutLaunchActionInput) SetActive(v bool) *PutLaunchActionInput {
	s.Active = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *PutLaunchActionInput) SetCategory(v string) *PutLaunchActionInput {
	s.Category = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutLaunchActionInput) SetDescription(v string) *PutLaunchActionInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutLaunchActionInput) SetName(v string) *PutLaunchActionInput {
	s.Name = &v
	return s
}

// SetOptional sets the Optional field's value.
func (s *PutLaunchActionInput) SetOptional(v bool) *PutLaunchActionInput {
	s.Optional = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *PutLaunchActionInput) SetOrder(v int64) *PutLaunchActionInput {
	s.Order = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *PutLaunchActionInput) SetParameters(v map[string]*LaunchActionParameter) *PutLaunchActionInput {
	s.Parameters = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *PutLaunchActionInput) SetResourceId(v string) *PutLaunchActionInput {
	s.ResourceId = &v
	return s
}

type PutLaunchActionOutput struct {
	_ struct{} `type:"structure"`

	// Launch action code.
	ActionCode *string `locationName:"actionCode" min:"1" type:"string"`

	// Launch action Id.
	ActionId *string `locationName:"actionId" min:"1" type:"string"`

	// Launch action version.
	ActionVersion *string `locationName:"actionVersion" min:"1" type:"string"`

	// Whether the launch action is active.
	Active *bool `locationName:"active" type:"boolean"`

	// Launch action category.
	Category *string `locationName:"category" type:"string" enum:"LaunchActionCategory"`

	// Launch action description.
	Description *string `locationName:"description" type:"string"`

	// Launch action name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Whether the launch will not be marked as failed if this action fails.
	Optional *bool `locationName:"optional" type:"boolean"`

	// Launch action order.
	Order *int64 `locationName:"order" min:"2" type:"integer"`

	// Launch action parameters.
	Parameters map[string]*LaunchActionParameter `locationName:"parameters" type:"map"`

	// Launch configuration template Id or Source Server Id
	ResourceId *string `locationName:"resourceId" type:"string"`

	// Launch action type.
	Type *string `locationName:"type" type:"string" enum:"LaunchActionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLaunchActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLaunchActionOutput) GoString() string {
	return s.String()
}

// SetActionCode sets the ActionCode field's value.
func (s *PutLaunchActionOutput) SetActionCode(v string) *PutLaunchActionOutput {
	s.ActionCode = &v
	return s
}

// SetActionId sets the ActionId field's value.
func (s *PutLaunchActionOutput) SetActionId(v string) *PutLaunchActionOutput {
	s.ActionId = &v
	return s
}

// SetActionVersion sets the ActionVersion field's value.
func (s *PutLaunchActionOutput) SetActionVersion(v string) *PutLaunchActionOutput {
	s.ActionVersion = &v
	return s
}

// SetActive sets the Active field's value.
func (s *PutLaunchActionOutput) SetActive(v bool) *PutLaunchActionOutput {
	s.Active = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *PutLaunchActionOutput) SetCategory(v string) *PutLaunchActionOutput {
	s.Category = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutLaunchActionOutput) SetDescription(v string) *PutLaunchActionOutput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutLaunchActionOutput) SetName(v string) *PutLaunchActionOutput {
	s.Name = &v
	return s
}

// SetOptional sets the Optional field's value.
func (s *PutLaunchActionOutput) SetOptional(v bool) *PutLaunchActionOutput {
	s.Optional = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *PutLaunchActionOutput) SetOrder(v int64) *PutLaunchActionOutput {
	s.Order = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *PutLaunchActionOutput) SetParameters(v map[string]*LaunchActionParameter) *PutLaunchActionOutput {
	s.Parameters = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *PutLaunchActionOutput) SetResourceId(v string) *PutLaunchActionOutput {
	s.ResourceId = &v
	return s
}

// SetType sets the Type field's value.
func (s *PutLaunchActionOutput) SetType(v string) *PutLaunchActionOutput {
	s.Type = &v
	return s
}

// A Recovery Instance is a replica of a Source Server running on EC2.
type RecoveryInstance struct {
	_ struct{} `type:"structure"`

	// The version of the DRS agent installed on the recovery instance
	AgentVersion *string `locationName:"agentVersion" type:"string"`

	// The ARN of the Recovery Instance.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The Data Replication Info of the Recovery Instance.
	DataReplicationInfo *RecoveryInstanceDataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// The EC2 instance ID of the Recovery Instance.
	Ec2InstanceID *string `locationName:"ec2InstanceID" type:"string"`

	// The state of the EC2 instance for this Recovery Instance.
	Ec2InstanceState *string `locationName:"ec2InstanceState" type:"string" enum:"EC2InstanceState"`

	// An object representing failback related information of the Recovery Instance.
	Failback *RecoveryInstanceFailback `locationName:"failback" type:"structure"`

	// Whether this Recovery Instance was created for a drill or for an actual Recovery
	// event.
	IsDrill *bool `locationName:"isDrill" type:"boolean"`

	// The ID of the Job that created the Recovery Instance.
	JobID *string `locationName:"jobID" min:"24" type:"string"`

	// AWS availability zone associated with the recovery instance.
	OriginAvailabilityZone *string `locationName:"originAvailabilityZone" type:"string"`

	// Environment (On Premises / AWS) of the instance that the recovery instance
	// originated from.
	OriginEnvironment *string `locationName:"originEnvironment" type:"string" enum:"OriginEnvironment"`

	// The date and time of the Point in Time (PIT) snapshot that this Recovery
	// Instance was launched from.
	PointInTimeSnapshotDateTime *string `locationName:"pointInTimeSnapshotDateTime" min:"19" type:"string"`

	// The ID of the Recovery Instance.
	RecoveryInstanceID *string `locationName:"recoveryInstanceID" min:"10" type:"string"`

	// Properties of the Recovery Instance machine.
	RecoveryInstanceProperties *RecoveryInstanceProperties `locationName:"recoveryInstanceProperties" type:"structure"`

	// The Source Server ID that this Recovery Instance is associated with.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// An array of tags that are associated with the Recovery Instance.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RecoveryInstance's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstance) GoString() string {
	return s.String()
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *RecoveryInstance) SetAgentVersion(v string) *RecoveryInstance {
	s.AgentVersion = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *RecoveryInstance) SetArn(v string) *RecoveryInstance {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *RecoveryInstance) SetDataReplicationInfo(v *RecoveryInstanceDataReplicationInfo) *RecoveryInstance {
	s.DataReplicationInfo = v
	return s
}

// SetEc2InstanceID sets the Ec2InstanceID field's value.
func (s *RecoveryInstance) SetEc2InstanceID(v string) *RecoveryInstance {
	s.Ec2InstanceID = &v
	return s
}

// SetEc2InstanceState sets the Ec2InstanceState field's value.
func (s *RecoveryInstance) SetEc2InstanceState(v string) *RecoveryInstance {
	s.Ec2InstanceState = &v
	return s
}

// SetFailback sets the Failback field's value.
func (s *RecoveryInstance) SetFailback(v *RecoveryInstanceFailback) *RecoveryInstance {
	s.Failback = v
	return s
}

// SetIsDrill sets the IsDrill field's value.
func (s *RecoveryInstance) SetIsDrill(v bool) *RecoveryInstance {
	s.IsDrill = &v
	return s
}

// SetJobID sets the JobID field's value.
func (s *RecoveryInstance) SetJobID(v string) *RecoveryInstance {
	s.JobID = &v
	return s
}

// SetOriginAvailabilityZone sets the OriginAvailabilityZone field's value.
func (s *RecoveryInstance) SetOriginAvailabilityZone(v string) *RecoveryInstance {
	s.OriginAvailabilityZone = &v
	return s
}

// SetOriginEnvironment sets the OriginEnvironment field's value.
func (s *RecoveryInstance) SetOriginEnvironment(v string) *RecoveryInstance {
	s.OriginEnvironment = &v
	return s
}

// SetPointInTimeSnapshotDateTime sets the PointInTimeSnapshotDateTime field's value.
func (s *RecoveryInstance) SetPointInTimeSnapshotDateTime(v string) *RecoveryInstance {
	s.PointInTimeSnapshotDateTime = &v
	return s
}

// SetRecoveryInstanceID sets the RecoveryInstanceID field's value.
func (s *RecoveryInstance) SetRecoveryInstanceID(v string) *RecoveryInstance {
	s.RecoveryInstanceID = &v
	return s
}

// SetRecoveryInstanceProperties sets the RecoveryInstanceProperties field's value.
func (s *RecoveryInstance) SetRecoveryInstanceProperties(v *RecoveryInstanceProperties) *RecoveryInstance {
	s.RecoveryInstanceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *RecoveryInstance) SetSourceServerID(v string) *RecoveryInstance {
	s.SourceServerID = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RecoveryInstance) SetTags(v map[string]*string) *RecoveryInstance {
	s.Tags = v
	return s
}

// Error in data replication.
type RecoveryInstanceDataReplicationError struct {
	_ struct{} `type:"structure"`

	// Error in data replication.
	Error *string `locationName:"error" type:"string" enum:"FailbackReplicationError"`

	// Error in data replication.
	RawError *string `locationName:"rawError" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDataReplicationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDataReplicationError) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *RecoveryInstanceDataReplicationError) SetError(v string) *RecoveryInstanceDataReplicationError {
	s.Error = &v
	return s
}

// SetRawError sets the RawError field's value.
func (s *RecoveryInstanceDataReplicationError) SetRawError(v string) *RecoveryInstanceDataReplicationError {
	s.RawError = &v
	return s
}

// Information about Data Replication
type RecoveryInstanceDataReplicationInfo struct {
	_ struct{} `type:"structure"`

	// Information about Data Replication
	DataReplicationError *RecoveryInstanceDataReplicationError `locationName:"dataReplicationError" type:"structure"`

	// Information about whether the data replication has been initiated.
	DataReplicationInitiation *RecoveryInstanceDataReplicationInitiation `locationName:"dataReplicationInitiation" type:"structure"`

	// The state of the data replication.
	DataReplicationState *string `locationName:"dataReplicationState" type:"string" enum:"RecoveryInstanceDataReplicationState"`

	// An estimate of when the data replication will be completed.
	EtaDateTime *string `locationName:"etaDateTime" min:"19" type:"string"`

	// Data replication lag duration.
	LagDuration *string `locationName:"lagDuration" min:"19" type:"string"`

	// The disks that should be replicated.
	ReplicatedDisks []*RecoveryInstanceDataReplicationInfoReplicatedDisk `locationName:"replicatedDisks" type:"list"`

	// AWS Availability zone into which data is being replicated.
	StagingAvailabilityZone *string `locationName:"stagingAvailabilityZone" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDataReplicationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDataReplicationInfo) GoString() string {
	return s.String()
}

// SetDataReplicationError sets the DataReplicationError field's value.
func (s *RecoveryInstanceDataReplicationInfo) SetDataReplicationError(v *RecoveryInstanceDataReplicationError) *RecoveryInstanceDataReplicationInfo {
	s.DataReplicationError = v
	return s
}

// SetDataReplicationInitiation sets the DataReplicationInitiation field's value.
func (s *RecoveryInstanceDataReplicationInfo) SetDataReplicationInitiation(v *RecoveryInstanceDataReplicationInitiation) *RecoveryInstanceDataReplicationInfo {
	s.DataReplicationInitiation = v
	return s
}

// SetDataReplicationState sets the DataReplicationState field's value.
func (s *RecoveryInstanceDataReplicationInfo) SetDataReplicationState(v string) *RecoveryInstanceDataReplicationInfo {
	s.DataReplicationState = &v
	return s
}

// SetEtaDateTime sets the EtaDateTime field's value.
func (s *RecoveryInstanceDataReplicationInfo) SetEtaDateTime(v string) *RecoveryInstanceDataReplicationInfo {
	s.EtaDateTime = &v
	return s
}

// SetLagDuration sets the LagDuration field's value.
func (s *RecoveryInstanceDataReplicationInfo) SetLagDuration(v string) *RecoveryInstanceDataReplicationInfo {
	s.LagDuration = &v
	return s
}

// SetReplicatedDisks sets the ReplicatedDisks field's value.
func (s *RecoveryInstanceDataReplicationInfo) SetReplicatedDisks(v []*RecoveryInstanceDataReplicationInfoReplicatedDisk) *RecoveryInstanceDataReplicationInfo {
	s.ReplicatedDisks = v
	return s
}

// SetStagingAvailabilityZone sets the StagingAvailabilityZone field's value.
func (s *RecoveryInstanceDataReplicationInfo) SetStagingAvailabilityZone(v string) *RecoveryInstanceDataReplicationInfo {
	s.StagingAvailabilityZone = &v
	return s
}

// A disk that should be replicated.
type RecoveryInstanceDataReplicationInfoReplicatedDisk struct {
	_ struct{} `type:"structure"`

	// The size of the replication backlog in bytes.
	BackloggedStorageBytes *int64 `locationName:"backloggedStorageBytes" type:"long"`

	// The name of the device.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// The amount of data replicated so far in bytes.
	ReplicatedStorageBytes *int64 `locationName:"replicatedStorageBytes" type:"long"`

	// The amount of data to be rescanned in bytes.
	RescannedStorageBytes *int64 `locationName:"rescannedStorageBytes" type:"long"`

	// The total amount of data to be replicated in bytes.
	TotalStorageBytes *int64 `locationName:"totalStorageBytes" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDataReplicationInfoReplicatedDisk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDataReplicationInfoReplicatedDisk) GoString() string {
	return s.String()
}

// SetBackloggedStorageBytes sets the BackloggedStorageBytes field's value.
func (s *RecoveryInstanceDataReplicationInfoReplicatedDisk) SetBackloggedStorageBytes(v int64) *RecoveryInstanceDataReplicationInfoReplicatedDisk {
	s.BackloggedStorageBytes = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *RecoveryInstanceDataReplicationInfoReplicatedDisk) SetDeviceName(v string) *RecoveryInstanceDataReplicationInfoReplicatedDisk {
	s.DeviceName = &v
	return s
}

// SetReplicatedStorageBytes sets the ReplicatedStorageBytes field's value.
func (s *RecoveryInstanceDataReplicationInfoReplicatedDisk) SetReplicatedStorageBytes(v int64) *RecoveryInstanceDataReplicationInfoReplicatedDisk {
	s.ReplicatedStorageBytes = &v
	return s
}

// SetRescannedStorageBytes sets the RescannedStorageBytes field's value.
func (s *RecoveryInstanceDataReplicationInfoReplicatedDisk) SetRescannedStorageBytes(v int64) *RecoveryInstanceDataReplicationInfoReplicatedDisk {
	s.RescannedStorageBytes = &v
	return s
}

// SetTotalStorageBytes sets the TotalStorageBytes field's value.
func (s *RecoveryInstanceDataReplicationInfoReplicatedDisk) SetTotalStorageBytes(v int64) *RecoveryInstanceDataReplicationInfoReplicatedDisk {
	s.TotalStorageBytes = &v
	return s
}

// Data replication initiation.
type RecoveryInstanceDataReplicationInitiation struct {
	_ struct{} `type:"structure"`

	// The date and time of the current attempt to initiate data replication.
	StartDateTime *string `locationName:"startDateTime" min:"19" type:"string"`

	// The steps of the current attempt to initiate data replication.
	Steps []*RecoveryInstanceDataReplicationInitiationStep `locationName:"steps" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDataReplicationInitiation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDataReplicationInitiation) GoString() string {
	return s.String()
}

// SetStartDateTime sets the StartDateTime field's value.
func (s *RecoveryInstanceDataReplicationInitiation) SetStartDateTime(v string) *RecoveryInstanceDataReplicationInitiation {
	s.StartDateTime = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *RecoveryInstanceDataReplicationInitiation) SetSteps(v []*RecoveryInstanceDataReplicationInitiationStep) *RecoveryInstanceDataReplicationInitiation {
	s.Steps = v
	return s
}

// Data replication initiation step.
type RecoveryInstanceDataReplicationInitiationStep struct {
	_ struct{} `type:"structure"`

	// The name of the step.
	Name *string `locationName:"name" type:"string" enum:"RecoveryInstanceDataReplicationInitiationStepName"`

	// The status of the step.
	Status *string `locationName:"status" type:"string" enum:"RecoveryInstanceDataReplicationInitiationStepStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDataReplicationInitiationStep) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDataReplicationInitiationStep) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RecoveryInstanceDataReplicationInitiationStep) SetName(v string) *RecoveryInstanceDataReplicationInitiationStep {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecoveryInstanceDataReplicationInitiationStep) SetStatus(v string) *RecoveryInstanceDataReplicationInitiationStep {
	s.Status = &v
	return s
}

// An object representing a block storage device on the Recovery Instance.
type RecoveryInstanceDisk struct {
	_ struct{} `type:"structure"`

	// The amount of storage on the disk in bytes.
	Bytes *int64 `locationName:"bytes" type:"long"`

	// The EBS Volume ID of this disk.
	EbsVolumeID *string `locationName:"ebsVolumeID" min:"10" type:"string"`

	// The internal device name of this disk. This is the name that is visible on
	// the machine itself and not from the EC2 console.
	InternalDeviceName *string `locationName:"internalDeviceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDisk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceDisk) GoString() string {
	return s.String()
}

// SetBytes sets the Bytes field's value.
func (s *RecoveryInstanceDisk) SetBytes(v int64) *RecoveryInstanceDisk {
	s.Bytes = &v
	return s
}

// SetEbsVolumeID sets the EbsVolumeID field's value.
func (s *RecoveryInstanceDisk) SetEbsVolumeID(v string) *RecoveryInstanceDisk {
	s.EbsVolumeID = &v
	return s
}

// SetInternalDeviceName sets the InternalDeviceName field's value.
func (s *RecoveryInstanceDisk) SetInternalDeviceName(v string) *RecoveryInstanceDisk {
	s.InternalDeviceName = &v
	return s
}

// An object representing failback related information of the Recovery Instance.
type RecoveryInstanceFailback struct {
	_ struct{} `type:"structure"`

	// The date and time the agent on the Recovery Instance was last seen by the
	// service.
	AgentLastSeenByServiceDateTime *string `locationName:"agentLastSeenByServiceDateTime" min:"19" type:"string"`

	// The amount of time that the Recovery Instance has been replicating for.
	ElapsedReplicationDuration *string `locationName:"elapsedReplicationDuration" min:"19" type:"string"`

	// The ID of the failback client that this Recovery Instance is associated with.
	FailbackClientID *string `locationName:"failbackClientID" type:"string"`

	// The date and time that the failback client was last seen by the service.
	FailbackClientLastSeenByServiceDateTime *string `locationName:"failbackClientLastSeenByServiceDateTime" min:"19" type:"string"`

	// The date and time that the failback initiation started.
	FailbackInitiationTime *string `locationName:"failbackInitiationTime" min:"19" type:"string"`

	// The Job ID of the last failback log for this Recovery Instance.
	FailbackJobID *string `locationName:"failbackJobID" min:"24" type:"string"`

	// The launch type (Recovery / Drill) of the last launch for the failback replication
	// of this recovery instance.
	FailbackLaunchType *string `locationName:"failbackLaunchType" type:"string" enum:"FailbackLaunchType"`

	// Whether we are failing back to the original Source Server for this Recovery
	// Instance.
	FailbackToOriginalServer *bool `locationName:"failbackToOriginalServer" type:"boolean"`

	// The date and time of the first byte that was replicated from the Recovery
	// Instance.
	FirstByteDateTime *string `locationName:"firstByteDateTime" min:"19" type:"string"`

	// The state of the failback process that this Recovery Instance is in.
	State *string `locationName:"state" type:"string" enum:"FailbackState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceFailback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceFailback) GoString() string {
	return s.String()
}

// SetAgentLastSeenByServiceDateTime sets the AgentLastSeenByServiceDateTime field's value.
func (s *RecoveryInstanceFailback) SetAgentLastSeenByServiceDateTime(v string) *RecoveryInstanceFailback {
	s.AgentLastSeenByServiceDateTime = &v
	return s
}

// SetElapsedReplicationDuration sets the ElapsedReplicationDuration field's value.
func (s *RecoveryInstanceFailback) SetElapsedReplicationDuration(v string) *RecoveryInstanceFailback {
	s.ElapsedReplicationDuration = &v
	return s
}

// SetFailbackClientID sets the FailbackClientID field's value.
func (s *RecoveryInstanceFailback) SetFailbackClientID(v string) *RecoveryInstanceFailback {
	s.FailbackClientID = &v
	return s
}

// SetFailbackClientLastSeenByServiceDateTime sets the FailbackClientLastSeenByServiceDateTime field's value.
func (s *RecoveryInstanceFailback) SetFailbackClientLastSeenByServiceDateTime(v string) *RecoveryInstanceFailback {
	s.FailbackClientLastSeenByServiceDateTime = &v
	return s
}

// SetFailbackInitiationTime sets the FailbackInitiationTime field's value.
func (s *RecoveryInstanceFailback) SetFailbackInitiationTime(v string) *RecoveryInstanceFailback {
	s.FailbackInitiationTime = &v
	return s
}

// SetFailbackJobID sets the FailbackJobID field's value.
func (s *RecoveryInstanceFailback) SetFailbackJobID(v string) *RecoveryInstanceFailback {
	s.FailbackJobID = &v
	return s
}

// SetFailbackLaunchType sets the FailbackLaunchType field's value.
func (s *RecoveryInstanceFailback) SetFailbackLaunchType(v string) *RecoveryInstanceFailback {
	s.FailbackLaunchType = &v
	return s
}

// SetFailbackToOriginalServer sets the FailbackToOriginalServer field's value.
func (s *RecoveryInstanceFailback) SetFailbackToOriginalServer(v bool) *RecoveryInstanceFailback {
	s.FailbackToOriginalServer = &v
	return s
}

// SetFirstByteDateTime sets the FirstByteDateTime field's value.
func (s *RecoveryInstanceFailback) SetFirstByteDateTime(v string) *RecoveryInstanceFailback {
	s.FirstByteDateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *RecoveryInstanceFailback) SetState(v string) *RecoveryInstanceFailback {
	s.State = &v
	return s
}

// Properties of the Recovery Instance machine.
type RecoveryInstanceProperties struct {
	_ struct{} `type:"structure"`

	// An array of CPUs.
	Cpus []*CPU `locationName:"cpus" type:"list"`

	// An array of disks.
	Disks []*RecoveryInstanceDisk `locationName:"disks" type:"list"`

	// Hints used to uniquely identify a machine.
	IdentificationHints *IdentificationHints `locationName:"identificationHints" type:"structure"`

	// The date and time the Recovery Instance properties were last updated on.
	LastUpdatedDateTime *string `locationName:"lastUpdatedDateTime" min:"19" type:"string"`

	// An array of network interfaces.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// Operating system.
	Os *OS `locationName:"os" type:"structure"`

	// The amount of RAM in bytes.
	RamBytes *int64 `locationName:"ramBytes" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryInstanceProperties) GoString() string {
	return s.String()
}

// SetCpus sets the Cpus field's value.
func (s *RecoveryInstanceProperties) SetCpus(v []*CPU) *RecoveryInstanceProperties {
	s.Cpus = v
	return s
}

// SetDisks sets the Disks field's value.
func (s *RecoveryInstanceProperties) SetDisks(v []*RecoveryInstanceDisk) *RecoveryInstanceProperties {
	s.Disks = v
	return s
}

// SetIdentificationHints sets the IdentificationHints field's value.
func (s *RecoveryInstanceProperties) SetIdentificationHints(v *IdentificationHints) *RecoveryInstanceProperties {
	s.IdentificationHints = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *RecoveryInstanceProperties) SetLastUpdatedDateTime(v string) *RecoveryInstanceProperties {
	s.LastUpdatedDateTime = &v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *RecoveryInstanceProperties) SetNetworkInterfaces(v []*NetworkInterface) *RecoveryInstanceProperties {
	s.NetworkInterfaces = v
	return s
}

// SetOs sets the Os field's value.
func (s *RecoveryInstanceProperties) SetOs(v *OS) *RecoveryInstanceProperties {
	s.Os = v
	return s
}

// SetRamBytes sets the RamBytes field's value.
func (s *RecoveryInstanceProperties) SetRamBytes(v int64) *RecoveryInstanceProperties {
	s.RamBytes = &v
	return s
}

// An object representing the Source Network recovery Lifecycle.
type RecoveryLifeCycle struct {
	_ struct{} `type:"structure"`

	// The date and time the last Source Network recovery was initiated.
	ApiCallDateTime *time.Time `locationName:"apiCallDateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the Job that was used to last recover the Source Network.
	JobID *string `locationName:"jobID" min:"24" type:"string"`

	// The status of the last recovery status of this Source Network.
	LastRecoveryResult *string `locationName:"lastRecoveryResult" type:"string" enum:"RecoveryResult"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryLifeCycle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryLifeCycle) GoString() string {
	return s.String()
}

// SetApiCallDateTime sets the ApiCallDateTime field's value.
func (s *RecoveryLifeCycle) SetApiCallDateTime(v time.Time) *RecoveryLifeCycle {
	s.ApiCallDateTime = &v
	return s
}

// SetJobID sets the JobID field's value.
func (s *RecoveryLifeCycle) SetJobID(v string) *RecoveryLifeCycle {
	s.JobID = &v
	return s
}

// SetLastRecoveryResult sets the LastRecoveryResult field's value.
func (s *RecoveryLifeCycle) SetLastRecoveryResult(v string) *RecoveryLifeCycle {
	s.LastRecoveryResult = &v
	return s
}

// A snapshot of a Source Server used during recovery.
type RecoverySnapshot struct {
	_ struct{} `type:"structure"`

	// A list of EBS snapshots.
	EbsSnapshots []*string `locationName:"ebsSnapshots" type:"list"`

	// The timestamp of when we expect the snapshot to be taken.
	//
	// ExpectedTimestamp is a required field
	ExpectedTimestamp *string `locationName:"expectedTimestamp" min:"19" type:"string" required:"true"`

	// The ID of the Recovery Snapshot.
	//
	// SnapshotID is a required field
	SnapshotID *string `locationName:"snapshotID" min:"21" type:"string" required:"true"`

	// The ID of the Source Server that the snapshot was taken for.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`

	// The actual timestamp that the snapshot was taken.
	Timestamp *string `locationName:"timestamp" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoverySnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoverySnapshot) GoString() string {
	return s.String()
}

// SetEbsSnapshots sets the EbsSnapshots field's value.
func (s *RecoverySnapshot) SetEbsSnapshots(v []*string) *RecoverySnapshot {
	s.EbsSnapshots = v
	return s
}

// SetExpectedTimestamp sets the ExpectedTimestamp field's value.
func (s *RecoverySnapshot) SetExpectedTimestamp(v string) *RecoverySnapshot {
	s.ExpectedTimestamp = &v
	return s
}

// SetSnapshotID sets the SnapshotID field's value.
func (s *RecoverySnapshot) SetSnapshotID(v string) *RecoverySnapshot {
	s.SnapshotID = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *RecoverySnapshot) SetSourceServerID(v string) *RecoverySnapshot {
	s.SourceServerID = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *RecoverySnapshot) SetTimestamp(v string) *RecoverySnapshot {
	s.Timestamp = &v
	return s
}

// The configuration of a disk of the Source Server to be replicated.
type ReplicationConfigurationReplicatedDisk struct {
	_ struct{} `type:"structure"`

	// The name of the device.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// The requested number of I/O operations per second (IOPS).
	Iops *int64 `locationName:"iops" type:"long"`

	// Whether to boot from this disk or not.
	IsBootDisk *bool `locationName:"isBootDisk" type:"boolean"`

	// The Staging Disk EBS volume type to be used during replication when stagingDiskType
	// is set to Auto. This is a read-only field.
	OptimizedStagingDiskType *string `locationName:"optimizedStagingDiskType" type:"string" enum:"ReplicationConfigurationReplicatedDiskStagingDiskType"`

	// The Staging Disk EBS volume type to be used during replication.
	StagingDiskType *string `locationName:"stagingDiskType" type:"string" enum:"ReplicationConfigurationReplicatedDiskStagingDiskType"`

	// The throughput to use for the EBS volume in MiB/s. This parameter is valid
	// only for gp3 volumes.
	Throughput *int64 `locationName:"throughput" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfigurationReplicatedDisk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfigurationReplicatedDisk) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *ReplicationConfigurationReplicatedDisk) SetDeviceName(v string) *ReplicationConfigurationReplicatedDisk {
	s.DeviceName = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *ReplicationConfigurationReplicatedDisk) SetIops(v int64) *ReplicationConfigurationReplicatedDisk {
	s.Iops = &v
	return s
}

// SetIsBootDisk sets the IsBootDisk field's value.
func (s *ReplicationConfigurationReplicatedDisk) SetIsBootDisk(v bool) *ReplicationConfigurationReplicatedDisk {
	s.IsBootDisk = &v
	return s
}

// SetOptimizedStagingDiskType sets the OptimizedStagingDiskType field's value.
func (s *ReplicationConfigurationReplicatedDisk) SetOptimizedStagingDiskType(v string) *ReplicationConfigurationReplicatedDisk {
	s.OptimizedStagingDiskType = &v
	return s
}

// SetStagingDiskType sets the StagingDiskType field's value.
func (s *ReplicationConfigurationReplicatedDisk) SetStagingDiskType(v string) *ReplicationConfigurationReplicatedDisk {
	s.StagingDiskType = &v
	return s
}

// SetThroughput sets the Throughput field's value.
func (s *ReplicationConfigurationReplicatedDisk) SetThroughput(v int64) *ReplicationConfigurationReplicatedDisk {
	s.Throughput = &v
	return s
}

type ReplicationConfigurationTemplate struct {
	_ struct{} `type:"structure"`

	// The Replication Configuration Template ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Whether to associate the default Elastic Disaster Recovery Security group
	// with the Replication Configuration Template.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Whether to allow the AWS replication agent to automatically replicate newly
	// added disks.
	AutoReplicateNewDisks *bool `locationName:"autoReplicateNewDisks" type:"boolean"`

	// Configure bandwidth throttling for the outbound data transfer rate of the
	// Source Server in Mbps.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Whether to create a Public IP for the Recovery Instance by default.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// The data plane routing mechanism that will be used for replication.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// The Staging Disk EBS volume type to be used during replication.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// The type of EBS encryption to be used during replication.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// The ARN of the EBS encryption key to be used during replication.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// The Point in time (PIT) policy to manage snapshots taken during replication.
	PitPolicy []*PITPolicyRule `locationName:"pitPolicy" min:"1" type:"list"`

	// The Replication Configuration Template ID.
	//
	// ReplicationConfigurationTemplateID is a required field
	ReplicationConfigurationTemplateID *string `locationName:"replicationConfigurationTemplateID" min:"21" type:"string" required:"true"`

	// The instance type to be used for the replication server.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// The security group IDs that will be used by the replication server.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// The subnet to be used by the replication staging area.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// A set of tags to be associated with all resources created in the replication
	// staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ReplicationConfigurationTemplate's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// A set of tags to be associated with the Replication Configuration Template
	// resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ReplicationConfigurationTemplate's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Whether to use a dedicated Replication Server in the replication staging
	// area.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfigurationTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfigurationTemplate) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ReplicationConfigurationTemplate) SetArn(v string) *ReplicationConfigurationTemplate {
	s.Arn = &v
	return s
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *ReplicationConfigurationTemplate) SetAssociateDefaultSecurityGroup(v bool) *ReplicationConfigurationTemplate {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetAutoReplicateNewDisks sets the AutoReplicateNewDisks field's value.
func (s *ReplicationConfigurationTemplate) SetAutoReplicateNewDisks(v bool) *ReplicationConfigurationTemplate {
	s.AutoReplicateNewDisks = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *ReplicationConfigurationTemplate) SetBandwidthThrottling(v int64) *ReplicationConfigurationTemplate {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *ReplicationConfigurationTemplate) SetCreatePublicIP(v bool) *ReplicationConfigurationTemplate {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *ReplicationConfigurationTemplate) SetDataPlaneRouting(v string) *ReplicationConfigurationTemplate {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *ReplicationConfigurationTemplate) SetDefaultLargeStagingDiskType(v string) *ReplicationConfigurationTemplate {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *ReplicationConfigurationTemplate) SetEbsEncryption(v string) *ReplicationConfigurationTemplate {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *ReplicationConfigurationTemplate) SetEbsEncryptionKeyArn(v string) *ReplicationConfigurationTemplate {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetPitPolicy sets the PitPolicy field's value.
func (s *ReplicationConfigurationTemplate) SetPitPolicy(v []*PITPolicyRule) *ReplicationConfigurationTemplate {
	s.PitPolicy = v
	return s
}

// SetReplicationConfigurationTemplateID sets the ReplicationConfigurationTemplateID field's value.
func (s *ReplicationConfigurationTemplate) SetReplicationConfigurationTemplateID(v string) *ReplicationConfigurationTemplate {
	s.ReplicationConfigurationTemplateID = &v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *ReplicationConfigurationTemplate) SetReplicationServerInstanceType(v string) *ReplicationConfigurationTemplate {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *ReplicationConfigurationTemplate) SetReplicationServersSecurityGroupsIDs(v []*string) *ReplicationConfigurationTemplate {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *ReplicationConfigurationTemplate) SetStagingAreaSubnetId(v string) *ReplicationConfigurationTemplate {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *ReplicationConfigurationTemplate) SetStagingAreaTags(v map[string]*string) *ReplicationConfigurationTemplate {
	s.StagingAreaTags = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ReplicationConfigurationTemplate) SetTags(v map[string]*string) *ReplicationConfigurationTemplate {
	s.Tags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *ReplicationConfigurationTemplate) SetUseDedicatedReplicationServer(v bool) *ReplicationConfigurationTemplate {
	s.UseDedicatedReplicationServer = &v
	return s
}

// The resource for this operation was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Deprecated: WARNING: RetryDataReplication is deprecated
type RetryDataReplicationInput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The ID of the Source Server whose data replication should be retried.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryDataReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryDataReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetryDataReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetryDataReplicationInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *RetryDataReplicationInput) SetSourceServerID(v string) *RetryDataReplicationInput {
	s.SourceServerID = &v
	return s
}

type RetryDataReplicationOutput struct {
	_ struct{} `type:"structure"`

	// The version of the DRS agent installed on the source server
	AgentVersion *string `locationName:"agentVersion" type:"string"`

	// The ARN of the Source Server.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The Data Replication Info of the Source Server.
	DataReplicationInfo *DataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// The status of the last recovery launch of this Source Server.
	LastLaunchResult *string `locationName:"lastLaunchResult" type:"string" enum:"LastLaunchResult"`

	// The lifecycle information of this Source Server.
	LifeCycle *LifeCycle `locationName:"lifeCycle" type:"structure"`

	// The ID of the Recovery Instance associated with this Source Server.
	RecoveryInstanceId *string `locationName:"recoveryInstanceId" min:"10" type:"string"`

	// Replication direction of the Source Server.
	ReplicationDirection *string `locationName:"replicationDirection" type:"string" enum:"ReplicationDirection"`

	// For EC2-originated Source Servers which have been failed over and then failed
	// back, this value will mean the ARN of the Source Server on the opposite replication
	// direction.
	ReversedDirectionSourceServerArn *string `locationName:"reversedDirectionSourceServerArn" min:"20" type:"string"`

	// Source cloud properties of the Source Server.
	SourceCloudProperties *SourceCloudProperties `locationName:"sourceCloudProperties" type:"structure"`

	// ID of the Source Network which is protecting this Source Server's network.
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string"`

	// The source properties of the Source Server.
	SourceProperties *SourceProperties `locationName:"sourceProperties" type:"structure"`

	// The ID of the Source Server.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// The staging area of the source server.
	StagingArea *StagingArea `locationName:"stagingArea" type:"structure"`

	// The tags associated with the Source Server.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetryDataReplicationOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryDataReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryDataReplicationOutput) GoString() string {
	return s.String()
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *RetryDataReplicationOutput) SetAgentVersion(v string) *RetryDataReplicationOutput {
	s.AgentVersion = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *RetryDataReplicationOutput) SetArn(v string) *RetryDataReplicationOutput {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *RetryDataReplicationOutput) SetDataReplicationInfo(v *DataReplicationInfo) *RetryDataReplicationOutput {
	s.DataReplicationInfo = v
	return s
}

// SetLastLaunchResult sets the LastLaunchResult field's value.
func (s *RetryDataReplicationOutput) SetLastLaunchResult(v string) *RetryDataReplicationOutput {
	s.LastLaunchResult = &v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *RetryDataReplicationOutput) SetLifeCycle(v *LifeCycle) *RetryDataReplicationOutput {
	s.LifeCycle = v
	return s
}

// SetRecoveryInstanceId sets the RecoveryInstanceId field's value.
func (s *RetryDataReplicationOutput) SetRecoveryInstanceId(v string) *RetryDataReplicationOutput {
	s.RecoveryInstanceId = &v
	return s
}

// SetReplicationDirection sets the ReplicationDirection field's value.
func (s *RetryDataReplicationOutput) SetReplicationDirection(v string) *RetryDataReplicationOutput {
	s.ReplicationDirection = &v
	return s
}

// SetReversedDirectionSourceServerArn sets the ReversedDirectionSourceServerArn field's value.
func (s *RetryDataReplicationOutput) SetReversedDirectionSourceServerArn(v string) *RetryDataReplicationOutput {
	s.ReversedDirectionSourceServerArn = &v
	return s
}

// SetSourceCloudProperties sets the SourceCloudProperties field's value.
func (s *RetryDataReplicationOutput) SetSourceCloudProperties(v *SourceCloudProperties) *RetryDataReplicationOutput {
	s.SourceCloudProperties = v
	return s
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *RetryDataReplicationOutput) SetSourceNetworkID(v string) *RetryDataReplicationOutput {
	s.SourceNetworkID = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *RetryDataReplicationOutput) SetSourceProperties(v *SourceProperties) *RetryDataReplicationOutput {
	s.SourceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *RetryDataReplicationOutput) SetSourceServerID(v string) *RetryDataReplicationOutput {
	s.SourceServerID = &v
	return s
}

// SetStagingArea sets the StagingArea field's value.
func (s *RetryDataReplicationOutput) SetStagingArea(v *StagingArea) *RetryDataReplicationOutput {
	s.StagingArea = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RetryDataReplicationOutput) SetTags(v map[string]*string) *RetryDataReplicationOutput {
	s.Tags = v
	return s
}

type ReverseReplicationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Recovery Instance that we want to reverse the replication for.
	//
	// RecoveryInstanceID is a required field
	RecoveryInstanceID *string `locationName:"recoveryInstanceID" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReverseReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReverseReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReverseReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReverseReplicationInput"}
	if s.RecoveryInstanceID == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryInstanceID"))
	}
	if s.RecoveryInstanceID != nil && len(*s.RecoveryInstanceID) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryInstanceID", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryInstanceID sets the RecoveryInstanceID field's value.
func (s *ReverseReplicationInput) SetRecoveryInstanceID(v string) *ReverseReplicationInput {
	s.RecoveryInstanceID = &v
	return s
}

type ReverseReplicationOutput struct {
	_ struct{} `type:"structure"`

	// ARN of created SourceServer.
	ReversedDirectionSourceServerArn *string `locationName:"reversedDirectionSourceServerArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReverseReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReverseReplicationOutput) GoString() string {
	return s.String()
}

// SetReversedDirectionSourceServerArn sets the ReversedDirectionSourceServerArn field's value.
func (s *ReverseReplicationOutput) SetReversedDirectionSourceServerArn(v string) *ReverseReplicationOutput {
	s.ReversedDirectionSourceServerArn = &v
	return s
}

// The request could not be completed because its exceeded the service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// Quota code.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// Service code.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Properties of the cloud environment where this Source Server originated from.
type SourceCloudProperties struct {
	_ struct{} `type:"structure"`

	// AWS Account ID for an EC2-originated Source Server.
	OriginAccountID *string `locationName:"originAccountID" min:"12" type:"string"`

	// AWS Availability Zone for an EC2-originated Source Server.
	OriginAvailabilityZone *string `locationName:"originAvailabilityZone" type:"string"`

	// AWS Region for an EC2-originated Source Server.
	OriginRegion *string `locationName:"originRegion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceCloudProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceCloudProperties) GoString() string {
	return s.String()
}

// SetOriginAccountID sets the OriginAccountID field's value.
func (s *SourceCloudProperties) SetOriginAccountID(v string) *SourceCloudProperties {
	s.OriginAccountID = &v
	return s
}

// SetOriginAvailabilityZone sets the OriginAvailabilityZone field's value.
func (s *SourceCloudProperties) SetOriginAvailabilityZone(v string) *SourceCloudProperties {
	s.OriginAvailabilityZone = &v
	return s
}

// SetOriginRegion sets the OriginRegion field's value.
func (s *SourceCloudProperties) SetOriginRegion(v string) *SourceCloudProperties {
	s.OriginRegion = &v
	return s
}

// The ARN of the Source Network.
type SourceNetwork struct {
	_ struct{} `type:"structure"`

	// The ARN of the Source Network.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// CloudFormation stack name that was deployed for recovering the Source Network.
	//
	// CfnStackName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SourceNetwork's
	// String and GoString methods.
	CfnStackName *string `locationName:"cfnStackName" min:"1" type:"string" sensitive:"true"`

	// An object containing information regarding the last recovery of the Source
	// Network.
	LastRecovery *RecoveryLifeCycle `locationName:"lastRecovery" type:"structure"`

	// ID of the recovered VPC following Source Network recovery.
	LaunchedVpcID *string `locationName:"launchedVpcID" min:"12" type:"string"`

	// Status of Source Network Replication. Possible values: (a) STOPPED - Source
	// Network is not replicating. (b) IN_PROGRESS - Source Network is being replicated.
	// (c) PROTECTED - Source Network was replicated successfully and is being synchronized
	// for changes. (d) ERROR - Source Network replication has failed
	ReplicationStatus *string `locationName:"replicationStatus" type:"string" enum:"ReplicationStatus"`

	// Error details in case Source Network replication status is ERROR.
	//
	// ReplicationStatusDetails is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SourceNetwork's
	// String and GoString methods.
	ReplicationStatusDetails *string `locationName:"replicationStatusDetails" type:"string" sensitive:"true"`

	// Account ID containing the VPC protected by the Source Network.
	SourceAccountID *string `locationName:"sourceAccountID" min:"12" type:"string"`

	// Source Network ID.
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string"`

	// Region containing the VPC protected by the Source Network.
	SourceRegion *string `locationName:"sourceRegion" type:"string"`

	// VPC ID protected by the Source Network.
	SourceVpcID *string `locationName:"sourceVpcID" min:"12" type:"string"`

	// A list of tags associated with the Source Network.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SourceNetwork's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceNetwork) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceNetwork) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SourceNetwork) SetArn(v string) *SourceNetwork {
	s.Arn = &v
	return s
}

// SetCfnStackName sets the CfnStackName field's value.
func (s *SourceNetwork) SetCfnStackName(v string) *SourceNetwork {
	s.CfnStackName = &v
	return s
}

// SetLastRecovery sets the LastRecovery field's value.
func (s *SourceNetwork) SetLastRecovery(v *RecoveryLifeCycle) *SourceNetwork {
	s.LastRecovery = v
	return s
}

// SetLaunchedVpcID sets the LaunchedVpcID field's value.
func (s *SourceNetwork) SetLaunchedVpcID(v string) *SourceNetwork {
	s.LaunchedVpcID = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *SourceNetwork) SetReplicationStatus(v string) *SourceNetwork {
	s.ReplicationStatus = &v
	return s
}

// SetReplicationStatusDetails sets the ReplicationStatusDetails field's value.
func (s *SourceNetwork) SetReplicationStatusDetails(v string) *SourceNetwork {
	s.ReplicationStatusDetails = &v
	return s
}

// SetSourceAccountID sets the SourceAccountID field's value.
func (s *SourceNetwork) SetSourceAccountID(v string) *SourceNetwork {
	s.SourceAccountID = &v
	return s
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *SourceNetwork) SetSourceNetworkID(v string) *SourceNetwork {
	s.SourceNetworkID = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *SourceNetwork) SetSourceRegion(v string) *SourceNetwork {
	s.SourceRegion = &v
	return s
}

// SetSourceVpcID sets the SourceVpcID field's value.
func (s *SourceNetwork) SetSourceVpcID(v string) *SourceNetwork {
	s.SourceVpcID = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SourceNetwork) SetTags(v map[string]*string) *SourceNetwork {
	s.Tags = v
	return s
}

// Properties of Source Network related to a job event.
type SourceNetworkData struct {
	_ struct{} `type:"structure"`

	// Source Network ID.
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string"`

	// VPC ID protected by the Source Network.
	SourceVpc *string `locationName:"sourceVpc" min:"12" type:"string"`

	// CloudFormation stack name that was deployed for recovering the Source Network.
	StackName *string `locationName:"stackName" type:"string"`

	// ID of the recovered VPC following Source Network recovery.
	TargetVpc *string `locationName:"targetVpc" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceNetworkData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceNetworkData) GoString() string {
	return s.String()
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *SourceNetworkData) SetSourceNetworkID(v string) *SourceNetworkData {
	s.SourceNetworkID = &v
	return s
}

// SetSourceVpc sets the SourceVpc field's value.
func (s *SourceNetworkData) SetSourceVpc(v string) *SourceNetworkData {
	s.SourceVpc = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *SourceNetworkData) SetStackName(v string) *SourceNetworkData {
	s.StackName = &v
	return s
}

// SetTargetVpc sets the TargetVpc field's value.
func (s *SourceNetworkData) SetTargetVpc(v string) *SourceNetworkData {
	s.TargetVpc = &v
	return s
}

// Properties of the Source Server machine.
type SourceProperties struct {
	_ struct{} `type:"structure"`

	// An array of CPUs.
	Cpus []*CPU `locationName:"cpus" type:"list"`

	// An array of disks.
	Disks []*Disk `locationName:"disks" type:"list"`

	// Hints used to uniquely identify a machine.
	IdentificationHints *IdentificationHints `locationName:"identificationHints" type:"structure"`

	// The date and time the Source Properties were last updated on.
	LastUpdatedDateTime *string `locationName:"lastUpdatedDateTime" min:"19" type:"string"`

	// An array of network interfaces.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// Operating system.
	Os *OS `locationName:"os" type:"structure"`

	// The amount of RAM in bytes.
	RamBytes *int64 `locationName:"ramBytes" type:"long"`

	// The recommended EC2 instance type that will be used when recovering the Source
	// Server.
	RecommendedInstanceType *string `locationName:"recommendedInstanceType" type:"string"`

	// Are EC2 nitro instance types supported when recovering the Source Server.
	SupportsNitroInstances *bool `locationName:"supportsNitroInstances" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceProperties) GoString() string {
	return s.String()
}

// SetCpus sets the Cpus field's value.
func (s *SourceProperties) SetCpus(v []*CPU) *SourceProperties {
	s.Cpus = v
	return s
}

// SetDisks sets the Disks field's value.
func (s *SourceProperties) SetDisks(v []*Disk) *SourceProperties {
	s.Disks = v
	return s
}

// SetIdentificationHints sets the IdentificationHints field's value.
func (s *SourceProperties) SetIdentificationHints(v *IdentificationHints) *SourceProperties {
	s.IdentificationHints = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *SourceProperties) SetLastUpdatedDateTime(v string) *SourceProperties {
	s.LastUpdatedDateTime = &v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *SourceProperties) SetNetworkInterfaces(v []*NetworkInterface) *SourceProperties {
	s.NetworkInterfaces = v
	return s
}

// SetOs sets the Os field's value.
func (s *SourceProperties) SetOs(v *OS) *SourceProperties {
	s.Os = v
	return s
}

// SetRamBytes sets the RamBytes field's value.
func (s *SourceProperties) SetRamBytes(v int64) *SourceProperties {
	s.RamBytes = &v
	return s
}

// SetRecommendedInstanceType sets the RecommendedInstanceType field's value.
func (s *SourceProperties) SetRecommendedInstanceType(v string) *SourceProperties {
	s.RecommendedInstanceType = &v
	return s
}

// SetSupportsNitroInstances sets the SupportsNitroInstances field's value.
func (s *SourceProperties) SetSupportsNitroInstances(v bool) *SourceProperties {
	s.SupportsNitroInstances = &v
	return s
}

type SourceServer struct {
	_ struct{} `type:"structure"`

	// The version of the DRS agent installed on the source server
	AgentVersion *string `locationName:"agentVersion" type:"string"`

	// The ARN of the Source Server.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The Data Replication Info of the Source Server.
	DataReplicationInfo *DataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// The status of the last recovery launch of this Source Server.
	LastLaunchResult *string `locationName:"lastLaunchResult" type:"string" enum:"LastLaunchResult"`

	// The lifecycle information of this Source Server.
	LifeCycle *LifeCycle `locationName:"lifeCycle" type:"structure"`

	// The ID of the Recovery Instance associated with this Source Server.
	RecoveryInstanceId *string `locationName:"recoveryInstanceId" min:"10" type:"string"`

	// Replication direction of the Source Server.
	ReplicationDirection *string `locationName:"replicationDirection" type:"string" enum:"ReplicationDirection"`

	// For EC2-originated Source Servers which have been failed over and then failed
	// back, this value will mean the ARN of the Source Server on the opposite replication
	// direction.
	ReversedDirectionSourceServerArn *string `locationName:"reversedDirectionSourceServerArn" min:"20" type:"string"`

	// Source cloud properties of the Source Server.
	SourceCloudProperties *SourceCloudProperties `locationName:"sourceCloudProperties" type:"structure"`

	// ID of the Source Network which is protecting this Source Server's network.
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string"`

	// The source properties of the Source Server.
	SourceProperties *SourceProperties `locationName:"sourceProperties" type:"structure"`

	// The ID of the Source Server.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// The staging area of the source server.
	StagingArea *StagingArea `locationName:"stagingArea" type:"structure"`

	// The tags associated with the Source Server.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SourceServer's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceServer) GoString() string {
	return s.String()
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *SourceServer) SetAgentVersion(v string) *SourceServer {
	s.AgentVersion = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *SourceServer) SetArn(v string) *SourceServer {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *SourceServer) SetDataReplicationInfo(v *DataReplicationInfo) *SourceServer {
	s.DataReplicationInfo = v
	return s
}

// SetLastLaunchResult sets the LastLaunchResult field's value.
func (s *SourceServer) SetLastLaunchResult(v string) *SourceServer {
	s.LastLaunchResult = &v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *SourceServer) SetLifeCycle(v *LifeCycle) *SourceServer {
	s.LifeCycle = v
	return s
}

// SetRecoveryInstanceId sets the RecoveryInstanceId field's value.
func (s *SourceServer) SetRecoveryInstanceId(v string) *SourceServer {
	s.RecoveryInstanceId = &v
	return s
}

// SetReplicationDirection sets the ReplicationDirection field's value.
func (s *SourceServer) SetReplicationDirection(v string) *SourceServer {
	s.ReplicationDirection = &v
	return s
}

// SetReversedDirectionSourceServerArn sets the ReversedDirectionSourceServerArn field's value.
func (s *SourceServer) SetReversedDirectionSourceServerArn(v string) *SourceServer {
	s.ReversedDirectionSourceServerArn = &v
	return s
}

// SetSourceCloudProperties sets the SourceCloudProperties field's value.
func (s *SourceServer) SetSourceCloudProperties(v *SourceCloudProperties) *SourceServer {
	s.SourceCloudProperties = v
	return s
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *SourceServer) SetSourceNetworkID(v string) *SourceServer {
	s.SourceNetworkID = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *SourceServer) SetSourceProperties(v *SourceProperties) *SourceServer {
	s.SourceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *SourceServer) SetSourceServerID(v string) *SourceServer {
	s.SourceServerID = &v
	return s
}

// SetStagingArea sets the StagingArea field's value.
func (s *SourceServer) SetStagingArea(v *StagingArea) *SourceServer {
	s.StagingArea = v
	return s
}

// SetTags sets the Tags field's value.
func (s *SourceServer) SetTags(v map[string]*string) *SourceServer {
	s.Tags = v
	return s
}

// Staging information related to source server.
type StagingArea struct {
	_ struct{} `type:"structure"`

	// Shows an error message that occurred when DRS tried to access the staging
	// source server. In this case StagingArea$status will have value EXTENSION_ERROR
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Account ID of the account to which source server belongs. If this source
	// server is extended - shows Account ID of staging source server.
	StagingAccountID *string `locationName:"stagingAccountID" min:"12" type:"string"`

	// Arn of the staging source server if this source server is extended
	StagingSourceServerArn *string `locationName:"stagingSourceServerArn" min:"20" type:"string"`

	// Status of Source server extension. Possible values: (a) NOT_EXTENDED - This
	// is a source server that is replicating in the current account. (b) EXTENDED
	// - Source server is extended from a staging source server. In this case, the
	// value of stagingSourceServerArn is pointing to the Arn of the source server
	// in the staging account. (c) EXTENSION_ERROR - Some issue occurred when accessing
	// staging source server. In this case, errorMessage field will contain an error
	// message that explains what happened.
	Status *string `locationName:"status" type:"string" enum:"ExtensionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StagingArea) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StagingArea) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *StagingArea) SetErrorMessage(v string) *StagingArea {
	s.ErrorMessage = &v
	return s
}

// SetStagingAccountID sets the StagingAccountID field's value.
func (s *StagingArea) SetStagingAccountID(v string) *StagingArea {
	s.StagingAccountID = &v
	return s
}

// SetStagingSourceServerArn sets the StagingSourceServerArn field's value.
func (s *StagingArea) SetStagingSourceServerArn(v string) *StagingArea {
	s.StagingSourceServerArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StagingArea) SetStatus(v string) *StagingArea {
	s.Status = &v
	return s
}

// Source server in staging account that extended source server connected to.
type StagingSourceServer struct {
	_ struct{} `type:"structure"`

	// The ARN of the source server.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Hostname of staging source server.
	Hostname *string `locationName:"hostname" type:"string"`

	// A list of tags associated with the staging source server.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StagingSourceServer's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StagingSourceServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StagingSourceServer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StagingSourceServer) SetArn(v string) *StagingSourceServer {
	s.Arn = &v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *StagingSourceServer) SetHostname(v string) *StagingSourceServer {
	s.Hostname = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StagingSourceServer) SetTags(v map[string]*string) *StagingSourceServer {
	s.Tags = v
	return s
}

type StartFailbackLaunchInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the Recovery Instance whose failback launch we want to request.
	//
	// RecoveryInstanceIDs is a required field
	RecoveryInstanceIDs []*string `locationName:"recoveryInstanceIDs" min:"1" type:"list" required:"true"`

	// The tags to be associated with the failback launch Job.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartFailbackLaunchInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFailbackLaunchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFailbackLaunchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFailbackLaunchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFailbackLaunchInput"}
	if s.RecoveryInstanceIDs == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryInstanceIDs"))
	}
	if s.RecoveryInstanceIDs != nil && len(s.RecoveryInstanceIDs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryInstanceIDs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryInstanceIDs sets the RecoveryInstanceIDs field's value.
func (s *StartFailbackLaunchInput) SetRecoveryInstanceIDs(v []*string) *StartFailbackLaunchInput {
	s.RecoveryInstanceIDs = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartFailbackLaunchInput) SetTags(v map[string]*string) *StartFailbackLaunchInput {
	s.Tags = v
	return s
}

type StartFailbackLaunchOutput struct {
	_ struct{} `type:"structure"`

	// The failback launch Job.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFailbackLaunchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFailbackLaunchOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *StartFailbackLaunchOutput) SetJob(v *Job) *StartFailbackLaunchOutput {
	s.Job = v
	return s
}

type StartRecoveryInput struct {
	_ struct{} `type:"structure"`

	// Whether this Source Server Recovery operation is a drill or not.
	IsDrill *bool `locationName:"isDrill" type:"boolean"`

	// The Source Servers that we want to start a Recovery Job for.
	//
	// SourceServers is a required field
	SourceServers []*StartRecoveryRequestSourceServer `locationName:"sourceServers" min:"1" type:"list" required:"true"`

	// The tags to be associated with the Recovery Job.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartRecoveryInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecoveryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecoveryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartRecoveryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartRecoveryInput"}
	if s.SourceServers == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServers"))
	}
	if s.SourceServers != nil && len(s.SourceServers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServers", 1))
	}
	if s.SourceServers != nil {
		for i, v := range s.SourceServers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceServers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsDrill sets the IsDrill field's value.
func (s *StartRecoveryInput) SetIsDrill(v bool) *StartRecoveryInput {
	s.IsDrill = &v
	return s
}

// SetSourceServers sets the SourceServers field's value.
func (s *StartRecoveryInput) SetSourceServers(v []*StartRecoveryRequestSourceServer) *StartRecoveryInput {
	s.SourceServers = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartRecoveryInput) SetTags(v map[string]*string) *StartRecoveryInput {
	s.Tags = v
	return s
}

type StartRecoveryOutput struct {
	_ struct{} `type:"structure"`

	// The Recovery Job.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecoveryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecoveryOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *StartRecoveryOutput) SetJob(v *Job) *StartRecoveryOutput {
	s.Job = v
	return s
}

// An object representing the Source Server to recover.
type StartRecoveryRequestSourceServer struct {
	_ struct{} `type:"structure"`

	// The ID of a Recovery Snapshot we want to recover from. Omit this field to
	// launch from the latest data by taking an on-demand snapshot.
	RecoverySnapshotID *string `locationName:"recoverySnapshotID" min:"21" type:"string"`

	// The ID of the Source Server you want to recover.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecoveryRequestSourceServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecoveryRequestSourceServer) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartRecoveryRequestSourceServer) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartRecoveryRequestSourceServer"}
	if s.RecoverySnapshotID != nil && len(*s.RecoverySnapshotID) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("RecoverySnapshotID", 21))
	}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoverySnapshotID sets the RecoverySnapshotID field's value.
func (s *StartRecoveryRequestSourceServer) SetRecoverySnapshotID(v string) *StartRecoveryRequestSourceServer {
	s.RecoverySnapshotID = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *StartRecoveryRequestSourceServer) SetSourceServerID(v string) *StartRecoveryRequestSourceServer {
	s.SourceServerID = &v
	return s
}

type StartReplicationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Source Server to start replication for.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReplicationInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *StartReplicationInput) SetSourceServerID(v string) *StartReplicationInput {
	s.SourceServerID = &v
	return s
}

type StartReplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Source Server that this action was targeted on.
	SourceServer *SourceServer `locationName:"sourceServer" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplicationOutput) GoString() string {
	return s.String()
}

// SetSourceServer sets the SourceServer field's value.
func (s *StartReplicationOutput) SetSourceServer(v *SourceServer) *StartReplicationOutput {
	s.SourceServer = v
	return s
}

type StartSourceNetworkRecoveryInput struct {
	_ struct{} `type:"structure"`

	// Don't update existing CloudFormation Stack, recover the network using a new
	// stack.
	DeployAsNew *bool `locationName:"deployAsNew" type:"boolean"`

	// The Source Networks that we want to start a Recovery Job for.
	//
	// SourceNetworks is a required field
	SourceNetworks []*StartSourceNetworkRecoveryRequestNetworkEntry `locationName:"sourceNetworks" min:"1" type:"list" required:"true"`

	// The tags to be associated with the Source Network recovery Job.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartSourceNetworkRecoveryInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSourceNetworkRecoveryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSourceNetworkRecoveryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSourceNetworkRecoveryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSourceNetworkRecoveryInput"}
	if s.SourceNetworks == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceNetworks"))
	}
	if s.SourceNetworks != nil && len(s.SourceNetworks) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceNetworks", 1))
	}
	if s.SourceNetworks != nil {
		for i, v := range s.SourceNetworks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceNetworks", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeployAsNew sets the DeployAsNew field's value.
func (s *StartSourceNetworkRecoveryInput) SetDeployAsNew(v bool) *StartSourceNetworkRecoveryInput {
	s.DeployAsNew = &v
	return s
}

// SetSourceNetworks sets the SourceNetworks field's value.
func (s *StartSourceNetworkRecoveryInput) SetSourceNetworks(v []*StartSourceNetworkRecoveryRequestNetworkEntry) *StartSourceNetworkRecoveryInput {
	s.SourceNetworks = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartSourceNetworkRecoveryInput) SetTags(v map[string]*string) *StartSourceNetworkRecoveryInput {
	s.Tags = v
	return s
}

type StartSourceNetworkRecoveryOutput struct {
	_ struct{} `type:"structure"`

	// The Source Network recovery Job.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSourceNetworkRecoveryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSourceNetworkRecoveryOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *StartSourceNetworkRecoveryOutput) SetJob(v *Job) *StartSourceNetworkRecoveryOutput {
	s.Job = v
	return s
}

// An object representing the Source Network to recover.
type StartSourceNetworkRecoveryRequestNetworkEntry struct {
	_ struct{} `type:"structure"`

	// CloudFormation stack name to be used for recovering the network.
	//
	// CfnStackName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartSourceNetworkRecoveryRequestNetworkEntry's
	// String and GoString methods.
	CfnStackName *string `locationName:"cfnStackName" min:"1" type:"string" sensitive:"true"`

	// The ID of the Source Network you want to recover.
	//
	// SourceNetworkID is a required field
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSourceNetworkRecoveryRequestNetworkEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSourceNetworkRecoveryRequestNetworkEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSourceNetworkRecoveryRequestNetworkEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSourceNetworkRecoveryRequestNetworkEntry"}
	if s.CfnStackName != nil && len(*s.CfnStackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CfnStackName", 1))
	}
	if s.SourceNetworkID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceNetworkID"))
	}
	if s.SourceNetworkID != nil && len(*s.SourceNetworkID) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceNetworkID", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCfnStackName sets the CfnStackName field's value.
func (s *StartSourceNetworkRecoveryRequestNetworkEntry) SetCfnStackName(v string) *StartSourceNetworkRecoveryRequestNetworkEntry {
	s.CfnStackName = &v
	return s
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *StartSourceNetworkRecoveryRequestNetworkEntry) SetSourceNetworkID(v string) *StartSourceNetworkRecoveryRequestNetworkEntry {
	s.SourceNetworkID = &v
	return s
}

type StartSourceNetworkReplicationInput struct {
	_ struct{} `type:"structure"`

	// ID of the Source Network to replicate.
	//
	// SourceNetworkID is a required field
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSourceNetworkReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSourceNetworkReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSourceNetworkReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSourceNetworkReplicationInput"}
	if s.SourceNetworkID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceNetworkID"))
	}
	if s.SourceNetworkID != nil && len(*s.SourceNetworkID) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceNetworkID", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *StartSourceNetworkReplicationInput) SetSourceNetworkID(v string) *StartSourceNetworkReplicationInput {
	s.SourceNetworkID = &v
	return s
}

type StartSourceNetworkReplicationOutput struct {
	_ struct{} `type:"structure"`

	// Source Network which was requested for replication.
	SourceNetwork *SourceNetwork `locationName:"sourceNetwork" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSourceNetworkReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSourceNetworkReplicationOutput) GoString() string {
	return s.String()
}

// SetSourceNetwork sets the SourceNetwork field's value.
func (s *StartSourceNetworkReplicationOutput) SetSourceNetwork(v *SourceNetwork) *StartSourceNetworkReplicationOutput {
	s.SourceNetwork = v
	return s
}

type StopFailbackInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Recovery Instance we want to stop failback for.
	//
	// RecoveryInstanceID is a required field
	RecoveryInstanceID *string `locationName:"recoveryInstanceID" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopFailbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopFailbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopFailbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopFailbackInput"}
	if s.RecoveryInstanceID == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryInstanceID"))
	}
	if s.RecoveryInstanceID != nil && len(*s.RecoveryInstanceID) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryInstanceID", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryInstanceID sets the RecoveryInstanceID field's value.
func (s *StopFailbackInput) SetRecoveryInstanceID(v string) *StopFailbackInput {
	s.RecoveryInstanceID = &v
	return s
}

type StopFailbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopFailbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopFailbackOutput) GoString() string {
	return s.String()
}

type StopReplicationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Source Server to stop replication for.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopReplicationInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *StopReplicationInput) SetSourceServerID(v string) *StopReplicationInput {
	s.SourceServerID = &v
	return s
}

type StopReplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Source Server that this action was targeted on.
	SourceServer *SourceServer `locationName:"sourceServer" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopReplicationOutput) GoString() string {
	return s.String()
}

// SetSourceServer sets the SourceServer field's value.
func (s *StopReplicationOutput) SetSourceServer(v *SourceServer) *StopReplicationOutput {
	s.SourceServer = v
	return s
}

type StopSourceNetworkReplicationInput struct {
	_ struct{} `type:"structure"`

	// ID of the Source Network to stop replication.
	//
	// SourceNetworkID is a required field
	SourceNetworkID *string `locationName:"sourceNetworkID" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSourceNetworkReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSourceNetworkReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopSourceNetworkReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopSourceNetworkReplicationInput"}
	if s.SourceNetworkID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceNetworkID"))
	}
	if s.SourceNetworkID != nil && len(*s.SourceNetworkID) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceNetworkID", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceNetworkID sets the SourceNetworkID field's value.
func (s *StopSourceNetworkReplicationInput) SetSourceNetworkID(v string) *StopSourceNetworkReplicationInput {
	s.SourceNetworkID = &v
	return s
}

type StopSourceNetworkReplicationOutput struct {
	_ struct{} `type:"structure"`

	// Source Network which was requested to stop replication.
	SourceNetwork *SourceNetwork `locationName:"sourceNetwork" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSourceNetworkReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSourceNetworkReplicationOutput) GoString() string {
	return s.String()
}

// SetSourceNetwork sets the SourceNetwork field's value.
func (s *StopSourceNetworkReplicationOutput) SetSourceNetwork(v *SourceNetwork) *StopSourceNetworkReplicationOutput {
	s.SourceNetwork = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ARN of the resource for which tags are to be added or updated.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// Array of tags to be added or updated.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TagResourceInput's
	// String and GoString methods.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TerminateRecoveryInstancesInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the Recovery Instances that should be terminated.
	//
	// RecoveryInstanceIDs is a required field
	RecoveryInstanceIDs []*string `locationName:"recoveryInstanceIDs" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateRecoveryInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateRecoveryInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateRecoveryInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateRecoveryInstancesInput"}
	if s.RecoveryInstanceIDs == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryInstanceIDs"))
	}
	if s.RecoveryInstanceIDs != nil && len(s.RecoveryInstanceIDs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryInstanceIDs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryInstanceIDs sets the RecoveryInstanceIDs field's value.
func (s *TerminateRecoveryInstancesInput) SetRecoveryInstanceIDs(v []*string) *TerminateRecoveryInstancesInput {
	s.RecoveryInstanceIDs = v
	return s
}

type TerminateRecoveryInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The Job for terminating the Recovery Instances.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateRecoveryInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateRecoveryInstancesOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *TerminateRecoveryInstancesOutput) SetJob(v *Job) *TerminateRecoveryInstancesOutput {
	s.Job = v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Quota code.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The number of seconds after which the request should be safe to retry.
	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`

	// Service code.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The account performing the request has not been initialized.
type UninitializedAccountException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UninitializedAccountException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UninitializedAccountException) GoString() string {
	return s.String()
}

func newErrorUninitializedAccountException(v protocol.ResponseMetadata) error {
	return &UninitializedAccountException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UninitializedAccountException) Code() string {
	return "UninitializedAccountException"
}

// Message returns the exception's message.
func (s *UninitializedAccountException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UninitializedAccountException) OrigErr() error {
	return nil
}

func (s *UninitializedAccountException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UninitializedAccountException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UninitializedAccountException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ARN of the resource for which tags are to be removed.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// Array of tags to be removed.
	//
	// TagKeys is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UntagResourceInput's
	// String and GoString methods.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateFailbackReplicationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Configure bandwidth throttling for the outbound data transfer rate of the
	// Recovery Instance in Mbps.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// The name of the Failback Replication Configuration.
	Name *string `locationName:"name" type:"string"`

	// The ID of the Recovery Instance.
	//
	// RecoveryInstanceID is a required field
	RecoveryInstanceID *string `locationName:"recoveryInstanceID" min:"10" type:"string" required:"true"`

	// Whether to use Private IP for the failback replication of the Recovery Instance.
	UsePrivateIP *bool `locationName:"usePrivateIP" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFailbackReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFailbackReplicationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFailbackReplicationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFailbackReplicationConfigurationInput"}
	if s.RecoveryInstanceID == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryInstanceID"))
	}
	if s.RecoveryInstanceID != nil && len(*s.RecoveryInstanceID) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryInstanceID", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *UpdateFailbackReplicationConfigurationInput) SetBandwidthThrottling(v int64) *UpdateFailbackReplicationConfigurationInput {
	s.BandwidthThrottling = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFailbackReplicationConfigurationInput) SetName(v string) *UpdateFailbackReplicationConfigurationInput {
	s.Name = &v
	return s
}

// SetRecoveryInstanceID sets the RecoveryInstanceID field's value.
func (s *UpdateFailbackReplicationConfigurationInput) SetRecoveryInstanceID(v string) *UpdateFailbackReplicationConfigurationInput {
	s.RecoveryInstanceID = &v
	return s
}

// SetUsePrivateIP sets the UsePrivateIP field's value.
func (s *UpdateFailbackReplicationConfigurationInput) SetUsePrivateIP(v bool) *UpdateFailbackReplicationConfigurationInput {
	s.UsePrivateIP = &v
	return s
}

type UpdateFailbackReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFailbackReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFailbackReplicationConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Whether we should copy the Private IP of the Source Server to the Recovery
	// Instance.
	CopyPrivateIp *bool `locationName:"copyPrivateIp" type:"boolean"`

	// Whether we want to copy the tags of the Source Server to the EC2 machine
	// of the Recovery Instance.
	CopyTags *bool `locationName:"copyTags" type:"boolean"`

	// The state of the Recovery Instance in EC2 after the recovery operation.
	LaunchDisposition *string `locationName:"launchDisposition" type:"string" enum:"LaunchDisposition"`

	// Launch into existing instance properties.
	LaunchIntoInstanceProperties *LaunchIntoInstanceProperties `locationName:"launchIntoInstanceProperties" type:"structure"`

	// The licensing configuration to be used for this launch configuration.
	Licensing *Licensing `locationName:"licensing" type:"structure"`

	// The name of the launch configuration.
	Name *string `locationName:"name" type:"string"`

	// Whether we want to enable post-launch actions for the Source Server.
	PostLaunchEnabled *bool `locationName:"postLaunchEnabled" type:"boolean"`

	// The ID of the Source Server that we want to retrieve a Launch Configuration
	// for.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`

	// Whether Elastic Disaster Recovery should try to automatically choose the
	// instance type that best matches the OS, CPU, and RAM of your Source Server.
	TargetInstanceTypeRightSizingMethod *string `locationName:"targetInstanceTypeRightSizingMethod" type:"string" enum:"TargetInstanceTypeRightSizingMethod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLaunchConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLaunchConfigurationInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyPrivateIp sets the CopyPrivateIp field's value.
func (s *UpdateLaunchConfigurationInput) SetCopyPrivateIp(v bool) *UpdateLaunchConfigurationInput {
	s.CopyPrivateIp = &v
	return s
}

// SetCopyTags sets the CopyTags field's value.
func (s *UpdateLaunchConfigurationInput) SetCopyTags(v bool) *UpdateLaunchConfigurationInput {
	s.CopyTags = &v
	return s
}

// SetLaunchDisposition sets the LaunchDisposition field's value.
func (s *UpdateLaunchConfigurationInput) SetLaunchDisposition(v string) *UpdateLaunchConfigurationInput {
	s.LaunchDisposition = &v
	return s
}

// SetLaunchIntoInstanceProperties sets the LaunchIntoInstanceProperties field's value.
func (s *UpdateLaunchConfigurationInput) SetLaunchIntoInstanceProperties(v *LaunchIntoInstanceProperties) *UpdateLaunchConfigurationInput {
	s.LaunchIntoInstanceProperties = v
	return s
}

// SetLicensing sets the Licensing field's value.
func (s *UpdateLaunchConfigurationInput) SetLicensing(v *Licensing) *UpdateLaunchConfigurationInput {
	s.Licensing = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLaunchConfigurationInput) SetName(v string) *UpdateLaunchConfigurationInput {
	s.Name = &v
	return s
}

// SetPostLaunchEnabled sets the PostLaunchEnabled field's value.
func (s *UpdateLaunchConfigurationInput) SetPostLaunchEnabled(v bool) *UpdateLaunchConfigurationInput {
	s.PostLaunchEnabled = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *UpdateLaunchConfigurationInput) SetSourceServerID(v string) *UpdateLaunchConfigurationInput {
	s.SourceServerID = &v
	return s
}

// SetTargetInstanceTypeRightSizingMethod sets the TargetInstanceTypeRightSizingMethod field's value.
func (s *UpdateLaunchConfigurationInput) SetTargetInstanceTypeRightSizingMethod(v string) *UpdateLaunchConfigurationInput {
	s.TargetInstanceTypeRightSizingMethod = &v
	return s
}

type UpdateLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Whether we should copy the Private IP of the Source Server to the Recovery
	// Instance.
	CopyPrivateIp *bool `locationName:"copyPrivateIp" type:"boolean"`

	// Whether we want to copy the tags of the Source Server to the EC2 machine
	// of the Recovery Instance.
	CopyTags *bool `locationName:"copyTags" type:"boolean"`

	// The EC2 launch template ID of this launch configuration.
	Ec2LaunchTemplateID *string `locationName:"ec2LaunchTemplateID" type:"string"`

	// The state of the Recovery Instance in EC2 after the recovery operation.
	LaunchDisposition *string `locationName:"launchDisposition" type:"string" enum:"LaunchDisposition"`

	// Launch into existing instance properties.
	LaunchIntoInstanceProperties *LaunchIntoInstanceProperties `locationName:"launchIntoInstanceProperties" type:"structure"`

	// The licensing configuration to be used for this launch configuration.
	Licensing *Licensing `locationName:"licensing" type:"structure"`

	// The name of the launch configuration.
	Name *string `locationName:"name" type:"string"`

	// Whether we want to activate post-launch actions for the Source Server.
	PostLaunchEnabled *bool `locationName:"postLaunchEnabled" type:"boolean"`

	// The ID of the Source Server for this launch configuration.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Whether Elastic Disaster Recovery should try to automatically choose the
	// instance type that best matches the OS, CPU, and RAM of your Source Server.
	TargetInstanceTypeRightSizingMethod *string `locationName:"targetInstanceTypeRightSizingMethod" type:"string" enum:"TargetInstanceTypeRightSizingMethod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationOutput) GoString() string {
	return s.String()
}

// SetCopyPrivateIp sets the CopyPrivateIp field's value.
func (s *UpdateLaunchConfigurationOutput) SetCopyPrivateIp(v bool) *UpdateLaunchConfigurationOutput {
	s.CopyPrivateIp = &v
	return s
}

// SetCopyTags sets the CopyTags field's value.
func (s *UpdateLaunchConfigurationOutput) SetCopyTags(v bool) *UpdateLaunchConfigurationOutput {
	s.CopyTags = &v
	return s
}

// SetEc2LaunchTemplateID sets the Ec2LaunchTemplateID field's value.
func (s *UpdateLaunchConfigurationOutput) SetEc2LaunchTemplateID(v string) *UpdateLaunchConfigurationOutput {
	s.Ec2LaunchTemplateID = &v
	return s
}

// SetLaunchDisposition sets the LaunchDisposition field's value.
func (s *UpdateLaunchConfigurationOutput) SetLaunchDisposition(v string) *UpdateLaunchConfigurationOutput {
	s.LaunchDisposition = &v
	return s
}

// SetLaunchIntoInstanceProperties sets the LaunchIntoInstanceProperties field's value.
func (s *UpdateLaunchConfigurationOutput) SetLaunchIntoInstanceProperties(v *LaunchIntoInstanceProperties) *UpdateLaunchConfigurationOutput {
	s.LaunchIntoInstanceProperties = v
	return s
}

// SetLicensing sets the Licensing field's value.
func (s *UpdateLaunchConfigurationOutput) SetLicensing(v *Licensing) *UpdateLaunchConfigurationOutput {
	s.Licensing = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLaunchConfigurationOutput) SetName(v string) *UpdateLaunchConfigurationOutput {
	s.Name = &v
	return s
}

// SetPostLaunchEnabled sets the PostLaunchEnabled field's value.
func (s *UpdateLaunchConfigurationOutput) SetPostLaunchEnabled(v bool) *UpdateLaunchConfigurationOutput {
	s.PostLaunchEnabled = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *UpdateLaunchConfigurationOutput) SetSourceServerID(v string) *UpdateLaunchConfigurationOutput {
	s.SourceServerID = &v
	return s
}

// SetTargetInstanceTypeRightSizingMethod sets the TargetInstanceTypeRightSizingMethod field's value.
func (s *UpdateLaunchConfigurationOutput) SetTargetInstanceTypeRightSizingMethod(v string) *UpdateLaunchConfigurationOutput {
	s.TargetInstanceTypeRightSizingMethod = &v
	return s
}

type UpdateLaunchConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// Copy private IP.
	CopyPrivateIp *bool `locationName:"copyPrivateIp" type:"boolean"`

	// Copy tags.
	CopyTags *bool `locationName:"copyTags" type:"boolean"`

	// S3 bucket ARN to export Source Network templates.
	ExportBucketArn *string `locationName:"exportBucketArn" min:"20" type:"string"`

	// Launch Configuration Template ID.
	//
	// LaunchConfigurationTemplateID is a required field
	LaunchConfigurationTemplateID *string `locationName:"launchConfigurationTemplateID" min:"21" type:"string" required:"true"`

	// Launch disposition.
	LaunchDisposition *string `locationName:"launchDisposition" type:"string" enum:"LaunchDisposition"`

	// DRS will set the 'launch into instance ID' of any source server when performing
	// a drill, recovery or failback to the previous region or availability zone,
	// using the instance ID of the source instance.
	LaunchIntoSourceInstance *bool `locationName:"launchIntoSourceInstance" type:"boolean"`

	// Licensing.
	Licensing *Licensing `locationName:"licensing" type:"structure"`

	// Whether we want to activate post-launch actions.
	PostLaunchEnabled *bool `locationName:"postLaunchEnabled" type:"boolean"`

	// Target instance type right-sizing method.
	TargetInstanceTypeRightSizingMethod *string `locationName:"targetInstanceTypeRightSizingMethod" type:"string" enum:"TargetInstanceTypeRightSizingMethod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLaunchConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLaunchConfigurationTemplateInput"}
	if s.ExportBucketArn != nil && len(*s.ExportBucketArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExportBucketArn", 20))
	}
	if s.LaunchConfigurationTemplateID == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchConfigurationTemplateID"))
	}
	if s.LaunchConfigurationTemplateID != nil && len(*s.LaunchConfigurationTemplateID) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchConfigurationTemplateID", 21))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyPrivateIp sets the CopyPrivateIp field's value.
func (s *UpdateLaunchConfigurationTemplateInput) SetCopyPrivateIp(v bool) *UpdateLaunchConfigurationTemplateInput {
	s.CopyPrivateIp = &v
	return s
}

// SetCopyTags sets the CopyTags field's value.
func (s *UpdateLaunchConfigurationTemplateInput) SetCopyTags(v bool) *UpdateLaunchConfigurationTemplateInput {
	s.CopyTags = &v
	return s
}

// SetExportBucketArn sets the ExportBucketArn field's value.
func (s *UpdateLaunchConfigurationTemplateInput) SetExportBucketArn(v string) *UpdateLaunchConfigurationTemplateInput {
	s.ExportBucketArn = &v
	return s
}

// SetLaunchConfigurationTemplateID sets the LaunchConfigurationTemplateID field's value.
func (s *UpdateLaunchConfigurationTemplateInput) SetLaunchConfigurationTemplateID(v string) *UpdateLaunchConfigurationTemplateInput {
	s.LaunchConfigurationTemplateID = &v
	return s
}

// SetLaunchDisposition sets the LaunchDisposition field's value.
func (s *UpdateLaunchConfigurationTemplateInput) SetLaunchDisposition(v string) *UpdateLaunchConfigurationTemplateInput {
	s.LaunchDisposition = &v
	return s
}

// SetLaunchIntoSourceInstance sets the LaunchIntoSourceInstance field's value.
func (s *UpdateLaunchConfigurationTemplateInput) SetLaunchIntoSourceInstance(v bool) *UpdateLaunchConfigurationTemplateInput {
	s.LaunchIntoSourceInstance = &v
	return s
}

// SetLicensing sets the Licensing field's value.
func (s *UpdateLaunchConfigurationTemplateInput) SetLicensing(v *Licensing) *UpdateLaunchConfigurationTemplateInput {
	s.Licensing = v
	return s
}

// SetPostLaunchEnabled sets the PostLaunchEnabled field's value.
func (s *UpdateLaunchConfigurationTemplateInput) SetPostLaunchEnabled(v bool) *UpdateLaunchConfigurationTemplateInput {
	s.PostLaunchEnabled = &v
	return s
}

// SetTargetInstanceTypeRightSizingMethod sets the TargetInstanceTypeRightSizingMethod field's value.
func (s *UpdateLaunchConfigurationTemplateInput) SetTargetInstanceTypeRightSizingMethod(v string) *UpdateLaunchConfigurationTemplateInput {
	s.TargetInstanceTypeRightSizingMethod = &v
	return s
}

type UpdateLaunchConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Updated Launch Configuration Template.
	LaunchConfigurationTemplate *LaunchConfigurationTemplate `locationName:"launchConfigurationTemplate" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationTemplateOutput) GoString() string {
	return s.String()
}

// SetLaunchConfigurationTemplate sets the LaunchConfigurationTemplate field's value.
func (s *UpdateLaunchConfigurationTemplateOutput) SetLaunchConfigurationTemplate(v *LaunchConfigurationTemplate) *UpdateLaunchConfigurationTemplateOutput {
	s.LaunchConfigurationTemplate = v
	return s
}

type UpdateReplicationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Whether to associate the default Elastic Disaster Recovery Security group
	// with the Replication Configuration.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Whether to allow the AWS replication agent to automatically replicate newly
	// added disks.
	AutoReplicateNewDisks *bool `locationName:"autoReplicateNewDisks" type:"boolean"`

	// Configure bandwidth throttling for the outbound data transfer rate of the
	// Source Server in Mbps.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Whether to create a Public IP for the Recovery Instance by default.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// The data plane routing mechanism that will be used for replication.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// The Staging Disk EBS volume type to be used during replication.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// The type of EBS encryption to be used during replication.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// The ARN of the EBS encryption key to be used during replication.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// The name of the Replication Configuration.
	Name *string `locationName:"name" type:"string"`

	// The Point in time (PIT) policy to manage snapshots taken during replication.
	PitPolicy []*PITPolicyRule `locationName:"pitPolicy" min:"1" type:"list"`

	// The configuration of the disks of the Source Server to be replicated.
	ReplicatedDisks []*ReplicationConfigurationReplicatedDisk `locationName:"replicatedDisks" type:"list"`

	// The instance type to be used for the replication server.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// The security group IDs that will be used by the replication server.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// The ID of the Source Server for this Replication Configuration.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`

	// The subnet to be used by the replication staging area.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// A set of tags to be associated with all resources created in the replication
	// staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateReplicationConfigurationInput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// Whether to use a dedicated Replication Server in the replication staging
	// area.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReplicationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReplicationConfigurationInput"}
	if s.EbsEncryptionKeyArn != nil && len(*s.EbsEncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EbsEncryptionKeyArn", 20))
	}
	if s.PitPolicy != nil && len(s.PitPolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PitPolicy", 1))
	}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}
	if s.PitPolicy != nil {
		for i, v := range s.PitPolicy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PitPolicy", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *UpdateReplicationConfigurationInput) SetAssociateDefaultSecurityGroup(v bool) *UpdateReplicationConfigurationInput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetAutoReplicateNewDisks sets the AutoReplicateNewDisks field's value.
func (s *UpdateReplicationConfigurationInput) SetAutoReplicateNewDisks(v bool) *UpdateReplicationConfigurationInput {
	s.AutoReplicateNewDisks = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *UpdateReplicationConfigurationInput) SetBandwidthThrottling(v int64) *UpdateReplicationConfigurationInput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *UpdateReplicationConfigurationInput) SetCreatePublicIP(v bool) *UpdateReplicationConfigurationInput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *UpdateReplicationConfigurationInput) SetDataPlaneRouting(v string) *UpdateReplicationConfigurationInput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *UpdateReplicationConfigurationInput) SetDefaultLargeStagingDiskType(v string) *UpdateReplicationConfigurationInput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *UpdateReplicationConfigurationInput) SetEbsEncryption(v string) *UpdateReplicationConfigurationInput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *UpdateReplicationConfigurationInput) SetEbsEncryptionKeyArn(v string) *UpdateReplicationConfigurationInput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateReplicationConfigurationInput) SetName(v string) *UpdateReplicationConfigurationInput {
	s.Name = &v
	return s
}

// SetPitPolicy sets the PitPolicy field's value.
func (s *UpdateReplicationConfigurationInput) SetPitPolicy(v []*PITPolicyRule) *UpdateReplicationConfigurationInput {
	s.PitPolicy = v
	return s
}

// SetReplicatedDisks sets the ReplicatedDisks field's value.
func (s *UpdateReplicationConfigurationInput) SetReplicatedDisks(v []*ReplicationConfigurationReplicatedDisk) *UpdateReplicationConfigurationInput {
	s.ReplicatedDisks = v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *UpdateReplicationConfigurationInput) SetReplicationServerInstanceType(v string) *UpdateReplicationConfigurationInput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *UpdateReplicationConfigurationInput) SetReplicationServersSecurityGroupsIDs(v []*string) *UpdateReplicationConfigurationInput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *UpdateReplicationConfigurationInput) SetSourceServerID(v string) *UpdateReplicationConfigurationInput {
	s.SourceServerID = &v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *UpdateReplicationConfigurationInput) SetStagingAreaSubnetId(v string) *UpdateReplicationConfigurationInput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *UpdateReplicationConfigurationInput) SetStagingAreaTags(v map[string]*string) *UpdateReplicationConfigurationInput {
	s.StagingAreaTags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *UpdateReplicationConfigurationInput) SetUseDedicatedReplicationServer(v bool) *UpdateReplicationConfigurationInput {
	s.UseDedicatedReplicationServer = &v
	return s
}

type UpdateReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Whether to associate the default Elastic Disaster Recovery Security group
	// with the Replication Configuration.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Whether to allow the AWS replication agent to automatically replicate newly
	// added disks.
	AutoReplicateNewDisks *bool `locationName:"autoReplicateNewDisks" type:"boolean"`

	// Configure bandwidth throttling for the outbound data transfer rate of the
	// Source Server in Mbps.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Whether to create a Public IP for the Recovery Instance by default.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// The data plane routing mechanism that will be used for replication.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// The Staging Disk EBS volume type to be used during replication.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// The type of EBS encryption to be used during replication.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// The ARN of the EBS encryption key to be used during replication.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// The name of the Replication Configuration.
	Name *string `locationName:"name" type:"string"`

	// The Point in time (PIT) policy to manage snapshots taken during replication.
	PitPolicy []*PITPolicyRule `locationName:"pitPolicy" min:"1" type:"list"`

	// The configuration of the disks of the Source Server to be replicated.
	ReplicatedDisks []*ReplicationConfigurationReplicatedDisk `locationName:"replicatedDisks" type:"list"`

	// The instance type to be used for the replication server.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// The security group IDs that will be used by the replication server.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// The ID of the Source Server for this Replication Configuration.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// The subnet to be used by the replication staging area.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// A set of tags to be associated with all resources created in the replication
	// staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateReplicationConfigurationOutput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// Whether to use a dedicated Replication Server in the replication staging
	// area.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *UpdateReplicationConfigurationOutput) SetAssociateDefaultSecurityGroup(v bool) *UpdateReplicationConfigurationOutput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetAutoReplicateNewDisks sets the AutoReplicateNewDisks field's value.
func (s *UpdateReplicationConfigurationOutput) SetAutoReplicateNewDisks(v bool) *UpdateReplicationConfigurationOutput {
	s.AutoReplicateNewDisks = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *UpdateReplicationConfigurationOutput) SetBandwidthThrottling(v int64) *UpdateReplicationConfigurationOutput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *UpdateReplicationConfigurationOutput) SetCreatePublicIP(v bool) *UpdateReplicationConfigurationOutput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *UpdateReplicationConfigurationOutput) SetDataPlaneRouting(v string) *UpdateReplicationConfigurationOutput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *UpdateReplicationConfigurationOutput) SetDefaultLargeStagingDiskType(v string) *UpdateReplicationConfigurationOutput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *UpdateReplicationConfigurationOutput) SetEbsEncryption(v string) *UpdateReplicationConfigurationOutput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *UpdateReplicationConfigurationOutput) SetEbsEncryptionKeyArn(v string) *UpdateReplicationConfigurationOutput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateReplicationConfigurationOutput) SetName(v string) *UpdateReplicationConfigurationOutput {
	s.Name = &v
	return s
}

// SetPitPolicy sets the PitPolicy field's value.
func (s *UpdateReplicationConfigurationOutput) SetPitPolicy(v []*PITPolicyRule) *UpdateReplicationConfigurationOutput {
	s.PitPolicy = v
	return s
}

// SetReplicatedDisks sets the ReplicatedDisks field's value.
func (s *UpdateReplicationConfigurationOutput) SetReplicatedDisks(v []*ReplicationConfigurationReplicatedDisk) *UpdateReplicationConfigurationOutput {
	s.ReplicatedDisks = v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *UpdateReplicationConfigurationOutput) SetReplicationServerInstanceType(v string) *UpdateReplicationConfigurationOutput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *UpdateReplicationConfigurationOutput) SetReplicationServersSecurityGroupsIDs(v []*string) *UpdateReplicationConfigurationOutput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *UpdateReplicationConfigurationOutput) SetSourceServerID(v string) *UpdateReplicationConfigurationOutput {
	s.SourceServerID = &v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *UpdateReplicationConfigurationOutput) SetStagingAreaSubnetId(v string) *UpdateReplicationConfigurationOutput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *UpdateReplicationConfigurationOutput) SetStagingAreaTags(v map[string]*string) *UpdateReplicationConfigurationOutput {
	s.StagingAreaTags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *UpdateReplicationConfigurationOutput) SetUseDedicatedReplicationServer(v bool) *UpdateReplicationConfigurationOutput {
	s.UseDedicatedReplicationServer = &v
	return s
}

type UpdateReplicationConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// The Replication Configuration Template ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Whether to associate the default Elastic Disaster Recovery Security group
	// with the Replication Configuration Template.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Whether to allow the AWS replication agent to automatically replicate newly
	// added disks.
	AutoReplicateNewDisks *bool `locationName:"autoReplicateNewDisks" type:"boolean"`

	// Configure bandwidth throttling for the outbound data transfer rate of the
	// Source Server in Mbps.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Whether to create a Public IP for the Recovery Instance by default.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// The data plane routing mechanism that will be used for replication.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// The Staging Disk EBS volume type to be used during replication.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// The type of EBS encryption to be used during replication.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// The ARN of the EBS encryption key to be used during replication.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// The Point in time (PIT) policy to manage snapshots taken during replication.
	PitPolicy []*PITPolicyRule `locationName:"pitPolicy" min:"1" type:"list"`

	// The Replication Configuration Template ID.
	//
	// ReplicationConfigurationTemplateID is a required field
	ReplicationConfigurationTemplateID *string `locationName:"replicationConfigurationTemplateID" min:"21" type:"string" required:"true"`

	// The instance type to be used for the replication server.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// The security group IDs that will be used by the replication server.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// The subnet to be used by the replication staging area.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// A set of tags to be associated with all resources created in the replication
	// staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateReplicationConfigurationTemplateInput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// Whether to use a dedicated Replication Server in the replication staging
	// area.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReplicationConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReplicationConfigurationTemplateInput"}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.EbsEncryptionKeyArn != nil && len(*s.EbsEncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EbsEncryptionKeyArn", 20))
	}
	if s.PitPolicy != nil && len(s.PitPolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PitPolicy", 1))
	}
	if s.ReplicationConfigurationTemplateID == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationConfigurationTemplateID"))
	}
	if s.ReplicationConfigurationTemplateID != nil && len(*s.ReplicationConfigurationTemplateID) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicationConfigurationTemplateID", 21))
	}
	if s.PitPolicy != nil {
		for i, v := range s.PitPolicy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PitPolicy", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetArn(v string) *UpdateReplicationConfigurationTemplateInput {
	s.Arn = &v
	return s
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetAssociateDefaultSecurityGroup(v bool) *UpdateReplicationConfigurationTemplateInput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetAutoReplicateNewDisks sets the AutoReplicateNewDisks field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetAutoReplicateNewDisks(v bool) *UpdateReplicationConfigurationTemplateInput {
	s.AutoReplicateNewDisks = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetBandwidthThrottling(v int64) *UpdateReplicationConfigurationTemplateInput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetCreatePublicIP(v bool) *UpdateReplicationConfigurationTemplateInput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetDataPlaneRouting(v string) *UpdateReplicationConfigurationTemplateInput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetDefaultLargeStagingDiskType(v string) *UpdateReplicationConfigurationTemplateInput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetEbsEncryption(v string) *UpdateReplicationConfigurationTemplateInput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetEbsEncryptionKeyArn(v string) *UpdateReplicationConfigurationTemplateInput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetPitPolicy sets the PitPolicy field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetPitPolicy(v []*PITPolicyRule) *UpdateReplicationConfigurationTemplateInput {
	s.PitPolicy = v
	return s
}

// SetReplicationConfigurationTemplateID sets the ReplicationConfigurationTemplateID field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetReplicationConfigurationTemplateID(v string) *UpdateReplicationConfigurationTemplateInput {
	s.ReplicationConfigurationTemplateID = &v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetReplicationServerInstanceType(v string) *UpdateReplicationConfigurationTemplateInput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetReplicationServersSecurityGroupsIDs(v []*string) *UpdateReplicationConfigurationTemplateInput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetStagingAreaSubnetId(v string) *UpdateReplicationConfigurationTemplateInput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetStagingAreaTags(v map[string]*string) *UpdateReplicationConfigurationTemplateInput {
	s.StagingAreaTags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetUseDedicatedReplicationServer(v bool) *UpdateReplicationConfigurationTemplateInput {
	s.UseDedicatedReplicationServer = &v
	return s
}

type UpdateReplicationConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Replication Configuration Template ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Whether to associate the default Elastic Disaster Recovery Security group
	// with the Replication Configuration Template.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Whether to allow the AWS replication agent to automatically replicate newly
	// added disks.
	AutoReplicateNewDisks *bool `locationName:"autoReplicateNewDisks" type:"boolean"`

	// Configure bandwidth throttling for the outbound data transfer rate of the
	// Source Server in Mbps.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Whether to create a Public IP for the Recovery Instance by default.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// The data plane routing mechanism that will be used for replication.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// The Staging Disk EBS volume type to be used during replication.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// The type of EBS encryption to be used during replication.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// The ARN of the EBS encryption key to be used during replication.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// The Point in time (PIT) policy to manage snapshots taken during replication.
	PitPolicy []*PITPolicyRule `locationName:"pitPolicy" min:"1" type:"list"`

	// The Replication Configuration Template ID.
	//
	// ReplicationConfigurationTemplateID is a required field
	ReplicationConfigurationTemplateID *string `locationName:"replicationConfigurationTemplateID" min:"21" type:"string" required:"true"`

	// The instance type to be used for the replication server.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// The security group IDs that will be used by the replication server.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// The subnet to be used by the replication staging area.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// A set of tags to be associated with all resources created in the replication
	// staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateReplicationConfigurationTemplateOutput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// A set of tags to be associated with the Replication Configuration Template
	// resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateReplicationConfigurationTemplateOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Whether to use a dedicated Replication Server in the replication staging
	// area.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetArn(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.Arn = &v
	return s
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetAssociateDefaultSecurityGroup(v bool) *UpdateReplicationConfigurationTemplateOutput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetAutoReplicateNewDisks sets the AutoReplicateNewDisks field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetAutoReplicateNewDisks(v bool) *UpdateReplicationConfigurationTemplateOutput {
	s.AutoReplicateNewDisks = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetBandwidthThrottling(v int64) *UpdateReplicationConfigurationTemplateOutput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetCreatePublicIP(v bool) *UpdateReplicationConfigurationTemplateOutput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetDataPlaneRouting(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetDefaultLargeStagingDiskType(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetEbsEncryption(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetEbsEncryptionKeyArn(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetPitPolicy sets the PitPolicy field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetPitPolicy(v []*PITPolicyRule) *UpdateReplicationConfigurationTemplateOutput {
	s.PitPolicy = v
	return s
}

// SetReplicationConfigurationTemplateID sets the ReplicationConfigurationTemplateID field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetReplicationConfigurationTemplateID(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.ReplicationConfigurationTemplateID = &v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetReplicationServerInstanceType(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetReplicationServersSecurityGroupsIDs(v []*string) *UpdateReplicationConfigurationTemplateOutput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetStagingAreaSubnetId(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetStagingAreaTags(v map[string]*string) *UpdateReplicationConfigurationTemplateOutput {
	s.StagingAreaTags = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetTags(v map[string]*string) *UpdateReplicationConfigurationTemplateOutput {
	s.Tags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetUseDedicatedReplicationServer(v bool) *UpdateReplicationConfigurationTemplateOutput {
	s.UseDedicatedReplicationServer = &v
	return s
}

// The input fails to satisfy the constraints specified by the AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	// A list of fields that failed validation.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// Validation exception reason.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Validate exception field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Validate exception field message.
	Message *string `locationName:"message" type:"string"`

	// Validate exception field name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// DataReplicationErrorStringAgentNotSeen is a DataReplicationErrorString enum value
	DataReplicationErrorStringAgentNotSeen = "AGENT_NOT_SEEN"

	// DataReplicationErrorStringSnapshotsFailure is a DataReplicationErrorString enum value
	DataReplicationErrorStringSnapshotsFailure = "SNAPSHOTS_FAILURE"

	// DataReplicationErrorStringNotConverging is a DataReplicationErrorString enum value
	DataReplicationErrorStringNotConverging = "NOT_CONVERGING"

	// DataReplicationErrorStringUnstableNetwork is a DataReplicationErrorString enum value
	DataReplicationErrorStringUnstableNetwork = "UNSTABLE_NETWORK"

	// DataReplicationErrorStringFailedToCreateSecurityGroup is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToCreateSecurityGroup = "FAILED_TO_CREATE_SECURITY_GROUP"

	// DataReplicationErrorStringFailedToLaunchReplicationServer is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToLaunchReplicationServer = "FAILED_TO_LAUNCH_REPLICATION_SERVER"

	// DataReplicationErrorStringFailedToBootReplicationServer is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToBootReplicationServer = "FAILED_TO_BOOT_REPLICATION_SERVER"

	// DataReplicationErrorStringFailedToAuthenticateWithService is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToAuthenticateWithService = "FAILED_TO_AUTHENTICATE_WITH_SERVICE"

	// DataReplicationErrorStringFailedToDownloadReplicationSoftware is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToDownloadReplicationSoftware = "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE"

	// DataReplicationErrorStringFailedToCreateStagingDisks is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToCreateStagingDisks = "FAILED_TO_CREATE_STAGING_DISKS"

	// DataReplicationErrorStringFailedToAttachStagingDisks is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToAttachStagingDisks = "FAILED_TO_ATTACH_STAGING_DISKS"

	// DataReplicationErrorStringFailedToPairReplicationServerWithAgent is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToPairReplicationServerWithAgent = "FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT"

	// DataReplicationErrorStringFailedToConnectAgentToReplicationServer is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToConnectAgentToReplicationServer = "FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER"

	// DataReplicationErrorStringFailedToStartDataTransfer is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToStartDataTransfer = "FAILED_TO_START_DATA_TRANSFER"
)

// DataReplicationErrorString_Values returns all elements of the DataReplicationErrorString enum
func DataReplicationErrorString_Values() []string {
	return []string{
		DataReplicationErrorStringAgentNotSeen,
		DataReplicationErrorStringSnapshotsFailure,
		DataReplicationErrorStringNotConverging,
		DataReplicationErrorStringUnstableNetwork,
		DataReplicationErrorStringFailedToCreateSecurityGroup,
		DataReplicationErrorStringFailedToLaunchReplicationServer,
		DataReplicationErrorStringFailedToBootReplicationServer,
		DataReplicationErrorStringFailedToAuthenticateWithService,
		DataReplicationErrorStringFailedToDownloadReplicationSoftware,
		DataReplicationErrorStringFailedToCreateStagingDisks,
		DataReplicationErrorStringFailedToAttachStagingDisks,
		DataReplicationErrorStringFailedToPairReplicationServerWithAgent,
		DataReplicationErrorStringFailedToConnectAgentToReplicationServer,
		DataReplicationErrorStringFailedToStartDataTransfer,
	}
}

const (
	// DataReplicationInitiationStepNameWait is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameWait = "WAIT"

	// DataReplicationInitiationStepNameCreateSecurityGroup is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameCreateSecurityGroup = "CREATE_SECURITY_GROUP"

	// DataReplicationInitiationStepNameLaunchReplicationServer is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameLaunchReplicationServer = "LAUNCH_REPLICATION_SERVER"

	// DataReplicationInitiationStepNameBootReplicationServer is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameBootReplicationServer = "BOOT_REPLICATION_SERVER"

	// DataReplicationInitiationStepNameAuthenticateWithService is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameAuthenticateWithService = "AUTHENTICATE_WITH_SERVICE"

	// DataReplicationInitiationStepNameDownloadReplicationSoftware is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameDownloadReplicationSoftware = "DOWNLOAD_REPLICATION_SOFTWARE"

	// DataReplicationInitiationStepNameCreateStagingDisks is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameCreateStagingDisks = "CREATE_STAGING_DISKS"

	// DataReplicationInitiationStepNameAttachStagingDisks is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameAttachStagingDisks = "ATTACH_STAGING_DISKS"

	// DataReplicationInitiationStepNamePairReplicationServerWithAgent is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNamePairReplicationServerWithAgent = "PAIR_REPLICATION_SERVER_WITH_AGENT"

	// DataReplicationInitiationStepNameConnectAgentToReplicationServer is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameConnectAgentToReplicationServer = "CONNECT_AGENT_TO_REPLICATION_SERVER"

	// DataReplicationInitiationStepNameStartDataTransfer is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameStartDataTransfer = "START_DATA_TRANSFER"
)

// DataReplicationInitiationStepName_Values returns all elements of the DataReplicationInitiationStepName enum
func DataReplicationInitiationStepName_Values() []string {
	return []string{
		DataReplicationInitiationStepNameWait,
		DataReplicationInitiationStepNameCreateSecurityGroup,
		DataReplicationInitiationStepNameLaunchReplicationServer,
		DataReplicationInitiationStepNameBootReplicationServer,
		DataReplicationInitiationStepNameAuthenticateWithService,
		DataReplicationInitiationStepNameDownloadReplicationSoftware,
		DataReplicationInitiationStepNameCreateStagingDisks,
		DataReplicationInitiationStepNameAttachStagingDisks,
		DataReplicationInitiationStepNamePairReplicationServerWithAgent,
		DataReplicationInitiationStepNameConnectAgentToReplicationServer,
		DataReplicationInitiationStepNameStartDataTransfer,
	}
}

const (
	// DataReplicationInitiationStepStatusNotStarted is a DataReplicationInitiationStepStatus enum value
	DataReplicationInitiationStepStatusNotStarted = "NOT_STARTED"

	// DataReplicationInitiationStepStatusInProgress is a DataReplicationInitiationStepStatus enum value
	DataReplicationInitiationStepStatusInProgress = "IN_PROGRESS"

	// DataReplicationInitiationStepStatusSucceeded is a DataReplicationInitiationStepStatus enum value
	DataReplicationInitiationStepStatusSucceeded = "SUCCEEDED"

	// DataReplicationInitiationStepStatusFailed is a DataReplicationInitiationStepStatus enum value
	DataReplicationInitiationStepStatusFailed = "FAILED"

	// DataReplicationInitiationStepStatusSkipped is a DataReplicationInitiationStepStatus enum value
	DataReplicationInitiationStepStatusSkipped = "SKIPPED"
)

// DataReplicationInitiationStepStatus_Values returns all elements of the DataReplicationInitiationStepStatus enum
func DataReplicationInitiationStepStatus_Values() []string {
	return []string{
		DataReplicationInitiationStepStatusNotStarted,
		DataReplicationInitiationStepStatusInProgress,
		DataReplicationInitiationStepStatusSucceeded,
		DataReplicationInitiationStepStatusFailed,
		DataReplicationInitiationStepStatusSkipped,
	}
}

const (
	// DataReplicationStateStopped is a DataReplicationState enum value
	DataReplicationStateStopped = "STOPPED"

	// DataReplicationStateInitiating is a DataReplicationState enum value
	DataReplicationStateInitiating = "INITIATING"

	// DataReplicationStateInitialSync is a DataReplicationState enum value
	DataReplicationStateInitialSync = "INITIAL_SYNC"

	// DataReplicationStateBacklog is a DataReplicationState enum value
	DataReplicationStateBacklog = "BACKLOG"

	// DataReplicationStateCreatingSnapshot is a DataReplicationState enum value
	DataReplicationStateCreatingSnapshot = "CREATING_SNAPSHOT"

	// DataReplicationStateContinuous is a DataReplicationState enum value
	DataReplicationStateContinuous = "CONTINUOUS"

	// DataReplicationStatePaused is a DataReplicationState enum value
	DataReplicationStatePaused = "PAUSED"

	// DataReplicationStateRescan is a DataReplicationState enum value
	DataReplicationStateRescan = "RESCAN"

	// DataReplicationStateStalled is a DataReplicationState enum value
	DataReplicationStateStalled = "STALLED"

	// DataReplicationStateDisconnected is a DataReplicationState enum value
	DataReplicationStateDisconnected = "DISCONNECTED"
)

// DataReplicationState_Values returns all elements of the DataReplicationState enum
func DataReplicationState_Values() []string {
	return []string{
		DataReplicationStateStopped,
		DataReplicationStateInitiating,
		DataReplicationStateInitialSync,
		DataReplicationStateBacklog,
		DataReplicationStateCreatingSnapshot,
		DataReplicationStateContinuous,
		DataReplicationStatePaused,
		DataReplicationStateRescan,
		DataReplicationStateStalled,
		DataReplicationStateDisconnected,
	}
}

const (
	// EC2InstanceStatePending is a EC2InstanceState enum value
	EC2InstanceStatePending = "PENDING"

	// EC2InstanceStateRunning is a EC2InstanceState enum value
	EC2InstanceStateRunning = "RUNNING"

	// EC2InstanceStateStopping is a EC2InstanceState enum value
	EC2InstanceStateStopping = "STOPPING"

	// EC2InstanceStateStopped is a EC2InstanceState enum value
	EC2InstanceStateStopped = "STOPPED"

	// EC2InstanceStateShuttingDown is a EC2InstanceState enum value
	EC2InstanceStateShuttingDown = "SHUTTING-DOWN"

	// EC2InstanceStateTerminated is a EC2InstanceState enum value
	EC2InstanceStateTerminated = "TERMINATED"

	// EC2InstanceStateNotFound is a EC2InstanceState enum value
	EC2InstanceStateNotFound = "NOT_FOUND"
)

// EC2InstanceState_Values returns all elements of the EC2InstanceState enum
func EC2InstanceState_Values() []string {
	return []string{
		EC2InstanceStatePending,
		EC2InstanceStateRunning,
		EC2InstanceStateStopping,
		EC2InstanceStateStopped,
		EC2InstanceStateShuttingDown,
		EC2InstanceStateTerminated,
		EC2InstanceStateNotFound,
	}
}

const (
	// ExtensionStatusExtended is a ExtensionStatus enum value
	ExtensionStatusExtended = "EXTENDED"

	// ExtensionStatusExtensionError is a ExtensionStatus enum value
	ExtensionStatusExtensionError = "EXTENSION_ERROR"

	// ExtensionStatusNotExtended is a ExtensionStatus enum value
	ExtensionStatusNotExtended = "NOT_EXTENDED"
)

// ExtensionStatus_Values returns all elements of the ExtensionStatus enum
func ExtensionStatus_Values() []string {
	return []string{
		ExtensionStatusExtended,
		ExtensionStatusExtensionError,
		ExtensionStatusNotExtended,
	}
}

const (
	// FailbackLaunchTypeRecovery is a FailbackLaunchType enum value
	FailbackLaunchTypeRecovery = "RECOVERY"

	// FailbackLaunchTypeDrill is a FailbackLaunchType enum value
	FailbackLaunchTypeDrill = "DRILL"
)

// FailbackLaunchType_Values returns all elements of the FailbackLaunchType enum
func FailbackLaunchType_Values() []string {
	return []string{
		FailbackLaunchTypeRecovery,
		FailbackLaunchTypeDrill,
	}
}

const (
	// FailbackReplicationErrorAgentNotSeen is a FailbackReplicationError enum value
	FailbackReplicationErrorAgentNotSeen = "AGENT_NOT_SEEN"

	// FailbackReplicationErrorFailbackClientNotSeen is a FailbackReplicationError enum value
	FailbackReplicationErrorFailbackClientNotSeen = "FAILBACK_CLIENT_NOT_SEEN"

	// FailbackReplicationErrorNotConverging is a FailbackReplicationError enum value
	FailbackReplicationErrorNotConverging = "NOT_CONVERGING"

	// FailbackReplicationErrorUnstableNetwork is a FailbackReplicationError enum value
	FailbackReplicationErrorUnstableNetwork = "UNSTABLE_NETWORK"

	// FailbackReplicationErrorFailedToEstablishRecoveryInstanceCommunication is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToEstablishRecoveryInstanceCommunication = "FAILED_TO_ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION"

	// FailbackReplicationErrorFailedToDownloadReplicationSoftwareToFailbackClient is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToDownloadReplicationSoftwareToFailbackClient = "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT"

	// FailbackReplicationErrorFailedToConfigureReplicationSoftware is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToConfigureReplicationSoftware = "FAILED_TO_CONFIGURE_REPLICATION_SOFTWARE"

	// FailbackReplicationErrorFailedToPairAgentWithReplicationSoftware is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToPairAgentWithReplicationSoftware = "FAILED_TO_PAIR_AGENT_WITH_REPLICATION_SOFTWARE"

	// FailbackReplicationErrorFailedToEstablishAgentReplicatorSoftwareCommunication is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToEstablishAgentReplicatorSoftwareCommunication = "FAILED_TO_ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION"

	// FailbackReplicationErrorFailedGettingReplicationState is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedGettingReplicationState = "FAILED_GETTING_REPLICATION_STATE"

	// FailbackReplicationErrorSnapshotsFailure is a FailbackReplicationError enum value
	FailbackReplicationErrorSnapshotsFailure = "SNAPSHOTS_FAILURE"

	// FailbackReplicationErrorFailedToCreateSecurityGroup is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToCreateSecurityGroup = "FAILED_TO_CREATE_SECURITY_GROUP"

	// FailbackReplicationErrorFailedToLaunchReplicationServer is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToLaunchReplicationServer = "FAILED_TO_LAUNCH_REPLICATION_SERVER"

	// FailbackReplicationErrorFailedToBootReplicationServer is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToBootReplicationServer = "FAILED_TO_BOOT_REPLICATION_SERVER"

	// FailbackReplicationErrorFailedToAuthenticateWithService is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToAuthenticateWithService = "FAILED_TO_AUTHENTICATE_WITH_SERVICE"

	// FailbackReplicationErrorFailedToDownloadReplicationSoftware is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToDownloadReplicationSoftware = "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE"

	// FailbackReplicationErrorFailedToCreateStagingDisks is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToCreateStagingDisks = "FAILED_TO_CREATE_STAGING_DISKS"

	// FailbackReplicationErrorFailedToAttachStagingDisks is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToAttachStagingDisks = "FAILED_TO_ATTACH_STAGING_DISKS"

	// FailbackReplicationErrorFailedToPairReplicationServerWithAgent is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToPairReplicationServerWithAgent = "FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT"

	// FailbackReplicationErrorFailedToConnectAgentToReplicationServer is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToConnectAgentToReplicationServer = "FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER"

	// FailbackReplicationErrorFailedToStartDataTransfer is a FailbackReplicationError enum value
	FailbackReplicationErrorFailedToStartDataTransfer = "FAILED_TO_START_DATA_TRANSFER"
)

// FailbackReplicationError_Values returns all elements of the FailbackReplicationError enum
func FailbackReplicationError_Values() []string {
	return []string{
		FailbackReplicationErrorAgentNotSeen,
		FailbackReplicationErrorFailbackClientNotSeen,
		FailbackReplicationErrorNotConverging,
		FailbackReplicationErrorUnstableNetwork,
		FailbackReplicationErrorFailedToEstablishRecoveryInstanceCommunication,
		FailbackReplicationErrorFailedToDownloadReplicationSoftwareToFailbackClient,
		FailbackReplicationErrorFailedToConfigureReplicationSoftware,
		FailbackReplicationErrorFailedToPairAgentWithReplicationSoftware,
		FailbackReplicationErrorFailedToEstablishAgentReplicatorSoftwareCommunication,
		FailbackReplicationErrorFailedGettingReplicationState,
		FailbackReplicationErrorSnapshotsFailure,
		FailbackReplicationErrorFailedToCreateSecurityGroup,
		FailbackReplicationErrorFailedToLaunchReplicationServer,
		FailbackReplicationErrorFailedToBootReplicationServer,
		FailbackReplicationErrorFailedToAuthenticateWithService,
		FailbackReplicationErrorFailedToDownloadReplicationSoftware,
		FailbackReplicationErrorFailedToCreateStagingDisks,
		FailbackReplicationErrorFailedToAttachStagingDisks,
		FailbackReplicationErrorFailedToPairReplicationServerWithAgent,
		FailbackReplicationErrorFailedToConnectAgentToReplicationServer,
		FailbackReplicationErrorFailedToStartDataTransfer,
	}
}

const (
	// FailbackStateFailbackNotStarted is a FailbackState enum value
	FailbackStateFailbackNotStarted = "FAILBACK_NOT_STARTED"

	// FailbackStateFailbackInProgress is a FailbackState enum value
	FailbackStateFailbackInProgress = "FAILBACK_IN_PROGRESS"

	// FailbackStateFailbackReadyForLaunch is a FailbackState enum value
	FailbackStateFailbackReadyForLaunch = "FAILBACK_READY_FOR_LAUNCH"

	// FailbackStateFailbackCompleted is a FailbackState enum value
	FailbackStateFailbackCompleted = "FAILBACK_COMPLETED"

	// FailbackStateFailbackError is a FailbackState enum value
	FailbackStateFailbackError = "FAILBACK_ERROR"

	// FailbackStateFailbackNotReadyForLaunch is a FailbackState enum value
	FailbackStateFailbackNotReadyForLaunch = "FAILBACK_NOT_READY_FOR_LAUNCH"

	// FailbackStateFailbackLaunchStateNotAvailable is a FailbackState enum value
	FailbackStateFailbackLaunchStateNotAvailable = "FAILBACK_LAUNCH_STATE_NOT_AVAILABLE"
)

// FailbackState_Values returns all elements of the FailbackState enum
func FailbackState_Values() []string {
	return []string{
		FailbackStateFailbackNotStarted,
		FailbackStateFailbackInProgress,
		FailbackStateFailbackReadyForLaunch,
		FailbackStateFailbackCompleted,
		FailbackStateFailbackError,
		FailbackStateFailbackNotReadyForLaunch,
		FailbackStateFailbackLaunchStateNotAvailable,
	}
}

const (
	// InitiatedByStartRecovery is a InitiatedBy enum value
	InitiatedByStartRecovery = "START_RECOVERY"

	// InitiatedByStartDrill is a InitiatedBy enum value
	InitiatedByStartDrill = "START_DRILL"

	// InitiatedByFailback is a InitiatedBy enum value
	InitiatedByFailback = "FAILBACK"

	// InitiatedByDiagnostic is a InitiatedBy enum value
	InitiatedByDiagnostic = "DIAGNOSTIC"

	// InitiatedByTerminateRecoveryInstances is a InitiatedBy enum value
	InitiatedByTerminateRecoveryInstances = "TERMINATE_RECOVERY_INSTANCES"

	// InitiatedByTargetAccount is a InitiatedBy enum value
	InitiatedByTargetAccount = "TARGET_ACCOUNT"

	// InitiatedByCreateNetworkRecovery is a InitiatedBy enum value
	InitiatedByCreateNetworkRecovery = "CREATE_NETWORK_RECOVERY"

	// InitiatedByUpdateNetworkRecovery is a InitiatedBy enum value
	InitiatedByUpdateNetworkRecovery = "UPDATE_NETWORK_RECOVERY"

	// InitiatedByAssociateNetworkRecovery is a InitiatedBy enum value
	InitiatedByAssociateNetworkRecovery = "ASSOCIATE_NETWORK_RECOVERY"
)

// InitiatedBy_Values returns all elements of the InitiatedBy enum
func InitiatedBy_Values() []string {
	return []string{
		InitiatedByStartRecovery,
		InitiatedByStartDrill,
		InitiatedByFailback,
		InitiatedByDiagnostic,
		InitiatedByTerminateRecoveryInstances,
		InitiatedByTargetAccount,
		InitiatedByCreateNetworkRecovery,
		InitiatedByUpdateNetworkRecovery,
		InitiatedByAssociateNetworkRecovery,
	}
}

const (
	// JobLogEventJobStart is a JobLogEvent enum value
	JobLogEventJobStart = "JOB_START"

	// JobLogEventServerSkipped is a JobLogEvent enum value
	JobLogEventServerSkipped = "SERVER_SKIPPED"

	// JobLogEventCleanupStart is a JobLogEvent enum value
	JobLogEventCleanupStart = "CLEANUP_START"

	// JobLogEventCleanupEnd is a JobLogEvent enum value
	JobLogEventCleanupEnd = "CLEANUP_END"

	// JobLogEventCleanupFail is a JobLogEvent enum value
	JobLogEventCleanupFail = "CLEANUP_FAIL"

	// JobLogEventSnapshotStart is a JobLogEvent enum value
	JobLogEventSnapshotStart = "SNAPSHOT_START"

	// JobLogEventSnapshotEnd is a JobLogEvent enum value
	JobLogEventSnapshotEnd = "SNAPSHOT_END"

	// JobLogEventSnapshotFail is a JobLogEvent enum value
	JobLogEventSnapshotFail = "SNAPSHOT_FAIL"

	// JobLogEventUsingPreviousSnapshot is a JobLogEvent enum value
	JobLogEventUsingPreviousSnapshot = "USING_PREVIOUS_SNAPSHOT"

	// JobLogEventUsingPreviousSnapshotFailed is a JobLogEvent enum value
	JobLogEventUsingPreviousSnapshotFailed = "USING_PREVIOUS_SNAPSHOT_FAILED"

	// JobLogEventConversionStart is a JobLogEvent enum value
	JobLogEventConversionStart = "CONVERSION_START"

	// JobLogEventConversionEnd is a JobLogEvent enum value
	JobLogEventConversionEnd = "CONVERSION_END"

	// JobLogEventConversionFail is a JobLogEvent enum value
	JobLogEventConversionFail = "CONVERSION_FAIL"

	// JobLogEventLaunchStart is a JobLogEvent enum value
	JobLogEventLaunchStart = "LAUNCH_START"

	// JobLogEventLaunchFailed is a JobLogEvent enum value
	JobLogEventLaunchFailed = "LAUNCH_FAILED"

	// JobLogEventJobCancel is a JobLogEvent enum value
	JobLogEventJobCancel = "JOB_CANCEL"

	// JobLogEventJobEnd is a JobLogEvent enum value
	JobLogEventJobEnd = "JOB_END"

	// JobLogEventDeployNetworkConfigurationStart is a JobLogEvent enum value
	JobLogEventDeployNetworkConfigurationStart = "DEPLOY_NETWORK_CONFIGURATION_START"

	// JobLogEventDeployNetworkConfigurationEnd is a JobLogEvent enum value
	JobLogEventDeployNetworkConfigurationEnd = "DEPLOY_NETWORK_CONFIGURATION_END"

	// JobLogEventDeployNetworkConfigurationFailed is a JobLogEvent enum value
	JobLogEventDeployNetworkConfigurationFailed = "DEPLOY_NETWORK_CONFIGURATION_FAILED"

	// JobLogEventUpdateNetworkConfigurationStart is a JobLogEvent enum value
	JobLogEventUpdateNetworkConfigurationStart = "UPDATE_NETWORK_CONFIGURATION_START"

	// JobLogEventUpdateNetworkConfigurationEnd is a JobLogEvent enum value
	JobLogEventUpdateNetworkConfigurationEnd = "UPDATE_NETWORK_CONFIGURATION_END"

	// JobLogEventUpdateNetworkConfigurationFailed is a JobLogEvent enum value
	JobLogEventUpdateNetworkConfigurationFailed = "UPDATE_NETWORK_CONFIGURATION_FAILED"

	// JobLogEventUpdateLaunchTemplateStart is a JobLogEvent enum value
	JobLogEventUpdateLaunchTemplateStart = "UPDATE_LAUNCH_TEMPLATE_START"

	// JobLogEventUpdateLaunchTemplateEnd is a JobLogEvent enum value
	JobLogEventUpdateLaunchTemplateEnd = "UPDATE_LAUNCH_TEMPLATE_END"

	// JobLogEventUpdateLaunchTemplateFailed is a JobLogEvent enum value
	JobLogEventUpdateLaunchTemplateFailed = "UPDATE_LAUNCH_TEMPLATE_FAILED"

	// JobLogEventNetworkRecoveryFail is a JobLogEvent enum value
	JobLogEventNetworkRecoveryFail = "NETWORK_RECOVERY_FAIL"
)

// JobLogEvent_Values returns all elements of the JobLogEvent enum
func JobLogEvent_Values() []string {
	return []string{
		JobLogEventJobStart,
		JobLogEventServerSkipped,
		JobLogEventCleanupStart,
		JobLogEventCleanupEnd,
		JobLogEventCleanupFail,
		JobLogEventSnapshotStart,
		JobLogEventSnapshotEnd,
		JobLogEventSnapshotFail,
		JobLogEventUsingPreviousSnapshot,
		JobLogEventUsingPreviousSnapshotFailed,
		JobLogEventConversionStart,
		JobLogEventConversionEnd,
		JobLogEventConversionFail,
		JobLogEventLaunchStart,
		JobLogEventLaunchFailed,
		JobLogEventJobCancel,
		JobLogEventJobEnd,
		JobLogEventDeployNetworkConfigurationStart,
		JobLogEventDeployNetworkConfigurationEnd,
		JobLogEventDeployNetworkConfigurationFailed,
		JobLogEventUpdateNetworkConfigurationStart,
		JobLogEventUpdateNetworkConfigurationEnd,
		JobLogEventUpdateNetworkConfigurationFailed,
		JobLogEventUpdateLaunchTemplateStart,
		JobLogEventUpdateLaunchTemplateEnd,
		JobLogEventUpdateLaunchTemplateFailed,
		JobLogEventNetworkRecoveryFail,
	}
}

const (
	// JobStatusPending is a JobStatus enum value
	JobStatusPending = "PENDING"

	// JobStatusStarted is a JobStatus enum value
	JobStatusStarted = "STARTED"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusPending,
		JobStatusStarted,
		JobStatusCompleted,
	}
}

const (
	// JobTypeLaunch is a JobType enum value
	JobTypeLaunch = "LAUNCH"

	// JobTypeTerminate is a JobType enum value
	JobTypeTerminate = "TERMINATE"

	// JobTypeCreateConvertedSnapshot is a JobType enum value
	JobTypeCreateConvertedSnapshot = "CREATE_CONVERTED_SNAPSHOT"
)

// JobType_Values returns all elements of the JobType enum
func JobType_Values() []string {
	return []string{
		JobTypeLaunch,
		JobTypeTerminate,
		JobTypeCreateConvertedSnapshot,
	}
}

const (
	// LastLaunchResultNotStarted is a LastLaunchResult enum value
	LastLaunchResultNotStarted = "NOT_STARTED"

	// LastLaunchResultPending is a LastLaunchResult enum value
	LastLaunchResultPending = "PENDING"

	// LastLaunchResultSucceeded is a LastLaunchResult enum value
	LastLaunchResultSucceeded = "SUCCEEDED"

	// LastLaunchResultFailed is a LastLaunchResult enum value
	LastLaunchResultFailed = "FAILED"
)

// LastLaunchResult_Values returns all elements of the LastLaunchResult enum
func LastLaunchResult_Values() []string {
	return []string{
		LastLaunchResultNotStarted,
		LastLaunchResultPending,
		LastLaunchResultSucceeded,
		LastLaunchResultFailed,
	}
}

const (
	// LastLaunchTypeRecovery is a LastLaunchType enum value
	LastLaunchTypeRecovery = "RECOVERY"

	// LastLaunchTypeDrill is a LastLaunchType enum value
	LastLaunchTypeDrill = "DRILL"
)

// LastLaunchType_Values returns all elements of the LastLaunchType enum
func LastLaunchType_Values() []string {
	return []string{
		LastLaunchTypeRecovery,
		LastLaunchTypeDrill,
	}
}

// Launch action category.
const (
	// LaunchActionCategoryMonitoring is a LaunchActionCategory enum value
	LaunchActionCategoryMonitoring = "MONITORING"

	// LaunchActionCategoryValidation is a LaunchActionCategory enum value
	LaunchActionCategoryValidation = "VALIDATION"

	// LaunchActionCategoryConfiguration is a LaunchActionCategory enum value
	LaunchActionCategoryConfiguration = "CONFIGURATION"

	// LaunchActionCategorySecurity is a LaunchActionCategory enum value
	LaunchActionCategorySecurity = "SECURITY"

	// LaunchActionCategoryOther is a LaunchActionCategory enum value
	LaunchActionCategoryOther = "OTHER"
)

// LaunchActionCategory_Values returns all elements of the LaunchActionCategory enum
func LaunchActionCategory_Values() []string {
	return []string{
		LaunchActionCategoryMonitoring,
		LaunchActionCategoryValidation,
		LaunchActionCategoryConfiguration,
		LaunchActionCategorySecurity,
		LaunchActionCategoryOther,
	}
}

const (
	// LaunchActionParameterTypeSsmStore is a LaunchActionParameterType enum value
	LaunchActionParameterTypeSsmStore = "SSM_STORE"

	// LaunchActionParameterTypeDynamic is a LaunchActionParameterType enum value
	LaunchActionParameterTypeDynamic = "DYNAMIC"
)

// LaunchActionParameterType_Values returns all elements of the LaunchActionParameterType enum
func LaunchActionParameterType_Values() []string {
	return []string{
		LaunchActionParameterTypeSsmStore,
		LaunchActionParameterTypeDynamic,
	}
}

const (
	// LaunchActionRunStatusInProgress is a LaunchActionRunStatus enum value
	LaunchActionRunStatusInProgress = "IN_PROGRESS"

	// LaunchActionRunStatusSucceeded is a LaunchActionRunStatus enum value
	LaunchActionRunStatusSucceeded = "SUCCEEDED"

	// LaunchActionRunStatusFailed is a LaunchActionRunStatus enum value
	LaunchActionRunStatusFailed = "FAILED"
)

// LaunchActionRunStatus_Values returns all elements of the LaunchActionRunStatus enum
func LaunchActionRunStatus_Values() []string {
	return []string{
		LaunchActionRunStatusInProgress,
		LaunchActionRunStatusSucceeded,
		LaunchActionRunStatusFailed,
	}
}

const (
	// LaunchActionTypeSsmAutomation is a LaunchActionType enum value
	LaunchActionTypeSsmAutomation = "SSM_AUTOMATION"

	// LaunchActionTypeSsmCommand is a LaunchActionType enum value
	LaunchActionTypeSsmCommand = "SSM_COMMAND"
)

// LaunchActionType_Values returns all elements of the LaunchActionType enum
func LaunchActionType_Values() []string {
	return []string{
		LaunchActionTypeSsmAutomation,
		LaunchActionTypeSsmCommand,
	}
}

const (
	// LaunchDispositionStopped is a LaunchDisposition enum value
	LaunchDispositionStopped = "STOPPED"

	// LaunchDispositionStarted is a LaunchDisposition enum value
	LaunchDispositionStarted = "STARTED"
)

// LaunchDisposition_Values returns all elements of the LaunchDisposition enum
func LaunchDisposition_Values() []string {
	return []string{
		LaunchDispositionStopped,
		LaunchDispositionStarted,
	}
}

const (
	// LaunchStatusPending is a LaunchStatus enum value
	LaunchStatusPending = "PENDING"

	// LaunchStatusInProgress is a LaunchStatus enum value
	LaunchStatusInProgress = "IN_PROGRESS"

	// LaunchStatusLaunched is a LaunchStatus enum value
	LaunchStatusLaunched = "LAUNCHED"

	// LaunchStatusFailed is a LaunchStatus enum value
	LaunchStatusFailed = "FAILED"

	// LaunchStatusTerminated is a LaunchStatus enum value
	LaunchStatusTerminated = "TERMINATED"
)

// LaunchStatus_Values returns all elements of the LaunchStatus enum
func LaunchStatus_Values() []string {
	return []string{
		LaunchStatusPending,
		LaunchStatusInProgress,
		LaunchStatusLaunched,
		LaunchStatusFailed,
		LaunchStatusTerminated,
	}
}

const (
	// OriginEnvironmentOnPremises is a OriginEnvironment enum value
	OriginEnvironmentOnPremises = "ON_PREMISES"

	// OriginEnvironmentAws is a OriginEnvironment enum value
	OriginEnvironmentAws = "AWS"
)

// OriginEnvironment_Values returns all elements of the OriginEnvironment enum
func OriginEnvironment_Values() []string {
	return []string{
		OriginEnvironmentOnPremises,
		OriginEnvironmentAws,
	}
}

const (
	// PITPolicyRuleUnitsMinute is a PITPolicyRuleUnits enum value
	PITPolicyRuleUnitsMinute = "MINUTE"

	// PITPolicyRuleUnitsHour is a PITPolicyRuleUnits enum value
	PITPolicyRuleUnitsHour = "HOUR"

	// PITPolicyRuleUnitsDay is a PITPolicyRuleUnits enum value
	PITPolicyRuleUnitsDay = "DAY"
)

// PITPolicyRuleUnits_Values returns all elements of the PITPolicyRuleUnits enum
func PITPolicyRuleUnits_Values() []string {
	return []string{
		PITPolicyRuleUnitsMinute,
		PITPolicyRuleUnitsHour,
		PITPolicyRuleUnitsDay,
	}
}

const (
	// ProductCodeModeEnabled is a ProductCodeMode enum value
	ProductCodeModeEnabled = "ENABLED"

	// ProductCodeModeDisabled is a ProductCodeMode enum value
	ProductCodeModeDisabled = "DISABLED"
)

// ProductCodeMode_Values returns all elements of the ProductCodeMode enum
func ProductCodeMode_Values() []string {
	return []string{
		ProductCodeModeEnabled,
		ProductCodeModeDisabled,
	}
}

const (
	// RecoveryInstanceDataReplicationInitiationStepNameLinkFailbackClientWithRecoveryInstance is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameLinkFailbackClientWithRecoveryInstance = "LINK_FAILBACK_CLIENT_WITH_RECOVERY_INSTANCE"

	// RecoveryInstanceDataReplicationInitiationStepNameCompleteVolumeMapping is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameCompleteVolumeMapping = "COMPLETE_VOLUME_MAPPING"

	// RecoveryInstanceDataReplicationInitiationStepNameEstablishRecoveryInstanceCommunication is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameEstablishRecoveryInstanceCommunication = "ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION"

	// RecoveryInstanceDataReplicationInitiationStepNameDownloadReplicationSoftwareToFailbackClient is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameDownloadReplicationSoftwareToFailbackClient = "DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT"

	// RecoveryInstanceDataReplicationInitiationStepNameConfigureReplicationSoftware is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameConfigureReplicationSoftware = "CONFIGURE_REPLICATION_SOFTWARE"

	// RecoveryInstanceDataReplicationInitiationStepNamePairAgentWithReplicationSoftware is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNamePairAgentWithReplicationSoftware = "PAIR_AGENT_WITH_REPLICATION_SOFTWARE"

	// RecoveryInstanceDataReplicationInitiationStepNameEstablishAgentReplicatorSoftwareCommunication is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameEstablishAgentReplicatorSoftwareCommunication = "ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION"

	// RecoveryInstanceDataReplicationInitiationStepNameWait is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameWait = "WAIT"

	// RecoveryInstanceDataReplicationInitiationStepNameCreateSecurityGroup is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameCreateSecurityGroup = "CREATE_SECURITY_GROUP"

	// RecoveryInstanceDataReplicationInitiationStepNameLaunchReplicationServer is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameLaunchReplicationServer = "LAUNCH_REPLICATION_SERVER"

	// RecoveryInstanceDataReplicationInitiationStepNameBootReplicationServer is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameBootReplicationServer = "BOOT_REPLICATION_SERVER"

	// RecoveryInstanceDataReplicationInitiationStepNameAuthenticateWithService is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameAuthenticateWithService = "AUTHENTICATE_WITH_SERVICE"

	// RecoveryInstanceDataReplicationInitiationStepNameDownloadReplicationSoftware is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameDownloadReplicationSoftware = "DOWNLOAD_REPLICATION_SOFTWARE"

	// RecoveryInstanceDataReplicationInitiationStepNameCreateStagingDisks is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameCreateStagingDisks = "CREATE_STAGING_DISKS"

	// RecoveryInstanceDataReplicationInitiationStepNameAttachStagingDisks is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameAttachStagingDisks = "ATTACH_STAGING_DISKS"

	// RecoveryInstanceDataReplicationInitiationStepNamePairReplicationServerWithAgent is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNamePairReplicationServerWithAgent = "PAIR_REPLICATION_SERVER_WITH_AGENT"

	// RecoveryInstanceDataReplicationInitiationStepNameConnectAgentToReplicationServer is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameConnectAgentToReplicationServer = "CONNECT_AGENT_TO_REPLICATION_SERVER"

	// RecoveryInstanceDataReplicationInitiationStepNameStartDataTransfer is a RecoveryInstanceDataReplicationInitiationStepName enum value
	RecoveryInstanceDataReplicationInitiationStepNameStartDataTransfer = "START_DATA_TRANSFER"
)

// RecoveryInstanceDataReplicationInitiationStepName_Values returns all elements of the RecoveryInstanceDataReplicationInitiationStepName enum
func RecoveryInstanceDataReplicationInitiationStepName_Values() []string {
	return []string{
		RecoveryInstanceDataReplicationInitiationStepNameLinkFailbackClientWithRecoveryInstance,
		RecoveryInstanceDataReplicationInitiationStepNameCompleteVolumeMapping,
		RecoveryInstanceDataReplicationInitiationStepNameEstablishRecoveryInstanceCommunication,
		RecoveryInstanceDataReplicationInitiationStepNameDownloadReplicationSoftwareToFailbackClient,
		RecoveryInstanceDataReplicationInitiationStepNameConfigureReplicationSoftware,
		RecoveryInstanceDataReplicationInitiationStepNamePairAgentWithReplicationSoftware,
		RecoveryInstanceDataReplicationInitiationStepNameEstablishAgentReplicatorSoftwareCommunication,
		RecoveryInstanceDataReplicationInitiationStepNameWait,
		RecoveryInstanceDataReplicationInitiationStepNameCreateSecurityGroup,
		RecoveryInstanceDataReplicationInitiationStepNameLaunchReplicationServer,
		RecoveryInstanceDataReplicationInitiationStepNameBootReplicationServer,
		RecoveryInstanceDataReplicationInitiationStepNameAuthenticateWithService,
		RecoveryInstanceDataReplicationInitiationStepNameDownloadReplicationSoftware,
		RecoveryInstanceDataReplicationInitiationStepNameCreateStagingDisks,
		RecoveryInstanceDataReplicationInitiationStepNameAttachStagingDisks,
		RecoveryInstanceDataReplicationInitiationStepNamePairReplicationServerWithAgent,
		RecoveryInstanceDataReplicationInitiationStepNameConnectAgentToReplicationServer,
		RecoveryInstanceDataReplicationInitiationStepNameStartDataTransfer,
	}
}

const (
	// RecoveryInstanceDataReplicationInitiationStepStatusNotStarted is a RecoveryInstanceDataReplicationInitiationStepStatus enum value
	RecoveryInstanceDataReplicationInitiationStepStatusNotStarted = "NOT_STARTED"

	// RecoveryInstanceDataReplicationInitiationStepStatusInProgress is a RecoveryInstanceDataReplicationInitiationStepStatus enum value
	RecoveryInstanceDataReplicationInitiationStepStatusInProgress = "IN_PROGRESS"

	// RecoveryInstanceDataReplicationInitiationStepStatusSucceeded is a RecoveryInstanceDataReplicationInitiationStepStatus enum value
	RecoveryInstanceDataReplicationInitiationStepStatusSucceeded = "SUCCEEDED"

	// RecoveryInstanceDataReplicationInitiationStepStatusFailed is a RecoveryInstanceDataReplicationInitiationStepStatus enum value
	RecoveryInstanceDataReplicationInitiationStepStatusFailed = "FAILED"

	// RecoveryInstanceDataReplicationInitiationStepStatusSkipped is a RecoveryInstanceDataReplicationInitiationStepStatus enum value
	RecoveryInstanceDataReplicationInitiationStepStatusSkipped = "SKIPPED"
)

// RecoveryInstanceDataReplicationInitiationStepStatus_Values returns all elements of the RecoveryInstanceDataReplicationInitiationStepStatus enum
func RecoveryInstanceDataReplicationInitiationStepStatus_Values() []string {
	return []string{
		RecoveryInstanceDataReplicationInitiationStepStatusNotStarted,
		RecoveryInstanceDataReplicationInitiationStepStatusInProgress,
		RecoveryInstanceDataReplicationInitiationStepStatusSucceeded,
		RecoveryInstanceDataReplicationInitiationStepStatusFailed,
		RecoveryInstanceDataReplicationInitiationStepStatusSkipped,
	}
}

const (
	// RecoveryInstanceDataReplicationStateStopped is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStateStopped = "STOPPED"

	// RecoveryInstanceDataReplicationStateInitiating is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStateInitiating = "INITIATING"

	// RecoveryInstanceDataReplicationStateInitialSync is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStateInitialSync = "INITIAL_SYNC"

	// RecoveryInstanceDataReplicationStateBacklog is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStateBacklog = "BACKLOG"

	// RecoveryInstanceDataReplicationStateCreatingSnapshot is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStateCreatingSnapshot = "CREATING_SNAPSHOT"

	// RecoveryInstanceDataReplicationStateContinuous is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStateContinuous = "CONTINUOUS"

	// RecoveryInstanceDataReplicationStatePaused is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStatePaused = "PAUSED"

	// RecoveryInstanceDataReplicationStateRescan is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStateRescan = "RESCAN"

	// RecoveryInstanceDataReplicationStateStalled is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStateStalled = "STALLED"

	// RecoveryInstanceDataReplicationStateDisconnected is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStateDisconnected = "DISCONNECTED"

	// RecoveryInstanceDataReplicationStateReplicationStateNotAvailable is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStateReplicationStateNotAvailable = "REPLICATION_STATE_NOT_AVAILABLE"

	// RecoveryInstanceDataReplicationStateNotStarted is a RecoveryInstanceDataReplicationState enum value
	RecoveryInstanceDataReplicationStateNotStarted = "NOT_STARTED"
)

// RecoveryInstanceDataReplicationState_Values returns all elements of the RecoveryInstanceDataReplicationState enum
func RecoveryInstanceDataReplicationState_Values() []string {
	return []string{
		RecoveryInstanceDataReplicationStateStopped,
		RecoveryInstanceDataReplicationStateInitiating,
		RecoveryInstanceDataReplicationStateInitialSync,
		RecoveryInstanceDataReplicationStateBacklog,
		RecoveryInstanceDataReplicationStateCreatingSnapshot,
		RecoveryInstanceDataReplicationStateContinuous,
		RecoveryInstanceDataReplicationStatePaused,
		RecoveryInstanceDataReplicationStateRescan,
		RecoveryInstanceDataReplicationStateStalled,
		RecoveryInstanceDataReplicationStateDisconnected,
		RecoveryInstanceDataReplicationStateReplicationStateNotAvailable,
		RecoveryInstanceDataReplicationStateNotStarted,
	}
}

const (
	// RecoveryResultNotStarted is a RecoveryResult enum value
	RecoveryResultNotStarted = "NOT_STARTED"

	// RecoveryResultInProgress is a RecoveryResult enum value
	RecoveryResultInProgress = "IN_PROGRESS"

	// RecoveryResultSuccess is a RecoveryResult enum value
	RecoveryResultSuccess = "SUCCESS"

	// RecoveryResultFail is a RecoveryResult enum value
	RecoveryResultFail = "FAIL"

	// RecoveryResultPartialSuccess is a RecoveryResult enum value
	RecoveryResultPartialSuccess = "PARTIAL_SUCCESS"

	// RecoveryResultAssociateSuccess is a RecoveryResult enum value
	RecoveryResultAssociateSuccess = "ASSOCIATE_SUCCESS"

	// RecoveryResultAssociateFail is a RecoveryResult enum value
	RecoveryResultAssociateFail = "ASSOCIATE_FAIL"
)

// RecoveryResult_Values returns all elements of the RecoveryResult enum
func RecoveryResult_Values() []string {
	return []string{
		RecoveryResultNotStarted,
		RecoveryResultInProgress,
		RecoveryResultSuccess,
		RecoveryResultFail,
		RecoveryResultPartialSuccess,
		RecoveryResultAssociateSuccess,
		RecoveryResultAssociateFail,
	}
}

const (
	// RecoverySnapshotsOrderAsc is a RecoverySnapshotsOrder enum value
	RecoverySnapshotsOrderAsc = "ASC"

	// RecoverySnapshotsOrderDesc is a RecoverySnapshotsOrder enum value
	RecoverySnapshotsOrderDesc = "DESC"
)

// RecoverySnapshotsOrder_Values returns all elements of the RecoverySnapshotsOrder enum
func RecoverySnapshotsOrder_Values() []string {
	return []string{
		RecoverySnapshotsOrderAsc,
		RecoverySnapshotsOrderDesc,
	}
}

const (
	// ReplicationConfigurationDataPlaneRoutingPrivateIp is a ReplicationConfigurationDataPlaneRouting enum value
	ReplicationConfigurationDataPlaneRoutingPrivateIp = "PRIVATE_IP"

	// ReplicationConfigurationDataPlaneRoutingPublicIp is a ReplicationConfigurationDataPlaneRouting enum value
	ReplicationConfigurationDataPlaneRoutingPublicIp = "PUBLIC_IP"
)

// ReplicationConfigurationDataPlaneRouting_Values returns all elements of the ReplicationConfigurationDataPlaneRouting enum
func ReplicationConfigurationDataPlaneRouting_Values() []string {
	return []string{
		ReplicationConfigurationDataPlaneRoutingPrivateIp,
		ReplicationConfigurationDataPlaneRoutingPublicIp,
	}
}

const (
	// ReplicationConfigurationDefaultLargeStagingDiskTypeGp2 is a ReplicationConfigurationDefaultLargeStagingDiskType enum value
	ReplicationConfigurationDefaultLargeStagingDiskTypeGp2 = "GP2"

	// ReplicationConfigurationDefaultLargeStagingDiskTypeGp3 is a ReplicationConfigurationDefaultLargeStagingDiskType enum value
	ReplicationConfigurationDefaultLargeStagingDiskTypeGp3 = "GP3"

	// ReplicationConfigurationDefaultLargeStagingDiskTypeSt1 is a ReplicationConfigurationDefaultLargeStagingDiskType enum value
	ReplicationConfigurationDefaultLargeStagingDiskTypeSt1 = "ST1"

	// ReplicationConfigurationDefaultLargeStagingDiskTypeAuto is a ReplicationConfigurationDefaultLargeStagingDiskType enum value
	ReplicationConfigurationDefaultLargeStagingDiskTypeAuto = "AUTO"
)

// ReplicationConfigurationDefaultLargeStagingDiskType_Values returns all elements of the ReplicationConfigurationDefaultLargeStagingDiskType enum
func ReplicationConfigurationDefaultLargeStagingDiskType_Values() []string {
	return []string{
		ReplicationConfigurationDefaultLargeStagingDiskTypeGp2,
		ReplicationConfigurationDefaultLargeStagingDiskTypeGp3,
		ReplicationConfigurationDefaultLargeStagingDiskTypeSt1,
		ReplicationConfigurationDefaultLargeStagingDiskTypeAuto,
	}
}

const (
	// ReplicationConfigurationEbsEncryptionDefault is a ReplicationConfigurationEbsEncryption enum value
	ReplicationConfigurationEbsEncryptionDefault = "DEFAULT"

	// ReplicationConfigurationEbsEncryptionCustom is a ReplicationConfigurationEbsEncryption enum value
	ReplicationConfigurationEbsEncryptionCustom = "CUSTOM"

	// ReplicationConfigurationEbsEncryptionNone is a ReplicationConfigurationEbsEncryption enum value
	ReplicationConfigurationEbsEncryptionNone = "NONE"
)

// ReplicationConfigurationEbsEncryption_Values returns all elements of the ReplicationConfigurationEbsEncryption enum
func ReplicationConfigurationEbsEncryption_Values() []string {
	return []string{
		ReplicationConfigurationEbsEncryptionDefault,
		ReplicationConfigurationEbsEncryptionCustom,
		ReplicationConfigurationEbsEncryptionNone,
	}
}

const (
	// ReplicationConfigurationReplicatedDiskStagingDiskTypeAuto is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeAuto = "AUTO"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeGp2 is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeGp2 = "GP2"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeGp3 is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeGp3 = "GP3"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeIo1 is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeIo1 = "IO1"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeSc1 is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeSc1 = "SC1"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeSt1 is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeSt1 = "ST1"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeStandard is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeStandard = "STANDARD"
)

// ReplicationConfigurationReplicatedDiskStagingDiskType_Values returns all elements of the ReplicationConfigurationReplicatedDiskStagingDiskType enum
func ReplicationConfigurationReplicatedDiskStagingDiskType_Values() []string {
	return []string{
		ReplicationConfigurationReplicatedDiskStagingDiskTypeAuto,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeGp2,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeGp3,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeIo1,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeSc1,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeSt1,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeStandard,
	}
}

// Replication direction designates if this is a failover replication, or a
// failback replication. When a DRS agent is installed on an instance, the replication
// direction is failover. In cases where a recovery launch was made in the recovery
// location and a new recovery instance was created, and then a failback replication
// was initiated from that recovery instance back to the origin location, then
// the replication direction will be failback.
const (
	// ReplicationDirectionFailover is a ReplicationDirection enum value
	ReplicationDirectionFailover = "FAILOVER"

	// ReplicationDirectionFailback is a ReplicationDirection enum value
	ReplicationDirectionFailback = "FAILBACK"
)

// ReplicationDirection_Values returns all elements of the ReplicationDirection enum
func ReplicationDirection_Values() []string {
	return []string{
		ReplicationDirectionFailover,
		ReplicationDirectionFailback,
	}
}

const (
	// ReplicationStatusStopped is a ReplicationStatus enum value
	ReplicationStatusStopped = "STOPPED"

	// ReplicationStatusInProgress is a ReplicationStatus enum value
	ReplicationStatusInProgress = "IN_PROGRESS"

	// ReplicationStatusProtected is a ReplicationStatus enum value
	ReplicationStatusProtected = "PROTECTED"

	// ReplicationStatusError is a ReplicationStatus enum value
	ReplicationStatusError = "ERROR"
)

// ReplicationStatus_Values returns all elements of the ReplicationStatus enum
func ReplicationStatus_Values() []string {
	return []string{
		ReplicationStatusStopped,
		ReplicationStatusInProgress,
		ReplicationStatusProtected,
		ReplicationStatusError,
	}
}

const (
	// TargetInstanceTypeRightSizingMethodNone is a TargetInstanceTypeRightSizingMethod enum value
	TargetInstanceTypeRightSizingMethodNone = "NONE"

	// TargetInstanceTypeRightSizingMethodBasic is a TargetInstanceTypeRightSizingMethod enum value
	TargetInstanceTypeRightSizingMethodBasic = "BASIC"

	// TargetInstanceTypeRightSizingMethodInAws is a TargetInstanceTypeRightSizingMethod enum value
	TargetInstanceTypeRightSizingMethodInAws = "IN_AWS"
)

// TargetInstanceTypeRightSizingMethod_Values returns all elements of the TargetInstanceTypeRightSizingMethod enum
func TargetInstanceTypeRightSizingMethod_Values() []string {
	return []string{
		TargetInstanceTypeRightSizingMethodNone,
		TargetInstanceTypeRightSizingMethodBasic,
		TargetInstanceTypeRightSizingMethodInAws,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}

const (
	// VolumeStatusRegular is a VolumeStatus enum value
	VolumeStatusRegular = "REGULAR"

	// VolumeStatusContainsMarketplaceProductCodes is a VolumeStatus enum value
	VolumeStatusContainsMarketplaceProductCodes = "CONTAINS_MARKETPLACE_PRODUCT_CODES"

	// VolumeStatusMissingVolumeAttributes is a VolumeStatus enum value
	VolumeStatusMissingVolumeAttributes = "MISSING_VOLUME_ATTRIBUTES"

	// VolumeStatusMissingVolumeAttributesAndPrecheckUnavailable is a VolumeStatus enum value
	VolumeStatusMissingVolumeAttributesAndPrecheckUnavailable = "MISSING_VOLUME_ATTRIBUTES_AND_PRECHECK_UNAVAILABLE"
)

// VolumeStatus_Values returns all elements of the VolumeStatus enum
func VolumeStatus_Values() []string {
	return []string{
		VolumeStatusRegular,
		VolumeStatusContainsMarketplaceProductCodes,
		VolumeStatusMissingVolumeAttributes,
		VolumeStatusMissingVolumeAttributesAndPrecheckUnavailable,
	}
}
