// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package fbs2

import (
	flatbuffers "github.com/google/flatbuffers/go"

	common__scheduler__controls__fbs "github.com/boschrexroth/ctrlx-datalayer-golang/pkg/fbs/common/scheduler/controls/fbs"
	common__scheduler__fbs "github.com/boschrexroth/ctrlx-datalayer-golang/pkg/fbs/common/scheduler/fbs"
)

/// General settings of Scheduler, startup behavior, callables, tasks and timing
type AdminT struct {
	StartupState CurrentState
	StartupTimeout uint32
	StartupErrorReaction common__scheduler__fbs.CurrentErrorReaction
	TriggerSource common__scheduler__fbs.CurrentTrigger
	ControlDebug *common__scheduler__controls__fbs.ControlsT
	CpuInfo *CpuInfoT
	HardwareWatchdogRequired bool
	WatchdogDefaultValue common__scheduler__fbs.CallableWdgConfig
	Utilization *UtilizationThresholdT
	CallableTimeouts *CallableTimeoutsT
}

func (t *AdminT) Pack(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	if t == nil { return 0 }
	controlDebugOffset := t.ControlDebug.Pack(builder)
	
	cpuInfoOffset := t.CpuInfo.Pack(builder)
	utilizationOffset := t.Utilization.Pack(builder)
	callableTimeoutsOffset := t.CallableTimeouts.Pack(builder)
	AdminStart(builder)
	AdminAddStartupState(builder, t.StartupState)
	AdminAddStartupTimeout(builder, t.StartupTimeout)
	AdminAddStartupErrorReaction(builder, t.StartupErrorReaction)
	AdminAddTriggerSource(builder, t.TriggerSource)
	if t.ControlDebug != nil {
		AdminAddControlDebugType(builder, t.ControlDebug.Type)
	}
	AdminAddControlDebug(builder, controlDebugOffset)
	AdminAddCpuInfo(builder, cpuInfoOffset)
	AdminAddHardwareWatchdogRequired(builder, t.HardwareWatchdogRequired)
	AdminAddWatchdogDefaultValue(builder, t.WatchdogDefaultValue)
	AdminAddUtilization(builder, utilizationOffset)
	AdminAddCallableTimeouts(builder, callableTimeoutsOffset)
	return AdminEnd(builder)
}

func (rcv *Admin) UnPackTo(t *AdminT) {
	t.StartupState = rcv.StartupState()
	t.StartupTimeout = rcv.StartupTimeout()
	t.StartupErrorReaction = rcv.StartupErrorReaction()
	t.TriggerSource = rcv.TriggerSource()
	controlDebugTable := flatbuffers.Table{}
	if rcv.ControlDebug(&controlDebugTable) {
		t.ControlDebug = rcv.ControlDebugType().UnPack(controlDebugTable)
	}
	t.CpuInfo = rcv.CpuInfo(nil).UnPack()
	t.HardwareWatchdogRequired = rcv.HardwareWatchdogRequired()
	t.WatchdogDefaultValue = rcv.WatchdogDefaultValue()
	t.Utilization = rcv.Utilization(nil).UnPack()
	t.CallableTimeouts = rcv.CallableTimeouts(nil).UnPack()
}

func (rcv *Admin) UnPack() *AdminT {
	if rcv == nil { return nil }
	t := &AdminT{}
	rcv.UnPackTo(t)
	return t
}

type Admin struct {
	_tab flatbuffers.Table
}

func GetRootAsAdmin(buf []byte, offset flatbuffers.UOffsetT) *Admin {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Admin{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsAdmin(buf []byte, offset flatbuffers.UOffsetT) *Admin {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Admin{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Admin) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Admin) Table() flatbuffers.Table {
	return rcv._tab
}

/// Target operation state of Scheduler after power on ctrlX CORE
func (rcv *Admin) StartupState() CurrentState {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return CurrentState(rcv._tab.GetInt8(o + rcv._tab.Pos))
	}
	return 0
}

/// Target operation state of Scheduler after power on ctrlX CORE
func (rcv *Admin) MutateStartupState(n CurrentState) bool {
	return rcv._tab.MutateInt8Slot(4, int8(n))
}

/// Timeout for waiting for missing components before carry on switching to target operation state
func (rcv *Admin) StartupTimeout() uint32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.GetUint32(o + rcv._tab.Pos)
	}
	return 0
}

/// Timeout for waiting for missing components before carry on switching to target operation state
func (rcv *Admin) MutateStartupTimeout(n uint32) bool {
	return rcv._tab.MutateUint32Slot(6, n)
}

/// Error reaction in case of not all configured components are available
func (rcv *Admin) StartupErrorReaction() common__scheduler__fbs.CurrentErrorReaction {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return common__scheduler__fbs.CurrentErrorReaction(rcv._tab.GetInt8(o + rcv._tab.Pos))
	}
	return 1
}

/// Error reaction in case of not all configured components are available
func (rcv *Admin) MutateStartupErrorReaction(n common__scheduler__fbs.CurrentErrorReaction) bool {
	return rcv._tab.MutateInt8Slot(8, int8(n))
}

/// Trigger source of Scheduler task tick
func (rcv *Admin) TriggerSource() common__scheduler__fbs.CurrentTrigger {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return common__scheduler__fbs.CurrentTrigger(rcv._tab.GetInt8(o + rcv._tab.Pos))
	}
	return 1
}

/// Trigger source of Scheduler task tick
func (rcv *Admin) MutateTriggerSource(n common__scheduler__fbs.CurrentTrigger) bool {
	return rcv._tab.MutateInt8Slot(10, int8(n))
}

func (rcv *Admin) ControlDebugType() common__scheduler__controls__fbs.Controls {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return common__scheduler__controls__fbs.Controls(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Admin) MutateControlDebugType(n common__scheduler__controls__fbs.Controls) bool {
	return rcv._tab.MutateByteSlot(12, byte(n))
}

/// Indication whether the DEBUG mode is active and hardware watchdog and task watchdogs are disabled
func (rcv *Admin) ControlDebug(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

/// Indication whether the DEBUG mode is active and hardware watchdog and task watchdogs are disabled
/// Information about CPU cores of ctrlX CORE
func (rcv *Admin) CpuInfo(obj *CpuInfo) *CpuInfo {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(CpuInfo)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// Information about CPU cores of ctrlX CORE
/// Indication whether switching to the SERVICE state is required for managing apps
func (rcv *Admin) HardwareWatchdogRequired() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

/// Indication whether switching to the SERVICE state is required for managing apps
func (rcv *Admin) MutateHardwareWatchdogRequired(n bool) bool {
	return rcv._tab.MutateBoolSlot(18, n)
}

/// Default behavior of task and hardware watchdog handling when no requirements are given by other
func (rcv *Admin) WatchdogDefaultValue() common__scheduler__fbs.CallableWdgConfig {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(20))
	if o != 0 {
		return common__scheduler__fbs.CallableWdgConfig(rcv._tab.GetInt8(o + rcv._tab.Pos))
	}
	return 3
}

/// Default behavior of task and hardware watchdog handling when no requirements are given by other
func (rcv *Admin) MutateWatchdogDefaultValue(n common__scheduler__fbs.CallableWdgConfig) bool {
	return rcv._tab.MutateInt8Slot(20, int8(n))
}

/// Utilization of the cycle time of Scheduler tick task causes by itself
func (rcv *Admin) Utilization(obj *UtilizationThreshold) *UtilizationThreshold {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(22))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(UtilizationThreshold)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// Utilization of the cycle time of Scheduler tick task causes by itself
/// General settings for timeouts when switching callable operation states
func (rcv *Admin) CallableTimeouts(obj *CallableTimeouts) *CallableTimeouts {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(24))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(CallableTimeouts)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// General settings for timeouts when switching callable operation states
func AdminStart(builder *flatbuffers.Builder) {
	builder.StartObject(11)
}
func AdminAddStartupState(builder *flatbuffers.Builder, startupState CurrentState) {
	builder.PrependInt8Slot(0, int8(startupState), 0)
}
func AdminAddStartupTimeout(builder *flatbuffers.Builder, startupTimeout uint32) {
	builder.PrependUint32Slot(1, startupTimeout, 0)
}
func AdminAddStartupErrorReaction(builder *flatbuffers.Builder, startupErrorReaction common__scheduler__fbs.CurrentErrorReaction) {
	builder.PrependInt8Slot(2, int8(startupErrorReaction), 1)
}
func AdminAddTriggerSource(builder *flatbuffers.Builder, triggerSource common__scheduler__fbs.CurrentTrigger) {
	builder.PrependInt8Slot(3, int8(triggerSource), 1)
}
func AdminAddControlDebugType(builder *flatbuffers.Builder, controlDebugType common__scheduler__controls__fbs.Controls) {
	builder.PrependByteSlot(4, byte(controlDebugType), 0)
}
func AdminAddControlDebug(builder *flatbuffers.Builder, controlDebug flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(controlDebug), 0)
}
func AdminAddCpuInfo(builder *flatbuffers.Builder, cpuInfo flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(6, flatbuffers.UOffsetT(cpuInfo), 0)
}
func AdminAddHardwareWatchdogRequired(builder *flatbuffers.Builder, hardwareWatchdogRequired bool) {
	builder.PrependBoolSlot(7, hardwareWatchdogRequired, false)
}
func AdminAddWatchdogDefaultValue(builder *flatbuffers.Builder, watchdogDefaultValue common__scheduler__fbs.CallableWdgConfig) {
	builder.PrependInt8Slot(8, int8(watchdogDefaultValue), 3)
}
func AdminAddUtilization(builder *flatbuffers.Builder, utilization flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(9, flatbuffers.UOffsetT(utilization), 0)
}
func AdminAddCallableTimeouts(builder *flatbuffers.Builder, callableTimeouts flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(10, flatbuffers.UOffsetT(callableTimeouts), 0)
}
func AdminEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
