# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_keychain__keychains_keychain_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This container defines keychain configuration.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__tolerance',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=True)
    self.__tolerance = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FOREVER': {}},),RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),], is_leaf=True, yang_name="tolerance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /keychains/keychain/config/name (string)

    YANG Description: Keychain name.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /keychains/keychain/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Keychain name.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=True)


  def _get_tolerance(self):
    """
    Getter method for tolerance, mapped from YANG variable /keychains/keychain/config/tolerance (union)

    YANG Description: Tolerance (overlap time) that a receive key should be accepted.  May be
expressed as range in seconds, or using the FOREVER value to indicate
that the key does not expire.  The default value should be 0, i.e., no
tolerance.
    """
    return self.__tolerance
      
  def _set_tolerance(self, v, load=False):
    """
    Setter method for tolerance, mapped from YANG variable /keychains/keychain/config/tolerance (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tolerance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tolerance() directly.

    YANG Description: Tolerance (overlap time) that a receive key should be accepted.  May be
expressed as range in seconds, or using the FOREVER value to indicate
that the key does not expire.  The default value should be 0, i.e., no
tolerance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FOREVER': {}},),RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),], is_leaf=True, yang_name="tolerance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tolerance must be of a type compatible with union""",
          'defined-type': "openconfig-keychain:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FOREVER': {}},),RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),], is_leaf=True, yang_name="tolerance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=True)""",
        })

    self.__tolerance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tolerance(self):
    self.__tolerance = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FOREVER': {}},),RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),], is_leaf=True, yang_name="tolerance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  tolerance = __builtin__.property(_get_tolerance, _set_tolerance)


  _pyangbind_elements = OrderedDict([('name', name), ('tolerance', tolerance), ])


class yc_state_openconfig_keychain__keychains_keychain_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This container defines keychain state information.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__tolerance',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=False)
    self.__tolerance = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FOREVER': {}},),RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),], is_leaf=True, yang_name="tolerance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /keychains/keychain/state/name (string)

    YANG Description: Keychain name.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /keychains/keychain/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Keychain name.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=False)


  def _get_tolerance(self):
    """
    Getter method for tolerance, mapped from YANG variable /keychains/keychain/state/tolerance (union)

    YANG Description: Tolerance (overlap time) that a receive key should be accepted.  May be
expressed as range in seconds, or using the FOREVER value to indicate
that the key does not expire.  The default value should be 0, i.e., no
tolerance.
    """
    return self.__tolerance
      
  def _set_tolerance(self, v, load=False):
    """
    Setter method for tolerance, mapped from YANG variable /keychains/keychain/state/tolerance (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tolerance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tolerance() directly.

    YANG Description: Tolerance (overlap time) that a receive key should be accepted.  May be
expressed as range in seconds, or using the FOREVER value to indicate
that the key does not expire.  The default value should be 0, i.e., no
tolerance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FOREVER': {}},),RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),], is_leaf=True, yang_name="tolerance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tolerance must be of a type compatible with union""",
          'defined-type': "openconfig-keychain:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FOREVER': {}},),RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),], is_leaf=True, yang_name="tolerance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=False)""",
        })

    self.__tolerance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tolerance(self):
    self.__tolerance = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FOREVER': {}},),RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),], is_leaf=True, yang_name="tolerance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=False)

  name = __builtin__.property(_get_name)
  tolerance = __builtin__.property(_get_tolerance)


  _pyangbind_elements = OrderedDict([('name', name), ('tolerance', tolerance), ])


class yc_config_openconfig_keychain__keychains_keychain_keys_key_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/keys/key/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This container defines keychain key configuration.
  """
  __slots__ = ('_path_helper', '_extmethods', '__key_id','__secret_key','__crypto_algorithm',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__key_id = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['1..64']}),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),], is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=True)
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=True)
    self.__crypto_algorithm = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}},), is_leaf=True, yang_name="crypto-algorithm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'keys', 'key', 'config']

  def _get_key_id(self):
    """
    Getter method for key_id, mapped from YANG variable /keychains/keychain/keys/key/config/key_id (union)

    YANG Description: Identifier for the key within the keychain.
    """
    return self.__key_id
      
  def _set_key_id(self, v, load=False):
    """
    Setter method for key_id, mapped from YANG variable /keychains/keychain/keys/key/config/key_id (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_key_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_key_id() directly.

    YANG Description: Identifier for the key within the keychain.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['1..64']}),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),], is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """key_id must be of a type compatible with union""",
          'defined-type': "openconfig-keychain:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['1..64']}),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),], is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=True)""",
        })

    self.__key_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_key_id(self):
    self.__key_id = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['1..64']}),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),], is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=True)


  def _get_secret_key(self):
    """
    Getter method for secret_key, mapped from YANG variable /keychains/keychain/keys/key/config/secret_key (string)

    YANG Description: Authentication key supplied as an encrypted value.  The system should store and
return the key in encrypted form.
    """
    return self.__secret_key
      
  def _set_secret_key(self, v, load=False):
    """
    Setter method for secret_key, mapped from YANG variable /keychains/keychain/keys/key/config/secret_key (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secret_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secret_key() directly.

    YANG Description: Authentication key supplied as an encrypted value.  The system should store and
return the key in encrypted form.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secret_key must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=True)""",
        })

    self.__secret_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secret_key(self):
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=True)


  def _get_crypto_algorithm(self):
    """
    Getter method for crypto_algorithm, mapped from YANG variable /keychains/keychain/keys/key/config/crypto_algorithm (identityref)

    YANG Description: Cryptographic algorithm associated with the key.  Note that not all cryptographic
algorithms are available in all contexts (e.g., across different protocols).
    """
    return self.__crypto_algorithm
      
  def _set_crypto_algorithm(self, v, load=False):
    """
    Setter method for crypto_algorithm, mapped from YANG variable /keychains/keychain/keys/key/config/crypto_algorithm (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_crypto_algorithm is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_crypto_algorithm() directly.

    YANG Description: Cryptographic algorithm associated with the key.  Note that not all cryptographic
algorithms are available in all contexts (e.g., across different protocols).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}},), is_leaf=True, yang_name="crypto-algorithm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """crypto_algorithm must be of a type compatible with identityref""",
          'defined-type': "openconfig-keychain:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}},), is_leaf=True, yang_name="crypto-algorithm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='identityref', is_config=True)""",
        })

    self.__crypto_algorithm = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_crypto_algorithm(self):
    self.__crypto_algorithm = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}},), is_leaf=True, yang_name="crypto-algorithm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='identityref', is_config=True)

  key_id = __builtin__.property(_get_key_id, _set_key_id)
  secret_key = __builtin__.property(_get_secret_key, _set_secret_key)
  crypto_algorithm = __builtin__.property(_get_crypto_algorithm, _set_crypto_algorithm)


  _pyangbind_elements = OrderedDict([('key_id', key_id), ('secret_key', secret_key), ('crypto_algorithm', crypto_algorithm), ])


class yc_state_openconfig_keychain__keychains_keychain_keys_key_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/keys/key/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This container defines keychain key state.
  """
  __slots__ = ('_path_helper', '_extmethods', '__key_id','__secret_key','__crypto_algorithm',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__key_id = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['1..64']}),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),], is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=False)
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=False)
    self.__crypto_algorithm = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}},), is_leaf=True, yang_name="crypto-algorithm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'keys', 'key', 'state']

  def _get_key_id(self):
    """
    Getter method for key_id, mapped from YANG variable /keychains/keychain/keys/key/state/key_id (union)

    YANG Description: Identifier for the key within the keychain.
    """
    return self.__key_id
      
  def _set_key_id(self, v, load=False):
    """
    Setter method for key_id, mapped from YANG variable /keychains/keychain/keys/key/state/key_id (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_key_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_key_id() directly.

    YANG Description: Identifier for the key within the keychain.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['1..64']}),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),], is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """key_id must be of a type compatible with union""",
          'defined-type': "openconfig-keychain:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['1..64']}),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),], is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=False)""",
        })

    self.__key_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_key_id(self):
    self.__key_id = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['1..64']}),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),], is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='union', is_config=False)


  def _get_secret_key(self):
    """
    Getter method for secret_key, mapped from YANG variable /keychains/keychain/keys/key/state/secret_key (string)

    YANG Description: Authentication key supplied as an encrypted value.  The system should store and
return the key in encrypted form.
    """
    return self.__secret_key
      
  def _set_secret_key(self, v, load=False):
    """
    Setter method for secret_key, mapped from YANG variable /keychains/keychain/keys/key/state/secret_key (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secret_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secret_key() directly.

    YANG Description: Authentication key supplied as an encrypted value.  The system should store and
return the key in encrypted form.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secret_key must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=False)""",
        })

    self.__secret_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secret_key(self):
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='string', is_config=False)


  def _get_crypto_algorithm(self):
    """
    Getter method for crypto_algorithm, mapped from YANG variable /keychains/keychain/keys/key/state/crypto_algorithm (identityref)

    YANG Description: Cryptographic algorithm associated with the key.  Note that not all cryptographic
algorithms are available in all contexts (e.g., across different protocols).
    """
    return self.__crypto_algorithm
      
  def _set_crypto_algorithm(self, v, load=False):
    """
    Setter method for crypto_algorithm, mapped from YANG variable /keychains/keychain/keys/key/state/crypto_algorithm (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_crypto_algorithm is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_crypto_algorithm() directly.

    YANG Description: Cryptographic algorithm associated with the key.  Note that not all cryptographic
algorithms are available in all contexts (e.g., across different protocols).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}},), is_leaf=True, yang_name="crypto-algorithm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """crypto_algorithm must be of a type compatible with identityref""",
          'defined-type': "openconfig-keychain:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}},), is_leaf=True, yang_name="crypto-algorithm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='identityref', is_config=False)""",
        })

    self.__crypto_algorithm = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_crypto_algorithm(self):
    self.__crypto_algorithm = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:CRYPTO_NONE': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_MD5': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_12': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_20': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_1_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:HMAC_SHA_256': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}, 'oc-keychain-types:AES_28_CMAC_96': {'@module': 'openconfig-keychain-types', '@namespace': 'http://openconfig.net/yang/oc-keychain-types'}},), is_leaf=True, yang_name="crypto-algorithm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='identityref', is_config=False)

  key_id = __builtin__.property(_get_key_id)
  secret_key = __builtin__.property(_get_secret_key)
  crypto_algorithm = __builtin__.property(_get_crypto_algorithm)


  _pyangbind_elements = OrderedDict([('key_id', key_id), ('secret_key', secret_key), ('crypto_algorithm', crypto_algorithm), ])


class yc_config_openconfig_keychain__keychains_keychain_keys_key_send_lifetime_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/keys/key/send-lifetime/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for key send lifetime.
  """
  __slots__ = ('_path_helper', '_extmethods', '__start_time','__end_time','__send_and_receive',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__start_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)
    self.__end_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)
    self.__send_and_receive = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="send-and-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'keys', 'key', 'send-lifetime', 'config']

  def _get_start_time(self):
    """
    Getter method for start_time, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/config/start_time (oc-types:timeticks64)

    YANG Description: The time at which the key becomes valid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__start_time
      
  def _set_start_time(self, v, load=False):
    """
    Setter method for start_time, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/config/start_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_time() directly.

    YANG Description: The time at which the key becomes valid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)""",
        })

    self.__start_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_time(self):
    self.__start_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)


  def _get_end_time(self):
    """
    Getter method for end_time, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/config/end_time (oc-types:timeticks64)

    YANG Description: The time at which the key becomes invalid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).

Leaving this value unset, or setting it to 0, indicates that
the key remains valid forever (no end time).
    """
    return self.__end_time
      
  def _set_end_time(self, v, load=False):
    """
    Setter method for end_time, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/config/end_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_end_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_end_time() directly.

    YANG Description: The time at which the key becomes invalid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).

Leaving this value unset, or setting it to 0, indicates that
the key remains valid forever (no end time).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """end_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)""",
        })

    self.__end_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_end_time(self):
    self.__end_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)


  def _get_send_and_receive(self):
    """
    Getter method for send_and_receive, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/config/send_and_receive (boolean)

    YANG Description: When this is set to true (the default value), the specified
send lifetime is also used in the receive direction.  When set
to false, the device should use the specified receive-lifetime
for the receive direction (asymmetric mode).  If send-and-receive
is false, and the device does not support asymmetric configuration,
the config should be rejected as unsupported.
    """
    return self.__send_and_receive
      
  def _set_send_and_receive(self, v, load=False):
    """
    Setter method for send_and_receive, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/config/send_and_receive (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_send_and_receive is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_send_and_receive() directly.

    YANG Description: When this is set to true (the default value), the specified
send lifetime is also used in the receive direction.  When set
to false, the device should use the specified receive-lifetime
for the receive direction (asymmetric mode).  If send-and-receive
is false, and the device does not support asymmetric configuration,
the config should be rejected as unsupported.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="send-and-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """send_and_receive must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="send-and-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='boolean', is_config=True)""",
        })

    self.__send_and_receive = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_send_and_receive(self):
    self.__send_and_receive = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="send-and-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='boolean', is_config=True)

  start_time = __builtin__.property(_get_start_time, _set_start_time)
  end_time = __builtin__.property(_get_end_time, _set_end_time)
  send_and_receive = __builtin__.property(_get_send_and_receive, _set_send_and_receive)


  _pyangbind_elements = OrderedDict([('start_time', start_time), ('end_time', end_time), ('send_and_receive', send_and_receive), ])


class yc_state_openconfig_keychain__keychains_keychain_keys_key_send_lifetime_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/keys/key/send-lifetime/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for key send lifetime.
  """
  __slots__ = ('_path_helper', '_extmethods', '__start_time','__end_time','__send_and_receive',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__start_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)
    self.__end_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)
    self.__send_and_receive = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="send-and-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'keys', 'key', 'send-lifetime', 'state']

  def _get_start_time(self):
    """
    Getter method for start_time, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/state/start_time (oc-types:timeticks64)

    YANG Description: The time at which the key becomes valid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__start_time
      
  def _set_start_time(self, v, load=False):
    """
    Setter method for start_time, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/state/start_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_time() directly.

    YANG Description: The time at which the key becomes valid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__start_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_time(self):
    self.__start_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)


  def _get_end_time(self):
    """
    Getter method for end_time, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/state/end_time (oc-types:timeticks64)

    YANG Description: The time at which the key becomes invalid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).

Leaving this value unset, or setting it to 0, indicates that
the key remains valid forever (no end time).
    """
    return self.__end_time
      
  def _set_end_time(self, v, load=False):
    """
    Setter method for end_time, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/state/end_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_end_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_end_time() directly.

    YANG Description: The time at which the key becomes invalid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).

Leaving this value unset, or setting it to 0, indicates that
the key remains valid forever (no end time).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """end_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__end_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_end_time(self):
    self.__end_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)


  def _get_send_and_receive(self):
    """
    Getter method for send_and_receive, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/state/send_and_receive (boolean)

    YANG Description: When this is set to true (the default value), the specified
send lifetime is also used in the receive direction.  When set
to false, the device should use the specified receive-lifetime
for the receive direction (asymmetric mode).  If send-and-receive
is false, and the device does not support asymmetric configuration,
the config should be rejected as unsupported.
    """
    return self.__send_and_receive
      
  def _set_send_and_receive(self, v, load=False):
    """
    Setter method for send_and_receive, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/state/send_and_receive (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_send_and_receive is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_send_and_receive() directly.

    YANG Description: When this is set to true (the default value), the specified
send lifetime is also used in the receive direction.  When set
to false, the device should use the specified receive-lifetime
for the receive direction (asymmetric mode).  If send-and-receive
is false, and the device does not support asymmetric configuration,
the config should be rejected as unsupported.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="send-and-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """send_and_receive must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="send-and-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='boolean', is_config=False)""",
        })

    self.__send_and_receive = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_send_and_receive(self):
    self.__send_and_receive = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="send-and-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='boolean', is_config=False)

  start_time = __builtin__.property(_get_start_time)
  end_time = __builtin__.property(_get_end_time)
  send_and_receive = __builtin__.property(_get_send_and_receive)


  _pyangbind_elements = OrderedDict([('start_time', start_time), ('end_time', end_time), ('send_and_receive', send_and_receive), ])


class yc_send_lifetime_openconfig_keychain__keychains_keychain_keys_key_send_lifetime(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/keys/key/send-lifetime. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Specifies the lifetime of the key for sending authentication
information to the peer.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'send-lifetime'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_keys_key_send_lifetime_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_keys_key_send_lifetime_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'keys', 'key', 'send-lifetime']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/config (container)

    YANG Description: Configuration data for key send lifetime.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for key send lifetime.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_keychain__keychains_keychain_keys_key_send_lifetime_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_keys_key_send_lifetime_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_keys_key_send_lifetime_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/state (container)

    YANG Description: Operational state data for key send lifetime.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for key send lifetime.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_keychain__keychains_keychain_keys_key_send_lifetime_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_keys_key_send_lifetime_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_keys_key_send_lifetime_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/keys/key/receive-lifetime/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for key receive lifetime.
  """
  __slots__ = ('_path_helper', '_extmethods', '__start_time','__end_time',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__start_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)
    self.__end_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'keys', 'key', 'receive-lifetime', 'config']

  def _get_start_time(self):
    """
    Getter method for start_time, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/config/start_time (oc-types:timeticks64)

    YANG Description: The time at which the key becomes valid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__start_time
      
  def _set_start_time(self, v, load=False):
    """
    Setter method for start_time, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/config/start_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_time() directly.

    YANG Description: The time at which the key becomes valid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)""",
        })

    self.__start_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_time(self):
    self.__start_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)


  def _get_end_time(self):
    """
    Getter method for end_time, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/config/end_time (oc-types:timeticks64)

    YANG Description: The time at which the key becomes invalid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).

Leaving this value unset, or setting it to 0, indicates that
the key remains valid forever (no end time).
    """
    return self.__end_time
      
  def _set_end_time(self, v, load=False):
    """
    Setter method for end_time, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/config/end_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_end_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_end_time() directly.

    YANG Description: The time at which the key becomes invalid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).

Leaving this value unset, or setting it to 0, indicates that
the key remains valid forever (no end time).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """end_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)""",
        })

    self.__end_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_end_time(self):
    self.__end_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=True)

  start_time = __builtin__.property(_get_start_time, _set_start_time)
  end_time = __builtin__.property(_get_end_time, _set_end_time)


  _pyangbind_elements = OrderedDict([('start_time', start_time), ('end_time', end_time), ])


class yc_state_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/keys/key/receive-lifetime/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for key receive lifetime.
  """
  __slots__ = ('_path_helper', '_extmethods', '__start_time','__end_time',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__start_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)
    self.__end_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'keys', 'key', 'receive-lifetime', 'state']

  def _get_start_time(self):
    """
    Getter method for start_time, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/state/start_time (oc-types:timeticks64)

    YANG Description: The time at which the key becomes valid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__start_time
      
  def _set_start_time(self, v, load=False):
    """
    Setter method for start_time, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/state/start_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_time() directly.

    YANG Description: The time at which the key becomes valid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__start_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_time(self):
    self.__start_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)


  def _get_end_time(self):
    """
    Getter method for end_time, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/state/end_time (oc-types:timeticks64)

    YANG Description: The time at which the key becomes invalid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).

Leaving this value unset, or setting it to 0, indicates that
the key remains valid forever (no end time).
    """
    return self.__end_time
      
  def _set_end_time(self, v, load=False):
    """
    Setter method for end_time, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/state/end_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_end_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_end_time() directly.

    YANG Description: The time at which the key becomes invalid for use.
The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).

Leaving this value unset, or setting it to 0, indicates that
the key remains valid forever (no end time).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """end_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__end_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_end_time(self):
    self.__end_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='oc-types:timeticks64', is_config=False)

  start_time = __builtin__.property(_get_start_time)
  end_time = __builtin__.property(_get_end_time)


  _pyangbind_elements = OrderedDict([('start_time', start_time), ('end_time', end_time), ])


class yc_receive_lifetime_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/keys/key/receive-lifetime. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Specify the validity lifetime of the key in the receive direction.
Some platforms may only support symmetric send and receive lifetimes,
in which case the receive-lifetime is typically not specified.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'receive-lifetime'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'keys', 'key', 'receive-lifetime']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/config (container)

    YANG Description: Configuration data for key receive lifetime.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for key receive lifetime.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/state (container)

    YANG Description: Operational state data for key receive lifetime.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for key receive lifetime.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_key_openconfig_keychain__keychains_keychain_keys_key(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/keys/key. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of configured keys for the keychain.
  """
  __slots__ = ('_path_helper', '_extmethods', '__key_id','__config','__state','__send_lifetime','__receive_lifetime',)

  _yang_name = 'key'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__key_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_keys_key_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_keys_key_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    self.__send_lifetime = YANGDynClass(base=yc_send_lifetime_openconfig_keychain__keychains_keychain_keys_key_send_lifetime, is_container='container', yang_name="send-lifetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    self.__receive_lifetime = YANGDynClass(base=yc_receive_lifetime_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime, is_container='container', yang_name="receive-lifetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'keys', 'key']

  def _get_key_id(self):
    """
    Getter method for key_id, mapped from YANG variable /keychains/keychain/keys/key/key_id (leafref)

    YANG Description: Reference to key id.
    """
    return self.__key_id
      
  def _set_key_id(self, v, load=False):
    """
    Setter method for key_id, mapped from YANG variable /keychains/keychain/keys/key/key_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_key_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_key_id() directly.

    YANG Description: Reference to key id.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """key_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='leafref', is_config=True)""",
        })

    self.__key_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_key_id(self):
    self.__key_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="key-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /keychains/keychain/keys/key/config (container)

    YANG Description: This container defines keychain key configuration.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /keychains/keychain/keys/key/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: This container defines keychain key configuration.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_keychain__keychains_keychain_keys_key_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_keys_key_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_keys_key_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /keychains/keychain/keys/key/state (container)

    YANG Description: This container defines keychain key state.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /keychains/keychain/keys/key/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: This container defines keychain key state.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_keychain__keychains_keychain_keys_key_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_keys_key_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_keys_key_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)


  def _get_send_lifetime(self):
    """
    Getter method for send_lifetime, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime (container)

    YANG Description: Specifies the lifetime of the key for sending authentication
information to the peer.
    """
    return self.__send_lifetime
      
  def _set_send_lifetime(self, v, load=False):
    """
    Setter method for send_lifetime, mapped from YANG variable /keychains/keychain/keys/key/send_lifetime (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_send_lifetime is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_send_lifetime() directly.

    YANG Description: Specifies the lifetime of the key for sending authentication
information to the peer.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_send_lifetime_openconfig_keychain__keychains_keychain_keys_key_send_lifetime, is_container='container', yang_name="send-lifetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """send_lifetime must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_send_lifetime_openconfig_keychain__keychains_keychain_keys_key_send_lifetime, is_container='container', yang_name="send-lifetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__send_lifetime = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_send_lifetime(self):
    self.__send_lifetime = YANGDynClass(base=yc_send_lifetime_openconfig_keychain__keychains_keychain_keys_key_send_lifetime, is_container='container', yang_name="send-lifetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)


  def _get_receive_lifetime(self):
    """
    Getter method for receive_lifetime, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime (container)

    YANG Description: Specify the validity lifetime of the key in the receive direction.
Some platforms may only support symmetric send and receive lifetimes,
in which case the receive-lifetime is typically not specified.
    """
    return self.__receive_lifetime
      
  def _set_receive_lifetime(self, v, load=False):
    """
    Setter method for receive_lifetime, mapped from YANG variable /keychains/keychain/keys/key/receive_lifetime (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_receive_lifetime is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_receive_lifetime() directly.

    YANG Description: Specify the validity lifetime of the key in the receive direction.
Some platforms may only support symmetric send and receive lifetimes,
in which case the receive-lifetime is typically not specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_receive_lifetime_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime, is_container='container', yang_name="receive-lifetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """receive_lifetime must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_receive_lifetime_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime, is_container='container', yang_name="receive-lifetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__receive_lifetime = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_receive_lifetime(self):
    self.__receive_lifetime = YANGDynClass(base=yc_receive_lifetime_openconfig_keychain__keychains_keychain_keys_key_receive_lifetime, is_container='container', yang_name="receive-lifetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)

  key_id = __builtin__.property(_get_key_id, _set_key_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  send_lifetime = __builtin__.property(_get_send_lifetime, _set_send_lifetime)
  receive_lifetime = __builtin__.property(_get_receive_lifetime, _set_receive_lifetime)


  _pyangbind_elements = OrderedDict([('key_id', key_id), ('config', config), ('state', state), ('send_lifetime', send_lifetime), ('receive_lifetime', receive_lifetime), ])


class yc_keys_openconfig_keychain__keychains_keychain_keys(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain/keys. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: list of keys to be stored
  """
  __slots__ = ('_path_helper', '_extmethods', '__key',)

  _yang_name = 'keys'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__key = YANGDynClass(base=YANGListType("key_id",yc_key_openconfig_keychain__keychains_keychain_keys_key, yang_name="key", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='key-id', extensions=None), is_container='list', yang_name="key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain', 'keys']

  def _get_key(self):
    """
    Getter method for key, mapped from YANG variable /keychains/keychain/keys/key (list)

    YANG Description: List of configured keys for the keychain.
    """
    return self.__key
      
  def _set_key(self, v, load=False):
    """
    Setter method for key, mapped from YANG variable /keychains/keychain/keys/key (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_key() directly.

    YANG Description: List of configured keys for the keychain.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("key_id",yc_key_openconfig_keychain__keychains_keychain_keys_key, yang_name="key", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='key-id', extensions=None), is_container='list', yang_name="key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """key must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("key_id",yc_key_openconfig_keychain__keychains_keychain_keys_key, yang_name="key", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='key-id', extensions=None), is_container='list', yang_name="key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='list', is_config=True)""",
        })

    self.__key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_key(self):
    self.__key = YANGDynClass(base=YANGListType("key_id",yc_key_openconfig_keychain__keychains_keychain_keys_key, yang_name="key", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='key-id', extensions=None), is_container='list', yang_name="key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='list', is_config=True)

  key = __builtin__.property(_get_key, _set_key)


  _pyangbind_elements = OrderedDict([('key', key), ])


class yc_keychain_openconfig_keychain__keychains_keychain(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains/keychain. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of defined keychains.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__keys',)

  _yang_name = 'keychain'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    self.__keys = YANGDynClass(base=yc_keys_openconfig_keychain__keychains_keychain_keys, is_container='container', yang_name="keys", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains', 'keychain']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /keychains/keychain/name (leafref)

    YANG Description: Reference to configured keychain name
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /keychains/keychain/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to configured keychain name
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /keychains/keychain/config (container)

    YANG Description: This container defines keychain configuration.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /keychains/keychain/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: This container defines keychain configuration.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_keychain__keychains_keychain_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_keychain__keychains_keychain_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /keychains/keychain/state (container)

    YANG Description: This container defines keychain state information.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /keychains/keychain/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: This container defines keychain state information.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_keychain__keychains_keychain_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_keychain__keychains_keychain_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)


  def _get_keys(self):
    """
    Getter method for keys, mapped from YANG variable /keychains/keychain/keys (container)

    YANG Description: list of keys to be stored
    """
    return self.__keys
      
  def _set_keys(self, v, load=False):
    """
    Setter method for keys, mapped from YANG variable /keychains/keychain/keys (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_keys is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_keys() directly.

    YANG Description: list of keys to be stored
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_keys_openconfig_keychain__keychains_keychain_keys, is_container='container', yang_name="keys", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """keys must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_keys_openconfig_keychain__keychains_keychain_keys, is_container='container', yang_name="keys", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__keys = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_keys(self):
    self.__keys = YANGDynClass(base=yc_keys_openconfig_keychain__keychains_keychain_keys, is_container='container', yang_name="keys", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  keys = __builtin__.property(_get_keys, _set_keys)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('keys', keys), ])


class yc_keychains_openconfig_keychain__keychains(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /keychains. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This container defines keychains.
  """
  __slots__ = ('_path_helper', '_extmethods', '__keychain',)

  _yang_name = 'keychains'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__keychain = YANGDynClass(base=YANGListType("name",yc_keychain_openconfig_keychain__keychains_keychain, yang_name="keychain", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="keychain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['keychains']

  def _get_keychain(self):
    """
    Getter method for keychain, mapped from YANG variable /keychains/keychain (list)

    YANG Description: List of defined keychains.
    """
    return self.__keychain
      
  def _set_keychain(self, v, load=False):
    """
    Setter method for keychain, mapped from YANG variable /keychains/keychain (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_keychain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_keychain() directly.

    YANG Description: List of defined keychains.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_keychain_openconfig_keychain__keychains_keychain, yang_name="keychain", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="keychain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """keychain must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_keychain_openconfig_keychain__keychains_keychain, yang_name="keychain", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="keychain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='list', is_config=True)""",
        })

    self.__keychain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_keychain(self):
    self.__keychain = YANGDynClass(base=YANGListType("name",yc_keychain_openconfig_keychain__keychains_keychain, yang_name="keychain", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="keychain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='list', is_config=True)

  keychain = __builtin__.property(_get_keychain, _set_keychain)


  _pyangbind_elements = OrderedDict([('keychain', keychain), ])


class openconfig_keychain(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain - based on the path /openconfig-keychain. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module describes a YANG model for keychain configuration
and management. These keys can be changed frequently to
increase security in long-lived connections. A keychain can be used
for authenticaion in a number of scenarios, including in routing protocols
(e.g. BGP, IS-IS, OSPF).  A keychain provides a solution for storing
a number of different keys, each key string value is associated with a
specific key id, name, the lifetime that the key is valid and an
encryption algorithm.

This model defines a central location for defining named keychains,
which may be then referenced by other models such as routing protocol
management.
  """
  __slots__ = ('_path_helper', '_extmethods', '__keychains',)

  _yang_name = 'openconfig-keychain'
  _yang_namespace = 'http://openconfig.net/yang/oc-keychain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__keychains = YANGDynClass(base=yc_keychains_openconfig_keychain__keychains, is_container='container', yang_name="keychains", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_keychains(self):
    """
    Getter method for keychains, mapped from YANG variable /keychains (container)

    YANG Description: This container defines keychains.
    """
    return self.__keychains
      
  def _set_keychains(self, v, load=False):
    """
    Setter method for keychains, mapped from YANG variable /keychains (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_keychains is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_keychains() directly.

    YANG Description: This container defines keychains.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_keychains_openconfig_keychain__keychains, is_container='container', yang_name="keychains", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """keychains must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_keychains_openconfig_keychain__keychains, is_container='container', yang_name="keychains", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)""",
        })

    self.__keychains = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_keychains(self):
    self.__keychains = YANGDynClass(base=yc_keychains_openconfig_keychain__keychains, is_container='container', yang_name="keychains", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-keychain', defining_module='openconfig-keychain', yang_type='container', is_config=True)

  keychains = __builtin__.property(_get_keychains, _set_keychains)


  _pyangbind_elements = OrderedDict([('keychains', keychains), ])


class openconfig_keychain_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-keychain-types - based on the path /openconfig-keychain-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module contains general data definitions for use in
keychain-based authentication.
  """
  _pyangbind_elements = {}

  

