// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//go:build windows
// +build windows

// Code generated by 'go generate'; DO NOT EDIT.

package wevtapi

import (
	"syscall"
	"unsafe"

	"golang.org/x/sys/windows"
)

var _ unsafe.Pointer

// Do the interface allocations only once for common
// Errno values.
const (
	errnoERROR_IO_PENDING = 997
)

var (
	errERROR_IO_PENDING error = syscall.Errno(errnoERROR_IO_PENDING)
	errERROR_EINVAL     error = syscall.EINVAL
)

// errnoErr returns common boxed Errno values, to prevent
// allocations at runtime.
func errnoErr(e syscall.Errno) error {
	switch e {
	case 0:
		return errERROR_EINVAL
	case errnoERROR_IO_PENDING:
		return errERROR_IO_PENDING
	}
	// TODO: add more here, after collecting data on the common
	// error values see on Windows. (perhaps when running
	// all.bat?)
	return e
}

var (
	modwevtapi = windows.NewLazySystemDLL("wevtapi.dll")

	procEvtClearLog                 = modwevtapi.NewProc("EvtClearLog")
	procEvtClose                    = modwevtapi.NewProc("EvtClose")
	procEvtCreateBookmark           = modwevtapi.NewProc("EvtCreateBookmark")
	procEvtCreateRenderContext      = modwevtapi.NewProc("EvtCreateRenderContext")
	procEvtExportLog                = modwevtapi.NewProc("EvtExportLog")
	procEvtFormatMessage            = modwevtapi.NewProc("EvtFormatMessage")
	procEvtGetChannelConfigProperty = modwevtapi.NewProc("EvtGetChannelConfigProperty")
	procEvtNext                     = modwevtapi.NewProc("EvtNext")
	procEvtNextChannelPath          = modwevtapi.NewProc("EvtNextChannelPath")
	procEvtNextPublisherId          = modwevtapi.NewProc("EvtNextPublisherId")
	procEvtOpenChannelConfig        = modwevtapi.NewProc("EvtOpenChannelConfig")
	procEvtOpenChannelEnum          = modwevtapi.NewProc("EvtOpenChannelEnum")
	procEvtOpenLog                  = modwevtapi.NewProc("EvtOpenLog")
	procEvtOpenPublisherEnum        = modwevtapi.NewProc("EvtOpenPublisherEnum")
	procEvtOpenPublisherMetadata    = modwevtapi.NewProc("EvtOpenPublisherMetadata")
	procEvtOpenSession              = modwevtapi.NewProc("EvtOpenSession")
	procEvtQuery                    = modwevtapi.NewProc("EvtQuery")
	procEvtRender                   = modwevtapi.NewProc("EvtRender")
	procEvtSeek                     = modwevtapi.NewProc("EvtSeek")
	procEvtSubscribe                = modwevtapi.NewProc("EvtSubscribe")
	procEvtUpdateBookmark           = modwevtapi.NewProc("EvtUpdateBookmark")
)

func EvtClearLog(session windows.Handle, channelPath *uint16, targetFilePath *uint16, flags uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procEvtClearLog.Addr(), 4, uintptr(session), uintptr(unsafe.Pointer(channelPath)), uintptr(unsafe.Pointer(targetFilePath)), uintptr(flags), 0, 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtClose(event windows.Handle) (err error) {
	r1, _, e1 := syscall.Syscall(procEvtClose.Addr(), 1, uintptr(event), 0, 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtCreateBookmark(bookmarkXML *uint16) (handle windows.Handle, err error) {
	r0, _, e1 := syscall.Syscall(procEvtCreateBookmark.Addr(), 1, uintptr(unsafe.Pointer(bookmarkXML)), 0, 0)
	handle = windows.Handle(r0)
	if handle == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtCreateRenderContext(valuePathsCount uint32, valuePaths uintptr, flags uint32) (handle windows.Handle, err error) {
	r0, _, e1 := syscall.Syscall(procEvtCreateRenderContext.Addr(), 3, uintptr(valuePathsCount), uintptr(valuePaths), uintptr(flags))
	handle = windows.Handle(r0)
	if handle == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtExportLog(session windows.Handle, path *uint16, query *uint16, targetFilePath *uint16, flags uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procEvtExportLog.Addr(), 5, uintptr(session), uintptr(unsafe.Pointer(path)), uintptr(unsafe.Pointer(query)), uintptr(unsafe.Pointer(targetFilePath)), uintptr(flags), 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtFormatMessage(pubMetaData windows.Handle, event windows.Handle, messageID uint32, valueCount uint32, variant uintptr, flags uint32, bufferSize uint32, buffer *byte, bufferUsed *uint32) (err error) {
	r1, _, e1 := syscall.Syscall9(procEvtFormatMessage.Addr(), 9, uintptr(pubMetaData), uintptr(event), uintptr(messageID), uintptr(valueCount), uintptr(variant), uintptr(flags), uintptr(bufferSize), uintptr(unsafe.Pointer(buffer)), uintptr(unsafe.Pointer(bufferUsed)))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtGetChannelConfigProperty(channelConfig windows.Handle, propertyID EvtChannelConfigPropertyID, flags uint32, bufferSize uint32, buffer unsafe.Pointer, bufferUsed *uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procEvtGetChannelConfigProperty.Addr(), 6, uintptr(channelConfig), uintptr(propertyID), uintptr(flags), uintptr(bufferSize), uintptr(buffer), uintptr(unsafe.Pointer(bufferUsed)))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtNext(resultSet windows.Handle, eventArraySize uint32, eventArray *windows.Handle, timeout uint32, flags uint32, returned *uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procEvtNext.Addr(), 6, uintptr(resultSet), uintptr(eventArraySize), uintptr(unsafe.Pointer(eventArray)), uintptr(timeout), uintptr(flags), uintptr(unsafe.Pointer(returned)))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtNextChannelPath(channelEnum windows.Handle, channelPathBufferSize uint32, channelPathBuffer *uint16, channelPathBufferUsed *uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procEvtNextChannelPath.Addr(), 4, uintptr(channelEnum), uintptr(channelPathBufferSize), uintptr(unsafe.Pointer(channelPathBuffer)), uintptr(unsafe.Pointer(channelPathBufferUsed)), 0, 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtNextPublisherId(publisherEnum windows.Handle, publisherIDBufferSize uint32, publisherIDBuffer *uint16, publisherIDBufferUsed *uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procEvtNextPublisherId.Addr(), 4, uintptr(publisherEnum), uintptr(publisherIDBufferSize), uintptr(unsafe.Pointer(publisherIDBuffer)), uintptr(unsafe.Pointer(publisherIDBufferUsed)), 0, 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtOpenChannelConfig(event windows.Handle, channelPath *uint16, flags uint32) (handle windows.Handle, err error) {
	r0, _, e1 := syscall.Syscall(procEvtOpenChannelConfig.Addr(), 3, uintptr(event), uintptr(unsafe.Pointer(channelPath)), uintptr(flags))
	handle = windows.Handle(r0)
	if handle == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtOpenChannelEnum(session windows.Handle, flags uint32) (handle windows.Handle, err error) {
	r0, _, e1 := syscall.Syscall(procEvtOpenChannelEnum.Addr(), 2, uintptr(session), uintptr(flags), 0)
	handle = windows.Handle(r0)
	if handle == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtOpenLog(session windows.Handle, path *uint16, flags uint32) (handle windows.Handle, err error) {
	r0, _, e1 := syscall.Syscall(procEvtOpenLog.Addr(), 3, uintptr(session), uintptr(unsafe.Pointer(path)), uintptr(flags))
	handle = windows.Handle(r0)
	if handle == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtOpenPublisherEnum(session windows.Handle, flags uint32) (handle windows.Handle, err error) {
	r0, _, e1 := syscall.Syscall(procEvtOpenPublisherEnum.Addr(), 2, uintptr(session), uintptr(flags), 0)
	handle = windows.Handle(r0)
	if handle == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtOpenPublisherMetadata(session windows.Handle, publisherIdentity *uint16, logFilePath *uint16, locale uint32, flags uint32) (handle windows.Handle, err error) {
	r0, _, e1 := syscall.Syscall6(procEvtOpenPublisherMetadata.Addr(), 5, uintptr(session), uintptr(unsafe.Pointer(publisherIdentity)), uintptr(unsafe.Pointer(logFilePath)), uintptr(locale), uintptr(flags), 0)
	handle = windows.Handle(r0)
	if handle == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtOpenSession(loginClass uint32, login uintptr, timeout uint32, flags uint32) (handle windows.Handle, err error) {
	r0, _, e1 := syscall.Syscall6(procEvtOpenSession.Addr(), 4, uintptr(loginClass), uintptr(login), uintptr(timeout), uintptr(flags), 0, 0)
	handle = windows.Handle(r0)
	if handle == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtQuery(session windows.Handle, path *uint16, query *uint16, flags uint32) (handle windows.Handle, err error) {
	r0, _, e1 := syscall.Syscall6(procEvtQuery.Addr(), 4, uintptr(session), uintptr(unsafe.Pointer(path)), uintptr(unsafe.Pointer(query)), uintptr(flags), 0, 0)
	handle = windows.Handle(r0)
	if handle == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtRender(ctx windows.Handle, fragment windows.Handle, flags uint32, bufferSize uint32, buffer unsafe.Pointer, bufferUsed *uint32, propertyCount *uint32) (err error) {
	r1, _, e1 := syscall.Syscall9(procEvtRender.Addr(), 7, uintptr(ctx), uintptr(fragment), uintptr(flags), uintptr(bufferSize), uintptr(buffer), uintptr(unsafe.Pointer(bufferUsed)), uintptr(unsafe.Pointer(propertyCount)), 0, 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtSeek(resultSet windows.Handle, position int64, bookmark windows.Handle, timeout uint32, flags uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procEvtSeek.Addr(), 5, uintptr(resultSet), uintptr(position), uintptr(bookmark), uintptr(timeout), uintptr(flags), 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtSubscribe(session windows.Handle, signalEvent windows.Handle, channelPath *uint16, query *uint16, bookmark windows.Handle, ctx uintptr, callback uintptr, flags uint32) (handle windows.Handle, err error) {
	r0, _, e1 := syscall.Syscall9(procEvtSubscribe.Addr(), 8, uintptr(session), uintptr(signalEvent), uintptr(unsafe.Pointer(channelPath)), uintptr(unsafe.Pointer(query)), uintptr(bookmark), uintptr(ctx), uintptr(callback), uintptr(flags), 0)
	handle = windows.Handle(r0)
	if handle == 0 {
		err = errnoErr(e1)
	}
	return
}

func EvtUpdateBookmark(bookmark windows.Handle, event windows.Handle) (err error) {
	r1, _, e1 := syscall.Syscall(procEvtUpdateBookmark.Addr(), 2, uintptr(bookmark), uintptr(event), 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}
