// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewSetResourcePermissionsForBuiltInRoleParams creates a new SetResourcePermissionsForBuiltInRoleParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSetResourcePermissionsForBuiltInRoleParams() *SetResourcePermissionsForBuiltInRoleParams {
	return &SetResourcePermissionsForBuiltInRoleParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSetResourcePermissionsForBuiltInRoleParamsWithTimeout creates a new SetResourcePermissionsForBuiltInRoleParams object
// with the ability to set a timeout on a request.
func NewSetResourcePermissionsForBuiltInRoleParamsWithTimeout(timeout time.Duration) *SetResourcePermissionsForBuiltInRoleParams {
	return &SetResourcePermissionsForBuiltInRoleParams{
		timeout: timeout,
	}
}

// NewSetResourcePermissionsForBuiltInRoleParamsWithContext creates a new SetResourcePermissionsForBuiltInRoleParams object
// with the ability to set a context for a request.
func NewSetResourcePermissionsForBuiltInRoleParamsWithContext(ctx context.Context) *SetResourcePermissionsForBuiltInRoleParams {
	return &SetResourcePermissionsForBuiltInRoleParams{
		Context: ctx,
	}
}

// NewSetResourcePermissionsForBuiltInRoleParamsWithHTTPClient creates a new SetResourcePermissionsForBuiltInRoleParams object
// with the ability to set a custom HTTPClient for a request.
func NewSetResourcePermissionsForBuiltInRoleParamsWithHTTPClient(client *http.Client) *SetResourcePermissionsForBuiltInRoleParams {
	return &SetResourcePermissionsForBuiltInRoleParams{
		HTTPClient: client,
	}
}

/*
SetResourcePermissionsForBuiltInRoleParams contains all the parameters to send to the API endpoint

	for the set resource permissions for built in role operation.

	Typically these are written to a http.Request.
*/
type SetResourcePermissionsForBuiltInRoleParams struct {

	// Body.
	Body *models.SetPermissionCommand

	// BuiltInRole.
	BuiltInRole string

	// Resource.
	Resource string

	// ResourceID.
	ResourceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the set resource permissions for built in role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SetResourcePermissionsForBuiltInRoleParams) WithDefaults() *SetResourcePermissionsForBuiltInRoleParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the set resource permissions for built in role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SetResourcePermissionsForBuiltInRoleParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) WithTimeout(timeout time.Duration) *SetResourcePermissionsForBuiltInRoleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) WithContext(ctx context.Context) *SetResourcePermissionsForBuiltInRoleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) WithHTTPClient(client *http.Client) *SetResourcePermissionsForBuiltInRoleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) WithBody(body *models.SetPermissionCommand) *SetResourcePermissionsForBuiltInRoleParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) SetBody(body *models.SetPermissionCommand) {
	o.Body = body
}

// WithBuiltInRole adds the builtInRole to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) WithBuiltInRole(builtInRole string) *SetResourcePermissionsForBuiltInRoleParams {
	o.SetBuiltInRole(builtInRole)
	return o
}

// SetBuiltInRole adds the builtInRole to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) SetBuiltInRole(builtInRole string) {
	o.BuiltInRole = builtInRole
}

// WithResource adds the resource to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) WithResource(resource string) *SetResourcePermissionsForBuiltInRoleParams {
	o.SetResource(resource)
	return o
}

// SetResource adds the resource to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) SetResource(resource string) {
	o.Resource = resource
}

// WithResourceID adds the resourceID to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) WithResourceID(resourceID string) *SetResourcePermissionsForBuiltInRoleParams {
	o.SetResourceID(resourceID)
	return o
}

// SetResourceID adds the resourceId to the set resource permissions for built in role params
func (o *SetResourcePermissionsForBuiltInRoleParams) SetResourceID(resourceID string) {
	o.ResourceID = resourceID
}

// WriteToRequest writes these params to a swagger request
func (o *SetResourcePermissionsForBuiltInRoleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param builtInRole
	if err := r.SetPathParam("builtInRole", o.BuiltInRole); err != nil {
		return err
	}

	// path param resource
	if err := r.SetPathParam("resource", o.Resource); err != nil {
		return err
	}

	// path param resourceID
	if err := r.SetPathParam("resourceID", o.ResourceID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
