// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewSetResourcePermissionsForTeamParams creates a new SetResourcePermissionsForTeamParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSetResourcePermissionsForTeamParams() *SetResourcePermissionsForTeamParams {
	return &SetResourcePermissionsForTeamParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSetResourcePermissionsForTeamParamsWithTimeout creates a new SetResourcePermissionsForTeamParams object
// with the ability to set a timeout on a request.
func NewSetResourcePermissionsForTeamParamsWithTimeout(timeout time.Duration) *SetResourcePermissionsForTeamParams {
	return &SetResourcePermissionsForTeamParams{
		timeout: timeout,
	}
}

// NewSetResourcePermissionsForTeamParamsWithContext creates a new SetResourcePermissionsForTeamParams object
// with the ability to set a context for a request.
func NewSetResourcePermissionsForTeamParamsWithContext(ctx context.Context) *SetResourcePermissionsForTeamParams {
	return &SetResourcePermissionsForTeamParams{
		Context: ctx,
	}
}

// NewSetResourcePermissionsForTeamParamsWithHTTPClient creates a new SetResourcePermissionsForTeamParams object
// with the ability to set a custom HTTPClient for a request.
func NewSetResourcePermissionsForTeamParamsWithHTTPClient(client *http.Client) *SetResourcePermissionsForTeamParams {
	return &SetResourcePermissionsForTeamParams{
		HTTPClient: client,
	}
}

/*
SetResourcePermissionsForTeamParams contains all the parameters to send to the API endpoint

	for the set resource permissions for team operation.

	Typically these are written to a http.Request.
*/
type SetResourcePermissionsForTeamParams struct {

	// Body.
	Body *models.SetPermissionCommand

	// Resource.
	Resource string

	// ResourceID.
	ResourceID string

	// TeamID.
	//
	// Format: int64
	TeamID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the set resource permissions for team params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SetResourcePermissionsForTeamParams) WithDefaults() *SetResourcePermissionsForTeamParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the set resource permissions for team params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SetResourcePermissionsForTeamParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) WithTimeout(timeout time.Duration) *SetResourcePermissionsForTeamParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) WithContext(ctx context.Context) *SetResourcePermissionsForTeamParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) WithHTTPClient(client *http.Client) *SetResourcePermissionsForTeamParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) WithBody(body *models.SetPermissionCommand) *SetResourcePermissionsForTeamParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) SetBody(body *models.SetPermissionCommand) {
	o.Body = body
}

// WithResource adds the resource to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) WithResource(resource string) *SetResourcePermissionsForTeamParams {
	o.SetResource(resource)
	return o
}

// SetResource adds the resource to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) SetResource(resource string) {
	o.Resource = resource
}

// WithResourceID adds the resourceID to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) WithResourceID(resourceID string) *SetResourcePermissionsForTeamParams {
	o.SetResourceID(resourceID)
	return o
}

// SetResourceID adds the resourceId to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) SetResourceID(resourceID string) {
	o.ResourceID = resourceID
}

// WithTeamID adds the teamID to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) WithTeamID(teamID int64) *SetResourcePermissionsForTeamParams {
	o.SetTeamID(teamID)
	return o
}

// SetTeamID adds the teamId to the set resource permissions for team params
func (o *SetResourcePermissionsForTeamParams) SetTeamID(teamID int64) {
	o.TeamID = teamID
}

// WriteToRequest writes these params to a swagger request
func (o *SetResourcePermissionsForTeamParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param resource
	if err := r.SetPathParam("resource", o.Resource); err != nil {
		return err
	}

	// path param resourceID
	if err := r.SetPathParam("resourceID", o.ResourceID); err != nil {
		return err
	}

	// path param teamID
	if err := r.SetPathParam("teamID", swag.FormatInt64(o.TeamID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
